/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;

public class HorzLayoutManager
implements LayoutManager2 {
    private Vector<Component> comps = new Vector();
    private Dimension preferredSize = new Dimension();
    private Dimension minimumSize = new Dimension();
    private int borderPadding = 2;
    private int xSeparation = 5;

    public HorzLayoutManager(int borderPadding, int xSeparation) {
        this.borderPadding = borderPadding;
        this.xSeparation = xSeparation;
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
        if (arg1 == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        this.comps.addElement(arg1);
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Null component in removeLayoutComponent");
        }
        this.comps.removeElement(arg0);
    }

    @Override
    public Dimension preferredLayoutSize(Container arg0) {
        return new Dimension(this.preferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        return new Dimension(this.minimumSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Dimension parentSize = target.getSize();
            parentSize.width -= 2 * this.borderPadding + insets.left + insets.right;
            parentSize.height -= 2 * this.borderPadding + insets.top + insets.bottom;
            int x = this.borderPadding;
            int y = this.borderPadding;
            for (Component comp : this.comps) {
                Dimension size = comp.getPreferredSize();
                if (comp instanceof JButton) {
                    comp.setBounds(x, y + parentSize.height - size.height, size.width, size.height);
                } else {
                    comp.setBounds(x, y, size.width, parentSize.height);
                }
                x += size.width + this.xSeparation;
            }
        }
    }

    protected void calcPreferredSize(Container target) {
        Insets insets = target.getInsets();
        this.preferredSize.setSize(this.borderPadding + insets.left + insets.right, this.borderPadding * 2 + insets.top + insets.bottom);
        for (Component comp : this.comps) {
            Dimension size = comp.getPreferredSize();
            this.preferredSize.height = Math.max(this.preferredSize.height, size.height + 2 * this.borderPadding);
            this.preferredSize.width += size.width + this.xSeparation;
            this.minimumSize.height = Math.max(this.minimumSize.height, comp.getMinimumSize().height + 2 * this.borderPadding);
        }
        this.preferredSize.width -= this.xSeparation;
    }

    public List<Component> getComponentList() {
        return this.comps;
    }

    public void removeAll() {
        this.comps.clear();
        this.preferredSize.setSize(0, 0);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        this.comps.addElement(comp);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.preferredSize.setSize(0, 0);
        this.calcPreferredSize(target);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        this.calcPreferredSize(target);
        return new Dimension(this.minimumSize);
    }
}

