/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.tasks.subpane.qb.BaseQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableAbbreviator;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableTree;
import java.sql.Timestamp;

public class FieldQRI
extends BaseQRI {
    protected TableQRI table = null;
    protected DBFieldInfo fi;

    public FieldQRI(TableQRI table, DBFieldInfo fi) {
        super(null);
        this.table = table;
        this.fi = fi;
        if (fi != null) {
            this.title = fi.getTitle();
        }
        this.iconName = "BlankIcon";
    }

    public DBFieldInfo getFieldInfo() {
        return this.fi;
    }

    public String getFieldName() {
        return this.fi.getName();
    }

    public UIFieldFormatterIFace getFormatter() {
        if (this.fi != null) {
            return this.fi.getFormatter();
        }
        return null;
    }

    public DBTableInfo getTableInfo() {
        if (this.fi != null) {
            return this.fi.getTableInfo();
        }
        return null;
    }

    protected boolean addPartialDateColumn(boolean forWhereClause, boolean forSchemaExport) {
        return !forWhereClause && this.getFieldInfo() != null && this.getFieldInfo().isPartialDate() && !forSchemaExport;
    }

    public String getSQLFldSpec(TableAbbreviator ta, boolean forWhereClause, boolean forSchemaExport) {
        String result = String.valueOf(ta.getAbbreviation(this.table.getTableTree())) + "." + this.getFieldName();
        if (this.addPartialDateColumn(forWhereClause, forSchemaExport)) {
            String precName = this.getFieldInfo().getDatePrecisionName();
            result = String.valueOf(result) + ", " + ta.getAbbreviation(this.table.getTableTree()) + "." + precName;
        } else if (this.getDataClass().equals(Timestamp.class)) {
            result = "DATE(" + result + ")";
        }
        return result;
    }

    public String getNullCondition(TableAbbreviator ta, boolean forSchemaExport, boolean negate) {
        return String.valueOf(this.getSQLFldSpec(ta, true, forSchemaExport)) + (negate ? " is not " : " is ") + "null";
    }

    public Class<?> getDataClass() {
        if (this.fi != null) {
            return this.fi.getDataClass();
        }
        return String.class;
    }

    public void setTable(TableQRI table) {
        this.table = table;
    }

    public TableQRI getTable() {
        return this.table;
    }

    @Override
    public TableTree getTableTree() {
        if (this.table != null) {
            return this.table.getTableTree();
        }
        return null;
    }

    public boolean isFieldHidden() {
        return this.getFieldInfo().isHidden();
    }

    protected String getFieldNameForStringId() {
        return this.getFieldName();
    }

    public String getStringId() {
        return String.valueOf(this.getTableTree().getPathFromRootAsString()) + "." + this.getTableInfo().getName() + "." + this.getFieldNameForStringId();
    }
}

