/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpExportSchema;
import edu.ku.brc.specify.datamodel.SpExportSchemaItem;
import edu.ku.brc.specify.datamodel.SpExportSchemaItemMapping;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.tasks.subpane.qb.FieldQRI;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public class ExportSchemaMapEditor
extends CustomDialog {
    protected SpExportSchema exportSchema = null;
    protected SpExportSchemaMapping schemaMapping = null;
    protected JPanel workPane = null;
    protected JPanel backgroundPane;
    protected JPanel rightSidePane;
    protected QueryBldrPane qb;
    protected final Taskable task;
    protected JButton mapToBtn;
    protected JButton unmapBtn;
    protected JButton upBtn;
    protected JButton downBtn;
    protected JPanel btnPanel;
    protected Color btnPanelColor;

    public ExportSchemaMapEditor(Frame frame, Taskable task) {
        super(frame, UIRegistry.getResourceString("ExportSchemaMapEditor.Title"), true, 7, null);
        this.task = task;
        this.qb = null;
        this.createUI();
    }

    protected QueryBldrPane buildQb(SpQuery query) {
        return new QueryBldrPane(query.getName(), this.task, query, false, this.exportSchema, this.schemaMapping);
    }

    protected SpQuery createNewQueryDataObj() {
        DBTableInfo tableInfo = this.getTableInfo();
        SpQuery query = new SpQuery();
        query.initialize();
        query.setName(this.exportSchema == null ? "nada" : this.exportSchema.getSchemaName());
        query.setNamed(false);
        query.setContextTableId((short)tableInfo.getTableId());
        query.setContextName(tableInfo.getShortClassName());
        return query;
    }

    protected DBTableInfo getTableInfo() {
        return DBTableIdMgr.getInstance().getInfoById(1);
    }

    protected boolean isMapped(Mapping item) {
        return item.getSchemaMap() != null;
    }

    protected Vector<SpExportSchemaMapping> getMappings() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            Vector<SpExportSchemaMapping> result = new Vector<SpExportSchemaMapping>();
            Integer disciplineId = AppContextMgr.getInstance().getClassObject(Discipline.class).getId();
            List<SpExportSchemaMapping> mappings = session.getDataList(SpExportSchemaMapping.class);
            for (SpExportSchemaMapping mapping : mappings) {
                if (!mapping.getSpExportSchema().getDiscipline().getId().equals(disciplineId)) continue;
                mapping.forceLoad();
                result.add(mapping);
            }
            Vector<SpExportSchemaMapping> vector = result;
            return vector;
        }
        finally {
            session.close();
        }
    }

    protected DefaultListModel getMappingsModel() {
        Vector<SpExportSchemaMapping> mappings = this.getMappings();
        DefaultListModel<SpExportSchemaMapping> result = new DefaultListModel<SpExportSchemaMapping>();
        for (SpExportSchemaMapping mapping : mappings) {
            result.addElement(mapping);
        }
        return result;
    }

    protected void editMapping(SpExportSchemaMapping mapping) {
        if (this.closeCurrentMapping()) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                this.exportSchema = mapping.getSpExportSchema();
                session.attach(this.exportSchema);
                this.exportSchema.forceLoad();
                this.schemaMapping = mapping;
                if (this.schemaMapping.getMappings().size() == 0) {
                    this.setupQB(this.createNewQueryDataObj());
                } else {
                    SpQuery query = this.schemaMapping.getMappings().iterator().next().getQueryField().getQuery();
                    session.attach(query);
                    query.forceLoad();
                    this.setupQB(query);
                }
            }
            finally {
                session.close();
            }
        }
    }

    protected boolean isEditingMapping() {
        return this.workPane != null;
    }

    protected void setupQB(SpQuery query) {
        this.qb = this.buildQb(query);
        CardLayout layout = (CardLayout)this.rightSidePane.getLayout();
        if (this.workPane != null) {
            layout.removeLayoutComponent(this.workPane);
            this.rightSidePane.remove(this.workPane);
        }
        this.workPane = this.createWorkPane();
        this.rightSidePane.add((Component)this.workPane, "work");
    }

    protected void addMapping() {
        SpExportSchema selectedSchema = this.chooseExportSchema();
        if (this.closeCurrentMapping()) {
            this.exportSchema = selectedSchema;
            this.schemaMapping = new SpExportSchemaMapping();
            this.schemaMapping.initialize();
            this.schemaMapping.setSpExportSchema(this.exportSchema);
            this.setupQB(this.createNewQueryDataObj());
        }
    }

    protected boolean closeCurrentMapping() {
        if (!this.isEditingMapping()) {
            return true;
        }
        return !this.qb.isChanged();
    }

    protected SpExportSchema chooseExportSchema() {
        ChooseFromListDlg<SpExportSchema> dlg = new ChooseFromListDlg<SpExportSchema>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ExportSchemaMapEditor.ChooseSchemaTitle"), this.getExportSchemas());
        UIHelper.centerAndShow(dlg);
        return dlg.getSelectedObject();
    }

    protected List<SpExportSchema> getExportSchemas() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            List<SpExportSchema> result = session.getDataList(SpExportSchema.class, "discipline", AppContextMgr.getInstance().getClassObject(Discipline.class));
            for (SpExportSchema schema : result) {
                schema.forceLoad();
            }
            List<SpExportSchema> list = result;
            return list;
        }
        finally {
            session.close();
        }
    }

    protected void importExportSchema() {
    }

    protected JPanel createWorkPane() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder rightSideBldr = new PanelBuilder(new FormLayout("f:p:g", "5dlu, p, 2dlu, f:p, 5dlu, p, 2dlu, f:p:g"));
        rightSideBldr.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("ExportSchemaMapEdit.ExportSchemaTitle")), cc.xy(1, 2));
        String schemaText = this.exportSchema.getSchemaName();
        if (StringUtils.isNotBlank((String)this.exportSchema.getSchemaVersion())) {
            schemaText = String.valueOf(schemaText) + " (" + UIRegistry.getResourceString("ExportSchemaMapEdit.SchemaVersion") + ": " + this.exportSchema.getSchemaVersion() + ")";
        }
        JPanel schemaPane = new JPanel(new BorderLayout());
        schemaPane.add((Component)UIHelper.createLabel(schemaText), "North");
        if (StringUtils.isNotBlank((String)this.exportSchema.getDescription())) {
            JTextArea ta = new JTextArea(this.exportSchema.getDescription());
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            schemaPane.add((Component)ta, "Center");
        }
        rightSideBldr.add((Component)schemaPane, cc.xy(1, 4));
        rightSideBldr.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("ExportSchemaMapEdit.MappingTitle")), cc.xy(1, 6));
        rightSideBldr.add((Component)this.qb, cc.xy(1, 8));
        return rightSideBldr.getPanel();
    }

    protected boolean deleteMappingFromDB(SpExportSchemaMapping mapping) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        boolean transOpen = false;
        boolean result = false;
        try {
            try {
                session.beginTransaction();
                transOpen = true;
                session.delete(mapping.getMappings().iterator().next().getQueryField().getQuery());
                session.delete(mapping);
                session.commit();
                transOpen = false;
                result = true;
            }
            catch (Exception ex) {
                if (transOpen) {
                    session.rollback();
                }
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                ex.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
        return result;
    }

    protected void deleteMapping(final JList mapList) {
        SpExportSchemaMapping mapping = (SpExportSchemaMapping)mapList.getSelectedValue();
        String mapName = mapping.getMappings().iterator().next().getQueryField().getQuery().getName();
        if (UIRegistry.displayConfirm(UIRegistry.getResourceString("ExportSchemaMapEditor.ConfirmMappingDeleteTitle"), String.format(UIRegistry.getResourceString("ExportSchemaMapEditor.ConfirmMappingDeleteMsg"), mapName), UIRegistry.getResourceString("OK"), UIRegistry.getResourceString("Cancel"), 3) && this.deleteMappingFromDB(mapping)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((DefaultListModel)mapList.getModel()).removeElementAt(mapList.getSelectedIndex());
                }
            });
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        CellConstraints cc = new CellConstraints();
        final JList mappingList = UIHelper.createList(this.getMappingsModel());
        final JButton editBtn = UIHelper.createButton(UIRegistry.getResourceString("EDIT"));
        editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportSchemaMapEditor.this.editMapping((SpExportSchemaMapping)mappingList.getSelectedValue());
            }
        });
        JButton addBtn = UIHelper.createButton(UIRegistry.getResourceString("ADD"));
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportSchemaMapEditor.this.addMapping();
            }
        });
        final JButton delBtn = UIHelper.createButton(UIRegistry.getResourceString("DELETE"));
        delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportSchemaMapEditor.this.deleteMapping(mappingList);
            }
        });
        JButton impBtn = UIHelper.createButton(UIRegistry.getResourceString("ExportSchemaMapEditor.ImportExportSchema"));
        impBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportSchemaMapEditor.this.importExportSchema();
            }
        });
        mappingList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                Object value = mappingList.getSelectedValue();
                delBtn.setEnabled(mappingList.getModel().getSize() > 0 && value != null && value != ExportSchemaMapEditor.this.schemaMapping);
                editBtn.setEnabled(mappingList.getModel().getSize() > 0 && value != null);
            }
        });
        PanelBuilder leftSideBldr = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "5dlu, p, 2dlu, f:p:g, 5dlu, p"));
        leftSideBldr.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("ExportSchemaMapEdit.MappingsListTitle")), cc.xy(2, 2));
        mappingList.setPreferredSize(new Dimension(300, 500));
        leftSideBldr.add((Component)mappingList, cc.xy(2, 4));
        PanelBuilder btnPaneBldr = new PanelBuilder(new FormLayout("f:p:g, 2dlu, f:p:g, 2dlu, f:p:g, 2dlu, f:p:g", "p"));
        btnPaneBldr.add((Component)editBtn, cc.xy(1, 1));
        btnPaneBldr.add((Component)addBtn, cc.xy(3, 1));
        btnPaneBldr.add((Component)delBtn, cc.xy(5, 1));
        btnPaneBldr.add((Component)impBtn, cc.xy(7, 1));
        leftSideBldr.add((Component)btnPaneBldr.getPanel(), cc.xy(2, 6));
        this.backgroundPane = new JPanel();
        CardLayout layout = new CardLayout();
        this.rightSidePane = new JPanel(layout);
        this.rightSidePane.setPreferredSize(new Dimension(400, 500));
        layout.addLayoutComponent(this.backgroundPane, "background");
        PanelBuilder mainBldr = new PanelBuilder(new FormLayout("f:p, 5dlu, f:p:g, 10dlu", "f:p:g"));
        mainBldr.add((Component)leftSideBldr.getPanel(), cc.xy(1, 1));
        mainBldr.add((Component)this.rightSidePane, cc.xy(3, 1));
        this.contentPanel = mainBldr.getPanel();
        this.okBtn.setEnabled(false);
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.helpContext);
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
    }

    public class Mapping {
        protected SpExportSchemaItem schemaItem;
        protected SpExportSchemaItemMapping schemaMap;

        public Mapping(SpExportSchemaItem schemaItem, SpExportSchemaItemMapping schemaMap) {
            this.schemaItem = schemaItem;
            this.schemaMap = schemaMap;
        }

        public SpExportSchemaItem getSchemaItem() {
            return this.schemaItem;
        }

        public void setSchemaItem(SpExportSchemaItem schemaItem) {
            this.schemaItem = schemaItem;
        }

        public SpExportSchemaItemMapping getSchemaMap() {
            return this.schemaMap;
        }

        public void setSchemaMap(SpExportSchemaItemMapping schemaMap) {
            this.schemaMap = schemaMap;
        }

        public SpQueryField getQueryField() {
            if (this.schemaMap != null) {
                return this.schemaMap.getQueryField();
            }
            return null;
        }

        public String getMappedToText() {
            DBTableInfo tbl;
            SpQueryField qf = this.getQueryField();
            if (qf != null && (tbl = DBTableIdMgr.getInstance().getInfoById(qf.getContextTableIdent())) != null) {
                return String.valueOf(tbl.getTitle()) + "." + qf.getFieldName();
            }
            return UIRegistry.getResourceString("ExportSchemaMapEditor.Unmapped");
        }

        public String toString() {
            return String.valueOf(this.getMappedToText()) + " <===> " + this.schemaItem;
        }
    }

    public class MappingListRenderer
    implements ListCellRenderer {
        protected SpQueryField dummy;

        public MappingListRenderer() {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                this.dummy = session.get(SpQueryField.class, 1);
                this.dummy.forceLoad();
            }
            finally {
                session.close();
            }
        }

        public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
            Mapping mapping = (Mapping)arg1;
            FieldQRI fieldQRI = ExportSchemaMapEditor.this.qb.getFieldQRI(this.dummy);
            if (fieldQRI != null) {
                return QueryBldrPane.bldQueryFieldPanel(ExportSchemaMapEditor.this.qb, fieldQRI, mapping.getQueryField(), ExportSchemaMapEditor.this.qb.getColumnDefStr(), null);
            }
            return new JLabel(mapping.toString());
        }
    }
}

