/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoTreeLevel;
import edu.ku.brc.specify.tasks.subpane.qb.LookupsCache;
import edu.ku.brc.specify.tasks.subpane.qb.TreeLevelQRI;
import edu.ku.brc.util.Pair;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ERTICaptionInfoTreeLevelGrp {
    protected final Vector<ERTICaptionInfoTreeLevel> members;
    protected final Class<?> treeClass;
    protected final int treeDefId;
    protected final String alias;
    protected final Vector<String> fieldsToRetrieve;
    protected final LookupsCache lookupCache;
    protected final boolean useCache;
    protected static boolean useHibernate = false;
    protected DataProviderSessionIFace.QueryIFace query = null;
    protected Statement statement = null;
    protected String querySQL = null;
    protected Object[] currentRanks = null;
    protected Object currentVal = null;
    protected DataProviderSessionIFace session = null;
    protected boolean isSetup = false;
    private HashMap<Integer, String> ancestorsCache = new HashMap();

    public ERTICaptionInfoTreeLevelGrp(Class<?> treeClass, int treeDefId, String alias, boolean useCache, Integer cacheSize) {
        this.treeClass = treeClass;
        this.treeDefId = treeDefId;
        this.alias = alias;
        this.fieldsToRetrieve = new Vector();
        this.members = new Vector();
        this.useCache = useCache;
        this.lookupCache = useCache ? (cacheSize == null ? new LookupsCache() : new LookupsCache(cacheSize)) : null;
    }

    public Object processValue(Object value, int rankIdx, int fldIdx) throws SQLException {
        Object[] currentRank;
        if (!this.isSetup) {
            throw new RuntimeException("ERTICaptionInfoTreeLevelGrp: " + this.treeClass.getName() + " group was not setup.");
        }
        if (value == null) {
            return null;
        }
        if (!value.equals(this.currentVal)) {
            this.newValue(value);
            this.currentVal = value;
        }
        if ((currentRank = (Object[])this.currentRanks[rankIdx]) == null) {
            return null;
        }
        return currentRank[fldIdx];
    }

    protected Pair<Integer, String[]> getAncestorInfo(Object ancestor) {
        if (ancestor == null) {
            return new Pair<Object, Object>(null, null);
        }
        Object[] info = (Object[])ancestor;
        String[] vals = new String[info.length - 1];
        int c = 0;
        while (c < vals.length) {
            vals[c] = info[c] == null ? null : info[c].toString();
            ++c;
        }
        return new Pair<Integer, String[]>((Integer)info[info.length - 1], vals);
    }

    protected void newValue(Object value) throws SQLException {
        Object[] lookedUp;
        if (this.useCache && (lookedUp = (Object[])this.lookupCache.lookupKey((Integer)value)) != null) {
            this.currentRanks = lookedUp;
            return;
        }
        if (this.useCache) {
            this.currentRanks = new Object[this.members.size()];
            int r = 0;
            while (r < this.currentRanks.length) {
                this.currentRanks[r] = null;
                ++r;
            }
        }
        ResultSet ancestorRows = null;
        Iterator<Object> ancestors = null;
        Pair<Integer, String[]> ancestor = null;
        if (useHibernate) {
            this.query.setParameter("descendantArg", value);
            ancestors = this.query.list().iterator();
        } else {
            ResultSet rows;
            String sql = this.setupQuery(value);
            ancestorRows = rows = this.statement.executeQuery(sql);
            ancestors = new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    try {
                        return rows.next();
                    }
                    catch (SQLException ex) {
                        return false;
                    }
                }

                @Override
                public Object next() {
                    try {
                        int arraySize = ERTICaptionInfoTreeLevelGrp.this.fieldsToRetrieve == null ? 2 : ERTICaptionInfoTreeLevelGrp.this.fieldsToRetrieve.size() + 1;
                        Object[] result = new Object[arraySize];
                        int c = 0;
                        while (c < arraySize - 1) {
                            result[c] = rows.getString(c + 1);
                            ++c;
                        }
                        result[arraySize - 1] = Integer.valueOf(rows.getString(arraySize));
                        return result;
                    }
                    catch (SQLException ex) {
                        return null;
                    }
                }

                @Override
                public void remove() {
                }
            };
        }
        ancestor = ancestors.hasNext() ? this.getAncestorInfo(ancestors.next()) : null;
        for (ERTICaptionInfoTreeLevel member : this.members) {
            while (ancestor != null && ancestor.getFirst() < member.getRank()) {
                Pair<Integer, String[]> pair = ancestor = ancestors.hasNext() ? this.getAncestorInfo(ancestors.next()) : null;
            }
            this.currentRanks[member.getRankIdx()] = ancestor != null && ancestor.getFirst().intValue() == member.getRank() ? ancestor.getSecond() : null;
        }
        if (ancestorRows != null) {
            ancestorRows.close();
        }
        if (this.useCache) {
            this.lookupCache.addKey((Integer)value, this.currentRanks);
        }
    }

    protected String setupQuery(Object value) {
        String ancestorsIn = this.getAncestorsIn(this.treeClass, (Integer)value);
        return this.querySQL.replace(":ancestorsIn", ancestorsIn);
    }

    protected String geFldsList() {
        if (this.fieldsToRetrieve == null) {
            return "name";
        }
        StringBuilder result = new StringBuilder();
        for (String fld : this.fieldsToRetrieve) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(fld);
        }
        return result.toString();
    }

    protected String getNodeTblName() {
        return this.treeClass.getSimpleName().toLowerCase();
    }

    protected String getNodeTreeFldName() {
        return String.valueOf(this.treeClass.getSimpleName().toLowerCase()) + "TreeDefId";
    }

    protected void finalize() throws Throwable {
        if (this.session != null) {
            this.session.close();
        }
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public int getTreeDefId() {
        return this.treeDefId;
    }

    public Class<?> getTreeClass() {
        return this.treeClass;
    }

    public String getAlias() {
        return this.alias;
    }

    public ERTICaptionInfoTreeLevel addRank(TreeLevelQRI rank, String colName, String lbl, String id, String fldName) {
        if (this.isSetup) {
            throw new RuntimeException("ERTICaptionInfoTreeLevelGrp: tree for " + this.treeClass.getSimpleName() + " is already setup.");
        }
        if (this.treeDefId != rank.getTreeDefId() || !this.treeClass.equals(rank.getTreeDataClass()) || !this.alias.equals(rank.getTableAlias())) {
            return null;
        }
        int fldIdx = this.fieldsToRetrieve.indexOf(fldName);
        if (fldIdx == -1) {
            this.fieldsToRetrieve.add(fldName);
            fldIdx = this.fieldsToRetrieve.size() - 1;
        }
        ERTICaptionInfoTreeLevel result = new ERTICaptionInfoTreeLevel(colName, lbl, 0, id, this, rank.getRankId(), fldIdx);
        this.members.add(result);
        return result;
    }

    private String getAncestorsIn(Class<?> clazz, Integer nodeId) {
        try {
            String ancestorsIn;
            this.session = DataProviderFactory.getInstance().createSession();
            DataProviderSessionIFace.QueryIFace query = this.session.createQuery("select e.parent.id from " + clazz.getName() + " e where e.id = :nodeId", false);
            query.setParameter("nodeId", nodeId);
            Integer parentId = (Integer)query.uniqueResult();
            if (this.ancestorsCache.containsKey(parentId)) {
                ancestorsIn = this.ancestorsCache.get(parentId);
            } else {
                ancestorsIn = this.getAncestorsInRecursive(clazz, nodeId);
                this.ancestorsCache.put(parentId, ancestorsIn);
            }
            String in = nodeId + ", " + ancestorsIn;
            String string = in = "in(" + in.substring(0, in.length() - 2) + ")";
            return string;
        }
        finally {
            this.session.close();
        }
    }

    private String getAncestorsInRecursive(Class<?> clazz, Integer nodeId) {
        DataProviderSessionIFace.QueryIFace query = this.session.createQuery("select e.parent.id from " + clazz.getName() + " e where e.id = :nodeId", false);
        query.setParameter("nodeId", nodeId);
        Integer parentId = (Integer)query.uniqueResult();
        if (parentId == null) {
            return "";
        }
        return parentId + ", " + this.getAncestorsInRecursive(clazz, parentId);
    }

    public void setUp() throws SQLException {
        if (this.isSetup) {
            throw new RuntimeException("ERTICaptionInfoTreeLevelGrp: tree for " + this.treeClass.getSimpleName() + " is already setup.");
        }
        Collections.sort(this.members, new Comparator<ERTICaptionInfoTreeLevel>(){

            @Override
            public int compare(ERTICaptionInfoTreeLevel o1, ERTICaptionInfoTreeLevel o2) {
                if (o1.getRank() < o2.getRank()) {
                    return -1;
                }
                if (o1.getRank() == o2.getRank()) {
                    return 0;
                }
                return 1;
            }
        });
        this.currentRanks = new String[this.members.size()];
        int m = 0;
        String rankStr = "";
        for (ERTICaptionInfoTreeLevel member : this.members) {
            member.setRankIdx(m);
            this.currentRanks[m++] = null;
            if (!StringUtils.isEmpty((String)rankStr)) {
                rankStr = String.valueOf(rankStr) + ",";
            }
            rankStr = String.valueOf(rankStr) + member.getRank();
        }
        if (useHibernate) {
            this.session = DataProviderFactory.getInstance().createSession();
            String ancestorSQL = "select " + this.geFldsList() + ", rankId from " + this.getNodeTblName() + " where id :ancestorsIn and" + this.getNodeTreeFldName() + "=" + this.treeDefId + " and rankId in(" + rankStr + ") order by rankId ";
            this.query = this.session.createQuery(ancestorSQL, true);
        } else {
            String idField = String.valueOf(this.treeClass.getSimpleName()) + "Id";
            this.querySQL = "select " + this.geFldsList() + ", rankId from " + this.getNodeTblName().toLowerCase() + " where " + idField + " :ancestorsIn and " + this.getNodeTreeFldName() + "=" + this.treeDefId + " and rankId in(" + rankStr + ") order by rankId ";
            Connection connection = DBConnection.getInstance().getConnection();
            this.statement = connection.createStatement();
        }
        this.isSetup = true;
    }
}

