/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregator;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.LookupsCache;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ERTICaptionInfoRel
extends ERTICaptionInfoQB {
    protected final DBRelationshipInfo relationship;
    protected final String listHql;
    protected final boolean useCache;
    protected final LookupsCache lookupCache;

    public ERTICaptionInfoRel(String colName, String colLabel, boolean isVisible, UIFieldFormatterIFace uiFieldFormatter, int posIndex, String colStringId, DBRelationshipInfo relationship, boolean useCache, Integer cacheSize) {
        super(colName, colLabel, isVisible, uiFieldFormatter, posIndex, colStringId, null, null);
        this.relationship = relationship;
        this.useCache = useCache;
        this.lookupCache = useCache ? (cacheSize == null ? new LookupsCache() : new LookupsCache(cacheSize)) : null;
        if (relationship.getType() == DBRelationshipInfo.RelationshipType.OneToMany) {
            DBTableInfo otherSideTbl = DBTableIdMgr.getInstance().getByClassName(relationship.getClassName());
            DBRelationshipInfo otherSideRel = otherSideTbl.getRelationshipByName(relationship.getOtherSide());
            String otherSideCol = otherSideRel.getColName();
            otherSideCol = otherSideCol.substring(0, 1).toLowerCase().concat(otherSideCol.substring(1));
            otherSideCol = String.valueOf(otherSideCol.substring(0, otherSideCol.length() - 2)) + "Id";
            List<DataObjAggregator> aggs = DataObjFieldFormatMgr.getInstance().getAggregatorList(relationship.getDataClass());
            String orderByFld = null;
            for (DataObjAggregator agg : aggs) {
                if (!agg.isDefault()) continue;
                orderByFld = agg.getOrderFieldName();
                break;
            }
            this.listHql = "from " + relationship.getDataClass().getName() + " where " + otherSideCol + " = &id" + (StringUtils.isNotEmpty((String)orderByFld) ? " order by " + orderByFld : "");
        } else {
            this.listHql = null;
        }
    }

    public DBRelationshipInfo getRelationship() {
        return this.relationship;
    }

    @Override
    public Class<?> getAggClass() {
        return null;
    }

    @Override
    public String getAggregatorName() {
        return null;
    }

    @Override
    public Class<?> getColClass() {
        return String.class;
    }

    @Override
    public DataObjSwitchFormatter getDataObjFormatter() {
        return null;
    }

    @Override
    public Class<?> getSubClass() {
        return null;
    }

    @Override
    public String getSubClassFieldName() {
        return null;
    }

    @Override
    public UIFieldFormatterIFace getUiFieldFormatter() {
        return null;
    }

    @Override
    public Object processValue(Object key) {
        Object value;
        Object object = value = this.useCache ? this.lookupCache.lookupKey((Integer)key) : null;
        if (value == null) {
            value = this.relationship.getType() == DBRelationshipInfo.RelationshipType.OneToMany ? DataObjFieldFormatMgr.getInstance().aggregate(this.getList(key), this.relationship.getDataClass()) : DataObjFieldFormatMgr.getInstance().format(this.getObject(key), this.relationship.getDataClass());
            if (this.useCache && key != null) {
                this.lookupCache.addKey((Integer)key, value);
            }
        }
        return value;
    }

    protected Collection<?> getList(Object value) {
        if (value instanceof Integer) {
            return this.getListFromKey(value);
        }
        return (Collection)value;
    }

    protected Collection<?> getListFromKey(Object key) {
        if (key != null) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                List<?> list = session.getDataList(this.getListHql(key));
                return list;
            }
            finally {
                session.close();
            }
        }
        return null;
    }

    public String getListHql(Object key) {
        return this.listHql.replace("&id", key != null ? key.toString() : "");
    }

    protected Object getObject(Object value) {
        if (value instanceof Integer) {
            return this.getObjectFromKey(value);
        }
        return value;
    }

    protected Object getObjectFromKey(Object key) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            Object obj = session.get(this.relationship.getDataClass(), (Integer)key);
            return obj;
        }
        finally {
            session.close();
        }
    }
}

