/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.qb;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.tasks.subpane.qb.FieldQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableAbbreviator;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.ui.UIRegistry;

public class DateAccessorQRI
extends FieldQRI {
    protected final DATEPART datePart;

    public DateAccessorQRI(TableQRI table, DBFieldInfo fi, DATEPART datePart) {
        super(table, fi);
        this.datePart = datePart;
        this.title = String.valueOf(this.title) + " (" + UIRegistry.getResourceString("DateAccessorQRI." + datePart.name()) + ")";
    }

    public DATEPART getDatePart() {
        return this.datePart;
    }

    @Override
    protected boolean addPartialDateColumn(boolean forWhereClause, boolean forSchemaExport) {
        return false;
    }

    @Override
    public String getStringId() {
        return String.valueOf(super.getStringId()) + this.datePart.name();
    }

    @Override
    public String getSQLFldSpec(TableAbbreviator ta, boolean forWhereClause, boolean forSchemaExport) {
        String fldExpr = String.valueOf(ta.getAbbreviation(this.table.getTableTree())) + "." + this.getFieldName();
        String validPartialDates = null;
        String sqlFunction = null;
        switch (this.datePart) {
            case NumericDay: {
                sqlFunction = "DAY";
                validPartialDates = "(" + String.valueOf(UIFieldFormatterIFace.PartialDateEnum.Full.ordinal()) + ")";
                break;
            }
            case NumericMonth: {
                sqlFunction = "MONTH";
                validPartialDates = "(" + String.valueOf(UIFieldFormatterIFace.PartialDateEnum.Full.ordinal()) + ", " + String.valueOf(UIFieldFormatterIFace.PartialDateEnum.Month.ordinal()) + ")";
                break;
            }
            case NumericYear: {
                sqlFunction = "YEAR";
                validPartialDates = "(" + String.valueOf(UIFieldFormatterIFace.PartialDateEnum.Full.ordinal()) + ", " + String.valueOf(UIFieldFormatterIFace.PartialDateEnum.Month.ordinal()) + ", " + String.valueOf(UIFieldFormatterIFace.PartialDateEnum.Year.ordinal()) + ")";
            }
        }
        if (!forWhereClause && this.getFieldInfo().getDatePrecisionName() != null) {
            String partialDateExpr = String.valueOf(ta.getAbbreviation(this.table.getTableTree())) + "." + this.getFieldInfo().getDatePrecisionName();
            return "CASE WHEN " + partialDateExpr + " IN" + validPartialDates + " THEN " + sqlFunction + "(" + fldExpr + ") ELSE null END";
        }
        return String.valueOf(sqlFunction) + "(" + fldExpr + ")";
    }

    @Override
    public Class<?> getDataClass() {
        return Integer.class;
    }

    public static enum DATEPART {
        NumericDay,
        NumericMonth,
        NumericYear;

    }
}

