/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.specify.tasks.WebSearchTask;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WebServiceSubPane
extends BaseSubPane {
    private DefaultListModel fileListModel = new DefaultListModel();
    private JList fileList = new JList(this.fileListModel);
    private EditDeleteAddPanel eadPanel;
    private JButton uploadFilesBtn;
    private JButton uploadDBBtn;
    private JLabel lastUpdatedLbl;

    public WebServiceSubPane(String name, Taskable task, boolean buildProgressUI, boolean includeProgressCancelBtn) {
        super(name, task, buildProgressUI, includeProgressCancelBtn);
    }

    public WebServiceSubPane(String name, Taskable task, boolean buildProgressUI) {
        super(name, task, buildProgressUI);
        this.createUI();
    }

    public WebServiceSubPane(String name, Taskable task) {
        super(name, task);
        this.createUI();
    }

    private JPanel makeCenteredBtn(JButton btn) {
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p"));
        pb.add((Component)btn, new CellConstraints().xy(2, 1));
        pb.getPanel().setOpaque(false);
        return pb.getPanel();
    }

    private void createUI() {
        this.removeAll();
        ActionListener addAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServiceSubPane.this.addFileItem();
            }
        };
        ActionListener delAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServiceSubPane.this.delFileItem();
            }
        };
        this.eadPanel = new EditDeleteAddPanel(null, delAction, addAction);
        this.eadPanel.setOpaque(false);
        this.uploadFilesBtn = UIHelper.createI18NButton("WSSP_UPLOAD_FILES_BTN");
        this.uploadDBBtn = UIHelper.createI18NButton("WSSP_UPLOAD_DB_BTN");
        this.uploadFilesBtn.setEnabled(false);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,f:p:g", "p,4px, p,2px,p,2px,p,2px,p,20px,p,10px,p"), (JPanel)this);
        int y = 1;
        pb.addSeparator(UIRegistry.getResourceString("WSSP_FILES_UPLD"), cc.xyw(1, y, 1));
        pb.add((Component)UIHelper.createI18NLabel("", 0), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createScrollPane(this.fileList), cc.xy(1, y += 2));
        pb.add((Component)this.eadPanel, cc.xy(1, y += 2));
        pb.add((Component)this.makeCenteredBtn(this.uploadFilesBtn), cc.xy(1, y += 2));
        pb.addSeparator(UIRegistry.getResourceString("WSSP_UPLOAD_DB"), cc.xyw(1, y += 2, 1));
        y += 2;
        PanelBuilder innerPanel = new PanelBuilder(new FormLayout("p,4px,p:g", "p,16px,p"));
        this.lastUpdatedLbl = new JLabel();
        this.fillDate();
        innerPanel.add((Component)UIHelper.createI18NFormLabel("WSSP_LAST_UPLD"), cc.xy(1, 1));
        innerPanel.add((Component)this.lastUpdatedLbl, cc.xy(3, 1));
        innerPanel.add((Component)this.makeCenteredBtn(this.uploadDBBtn), cc.xyw(1, 3, 3));
        innerPanel.getPanel().setOpaque(false);
        pb.add((Component)innerPanel.getPanel(), cc.xy(1, y));
        y += 2;
        this.eadPanel.getAddBtn().setEnabled(true);
        this.fileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    WebServiceSubPane.this.eadPanel.getDelBtn().setEnabled(WebServiceSubPane.this.fileList.getSelectedIndex() > -1);
                }
            }
        });
        this.uploadDBBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WebSearchTask)WebServiceSubPane.this.task).createAndSendBackup();
                AppPreferences.getRemote().putLong("LAST_WS_UPLOAD", Calendar.getInstance().getTimeInMillis());
                WebServiceSubPane.this.fillDate();
            }
        });
        pb.setDefaultDialogBorder();
    }

    private String fillDate() {
        long lastUploadTime = AppPreferences.getRemote().getLong("LAST_WS_UPLOAD", 0L);
        String lblTxt = lastUploadTime == 0L ? UIRegistry.getResourceString("NONE") : new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date(lastUploadTime));
        this.lastUpdatedLbl.setText(lblTxt);
        return lblTxt;
    }

    private void addFileItem() {
        FileDialog dlg = new FileDialog((Frame)UIRegistry.getMostRecentWindow(), "WSSP_CHSE_FILE", 0);
        dlg.setModal(true);
        dlg.setVisible(true);
        String fileName = dlg.getFile();
        if (fileName != null) {
            fileName = String.valueOf(dlg.getDirectory()) + dlg.getFile();
            this.fileListModel.addElement(fileName);
            this.uploadFilesBtn.setEnabled(true);
        }
    }

    private void delFileItem() {
        this.fileListModel.remove(this.fileList.getSelectedIndex());
        this.uploadFilesBtn.setEnabled(this.fileListModel.size() > 0);
    }

    @Override
    public boolean aboutToShutdown() {
        return super.aboutToShutdown();
    }

    @Override
    public String getHelpTarget() {
        return super.getHelpTarget();
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

