/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.RecordSetFactory;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.services.mapping.LatLonPoint;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.tasks.BaseTreeTask;
import edu.ku.brc.specify.ui.ClickAndGoSelectListener;
import edu.ku.brc.specify.ui.WorldWindPanel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.LineBuilder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.util.GeometryMath;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class VisualQueryPanel
extends BaseSubPane {
    protected static final int[] TABLE_IDS = new int[]{CollectionObject.getClassTableId(), Locality.getClassTableId(), CollectingEvent.getClassTableId(), Taxon.getClassTableId()};
    protected static final int MAP_WIDTH = 500;
    protected static final int MAP_HEIGHT = 500;
    protected static final String STATUSBAR_NAME = "VisualQueryStatusBar";
    protected static DBTableInfo[] TABLE_INFO;
    protected WorldWindPanel wwPanel;
    protected Vector<LatLonPoint> availPoints = new Vector();
    protected Vector<LatLonPoint> selectedPoints = new Vector();
    protected HashSet<Integer> topIdHash = new HashSet();
    protected HashSet<Integer> botIdHash = new HashSet();
    protected JLabel topLbl;
    protected JList dbObjList;
    protected JList recSetList;
    protected JComboBox typeCBX;
    protected JButton searchBtn;
    protected JButton startBtn;
    protected JButton endBtn;
    protected JButton clearAllBtn;
    protected JButton clearSearchBtn;
    protected JButton dwnBtn;
    protected JButton upBtn;
    protected JButton selectAllBtn;
    protected JButton deselectAllBtn;
    protected JButton rsBtn;
    protected JButton fmBtn;
    protected boolean isCreatingPolygon = false;
    protected Point prevPoint = null;
    protected Position lastClickPos = null;
    protected LineBuilder lineBuilder;
    protected RenderableLayer lineLayer;
    protected Polyline polyline = new Polyline();
    protected DefaultListModel model = null;
    protected List<LatLonPlacemarkIFace> markers = new Vector<LatLonPlacemarkIFace>();
    protected Polyline polygon = null;
    protected int totalNumRecords = 0;
    protected StringBuilder polySB = new StringBuilder();
    protected StringBuilder boxSB = new StringBuilder();
    protected boolean doDebug = false;

    public VisualQueryPanel(String name, Taskable task) {
        super(name, task);
        TABLE_INFO = new DBTableInfo[TABLE_IDS.length];
        int i = 0;
        while (i < TABLE_IDS.length) {
            VisualQueryPanel.TABLE_INFO[i] = DBTableIdMgr.getInstance().getInfoById(TABLE_IDS[i]);
            ++i;
        }
        this.createUI();
    }

    protected void createUI() {
        CellConstraints cc = new CellConstraints();
        this.lineLayer = new RenderableLayer();
        this.upBtn = UIHelper.createIconBtn("Green Arrow Up", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.moveItems(VisualQueryPanel.this.recSetList, VisualQueryPanel.this.botIdHash, VisualQueryPanel.this.dbObjList, VisualQueryPanel.this.topIdHash);
            }
        });
        this.dwnBtn = UIHelper.createIconBtn("Green Arrow Down", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.moveItems(VisualQueryPanel.this.dbObjList, VisualQueryPanel.this.topIdHash, VisualQueryPanel.this.recSetList, VisualQueryPanel.this.botIdHash);
                boolean hasItems = VisualQueryPanel.this.recSetList.getModel().getSize() > 0;
                VisualQueryPanel.this.rsBtn.setEnabled(hasItems);
                VisualQueryPanel.this.fmBtn.setEnabled(hasItems);
            }
        });
        this.selectAllBtn = UIHelper.createI18NButton("SELECTALL");
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.dbObjList.clearSelection();
                VisualQueryPanel.this.dbObjList.getSelectionModel().setSelectionInterval(0, VisualQueryPanel.this.dbObjList.getModel().getSize());
            }
        });
        this.deselectAllBtn = UIHelper.createI18NButton("DESELECTALL");
        this.deselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.dbObjList.clearSelection();
            }
        });
        PanelBuilder upDwnPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g,p,10px,p,f:p:g,p,f:p:g", "p"));
        upDwnPB.add((Component)this.dwnBtn, cc.xy(4, 1));
        upDwnPB.add((Component)this.upBtn, cc.xy(6, 1));
        this.dbObjList = new JList(new DefaultListModel());
        this.dbObjList.getSelectionModel().setSelectionMode(2);
        this.dbObjList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VisualQueryPanel.this.upBtn.setEnabled(false);
                VisualQueryPanel.this.dwnBtn.setEnabled(VisualQueryPanel.this.dbObjList.getSelectedIndex() != -1);
            }
        });
        this.recSetList = new JList(new DefaultListModel());
        this.recSetList.getSelectionModel().setSelectionMode(2);
        this.recSetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean isSel = VisualQueryPanel.this.recSetList.getSelectedIndex() != -1;
                VisualQueryPanel.this.dwnBtn.setEnabled(false);
                VisualQueryPanel.this.upBtn.setEnabled(isSel);
            }
        });
        this.rsBtn = UIHelper.createIconBtn("Record_Set", IconManager.IconSize.Std24, "", null);
        this.fmBtn = UIHelper.createIconBtn("FormEdit", IconManager.IconSize.Std24, "", null);
        PanelBuilder toolsBtnPB = new PanelBuilder(new FormLayout("f:p:g,2px,p,2px,p", "p"));
        toolsBtnPB.add((Component)this.fmBtn, cc.xy(3, 1));
        toolsBtnPB.add((Component)this.rsBtn, cc.xy(5, 1));
        PanelBuilder leftPB = new PanelBuilder(new FormLayout("min(p;250px),10px,f:p:g", "p,2px,f:p:g, 4px,p,4px, p,2px,f:p:g, 2px,p"));
        int y = 1;
        this.topLbl = UIHelper.createLabel("Available Points");
        leftPB.add((Component)this.topLbl, cc.xy(1, y));
        leftPB.add((Component)UIHelper.createScrollPane(this.dbObjList, true), cc.xy(1, y += 2));
        leftPB.add((Component)upDwnPB.getPanel(), cc.xy(1, y += 2));
        leftPB.add((Component)UIHelper.createLabel("Selected Objects"), cc.xy(1, y += 2));
        leftPB.add((Component)UIHelper.createScrollPane(this.recSetList, true), cc.xy(1, y += 2));
        leftPB.add((Component)toolsBtnPB.getPanel(), cc.xy(1, y += 2));
        y += 2;
        this.wwPanel = new WorldWindPanel();
        this.wwPanel.setPreferredSize(new Dimension(500, 500));
        this.wwPanel.getWorld().addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.wwPanel.getWorld(), MarkerLayer.class));
        PanelBuilder rightPB = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        this.lineBuilder = new LineBuilder((WorldWindow)this.wwPanel.getWorld(), this.lineLayer, this.polyline);
        rightPB.add((Component)this.wwPanel, cc.xy(1, 1));
        y += 2;
        this.polyline.setAntiAliasHint(4354);
        this.polyline.setLineWidth(1.5);
        this.polyline.setFollowTerrain(true);
        this.startBtn = UIHelper.createI18NButton("Start");
        this.endBtn = UIHelper.createI18NButton("End");
        this.searchBtn = UIHelper.createI18NButton("SEARCH");
        this.clearAllBtn = UIHelper.createI18NButton("Clear All");
        this.clearSearchBtn = UIHelper.createI18NButton("Clear Search");
        this.typeCBX = UIHelper.createComboBox(TABLE_INFO);
        PanelBuilder btnPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g,p,f:p:g,p,f:p:g,p,f:p:g,p,f:p:g,p,f:p:g", "p"));
        btnPB.add((Component)this.typeCBX, cc.xy(2, 1));
        btnPB.add((Component)this.startBtn, cc.xy(4, 1));
        btnPB.add((Component)this.endBtn, cc.xy(6, 1));
        btnPB.add((Component)this.searchBtn, cc.xy(8, 1));
        btnPB.add((Component)this.clearSearchBtn, cc.xy(10, 1));
        btnPB.add((Component)this.clearAllBtn, cc.xy(12, 1));
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,10px,f:p:g", "f:p:g, 4px, p"), (JPanel)this);
        pb.add((Component)leftPB.getPanel(), cc.xy(1, 1));
        pb.add((Component)rightPB.getPanel(), cc.xy(3, 1));
        pb.add((Component)btnPB.getPanel(), cc.xyw(1, 3, 3));
        pb.setDefaultDialogBorder();
        this.startBtn.setEnabled(true);
        this.endBtn.setEnabled(false);
        this.searchBtn.setEnabled(false);
        this.clearAllBtn.setEnabled(false);
        this.clearSearchBtn.setEnabled(false);
        this.rsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordSetIFace rs = VisualQueryPanel.this.createRecordSet();
                if (rs != null) {
                    CommandDispatcher.dispatch(new CommandAction("Record_Set", "Save", null, null, rs));
                }
            }
        });
        this.fmBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordSetIFace rs = VisualQueryPanel.this.createRecordSet();
                if (rs != null) {
                    CommandDispatcher.dispatch(new CommandAction("Data_Entry", "Edit", rs));
                }
            }
        });
        this.searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VisualQueryPanel.this.doSearch();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.isCreatingPolygon = true;
                VisualQueryPanel.this.searchBtn.setEnabled(false);
                VisualQueryPanel.this.endBtn.setEnabled(true);
                VisualQueryPanel.this.startBtn.setEnabled(false);
                VisualQueryPanel.this.lineBuilder.setArmed(true);
            }
        });
        this.endBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.polyline.setClosed(true);
                VisualQueryPanel.this.isCreatingPolygon = false;
                VisualQueryPanel.this.searchBtn.setEnabled(true);
                VisualQueryPanel.this.endBtn.setEnabled(false);
                VisualQueryPanel.this.startBtn.setEnabled(false);
                VisualQueryPanel.this.searchBtn.setEnabled(true);
                VisualQueryPanel.this.clearAllBtn.setEnabled(true);
                VisualQueryPanel.this.clearSearchBtn.setEnabled(true);
                VisualQueryPanel.this.lineBuilder.setArmed(false);
            }
        });
        this.clearAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.doClearAll(true);
            }
        });
        this.clearSearchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.doClearAll(false);
            }
        });
        this.typeCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualQueryPanel.this.doPickedNewObjType();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualQueryPanel.this.typeCBX.setSelectedIndex(0);
            }
        });
    }

    private RecordSetIFace createRecordSet() {
        RecordSetIFace rs = null;
        DefaultListModel model = (DefaultListModel)this.recSetList.getModel();
        if (model.getSize() > 0) {
            rs = RecordSetFactory.getInstance().createRecordSet();
            rs.setDbTableId(TABLE_IDS[this.typeCBX.getSelectedIndex()]);
            int i = 0;
            while (i < model.getSize()) {
                LatLonPoint llp = (LatLonPoint)model.get(i);
                rs.addItem(llp.getLocId());
                ++i;
            }
        }
        return rs;
    }

    private void moveItems(JList srcList, HashSet<Integer> srcHash, JList dstList, HashSet<Integer> dstHash) {
        int inx = srcList.getSelectedIndex();
        if (inx > -1) {
            DefaultListModel srcModel = (DefaultListModel)srcList.getModel();
            DefaultListModel dstModel = (DefaultListModel)dstList.getModel();
            int[] indexes = srcList.getSelectedIndices();
            ArrayList<LatLonPoint> llpList = new ArrayList<LatLonPoint>(indexes.length);
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int selInx = nArray[n2];
                LatLonPoint llp = (LatLonPoint)srcModel.get(selInx);
                llpList.add(llp);
                if (!dstHash.contains(llp.getLocId())) {
                    dstModel.addElement(llp);
                    dstHash.add(llp.getLocId());
                }
                ++n2;
            }
            for (LatLonPoint llp : llpList) {
                srcModel.removeElement(llp);
                srcHash.remove(llp.getLocId());
            }
        }
    }

    private void doClearAll(boolean doClearPolygon) {
        if (doClearPolygon) {
            LayerList layers = this.wwPanel.getWorld().getModel().getLayers();
            int inx = layers.indexOf((Object)this.lineLayer);
            layers.remove(inx);
        }
        this.wwPanel.getMarkerLayer().clearList();
        this.wwPanel.getWorld().redrawNow();
        this.wwPanel.reset();
        if (doClearPolygon) {
            this.polyline = new Polyline();
            this.polyline.setAntiAliasHint(4354);
            this.polyline.setLineWidth(1.5);
            this.polyline.setFollowTerrain(true);
            this.lineLayer = new RenderableLayer();
            this.lineBuilder = new LineBuilder((WorldWindow)this.wwPanel.getWorld(), this.lineLayer, this.polyline);
        }
        ((DefaultListModel)this.dbObjList.getModel()).removeAllElements();
        this.topIdHash.clear();
        this.clearAllBtn.setEnabled(false);
        this.clearSearchBtn.setEnabled(false);
        this.startBtn.setEnabled(true);
    }

    private void doPickedNewObjType() {
        boolean hadItems = this.dbObjList.getModel().getSize() > 0;
        this.doClearAll(false);
        this.topLbl.setText(this.typeCBX.getSelectedItem().toString());
        DefaultListModel model = (DefaultListModel)this.recSetList.getModel();
        model.removeAllElements();
        this.botIdHash.clear();
        this.rsBtn.setEnabled(false);
        this.fmBtn.setEnabled(false);
        if (hadItems) {
            this.searchBtn.setEnabled(true);
            this.startBtn.setEnabled(false);
        }
    }

    private void doSearch() throws IOException {
        String CNT = "CNT";
        UIFieldFormatterIFace fieldFmt = null;
        if (this.typeCBX.getSelectedIndex() == 0) {
            fieldFmt = DBTableIdMgr.getFieldFormatterFor(CollectionObject.class, "catalogNumber");
        }
        final StringBuilder pmStr = new StringBuilder();
        String placeMark = " <Placemark><name>%s - %d / %d</name><Point><coordinates>%8.5f, %8.5f, 5</coordinates></Point></Placemark>\n";
        this.polySB.setLength(0);
        this.boxSB.setLength(0);
        final JStatusBar statusBar = UIRegistry.getStatusBar();
        final UIFieldFormatterIFace fldFmt = fieldFmt;
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                VisualQueryPanel.this.totalNumRecords = BasicSQLUtils.getCountAsInt(VisualQueryPanel.this.buildSQL(true));
                VisualQueryPanel.this.availPoints.clear();
                VisualQueryPanel.this.model = (DefaultListModel)VisualQueryPanel.this.dbObjList.getModel();
                VisualQueryPanel.this.model.removeAllElements();
                VisualQueryPanel.this.topIdHash.clear();
                VisualQueryPanel.this.markers.clear();
                VisualQueryPanel.this.polygon = new Polyline(VisualQueryPanel.this.polyline.getPositions());
                VisualQueryPanel.this.polygon.setClosed(true);
                for (Position p : VisualQueryPanel.this.polyline.getPositions()) {
                    VisualQueryPanel.this.polySB.append(String.format("    %8.5f, %8.5f, 20\n", p.longitude.degrees, p.latitude.degrees));
                }
                int maxThreshold = 1000;
                int index = 0;
                Connection conn = null;
                Statement stmt = null;
                try {
                    try {
                        conn = DBConnection.getInstance().createConnection();
                        stmt = conn.createStatement();
                        int currCnt = 0;
                        ResultSet rs = stmt.executeQuery(VisualQueryPanel.this.buildSQL(false));
                        while (rs.next()) {
                            if (currCnt < maxThreshold) {
                                double lon;
                                double lat = rs.getBigDecimal(2).doubleValue();
                                Position pos = Position.fromDegrees((double)lat, (double)(lon = rs.getBigDecimal(3).doubleValue()), (double)0.0);
                                if (GeometryMath.isLocationInside((LatLon)pos, (Iterable)VisualQueryPanel.this.polygon.getPositions())) {
                                    LatLonPoint llp = new LatLonPoint(rs.getInt(1), (Double)lat, lon);
                                    String title = rs.getString(4);
                                    title = title != null ? (fldFmt != null ? fldFmt.formatToUI(title) : title).toString() : "N/A";
                                    llp.setTitle(title);
                                    llp.setIndex(index++);
                                    VisualQueryPanel.this.availPoints.add(llp);
                                    VisualQueryPanel.this.markers.add(llp);
                                    VisualQueryPanel.this.topIdHash.add(llp.getLocId());
                                    System.out.println(String.valueOf(index) + " / " + currCnt + " In:      " + lat + ",  " + lon);
                                    pmStr.append(String.format(" <Placemark><name>%s - %d / %d</name><Point><coordinates>%8.5f, %8.5f, 5</coordinates></Point></Placemark>\n", "In: ", index, currCnt, lon, lat));
                                } else {
                                    System.out.println(String.valueOf(index) + " / " + currCnt + " Tossing: " + lat + ",  " + lon);
                                    pmStr.append(String.format(" <Placemark><name>%s - %d / %d</name><Point><coordinates>%8.5f, %8.5f, 5</coordinates></Point></Placemark>\n", "Tossing: ", index, currCnt, lon, lat));
                                }
                            }
                            if (++currCnt % 100 != 0) continue;
                            this.firePropertyChange("CNT", 0, currCnt);
                        }
                        rs.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (conn != null) {
                                conn.close();
                            }
                        }
                        catch (Exception ex2) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(BaseTreeTask.class, ex2);
                            ex2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(BaseTreeTask.class, ex);
                        ex.printStackTrace();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                if (VisualQueryPanel.this.doDebug) {
                    try {
                        String template = FileUtils.readFileToString((File)new File("template.kml"));
                        PrintWriter pw = new PrintWriter(new File("debug.kml"));
                        String str = StringUtils.replace((String)template, (String)"<!-- BOX -->", (String)VisualQueryPanel.this.boxSB.toString());
                        str = StringUtils.replace((String)str, (String)"<!-- POLYGON -->", (String)VisualQueryPanel.this.polySB.toString());
                        str = StringUtils.replace((String)str, (String)"<!-- PLACEMARKS -->", (String)pmStr.toString());
                        pw.println(str);
                        pw.flush();
                        pw.close();
                    }
                    catch (IOException template) {
                        // empty catch block
                    }
                }
                UIRegistry.clearSimpleGlassPaneMsg();
                statusBar.setProgressDone(VisualQueryPanel.STATUSBAR_NAME);
                for (LatLonPlacemarkIFace llp : VisualQueryPanel.this.markers) {
                    VisualQueryPanel.this.model.addElement(llp);
                }
                if (VisualQueryPanel.this.markers.size() > 0) {
                    VisualQueryPanel.this.wwPanel.placeMarkers(VisualQueryPanel.this.markers, null);
                    VisualQueryPanel.this.searchBtn.setEnabled(false);
                } else {
                    VisualQueryPanel.this.doClearAll(true);
                    VisualQueryPanel.this.startBtn.setEnabled(false);
                }
                VisualQueryPanel.this.clearAllBtn.setEnabled(true);
                VisualQueryPanel.this.clearSearchBtn.setEnabled(true);
            }
        };
        statusBar.setIndeterminate(STATUSBAR_NAME, false);
        statusBar.setProgressRange(STATUSBAR_NAME, 0, 100);
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("MySQLBackupService.BACKINGUP", "XXX"), 24);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("CNT".equals(evt.getPropertyName())) {
                    int value = (Integer)evt.getNewValue();
                    int progress = (int)((double)value / (double)VisualQueryPanel.this.totalNumRecords * 100.0);
                    glassPane.setProgress(progress);
                    statusBar.setValue(VisualQueryPanel.STATUSBAR_NAME, progress);
                }
            }
        });
        worker.execute();
    }

    private String buildSQL(boolean doForCount) {
        double latMin = Double.MAX_VALUE;
        double latMax = Double.MIN_VALUE;
        double lonMin = Double.MAX_VALUE;
        double lonMax = -1000.0;
        for (Position p : this.polyline.getPositions()) {
            double lat = p.getLatitude().getDegrees();
            double lon = p.getLongitude().getDegrees();
            if (lat <= latMin) {
                latMin = lat;
            }
            if (lat >= latMax) {
                latMax = lat;
            }
            if (lon <= lonMin) {
                lonMin = lon;
            }
            if (!(lon >= lonMax)) continue;
            lonMax = lon;
        }
        StringBuilder sb = new StringBuilder();
        switch (this.typeCBX.getSelectedIndex()) {
            case 0: {
                sb.append(this.doColObjSearchSQL(doForCount));
                break;
            }
            case 1: {
                sb.append(this.getLocalitySearchSQL(doForCount));
                break;
            }
            case 2: {
                sb.append(this.doCollEventSearchSQL(doForCount));
                break;
            }
            case 3: {
                sb.append(this.doTaxonSearchSQL(doForCount));
            }
        }
        System.err.println(String.valueOf(latMin) + ", " + lonMin + "    " + latMax + ", " + lonMax);
        this.boxSB.append(String.format("  %8.5f, %8.5f, 10\n", lonMin, latMin));
        this.boxSB.append(String.format("  %8.5f, %8.5f, 10\n", lonMin, latMax));
        this.boxSB.append(String.format("  %8.5f, %8.5f, 10\n", lonMax, latMax));
        this.boxSB.append(String.format("  %8.5f, %8.5f, 10\n", lonMax, latMin));
        String whereSQL = String.format(" Latitude1 >= %10.5f AND Latitude1 <= %10.5f AND Longitude1 >= %10.5f AND Longitude1 <= %10.5f", latMin, latMax, lonMin, lonMax);
        String sql = String.format(sb.toString(), whereSQL);
        return sql;
    }

    private String getLocalitySearchSQL(boolean doForCount) {
        String fields = "LocalityID, Latitude1, Longitude1, LocalityName";
        return "SELECT " + (doForCount ? "COUNT(*)" : fields) + " FROM locality WHERE %s GROUP BY LocalityID ORDER BY LocalityName";
    }

    private String doColObjSearchSQL(boolean doForCount) {
        String fields = "co.CollectionObjectID, l.Latitude1, l.Longitude1, co.CatalogNumber";
        return "SELECT " + (doForCount ? "COUNT(*)" : fields) + " FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID " + "INNER JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID WHERE %s ORDER BY CatalogNumber";
    }

    private String doCollEventSearchSQL(boolean doForCount) {
        String fields = "ce.CollectingEventID, l.Latitude1, l.Longitude1, ce.StartDate";
        return "SELECT " + (doForCount ? "COUNT(*)" : fields) + " FROM locality l " + "INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID WHERE %s GROUP BY ce.CollectingEventID ORDER BY StartDate";
    }

    private String doTaxonSearchSQL(boolean doForCount) {
        String fields = "t.TaxonID, l.Latitude1, l.Longitude1, t.FullName";
        return "SELECT " + (doForCount ? "COUNT(*)" : fields) + "FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID " + "INNER JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID " + "INNER JOIN determination d ON co.CollectionObjectID = d.CollectionObjectID " + "INNER JOIN taxon t ON d.TaxonID = t.TaxonID WHERE d.IsCurrent = TRUE AND %s GROUP BY t.TaxonID ORDER BY FullName";
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

