/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class SearchFormPane
extends FormPane {
    private static final Logger log = Logger.getLogger(SearchFormPane.class);
    protected FormViewObj formViewObj;
    protected Hashtable<String, Hashtable<String, String>> hashTables = new Hashtable();

    public SearchFormPane(String name, Taskable task, String viewSetName, String viewName) {
        super(name, task, viewSetName, viewName, AltViewIFace.CreationMode.SEARCH.toString(), null, 4);
        Viewable viewable = this.multiView.getCurrentView();
        if (!(viewable instanceof FormViewObj)) {
            throw new RuntimeException("The form didn't create a FormViewObj for the Viewable!.");
        }
        this.formViewObj = (FormViewObj)viewable;
        this.walkMultiViewsSetHash(this.multiView);
        JComponent saveComp = this.formViewObj.getSaveComponent();
        if (!(saveComp instanceof JButton)) {
            throw new RuntimeException("The Save Component MUST be a button for this form!");
        }
        JButton saveBtn = (JButton)saveComp;
        saveBtn.setEnabled(true);
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchFormPane.this.doSearch();
            }
        });
    }

    protected void walkMultiViewsSetHash(MultiView multiViewArg) {
        Hashtable formData = new Hashtable();
        Viewable currentViewable = multiViewArg.getCurrentView();
        this.hashTables.put(currentViewable.getView().getName(), formData);
        multiViewArg.setData(formData);
        for (MultiView mv : multiViewArg.getKids()) {
            this.walkMultiViewsSetHash(mv);
        }
    }

    protected void walkMultiViewsGetValues(MultiView multiViewArg) {
        multiViewArg.getCurrentView().getDataFromUI();
        for (MultiView mv : multiViewArg.getKids()) {
            this.walkMultiViewsGetValues(mv);
        }
    }

    protected void doSearch() {
        this.walkMultiViewsGetValues(this.multiView);
        String[] nameMap = new String[]{"Collection Object Search", "CollectionObject"};
        int i = 0;
        while (i < nameMap.length) {
            String nameStr = nameMap[i++];
            Hashtable<String, String> formData = this.hashTables.get(nameStr);
            Enumeration<String> e = formData.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = formData.get(key);
                log.debug((Object)("[" + key + "][" + value + "]"));
            }
            ++i;
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.formViewObj = null;
        super.shutdown();
    }
}

