/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class SQLQueryPane
extends BaseSubPane
implements SQLExecutionListener {
    private JTextArea textArea;
    private JScrollPane taScrollPane;
    private JTable table;
    private JButton exeBtn;
    private JLabel label;
    private JButton selectAllBtn;
    private JButton deselectAllBtn;
    private JButton saveToRSBtn;
    private boolean hideSQLField;
    private SQLExecutionProcessor sqlExecutor;
    private String sqlStr;

    public SQLQueryPane(String name, Taskable task, boolean hideSQLField, boolean hideBtnPanel) {
        super(name, task);
        CellConstraints cc;
        PanelBuilder builder;
        FormLayout formLayout;
        this.setPreferredSize(new Dimension(600, 600));
        this.hideSQLField = hideSQLField;
        this.table = new JTable();
        if (!hideSQLField) {
            this.textArea = new JTextArea(80, 6);
            this.taScrollPane = new JScrollPane(this.textArea);
            this.taScrollPane.setHorizontalScrollBarPolicy(30);
            this.taScrollPane.setVerticalScrollBarPolicy(20);
            this.taScrollPane.setPreferredSize(new Dimension(400, 100));
            formLayout = new FormLayout("p,2dlu,100dlu:g,2dlu,p", "center:p:g");
            builder = new PanelBuilder(formLayout);
            cc = new CellConstraints();
            this.exeBtn = UIHelper.createButton(UIRegistry.getResourceString("Execute"));
            this.exeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLQueryPane.this.doQuery();
                }
            });
            this.label = UIHelper.createLabel("SQL:");
            builder.add((Component)this.label, cc.xy(1, 1));
            builder.add((Component)this.taScrollPane, cc.xy(3, 1));
            builder.add((Component)this.exeBtn, cc.xy(5, 1));
            this.add((Component)builder.getPanel(), "North");
            this.add((Component)new JScrollPane(this.table), "Center");
        }
        if (!hideBtnPanel) {
            formLayout = new FormLayout("p,2dlu,p,2dlu,p", "center:p:g");
            builder = new PanelBuilder(formLayout);
            cc = new CellConstraints();
            this.selectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("SELECTALL"));
            this.deselectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("DeselectAll"));
            this.saveToRSBtn = UIHelper.createButton(UIRegistry.getResourceString("SaveToRecordSet"));
            builder.add((Component)this.selectAllBtn, cc.xy(1, 1));
            builder.add((Component)this.deselectAllBtn, cc.xy(3, 1));
            builder.add((Component)this.saveToRSBtn, cc.xy(5, 1));
            this.add((Component)builder.getPanel(), "South");
            this.selectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SQLQueryPane.this.table.selectAll();
                }
            });
            this.deselectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SQLQueryPane.this.table.clearSelection();
                }
            });
            this.saveToRSBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.enableUI(true);
        }
    }

    public void enableUI(boolean enabled) {
        if (!this.hideSQLField) {
            this.exeBtn.setEnabled(enabled);
            this.textArea.setEnabled(enabled);
            this.label.setEnabled(enabled);
            if (this.selectAllBtn != null) {
                boolean en = enabled && this.table.getModel() != null && this.table.getModel().getRowCount() > 0;
                this.selectAllBtn.setEnabled(en);
                this.deselectAllBtn.setEnabled(en && this.table.getSelectedRowCount() > 0);
                this.saveToRSBtn.setEnabled(en);
            }
        }
    }

    public void doQuery() {
        ResultSetTableModel model;
        this.enableUI(false);
        if (this.sqlExecutor != null) {
            this.sqlExecutor.close();
        }
        if (this.table.getModel() instanceof ResultSetTableModel && (model = (ResultSetTableModel)this.table.getModel()) != null) {
            model.clear();
        }
        this.progressLabel.setText(UIRegistry.getResourceString("QueryStarting"));
        String queryStr = this.getSQLStr();
        queryStr = queryStr.replace("\r\n", " ");
        queryStr = queryStr.replace("\r", " ");
        queryStr = queryStr.replace("\n", " ");
        this.sqlExecutor = new SQLExecutionProcessor(this, queryStr);
        this.sqlExecutor.setAutoCloseConnection(false);
        this.sqlExecutor.start();
    }

    public void setSQLStr(String sqlStr) {
        this.sqlStr = sqlStr;
        if (this.textArea != null) {
            this.textArea.setText(sqlStr);
        }
    }

    public String getSQLStr() {
        return this.textArea == null ? this.sqlStr : this.textArea.getText();
    }

    public void finalize() {
        if (this.sqlExecutor != null) {
            this.sqlExecutor.close();
        }
        this.sqlExecutor = null;
    }

    @Override
    public synchronized void exectionDone(SQLExecutionProcessor process, ResultSet resultSet) {
    }

    @Override
    public synchronized void executionError(SQLExecutionProcessor process, Exception ex) {
        this.sqlExecutor = null;
        this.enableUI(true);
        JOptionPane.showMessageDialog(this, ex.toString(), "SQL Error", 0);
    }
}

