/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.tasks.subpane.FormProcessor;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PickListProcessor
implements FormProcessor {
    protected FormPane formPane = null;
    protected Viewable viewable;
    protected JButton addBtn = null;
    protected JButton removeBtn = null;
    protected JList list = null;
    protected JTextField title = null;
    protected JTextField value = null;
    protected JTextField name = null;
    protected List<String> titlesList = new ArrayList<String>();
    protected List<String> usedInList = new ArrayList<String>();
    protected PickList pickList;

    public PickListProcessor(List<String> titlesList) {
        this.titlesList = titlesList;
    }

    public int getNumUsed() {
        return this.usedInList.size();
    }

    public boolean doEvaluate() {
        String nameStr = this.name.getText();
        return StringUtils.isNotEmpty((String)nameStr) && Collections.binarySearch(this.titlesList, nameStr) < 0;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public void setViewable(FormPane formPane) {
        this.formPane = formPane;
        if (formPane != null) {
            this.viewable = formPane.getViewable();
            this.pickList = (PickList)this.viewable.getDataObj();
            this.name = (JTextField)this.viewable.getCompById("name");
            this.list = (JList)this.viewable.getCompById("items");
            this.title = (JTextField)this.viewable.getCompById("title");
            this.value = (JTextField)this.viewable.getCompById("value");
            this.list.setModel(new AbstractListModel(){

                @Override
                public int getSize() {
                    return PickListProcessor.this.usedInList.size();
                }

                @Override
                public Object getElementAt(int index) {
                    return PickListProcessor.this.usedInList.get(index);
                }
            });
            JButton saveBtn = (JButton)this.viewable.getCompById("savePL");
            this.viewable.getValidator().addEnableItem(saveBtn, FormValidator.EnableType.ValidAndChangedItems);
            this.viewable.getValidator().addRuleObjectMapping("processor", this);
            this.addBtn = (JButton)this.viewable.getCompById("AddItem");
            this.removeBtn = (JButton)this.viewable.getCompById("RemoveItem");
            this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PickListItem pli = new PickListItem(PickListProcessor.this.title.getText(), null, new Timestamp(System.currentTimeMillis()));
                    PickListProcessor.this.pickList.addItem(pli);
                    pli.setPickList(PickListProcessor.this.pickList);
                    PickListProcessor.this.title.setText("");
                    PickListProcessor.this.value.setText("");
                    ListModel lm = PickListProcessor.this.list.getModel();
                    if (!(lm instanceof DefaultListModel)) {
                        throw new RuntimeException("Unknown model type for JList[" + lm + "]");
                    }
                    ((DefaultListModel)lm).addElement(pli);
                    PickListProcessor.this.list.setSelectedIndex(-1);
                    PickListProcessor.this.viewable.getValidator().validateForm();
                }
            });
            this.removeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Object[] objs;
                    Object[] objectArray = objs = PickListProcessor.this.list.getSelectedValues();
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        PickListProcessor.this.pickList.removeItem((PickListItemIFace)o);
                        ListModel lm = PickListProcessor.this.list.getModel();
                        if (!(lm instanceof DefaultListModel)) {
                            throw new RuntimeException("Unknown model type for JList[" + lm + "]");
                        }
                        ((DefaultListModel)lm).removeElement(o);
                        ++n2;
                    }
                    PickListProcessor.this.list.setSelectedIndex(-1);
                    PickListProcessor.this.viewable.getValidator().validateForm();
                }
            });
            JButton deleteBtn = (JButton)this.viewable.getCompById("deletePL");
            deleteBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CommandDispatcher.dispatch(new CommandAction("SystemSetup", "DeletePickList", PickListProcessor.this.viewable.getDataObj()));
                }
            });
            saveBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PickListProcessor.this.pickList.setName(((JTextField)PickListProcessor.this.viewable.getCompById("name")).getText());
                    String sizeStr = ((JTextField)PickListProcessor.this.viewable.getCompById("sizeLimit")).getText().trim();
                    PickListProcessor.this.pickList.setSizeLimit(StringUtils.isNotEmpty((String)sizeStr) ? Integer.parseInt(sizeStr) : 0);
                    PickListProcessor.this.pickList.setReadOnly(((JCheckBox)PickListProcessor.this.viewable.getCompById("readOnly")).isSelected());
                    CommandDispatcher.dispatch(new CommandAction("SystemSetup", "SavePickList", PickListProcessor.this.viewable.getDataObj()));
                }
            });
            this.viewable.getValidator().validateForm();
        } else {
            this.viewable = null;
            this.pickList = null;
        }
    }
}

