/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.af.ui.forms.ControlBarPanel;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.ResultSetControllerListener;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.services.mapping.LocalityMapper;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.extras.FishBaseInfoGetter;
import edu.ku.brc.specify.extras.FishBaseInfoGetterListener;
import edu.ku.brc.specify.tasks.services.CollectingEventLocalityKMLGenerator;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ImageDisplay;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.animation.timing.TimingTarget;

public class LocalityMapperSubPane
extends BaseSubPane
implements LocalityMapper.MapperListener,
ResultSetControllerListener,
TimingTarget {
    protected DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    protected static final Cursor handCursor = new Cursor(12);
    protected static final Cursor defCursor = new Cursor(0);
    protected LocalityMapper localityMapper = new LocalityMapper();
    protected JLabel imageLabel = UIHelper.createLabel(UIRegistry.getResourceString("LoadingImage"));
    protected JLabel titleLabel = UIHelper.createLabel("");
    protected MultiView multiView;
    protected List<CollectingEvent> collectingEvents;
    protected List<Hashtable<String, Object>> valueList = new ArrayList<Hashtable<String, Object>>();
    protected List<Rectangle> markerRects = new ArrayList<Rectangle>();
    protected boolean dirty = false;
    protected List<ImageGetter> imageGetterList = new ArrayList<ImageGetter>();
    protected Hashtable<String, Image> imageMap = new Hashtable();
    protected FormViewObj formViewObj;
    protected JList imageJList;
    protected Hashtable<String, String> imageURLs = new Hashtable();
    protected ResultSetController recordSetController;
    protected ControlBarPanel controlPanel;
    protected JButton googleBtn;
    protected CollectingEventLocalityKMLGenerator kmlGen;
    protected List<CollectingEvent> colEvents;
    protected LocalityMapperSubPane thisPane;

    public LocalityMapperSubPane(String name, Taskable task, List<CollectingEvent> colEvents) {
        super(name, task);
        this.colEvents = colEvents;
        this.thisPane = this;
        this.progressLabel.setText("Loading Locality Data and Maps...");
        this.setBackground(Color.WHITE);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                LocalityMapperSubPane.this.createUI();
                return null;
            }

            @Override
            public void finished() {
                LocalityMapperSubPane.this.thisPane.removeAll();
                LocalityMapperSubPane.this.setLayout(new LocalityMapperLayoutManager(LocalityMapperSubPane.this.thisPane, LocalityMapperSubPane.this.titleLabel, LocalityMapperSubPane.this.imageLabel, LocalityMapperSubPane.this.controlPanel, LocalityMapperSubPane.this.multiView));
                LocalityMapperSubPane.this.multiView.setData(LocalityMapperSubPane.this.valueList.get(0));
                LocalityMapperSubPane.this.validate();
                LocalityMapperSubPane.this.doLayout();
            }
        };
        worker.start();
    }

    protected void createUI() {
        this.kmlGen = new CollectingEventLocalityKMLGenerator();
        this.collectingEvents = new ArrayList<CollectingEvent>();
        CollectingEvent startCE = null;
        CollectingEvent endCE = null;
        Vector<Object> localities = new Vector<Object>();
        Vector<String> labels = new Vector<String>();
        for (CollectingEvent obj : this.colEvents) {
            Calendar rightCal;
            CollectingEvent collectingEvent = obj;
            Locality locality = collectingEvent.getLocality();
            if (locality == null || locality.getLatitude1() == null || locality.getLongitude1() == null) continue;
            this.collectingEvents.add(collectingEvent);
            this.kmlGen.addDataObj(collectingEvent, "");
            if (this.collectingEvents.size() == 1) {
                startCE = collectingEvent;
                endCE = collectingEvent;
            }
            if (startCE == null || endCE == null) {
                return;
            }
            if (startCE.getStartDate().compareTo(collectingEvent.getStartDate()) > 1) {
                startCE = collectingEvent;
            }
            Calendar leftCal = endCE.getEndDate() != null ? endCE.getEndDate() : endCE.getStartDate();
            Calendar calendar = rightCal = collectingEvent.getEndDate() != null ? collectingEvent.getEndDate() : collectingEvent.getStartDate();
            if (leftCal.compareTo(rightCal) < 0) {
                endCE = collectingEvent;
            }
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            Set<CollectionObject> colObjs = collectingEvent.getCollectionObjects();
            map.put("startDate", collectingEvent.getStartDate());
            map.put("endDate", collectingEvent.getEndDate());
            HashSet<String> taxonNames = new HashSet<String>();
            block1: for (CollectionObject co : colObjs) {
                for (Determination d : co.getDeterminations()) {
                    Taxon genus;
                    if (!d.isCurrentDet()) continue;
                    Taxon taxon = d.getPreferredTaxon();
                    if (taxon == null) continue block1;
                    taxonNames.add(String.valueOf(taxon.getName()) + (co.getCountAmt() != null ? " (" + co.getCountAmt() + ")" : ""));
                    if (taxon.getRankId() != 220 || (genus = taxon.getParent()).getRankId() != 180) continue block1;
                    ImageGetter imgGetter = new ImageGetter(this.imageGetterList, this.imageMap, this.imageURLs, genus.getName(), taxon.getName());
                    this.imageGetterList.add(imgGetter);
                    continue block1;
                }
            }
            map.put("taxonItems", taxonNames);
            map.put("latitude1", locality.getLatitude1());
            map.put("longitude1", locality.getLongitude1());
            labels.add(Integer.toString(this.collectingEvents.size()));
            localities.add(locality);
            this.valueList.add(map);
        }
        this.localityMapper.setMaxMapWidth(515);
        this.localityMapper.setMaxMapHeight(375);
        Color arrow = new Color(220, 220, 220);
        this.localityMapper.setArrowColor(arrow);
        this.localityMapper.setDotColor(Color.WHITE);
        this.localityMapper.setDotSize(4);
        this.localityMapper.setLabelColor(Color.RED);
        int inx = 0;
        for (Locality locality : localities) {
            this.localityMapper.addLocationAndLabel(locality, labels != null ? (String)labels.get(inx) : null);
            ++inx;
        }
        this.localityMapper.setCurrentLoc((LocalityMapper.MapLocationIFace)localities.get(0));
        this.localityMapper.setCurrentLocColor(Color.RED);
        ViewIFace viewIFace = AppContextMgr.getInstance().getView("LocalityMapper");
        this.multiView = new MultiView(null, null, viewIFace, AltViewIFace.CreationMode.VIEW, 0);
        this.multiView.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(138, 128, 128)), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.formViewObj = this.multiView.getCurrentViewAsFormViewObj();
        this.formViewObj.getUIComponent().setBackground(Color.WHITE);
        this.imageJList = (JList)this.formViewObj.getCompById("taxonItems");
        this.imageJList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int index;
                    String nameStr = (String)LocalityMapperSubPane.this.imageJList.getSelectedValue();
                    if (nameStr != null && (index = nameStr.indexOf(" (")) > -1) {
                        nameStr = nameStr.substring(0, index);
                    }
                    Image img = null;
                    if (StringUtils.isNotEmpty((String)nameStr)) {
                        img = LocalityMapperSubPane.this.imageMap.get(nameStr);
                        ImageDisplay imgDisplay = (ImageDisplay)LocalityMapperSubPane.this.formViewObj.getCompById("image");
                        if (img != null) {
                            imgDisplay.setImage(new ImageIcon(img));
                        } else {
                            imgDisplay.setImage((Image)null);
                        }
                    }
                }
            }
        });
        if (startCE == null || endCE == null) {
            return;
        }
        String startDateStr = this.scrDateFormat.format(startCE.getStartDate().getTime());
        String endDateStr = this.scrDateFormat.format((endCE.getEndDate() != null ? endCE.getEndDate() : endCE.getStartDate()).getTime());
        Formatter formatter = new Formatter();
        this.titleLabel.setText(formatter.format(UIRegistry.getResourceString("LocalityMapperTitle"), startDateStr, endDateStr).toString());
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(new Font(font.getFontName(), 1, font.getSize() + 2));
        this.recordSetController = new ResultSetController(null, false, false, false, null, this.collectingEvents.size(), true);
        this.recordSetController.addListener(this);
        this.recordSetController.getPanel().setBackground(Color.WHITE);
        this.controlPanel = new ControlBarPanel(this.getBackground());
        this.controlPanel.add(this.recordSetController.getPanel());
        this.controlPanel.setRecordSetController(this.recordSetController);
        this.controlPanel.setBackground(Color.WHITE);
        this.googleBtn = new JButton(IconManager.getIcon("GoogleEarth", IconManager.STD_ICON_SIZE));
        this.googleBtn.setMargin(new Insets(1, 1, 1, 1));
        this.googleBtn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.googleBtn.setSize(new Dimension(18, 18));
        this.googleBtn.setPreferredSize(new Dimension(18, 18));
        this.googleBtn.setMaximumSize(new Dimension(18, 18));
        this.googleBtn.setFocusable(false);
        this.googleBtn.setBackground(Color.WHITE);
        this.controlPanel.addButtons(new JButton[]{this.googleBtn}, false);
        this.googleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    UIRegistry.displayStatusBarText("Exporting Collecting Events in KML.");
                    LocalityMapperSubPane.this.kmlGen.setSpeciesToImageMapper(LocalityMapperSubPane.this.imageURLs);
                    LocalityMapperSubPane.this.kmlGen.outputToFile(String.valueOf(System.getProperty("user.home")) + File.separator + "specify.kml");
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(LocalityMapperSubPane.class, ex);
                    ex.printStackTrace();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                LocalityMapperSubPane.this.checkMouseLocation(e.getPoint(), false);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LocalityMapperSubPane.this.checkMouseLocation(e.getPoint(), true);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocalityMapperSubPane.this.getLocalityMap();
            }
        });
    }

    protected void getLocalityMap() {
        this.localityMapper.getMap(this);
    }

    protected void setLabel(final Icon imageIcon) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocalityMapperSubPane.this.imageLabel.setText(null);
                LocalityMapperSubPane.this.imageLabel.setIcon(imageIcon);
            }
        });
        this.dirty = true;
    }

    protected void setLabel(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocalityMapperSubPane.this.imageLabel.setIcon(null);
                LocalityMapperSubPane.this.imageLabel.setText(msg);
            }
        });
    }

    public void checkMouseLocation(Point mousePnt, boolean showInfo) {
        if (this.dirty) {
            this.markerRects.clear();
            Point pnt = this.imageLabel.getLocation();
            for (Point p : this.localityMapper.getMarkerLocations()) {
                this.markerRects.add(new Rectangle(pnt.x + p.x - 5, pnt.y + p.y - 5, 10, 10));
            }
            this.dirty = false;
        }
        int inx = 0;
        for (Rectangle r : this.markerRects) {
            if (r.contains(mousePnt)) {
                if (showInfo) {
                    Hashtable<String, Object> map = this.valueList.get(inx);
                    this.multiView.setData(map);
                    this.localityMapper.setCurrentLoc(this.collectingEvents.get(inx).getLocality());
                } else {
                    this.setCursor(handCursor);
                }
                return;
            }
            this.setCursor(defCursor);
            ++inx;
        }
    }

    @Override
    public void indexChanged(int newIndex) {
        Hashtable<String, Object> map = this.valueList.get(newIndex);
        this.multiView.setData(map);
        this.localityMapper.setCurrentLoc(this.collectingEvents.get(newIndex).getLocality());
        this.repaint();
    }

    @Override
    public boolean indexAboutToChange(int oldIndex, int newIndex) {
        return true;
    }

    @Override
    public void newRecordAdded() {
    }

    @Override
    public void mapReceived(Icon map) {
        this.setLabel(map);
    }

    @Override
    public void exceptionOccurred(Exception e) {
        this.setLabel("Was unable to get the map.");
    }

    public void begin() {
    }

    public void end() {
    }

    public void repeat() {
    }

    public void timingEvent(float fraction) {
        this.repaint();
    }

    class ImageGetter
    implements FishBaseInfoGetterListener {
        protected FishBaseInfoGetter getter;
        protected List<ImageGetter> list;
        protected Hashtable<String, Image> map;
        protected Hashtable<String, String> imageURLMap;
        protected String genus;
        protected String species;

        public ImageGetter(List<ImageGetter> list, Hashtable<String, Image> map, Hashtable<String, String> imageURLMap, String genus, String species) {
            this.list = list;
            this.map = map;
            this.genus = genus;
            this.species = species;
            this.imageURLMap = imageURLMap;
            this.getter = new FishBaseInfoGetter(this, FishBaseInfoGetter.InfoType.Thumbnail, genus, species);
            this.getter.start();
        }

        @Override
        public void infoArrived(FishBaseInfoGetter getterArg) {
            if (getterArg.getImage() != null) {
                this.imageURLMap.put(String.valueOf(this.genus) + " " + this.species, getterArg.getImageURL());
                this.map.put(this.species, getterArg.getImage());
            }
            this.cleanUp();
        }

        @Override
        public void infoGetWasInError(FishBaseInfoGetter getterArg) {
            this.cleanUp();
        }

        protected void cleanUp() {
            this.list.remove(this);
            this.list = null;
            this.map = null;
            this.getter.setConsumer(null);
            this.getter = null;
        }
    }

    class LocalityMapperLayoutManager
    implements LayoutManager {
        protected final int gap = 5;
        protected final LocalityMapperSubPane parent;
        protected final JLabel titleLbl;
        protected final JLabel label;
        protected final JPanel controlBar;
        protected final MultiView form;
        protected Dimension preferredSize = new Dimension(100, 100);

        public LocalityMapperLayoutManager(LocalityMapperSubPane parent, JLabel titleLbl, JLabel label, JPanel controlBar, MultiView form) {
            this.parent = parent;
            this.label = label;
            this.titleLbl = titleLbl;
            this.controlBar = controlBar;
            this.form = form;
            parent.add(label);
            parent.add(form);
            parent.add(titleLbl);
            parent.add(controlBar);
        }

        @Override
        public void addLayoutComponent(String arg0, Component arg1) {
        }

        @Override
        public void removeLayoutComponent(Component arg0) {
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            Dimension formSize = this.form.getPreferredSize();
            return new Dimension(formSize.width + 200, formSize.height + 200);
        }

        @Override
        public Dimension minimumLayoutSize(Container arg0) {
            Dimension size = arg0.getPreferredSize();
            Dimension formSize = this.form.getPreferredSize();
            int w = size.width - formSize.width - 15;
            int h = size.height - formSize.height - 10;
            return new Dimension(w, h);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension size = target.getSize();
                Dimension formSize = this.form.getPreferredSize();
                if (size.width > formSize.width && size.height > formSize.height) {
                    this.preferredSize.setSize(size.width - formSize.width - 15, formSize.height);
                    int formY = (size.height - formSize.height) / 2;
                    this.form.setLocation(size.width - formSize.width - 5, formY);
                    this.form.setSize(formSize);
                    this.form.setVisible(true);
                    Dimension compSize = this.titleLbl.getPreferredSize();
                    this.titleLbl.setBounds((size.width - compSize.width) / 2, (formY - compSize.height) / 2, compSize.width, compSize.height);
                    int labelX = 5;
                    int labelY = (size.height - this.preferredSize.height) / 2;
                    this.label.setLocation(labelX, labelY);
                    this.label.setSize(this.preferredSize);
                    LocalityMapperSubPane.this.localityMapper.setMaxMapWidth(this.preferredSize.width);
                    LocalityMapperSubPane.this.localityMapper.setMaxMapHeight(this.preferredSize.height);
                    compSize = this.controlBar.getPreferredSize();
                    this.controlBar.setBounds(labelX + (this.preferredSize.width - compSize.width) / 2, labelY + this.preferredSize.height + 5, compSize.width, compSize.height);
                } else {
                    this.preferredSize.setSize(size.width - 10, size.height - 10);
                    this.label.setLocation(0, 0);
                    this.label.setSize(this.preferredSize);
                    this.form.setVisible(false);
                }
            }
        }
    }
}

