/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.ui.WorldWindPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ImageDisplay;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.util.Pair;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONTokener;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;

public class LifeMapperPane
extends BaseSubPane
implements ChangeListener {
    protected static final int GLASS_FONT_SIZE = 14;
    protected static final int MAX_IMAGE_REQUEST_COUNT = 3;
    private static final String URL_FMT = "http://lifemapper.org/ogc?%s&request=GetMap&service=WMS&version=1.1.0&bbox=%s&srs=epsg:4326&format=image/png&width=%d&height=%d&styles=&color=ff0000";
    private static final String BG_URL = "http://lifemapper.org/ogc?LAYERS=bmnglowres&MAP=anc_nasalocal.map&SERVICE=WMS&VERSION=1.0.0&FORMAT=image%2Fgif&REQUEST=GetMap&STYLES=&EXCEPTIONS=application%2Fvnd.ogc.se_inimage&SRS=EPSG%3A4326&BBOX=-180,-90,180,90&";
    private static final String BBOX_STR = "-180.0,-90.0,180.0,90.0";
    protected static final int MAP_WIDTH = 600;
    protected static final int MAP_HEIGHT = 450;
    protected static final int IMG_WIDTH = 450;
    protected static final int IMG_HEIGHT = 225;
    protected BufferedImage blueMarble = null;
    protected int blueMarbleTries = 0;
    protected String blueMarbleURL;
    protected ImageListener blueMarbleListener;
    protected ImageListener pointsMapImageListener;
    protected BufferedImage renderImage = null;
    protected WorldWindPanel wwPanel;
    protected boolean doResetWWPanel = true;
    protected JButton searchBtn;
    protected int currentSize = 0;
    protected DefaultListModel model = null;
    protected List<LatLonPlacemarkIFace> markers = new Vector<LatLonPlacemarkIFace>();
    protected Polyline polygon = null;
    protected int totalNumRecords = 0;
    protected JTextField myDataTF;
    protected JButton searchMyDataBtn;
    protected String myDataTaxa = "";
    protected JComponent mySepComp;
    protected JButton searchSciNameBtn;
    protected JTextField searchText;
    protected String occurSet = null;
    protected JList list;
    protected DefaultListModel listModel = new DefaultListModel();
    protected ArrayList<OccurrenceSetIFace> occurList = new ArrayList();
    protected ImageDisplay imgDisplay;
    protected int imgRequestCnt = 0;
    protected String imgURL = null;
    protected ImageIcon markerImg;
    protected ArrayList<LatLonPlacemarkIFace> points = new ArrayList();

    public LifeMapperPane(String name, Taskable task) {
        super(name, task);
        this.markerImg = IconManager.getIcon("RedDot6x6");
        this.createUI();
    }

    private int getCurrentSizeSquare() {
        int maxHeight = 450;
        int maxWidth = 600;
        if (SubPaneMgr.getInstance() instanceof JTabbedPane) {
            Dimension size;
            SubPaneMgr tbPane = SubPaneMgr.getInstance();
            if (tbPane.getTabCount() > 0) {
                size = tbPane.getComponentAt(0).getSize();
            } else {
                size = tbPane.getSize();
                size.height -= 30;
            }
            int lblHeight = UIHelper.createLabel((String)" ").getPreferredSize().height * 5;
            maxHeight = size.height - lblHeight - 225 - 30;
            maxWidth = size.width - 20;
        }
        return Math.min(maxHeight, maxWidth);
    }

    public boolean hasSizeChanged() {
        int newSize = this.getCurrentSizeSquare();
        return this.currentSize != newSize;
    }

    protected void createUI() {
        this.currentSize = this.getCurrentSizeSquare();
        this.searchText = UIHelper.createTextField(25);
        this.searchSciNameBtn = UIHelper.createI18NButton("LM_SEARCH");
        this.list = new JList(this.listModel);
        this.imgDisplay = new ImageDisplay(450, 225, false, true);
        this.imgDisplay.setChangeListener(this);
        this.wwPanel = new WorldWindPanel(false);
        this.wwPanel.setPreferredSize(new Dimension(this.currentSize, this.currentSize));
        this.wwPanel.setZoomInMeters(600000.0);
        this.imgDisplay.setDoShowText(false);
        this.searchMyDataBtn = UIHelper.createI18NButton("LM_SRCH_SP_DATA");
        this.myDataTF = UIHelper.createTextField();
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb1 = new PanelBuilder(new FormLayout("p,2px,f:p:g,2px,p", "p"));
        pb1.add((Component)UIHelper.createI18NFormLabel("LM_SRCH_COL"), cc.xy(1, 1));
        pb1.add((Component)this.searchText, cc.xy(3, 1));
        pb1.add((Component)this.searchSciNameBtn, cc.xy(5, 1));
        PanelBuilder myPB = new PanelBuilder(new FormLayout("f:p:g,p", "p,2px,p,2px,p"));
        this.mySepComp = myPB.addSeparator(UIRegistry.getResourceString("LM_MYDATA_TITLE"), cc.xyw(1, 1, 2));
        myPB.add((Component)this.myDataTF, cc.xyw(1, 3, 2));
        myPB.add((Component)this.searchMyDataBtn, cc.xy(2, 5));
        PanelBuilder pb2 = new PanelBuilder(new FormLayout("MAX(p;300px),2px,f:p:g", "f:p:g,20px,p"));
        pb2.add((Component)UIHelper.createScrollPane(this.list), cc.xy(1, 1));
        pb2.add((Component)myPB.getPanel(), cc.xy(1, 3));
        PanelBuilder pb3 = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "f:p:g,p,4px,p,f:p:g"));
        pb3.add((Component)UIHelper.createI18NLabel("LM_WRLD_OVRVW", 0), cc.xy(2, 2));
        pb3.add((Component)this.imgDisplay, cc.xy(2, 4));
        PanelBuilder pb4 = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "f:p:g,p,4px,p,f:p:g"));
        pb4.add((Component)UIHelper.createI18NLabel("LM_INTRACT_VW", 0), cc.xy(2, 2));
        pb4.add((Component)this.wwPanel, cc.xy(2, 4));
        PanelBuilder pb5 = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,p,f:p:g"));
        pb5.add((Component)pb3.getPanel(), cc.xy(1, 1));
        pb5.add((Component)pb4.getPanel(), cc.xy(1, 3));
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,8px,f:p:g", "p,8px,f:p:g"), (JPanel)this);
        pb.add((Component)pb1.getPanel(), cc.xyw(1, 1, 3));
        pb.add((Component)pb2.getPanel(), cc.xy(1, 3));
        pb.add((Component)pb5.getPanel(), cc.xy(3, 3));
        this.updateMyDataUIState(false);
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LifeMapperPane.this.searchSciNameBtn.doClick();
                }
            }
        });
        this.myDataTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LifeMapperPane.this.searchMyDataBtn.doClick();
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (LifeMapperPane.this.list.getSelectedIndex() == -1) {
                        LifeMapperPane.this.wwPanel.reset();
                        LifeMapperPane.this.imgDisplay.setImage(LifeMapperPane.this.blueMarble);
                    } else {
                        SwingWorker<Boolean, Boolean> worker = new SwingWorker<Boolean, Boolean>(){

                            @Override
                            protected Boolean doInBackground() throws Exception {
                                if ((this).LifeMapperPane.this.doResetWWPanel) {
                                    (this).LifeMapperPane.this.wwPanel.reset();
                                }
                                LifeMapperPane.this.doSearchOccur();
                                return null;
                            }

                            @Override
                            protected void done() {
                                (this).LifeMapperPane.this.imgDisplay.repaint();
                            }
                        };
                        worker.execute();
                    }
                }
            }
        });
        this.searchMyDataBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LifeMapperPane.this.doSearchSpecifyData((this).LifeMapperPane.this.myDataTF.getText().trim());
                    }
                });
            }
        });
        this.searchSciNameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LifeMapperPane.this.doSearchGenusSpecies();
            }
        });
        this.blueMarbleListener = new ImageListener(){

            @Override
            public void imageFetched(BufferedImage image) {
                LifeMapperPane.this.blueMarble = image;
                LifeMapperPane.this.imgDisplay.setImage(LifeMapperPane.this.blueMarble);
            }

            @Override
            public void error() {
                ++LifeMapperPane.this.blueMarbleTries;
                if (LifeMapperPane.this.blueMarbleTries < 5) {
                    LifeMapperPane.this.blueMarbleRetry();
                }
            }
        };
        this.blueMarbleURL = BG_URL + String.format("WIDTH=%d&HEIGHT=%d", 450, 225);
        this.pointsMapImageListener = new ImageListener(){

            @Override
            public void imageFetched(BufferedImage image) {
                Graphics2D g2d;
                if (LifeMapperPane.this.renderImage == null) {
                    LifeMapperPane.this.renderImage = new BufferedImage(450, 225, 2);
                }
                if ((g2d = LifeMapperPane.this.renderImage.createGraphics()) != null) {
                    g2d.fillRect(0, 0, 450, 225);
                    if (LifeMapperPane.this.blueMarble != null) {
                        g2d.drawImage((Image)LifeMapperPane.this.blueMarble, 0, 0, null);
                    }
                    if (image != null) {
                        g2d.drawImage((Image)image, 0, 0, null);
                    }
                    g2d.dispose();
                    LifeMapperPane.this.imgDisplay.setImage(LifeMapperPane.this.renderImage);
                }
            }

            @Override
            public void error() {
            }
        };
        this.blueMarbleRetry();
    }

    private void blueMarbleRetry() {
        this.getImageFromWeb(this.blueMarbleURL, this.blueMarbleListener);
    }

    private void getImageFromWeb(final String urlStr, final ImageListener listener) {
        SwingWorker<BufferedImage, BufferedImage> worker = new SwingWorker<BufferedImage, BufferedImage>(){

            @Override
            protected BufferedImage doInBackground() throws Exception {
                try {
                    URL url = new URL(urlStr);
                    return ImageIO.read(url);
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    BufferedImage img = (BufferedImage)this.get();
                    listener.imageFetched(img);
                    return;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                listener.error();
                super.done();
            }
        };
        worker.execute();
    }

    private void doSearchGenusSpecies() {
        this.doResetWWPanel = true;
        this.doSearchGenusSpecies(this.searchText.getText());
    }

    public void doSearchGenusSpecies(String searchStr) {
        this.doSearchGenusSpecies(searchStr, false);
    }

    public void doSearchGenusSpecies(final String searchStr, final boolean doSetTextField) {
        this.imgDisplay.setImage(this.blueMarble);
        this.listModel.clear();
        this.occurList.clear();
        if (doSetTextField) {
            this.myDataTF.setText(searchStr);
            this.searchText.setText(searchStr);
        }
        if (StringUtils.isNotEmpty((String)searchStr)) {
            this.doSearchGenusSpecies(searchStr, new LMSearchCallbackListener(){

                @Override
                public void noItems() {
                }

                @Override
                public void itemsFound(List<OccurrenceSetIFace> items) {
                    if (items != null) {
                        for (OccurrenceSetIFace item : items) {
                            LifeMapperPane.this.listModel.addElement(item.getTitle());
                            LifeMapperPane.this.occurList.add(item);
                        }
                        if (doSetTextField) {
                            LifeMapperPane.this.addLocalData(searchStr);
                        }
                    }
                }
            });
        }
    }

    private void addMarkerFromCE(PreparedStatement pStmt, int ceID, ArrayList<LatLonPlacemarkIFace> pmList) throws SQLException {
        pStmt.setInt(1, ceID);
        ResultSet rs = pStmt.executeQuery();
        if (rs.next()) {
            LatLonPlacemark llp = new LatLonPlacemark(rs.getDouble(1), rs.getDouble(2));
            pmList.add(llp);
        }
        rs.close();
    }

    public void resetWWPanel() {
        if (this.wwPanel != null) {
            this.wwPanel.reset();
        }
    }

    public void setDoResetWWPanel(boolean doResetWWPanel) {
        this.doResetWWPanel = doResetWWPanel;
    }

    private void doSearchSpecifyData(final String genusSpecies) {
        UsageTracker.incrUsageCount("LM.MyDataSearch");
        this.myDataTaxa = genusSpecies;
        SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("LM_SEARCH_SPECIFY", new Object[0]), 14);
        glassPane.setTextYPos((int)((double)this.getSize().height * 0.25));
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                return LifeMapperPane.this.addLocalData(genusSpecies);
            }

            @Override
            protected void done() {
                super.done();
                UIRegistry.clearSimpleGlassPaneMsg();
                Integer cnt = null;
                try {
                    cnt = (Integer)this.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                if (cnt == null || cnt == 0) {
                    UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString("LM_NO_LOCAL_DATA"), null, Color.RED, 14, true, (int)((double)LifeMapperPane.this.getSize().height * 0.25));
                    UsageTracker.incrUsageCount("LM.NoMyData");
                } else {
                    String msg = UIRegistry.getFormattedResStr("LM_MYDATA_FND", cnt, LifeMapperPane.this.myDataTaxa);
                    UIRegistry.writeTimedSimpleGlassPaneMsg(msg, null, null, 14, true, (int)((double)LifeMapperPane.this.getSize().height * 0.25));
                }
            }
        };
        worker.execute();
    }

    public int addLocalData(String genusSpecies) {
        int numFnd = 0;
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                String sql = "SELECT ce.CollectingEventID, l.Latitude1, l.Longitude1 FROM taxon t INNER JOIN determination d ON t.TaxonID = d.TaxonID INNER JOIN collectionobject co ON d.CollectionObjectID = co.CollectionObjectID INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID INNER JOIN locality l ON ce.LocalityID = l.LocalityID WHERE co.CollectionMemberID = COLMEMID AND t.FullName LIKE '" + genusSpecies + "%'";
                sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
                conn = DBConnection.getInstance().createConnection();
                stmt = conn.createStatement();
                ArrayList<LatLonPlacemarkIFace> coPoints = new ArrayList<LatLonPlacemarkIFace>();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    LatLonPlacemark llp = new LatLonPlacemark(rs.getDouble(2), rs.getDouble(3));
                    coPoints.add(llp);
                }
                numFnd = coPoints.size();
                if (numFnd > 0) {
                    BasicMarkerAttributes bmAttrs = new BasicMarkerAttributes(Material.GREEN, "gov.nasa.worldwind.render.markers.Cone", 1.0, 3.0, 3.0);
                    this.wwPanel.placeMarkers(coPoints, true, false, 0, bmAttrs, false);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        return numFnd;
    }

    public void addLocalData(RecordSet recSet) {
        UsageTracker.incrUsageCount("LM.RSData");
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        boolean isEmbedded = collection.getIsEmbeddedCollectingEvent();
        ArrayList<LatLonPlacemarkIFace> coPoints = new ArrayList<LatLonPlacemarkIFace>();
        Connection conn = null;
        PreparedStatement coStmt = null;
        Statement ceStmt = null;
        try {
            try {
                conn = DBConnection.getInstance().createConnection();
                coStmt = conn.prepareStatement("SELECT CollectingEventID FROM collectionobject WHERE CollectionObjectID = ?");
                ceStmt = conn.prepareStatement("SELECT Latitude1, Longitude1 FROM locality l INNER JOIN collectingevent ce ON ce.LocalityID = l.LocalityID WHERE CollectingEventID = ? And Latitude1 IS NOT NULL AND Longitude1 IS NOT NULL");
                HashSet<Integer> ceSet = new HashSet<Integer>();
                for (RecordSetItemIFace rsi : recSet.getItems()) {
                    coStmt.setInt(1, rsi.getRecordId());
                    ResultSet rs = coStmt.executeQuery();
                    if (rs.next()) {
                        if (isEmbedded) {
                            this.addMarkerFromCE((PreparedStatement)ceStmt, rs.getInt(1), coPoints);
                        } else {
                            ceSet.add(rs.getInt(1));
                        }
                    }
                    rs.close();
                    if (isEmbedded) continue;
                    for (Integer id : ceSet) {
                        this.addMarkerFromCE((PreparedStatement)ceStmt, id, coPoints);
                    }
                }
                if (coPoints.size() > 0) {
                    BasicMarkerAttributes bmAttrs = new BasicMarkerAttributes(Material.GREEN, "gov.nasa.worldwind.render.markers.Cone", 1.0, 3.0, 3.0);
                    this.wwPanel.placeMarkers(coPoints, true, false, 0, bmAttrs, false);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (ceStmt != null) {
                        ceStmt.close();
                    }
                    if (coStmt != null) {
                        coStmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (ceStmt != null) {
                    ceStmt.close();
                }
                if (coStmt != null) {
                    coStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void doSearchGenusSpecies(final String searchStr, final LMSearchCallbackListener cbListener) {
        UsageTracker.incrUsageCount("LM.GenSpSearch");
        this.updateMyDataUIState(false);
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("LifeMapperTask.PROCESSING", new Object[0]), 14);
        glassPane.setTextYPos((int)((double)this.getSize().height * 0.25));
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                HttpClient httpClient = new HttpClient();
                httpClient.getParams().setParameter("http.useragent", (Object)this.getClass().getName());
                httpClient.getParams().setParameter("http.socket.timeout", (Object)15000);
                String genusSpecies = StringUtils.replace((String)searchStr, (String)" ", (String)"%20");
                String url = "http://www.lifemapper.org/hint/species/" + genusSpecies + "?maxReturned=1000&format=json";
                PostMethod postMethod = new PostMethod(url);
                try {
                    httpClient.executeMethod((HttpMethod)postMethod);
                    return postMethod.getResponseBodyAsString();
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UsageTracker.incrUsageCount("LM.GenSpSearchErr");
                }
                return null;
            }

            @Override
            protected void done() {
                String errMsgKey;
                ArrayList<GenusSpeciesDataItem> items;
                block14: {
                    super.done();
                    items = null;
                    errMsgKey = "LifeMapperTask.PROC_ERR";
                    try {
                        String responseString = (String)this.get();
                        if (responseString == null) break block14;
                        if (responseString.startsWith("None of the species")) {
                            errMsgKey = "LM_NO_LM_DATA";
                            break block14;
                        }
                        if (responseString.startsWith("Search too broad")) {
                            errMsgKey = "LM_TOO_BROAD";
                            break block14;
                        }
                        if (!StringUtils.isNotEmpty((String)responseString) || !StringUtils.contains((String)responseString.toLowerCase(), (String)"{")) break block14;
                        JSONTokener tok = new JSONTokener(responseString);
                        while (tok.more()) {
                            JSONObject obj = (JSONObject)tok.nextValue();
                            JSONArray pointArray = (JSONArray)obj.get("columns");
                            for (JSONArray arrayObj : pointArray) {
                                for (JSONObject pObj : arrayObj) {
                                    String gnSpName = (String)pObj.get("name");
                                    String numPoints = (String)pObj.get("numPoints");
                                    String occurrenceSet = (String)pObj.get("occurrenceSet");
                                    if (!StringUtils.isNotEmpty((String)gnSpName) || !StringUtils.isNotEmpty((String)numPoints) || !StringUtils.isNotEmpty((String)occurrenceSet)) continue;
                                    try {
                                        int numPnts = Integer.parseInt(numPoints);
                                        int occurId = Integer.parseInt(occurrenceSet);
                                        if (numPnts > 0 && occurId > 0) {
                                            if (items == null) {
                                                items = new ArrayList<GenusSpeciesDataItem>();
                                            }
                                            items.add(new GenusSpeciesDataItem(String.format("%s (%s)", gnSpName, numPoints), occurrenceSet, gnSpName));
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    String string = errMsgKey = items == null || items.size() == 0 ? "LM_NO_LOCAL_DATA" : null;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                if (errMsgKey != null) {
                    LifeMapperPane.this.showErrorMsg(glassPane, errMsgKey);
                    cbListener.noItems();
                } else {
                    UIRegistry.clearSimpleGlassPaneMsg();
                    cbListener.itemsFound(items);
                }
            }
        };
        worker.execute();
    }

    protected void showErrorMsg(SimpleGlassPane glassPane, String key) {
        glassPane.setTextColor(Color.RED);
        glassPane.setText(UIRegistry.getLocalizedMessage(key, new Object[0]));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                UIRegistry.clearSimpleGlassPaneMsg();
            }
        });
    }

    private void doSearchOccur() {
        OccurrenceSetIFace occurSetItem = this.occurList.get(this.list.getSelectedIndex());
        this.occurSet = occurSetItem.getOccurrenceId();
        if (StringUtils.isNotEmpty((String)this.occurSet)) {
            this.doSearchOccur(this.occurSet);
            this.myDataTaxa = occurSetItem.getTaxa();
            this.myDataTF.setText(this.myDataTaxa);
        }
    }

    public void doSearchOccur(String occurrenceId) {
        this.updateMyDataUIState(false);
        this.points.clear();
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("LifeMapperTask.PROCESSING", new Object[0]), 14);
        glassPane.setTextYPos((int)((double)this.getSize().height * 0.25));
        final HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)this.getClass().getName());
        httpClient.getParams().setParameter("http.socket.timeout", (Object)15000);
        if (this.list.getSelectedIndex() < 0) {
            return;
        }
        UsageTracker.incrUsageCount("LM.OccurSearch");
        final String lmURL = String.format("http://www.lifemapper.org/services/occurrences/%s/json?format=specify&fillPoints=true", occurrenceId);
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                GetMethod getMethod = new GetMethod(lmURL);
                try {
                    httpClient.executeMethod((HttpMethod)getMethod);
                    byte[] bytes = getMethod.getResponseBody();
                    if (bytes != null && bytes.length > 0) {
                        return new String(bytes, "UTF-8");
                    }
                    return null;
                }
                catch (UnknownHostException bytes) {
                }
                catch (SocketTimeoutException ex) {
                    UsageTracker.incrUsageCount("LM.OccurSearchErr");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UsageTracker.incrUsageCount("LM.OccurSearchErr");
                }
                return null;
            }

            @Override
            protected void done() {
                boolean parseError;
                boolean isError;
                block15: {
                    super.done();
                    isError = true;
                    parseError = false;
                    try {
                        String responseString = (String)this.get();
                        if (StringUtils.isNotEmpty((String)responseString) && StringUtils.contains((String)responseString.toLowerCase(), (String)"{")) {
                            String[] lines;
                            StringBuilder sb = new StringBuilder();
                            String[] stringArray = lines = StringUtils.split((String)responseString, (char)'\n');
                            int n = lines.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String str = stringArray[n2];
                                if (str.indexOf("resname") == -1) {
                                    sb.append(str);
                                }
                                ++n2;
                            }
                            String cleaned = sb.toString();
                            parseError = false;
                            try {
                                JSONTokener tok = new JSONTokener(cleaned);
                                if (tok != null) {
                                    while (tok.more()) {
                                        JSONArray pointArray;
                                        JSONObject obj = (JSONObject)tok.nextValue();
                                        if (obj == null || (pointArray = (JSONArray)obj.get("feature")) == null) continue;
                                        for (JSONObject pObj : pointArray) {
                                            if (pObj == null) continue;
                                            String lat = (String)pObj.get("lat");
                                            String lon = (String)pObj.get("lon");
                                            if (lat == null || lon == null) continue;
                                            LatLonPlacemark plcMark = new LatLonPlacemark(Double.parseDouble(lat.trim()), Double.parseDouble(lon.trim()));
                                            LifeMapperPane.this.points.add(plcMark);
                                        }
                                        isError = false;
                                    }
                                }
                            }
                            catch (JSONException ex) {
                                System.err.println(ex.getLocalizedMessage());
                                parseError = true;
                            }
                            boolean hasPnts = LifeMapperPane.this.points.size() > 0;
                            LifeMapperPane.this.updateMyDataUIState(hasPnts && StringUtils.isNotEmpty((String)LifeMapperPane.this.myDataTF.getText()));
                            if (hasPnts) {
                                LifeMapperPane.this.imgDisplay.setImage((Image)null);
                                LifeMapperPane.this.wwPanel.placeMarkers(LifeMapperPane.this.points, false, false, 0, null, false);
                                LifeMapperPane.this.imgRequestCnt = 0;
                                LifeMapperPane.this.imgURL = LifeMapperPane.this.makeURL(LifeMapperPane.this.occurSet);
                                LifeMapperPane.this.getImageFromWeb(LifeMapperPane.this.imgURL, LifeMapperPane.this.pointsMapImageListener);
                            } else {
                                isError = false;
                            }
                            break block15;
                        }
                        UsageTracker.incrUsageCount("LM.OccurSearchErr");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                if (isError || parseError) {
                    LifeMapperPane.this.showErrorMsg(glassPane, "LifeMapperTask.PROC_ERR");
                } else {
                    UIRegistry.clearSimpleGlassPaneMsg();
                }
            }
        };
        worker.execute();
    }

    private String makeURL(String occurrenceSetId) {
        String paramStr = StringUtils.isNotEmpty((String)occurrenceSetId) ? String.format("map=data_%s&layers=occ_%s", occurrenceSetId, occurrenceSetId) : "layers=bmng";
        return String.format(URL_FMT, paramStr, BBOX_STR, 450, 225);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.imgDisplay.isInError()) {
            this.loadOverviewImage();
        }
    }

    private void loadOverviewImage() {
        if (StringUtils.isNotEmpty((String)this.imgURL) && this.imgRequestCnt < 3) {
            this.imgDisplay.setValue(this.imgURL, null);
            ++this.imgRequestCnt;
        }
    }

    private void updateMyDataUIState(boolean enable) {
        this.myDataTF.setEnabled(enable);
        this.searchMyDataBtn.setEnabled(enable);
        this.mySepComp.setEnabled(enable);
    }

    class GenusSpeciesDataItem
    implements OccurrenceSetIFace {
        private String title;
        private String occurrenceId;
        private String taxa;

        public GenusSpeciesDataItem(String title, String occurrenceId, String taxa) {
            this.title = title;
            this.occurrenceId = occurrenceId;
            this.taxa = taxa;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getOccurrenceId() {
            return this.occurrenceId;
        }

        @Override
        public String getTaxa() {
            return this.taxa;
        }
    }

    static interface ImageListener {
        public void imageFetched(BufferedImage var1);

        public void error();
    }

    public static interface LMSearchCallbackListener {
        public void itemsFound(List<OccurrenceSetIFace> var1);

        public void noItems();
    }

    class LatLonPlacemark
    implements LatLonPlacemarkIFace {
        private Pair<Double, Double> pnt;

        public LatLonPlacemark(double lat, double lon) {
            this.pnt = new Pair<Double, Double>(lat, lon);
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public String getHtmlContent(String textColor) {
            return null;
        }

        @Override
        public Pair<Double, Double> getLatLon() {
            return this.pnt;
        }

        @Override
        public Double getAltitude() {
            return null;
        }

        @Override
        public ImageIcon getImageIcon() {
            return LifeMapperPane.this.markerImg;
        }

        @Override
        public void cleanup() {
        }
    }

    public static interface OccurrenceSetIFace {
        public String getTitle();

        public String getOccurrenceId();

        public String getTaxa();
    }
}

