/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.JasperCompileListener;
import edu.ku.brc.specify.tasks.subpane.JasperCompilerRunnable;
import edu.ku.brc.specify.tasks.subpane.JasperReportsCache;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSource;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceBase;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceListenerIFace;
import edu.ku.brc.specify.tasks.subpane.qb.ReportParametersPanel;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.AsynchronousFillHandle;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class LabelsPane
extends BaseSubPane
implements AsynchronousFilllListener,
JasperCompileListener,
QBDataSourceListenerIFace {
    protected static final Logger log = Logger.getLogger(LabelsPane.class);
    protected static int virtualizerThresholdSize = 666;
    protected AsynchronousFillHandle asyncFillHandler = null;
    protected JLabel label = null;
    protected JasperCompilerRunnable compiler = null;
    protected AtomicBoolean compiling = new AtomicBoolean(false);
    protected AtomicBoolean filling = new AtomicBoolean(false);
    protected AtomicBoolean loading = new AtomicBoolean(false);
    protected RecordSetIFace recordSet = null;
    protected JRDataSource dataSource = null;
    protected File cachePath = null;
    protected Properties params = null;
    protected boolean requiresHibernate = false;
    protected Session session = null;
    protected ImageIcon icon = null;
    protected Throwable errThrowable = null;

    public LabelsPane(String name, Taskable task, Properties params) {
        super(name, task, true, true);
        this.params = params;
        this.cachePath = JasperReportsCache.checkAndCreateReportsCache();
        this.progressCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LabelsPane.this.compiler != null && LabelsPane.this.compiling.get()) {
                    LabelsPane.this.compiler.stop();
                } else if (LabelsPane.this.asyncFillHandler != null && LabelsPane.this.filling.get()) {
                    try {
                        LabelsPane.this.asyncFillHandler.cancellFill();
                        if (LabelsPane.this.dataSource != null && LabelsPane.this.dataSource instanceof QBDataSource && LabelsPane.this.loading.get()) {
                            ((QBDataSource)LabelsPane.this.dataSource).cancelLoad();
                        }
                    }
                    catch (JRException ex) {
                        log.error((Object)ex);
                    }
                }
            }
        });
    }

    @Override
    public Icon getIcon() {
        return this.icon != null ? this.icon : super.getIcon();
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public void setLabelText(final String msg) {
        if (this.label == null) {
            this.removeAll();
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,2px,p,f:p:g", "f:p:g, p, f:p:g"), (JPanel)this);
            JButton moreBtn = UIHelper.createIconBtn("InfoIcon", IconManager.IconSize.Std16, null, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelsPane.this.showErrorMsgs();
                }
            });
            this.label = UIHelper.createLabel("", 0);
            pb.add((Component)this.label, cc.xy(2, 2));
            pb.add((Component)moreBtn, cc.xy(4, 2));
            moreBtn.setEnabled(true);
        }
        if (this.progressBarPanel != null) {
            this.remove(this.progressBarPanel);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LabelsPane.this.label.setText(msg);
                LabelsPane.this.invalidate();
                LabelsPane.this.doLayout();
                LabelsPane.this.repaint();
            }
        });
    }

    private void showErrorMsgs() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        JTextArea ta = UIHelper.createTextArea(40, 80);
        pb.add((Component)UIHelper.createScrollPane(ta, true), cc.xy(1, 1));
        pb.setDefaultDialogBorder();
        ta.setText(this.errThrowable != null ? this.getStackTrace(this.errThrowable) : "");
        ta.setEditable(false);
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("Error"), true, 1, (Component)pb.getPanel());
        dlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        UIHelper.centerAndShow(dlg);
    }

    protected String getStackTrace(Throwable throwable) {
        String sep = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(throwable.toString());
        result.append(sep);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            result.append(element);
            result.append(sep);
            ++n2;
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.label != null;
    }

    public void createReport(String mainReportName, Object data, Properties paramsArg) {
        File compiledFile;
        if (this.progressBarPanel != null) {
            if (this.label != null) {
                this.remove(this.label);
            }
            this.add((Component)this.progressBarPanel, "Center");
        }
        if (data instanceof RecordSetIFace) {
            this.recordSet = (RecordSetIFace)data;
            this.dataSource = null;
        } else if (data instanceof JRDataSource) {
            this.recordSet = null;
            this.dataSource = (JRDataSource)data;
        } else {
            this.recordSet = null;
            this.dataSource = null;
        }
        this.params = paramsArg;
        AppResourceIFace appRes = AppContextMgr.getInstance().getResource(mainReportName);
        String resName = this.params.getProperty("name");
        if (appRes == null && resName != null) {
            appRes = AppContextMgr.getInstance().getResource(resName);
        }
        if (appRes != null) {
            String hqlStr = appRes.getMetaData("hql");
            if (StringUtils.isNotEmpty((String)hqlStr)) {
                this.requiresHibernate = Boolean.parseBoolean(hqlStr.toLowerCase());
            }
        } else {
            log.error((Object)("could not find report resource for " + mainReportName));
        }
        if ((compiledFile = (File)this.params.get("compiled-file")) != null) {
            this.compileComplete(compiledFile, null);
        } else {
            this.progressLabel.setText(UIRegistry.getResourceString("JasperReportCompiling"));
            this.compiler = new JasperCompilerRunnable(this, mainReportName, resName);
            this.compiling.set(true);
            this.compiler.start();
        }
    }

    @Override
    public void compileComplete(File compiledFile, Throwable throwable) {
        block21: {
            this.compiling.set(false);
            if (compiledFile != null) {
                try {
                    JasperReport jasperReport = (JasperReport)JRLoader.loadObject((File)compiledFile.getAbsoluteFile());
                    if (jasperReport != null) {
                        int size = -1;
                        if (this.recordSet != null) {
                            size = this.recordSet.getNumItems();
                        } else if (this.dataSource != null && this.dataSource instanceof QBDataSourceBase) {
                            size = ((QBDataSourceBase)this.dataSource).size();
                        }
                        boolean go = true;
                        ReportParametersPanel rpp = null;
                        String skipParams = this.params.getProperty("skip-parameter-prompt");
                        if ((StringUtils.isBlank((String)skipParams) || skipParams.equalsIgnoreCase("false")) && (rpp = new ReportParametersPanel(jasperReport, true)).getParamCount() > 0) {
                            CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("LabelsPane.REPORT_PARAMS"), true, rpp);
                            UIHelper.centerAndShow(cd);
                            go = !cd.isCancelled();
                            cd.dispose();
                        }
                        if (go) {
                            HashMap<Object, Object> parameters = new HashMap<Object, Object>();
                            if (rpp != null) {
                                int p = 0;
                                while (p < rpp.getParamCount()) {
                                    Pair<String, String> param = rpp.getParam(p);
                                    if (StringUtils.isNotBlank((String)param.getSecond())) {
                                        parameters.put(param.getFirst(), param.getSecond());
                                    }
                                    ++p;
                                }
                            }
                            parameters.put("RPT_IMAGE_DIR", JasperReportsCache.getImagePath().getAbsolutePath());
                            parameters.put("SUBREPORT_DIR", this.cachePath.getAbsoluteFile() + File.separator);
                            parameters.put("DATASOURCE", this.dataSource);
                            if (size > virtualizerThresholdSize) {
                                JRFileVirtualizer fileVirtualizer = new JRFileVirtualizer(10);
                                parameters.put("REPORT_VIRTUALIZER", fileVirtualizer);
                            }
                            if (this.params != null) {
                                for (Object key : this.params.keySet()) {
                                    parameters.put(key, this.params.get(key));
                                }
                            }
                            if (this.recordSet != null) {
                                parameters.put("itemnum", DBTableIdMgr.getInstance().getInClause(this.recordSet));
                            }
                            if (this.requiresHibernate) {
                                this.session = HibernateUtil.getNewSession();
                                parameters.put("HIBERNATE_SESSION", this.session);
                            }
                            if (this.dataSource instanceof QBDataSourceBase) {
                                ((QBDataSourceBase)this.dataSource).addListener(this);
                                this.progressLabel.setText(UIRegistry.getResourceString("LabelsPane.LoadingReportData"));
                            } else {
                                this.progressLabel.setText(UIRegistry.getResourceString("JasperReportFilling"));
                            }
                            jasperReport.setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
                            this.asyncFillHandler = this.recordSet != null || this.recordSet == null && this.dataSource == null ? AsynchronousFillHandle.createHandle((JasperReport)jasperReport, parameters, (Connection)DBConnection.getInstance().getConnection()) : AsynchronousFillHandle.createHandle((JasperReport)jasperReport, parameters, (JRDataSource)this.dataSource);
                            this.asyncFillHandler.addListener((AsynchronousFilllListener)this);
                            this.filling.set(true);
                            this.asyncFillHandler.startFill();
                        } else {
                            this.removeAll();
                            this.setLabelText(UIRegistry.getResourceString("LabelsPane.ReportCancelled"));
                        }
                        break block21;
                    }
                    log.error((Object)("jasperReport came back null [" + compiledFile.getAbsolutePath() + "]"));
                    this.progressBar.setIndeterminate(false);
                    this.setLabelText(UIRegistry.getResourceString("JasperReportReadingCachedReport"));
                }
                catch (JRException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(LabelsPane.class, (Exception)((Object)ex));
                    this.setLabelText(UIRegistry.getResourceString("JasperReportCreatingViewer"));
                    log.error((Object)ex);
                    ex.printStackTrace();
                }
            } else {
                this.errThrowable = throwable;
                this.setLabelText(UIRegistry.getResourceString("JasperReportCompileError"));
            }
        }
        this.compiler = null;
    }

    public void reportCancelled() {
        this.removeAll();
        this.setLabelText(UIRegistry.getResourceString("JasperReportCancelled"));
        this.asyncFillHandler = null;
        this.closeSession();
    }

    protected void closeSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception ex) {
                log.error((Object)ex);
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(LabelsPane.class, ex);
            }
        }
    }

    public void reportFillError(Throwable t) {
        this.errThrowable = t;
        this.removeAll();
        this.setLabelText(UIRegistry.getResourceString("JasperReportFillError"));
        log.error((Object)t);
        t.printStackTrace();
        this.asyncFillHandler = null;
        this.closeSession();
    }

    public void reportFinished(JasperPrint print) {
        this.filling.set(false);
        try {
            this.removeAll();
            this.label = null;
            JRViewer jasperViewer = new JRViewer(print);
            this.add((Component)jasperViewer, "Center");
            UIRegistry.forceTopFrameRepaint();
            this.closeSession();
        }
        catch (Exception ex) {
            this.errThrowable = ex;
            log.error((Object)ex);
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LabelsPane.class, ex);
            this.setLabelText(UIRegistry.getResourceString("JasperReportCreatingViewer"));
            ex.printStackTrace();
        }
        this.asyncFillHandler = null;
    }

    @Override
    public void currentRow(final long currentRow) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LabelsPane.this.progressBar.isIndeterminate() && LabelsPane.this.dataSource instanceof QBDataSource) {
                    LabelsPane.this.progressBar.setMinimum(0);
                    LabelsPane.this.progressBar.setMaximum(((QBDataSource)LabelsPane.this.dataSource).size());
                    LabelsPane.this.progressBar.setIndeterminate(false);
                }
                LabelsPane.this.progressBar.setValue((int)currentRow);
            }
        });
    }

    @Override
    public void done(long rows) {
    }

    @Override
    public void filling() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LabelsPane.this.progressBar.setValue(0);
                LabelsPane.this.progressLabel.setText(UIRegistry.getResourceString("JasperReportFilling"));
            }
        });
    }

    @Override
    public void loaded() {
        this.loading.set(false);
    }

    @Override
    public void loading() {
        this.loading.set(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LabelsPane.this.progressLabel.setText(UIRegistry.getResourceString("LabelsPane.LoadingReportData"));
            }
        });
    }

    @Override
    public void rowCount(final long rowCount) {
        if (rowCount > 0L) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LabelsPane.this.progressBar.setMinimum(0);
                    LabelsPane.this.progressBar.setMaximum((int)rowCount);
                    LabelsPane.this.progressBar.setValue(0);
                    LabelsPane.this.progressBar.setIndeterminate(false);
                }
            });
        }
    }

    protected class JRViewerPrintHackForSPNHCBDayQueryLinuxOnly
    extends JRViewer {
        protected final JasperPrint jp;

        JRViewerPrintHackForSPNHCBDayQueryLinuxOnly(JasperPrint print) {
            super(print);
            this.jp = print;
            ActionListener[] lists = this.btnPrint.getActionListeners();
            int l = 0;
            while (l < lists.length) {
                this.btnPrint.removeActionListener(lists[l]);
                ++l;
            }
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        JasperExportManager.exportReportToPdfFile((JasperPrint)JRViewerPrintHackForSPNHCBDayQueryLinuxOnly.this.jp, (String)"/home/timo/hbd.pdf");
                        Runtime.getRuntime().exec("lp -P1 /home/timo/hbd.pdf");
                    }
                    catch (Exception ex) {
                        ((JRViewerPrintHackForSPNHCBDayQueryLinuxOnly)JRViewerPrintHackForSPNHCBDayQueryLinuxOnly.this).LabelsPane.this.errThrowable = ex;
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(LabelsPane.class, ex);
                        LabelsPane.this.setLabelText(UIRegistry.getResourceString("JasperReportCreatingViewer"));
                        ex.printStackTrace();
                    }
                }
            });
        }
    }
}

