/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.tasks.subpane.LabelsPane;
import edu.ku.brc.specify.tasks.subpane.ReportCompileInfo;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.DataCacheIFace;
import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JasperReportsCache
implements DataCacheIFace {
    private static final Logger log = Logger.getLogger(LabelsPane.class);
    private static boolean reportsCacheWasCleared = false;
    private static JasperReportsCache instance = new JasperReportsCache();
    private static String reportsCacheName;

    protected JasperReportsCache() {
        reportsCacheName = "reportsCache_" + UIHelper.getOSType().toString();
    }

    public static JasperReportsCache getInstance() {
        return instance;
    }

    public static File getImagePath() {
        String imgPath = AppPreferences.getRemote().get("REPORT_IMAGE_PATH", null);
        File imageDir = StringUtils.isNotEmpty((String)imgPath) ? new File(imgPath) : UIRegistry.getAppDataSubDir("report_images", false);
        if (!imageDir.exists()) {
            imageDir = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "demo_files");
        }
        return imageDir;
    }

    public static File getCachePath() {
        File path = UIRegistry.getAppDataSubDir(reportsCacheName, true);
        if (path == null) {
            String msg = "The reportsCache directory path is empty.";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return path;
    }

    public static File checkAndCreateReportsCache() {
        File path = JasperReportsCache.getCachePath();
        if (SpecifyAppContextMgr.isNewJavaVersionAtAppStart() && !reportsCacheWasCleared) {
            JasperReportsCache.clearJasperFilesOnly(path);
            reportsCacheWasCleared = true;
        }
        return path;
    }

    protected static void clearJasperFilesOnly(File cachePath) {
        try {
            Iterator iter = FileUtils.iterateFiles((File)cachePath, (String[])new String[]{"jasper"}, (boolean)false);
            while (iter.hasNext()) {
                FileUtils.forceDelete((File)((File)iter.next()));
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(JasperReportsCache.class, ex);
            log.error((Object)ex);
        }
    }

    public static void refreshCacheFromDatabase() {
        JasperReportsCache.refreshCacheFromDatabase("jrxml/label");
        JasperReportsCache.refreshCacheFromDatabase("jrxml/report");
        JasperReportsCache.refreshCacheFromDatabase("jrxml/subreport");
    }

    protected static void refreshCacheFromDatabase(String mimeType) {
        File cachePath = JasperReportsCache.getCachePath();
        Hashtable<String, File> hash = new Hashtable<String, File>();
        File[] fileArray = cachePath.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            hash.put(f.getName(), f);
            ++n2;
        }
        for (AppResourceIFace ap : AppContextMgr.getInstance().getResourceByMimeType(mimeType)) {
            boolean updateCache = false;
            File fileFromJasperCache = (File)hash.get(ap.getName());
            if (fileFromJasperCache == null) {
                updateCache = true;
            } else {
                Date fileDate = new Date(fileFromJasperCache.lastModified());
                Timestamp apTime = ap.getTimestampModified() == null ? ap.getTimestampCreated() : ap.getTimestampModified();
                boolean bl = updateCache = apTime == null || fileDate.getTime() < apTime.getTime();
            }
            if (!updateCache) continue;
            File localFilePath = new File(cachePath.getAbsoluteFile() + File.separator + ap.getName());
            try {
                XMLHelper.setContents(localFilePath, ap.getDataAsString());
                File compiledFile = JasperReportsCache.getCompiledFile(localFilePath);
                if (!compiledFile.exists()) continue;
                compiledFile.delete();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(JasperReportsCache.class, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    protected static File getCompiledFile(File file) {
        String fileName = file.getName();
        String compiledName = String.valueOf(FilenameUtils.getBaseName((String)fileName)) + ".jasper";
        return new File(JasperReportsCache.getCachePath().getAbsoluteFile() + File.separator + compiledName);
    }

    public static boolean isReportsCacheWasCleared() {
        return reportsCacheWasCleared;
    }

    public static ReportCompileInfo checkReport(File file) {
        File cachePath = JasperReportsCache.getCachePath();
        String fileName = file.getName();
        File compiledPath = JasperReportsCache.getCompiledFile(file);
        AppResourceIFace appRes = AppContextMgr.getInstance().getResource(fileName);
        File reportFileFromCache = new File(cachePath.getAbsoluteFile() + File.separator + fileName);
        Timestamp apTime = appRes.getTimestampModified() == null ? appRes.getTimestampCreated() : appRes.getTimestampModified();
        boolean needsCompiling = apTime == null || !compiledPath.exists() || apTime.getTime() > reportFileFromCache.lastModified();
        return new ReportCompileInfo(reportFileFromCache, compiledPath, needsCompiling);
    }

    @Override
    public void clear() {
        try {
            FileUtils.cleanDirectory((File)JasperReportsCache.getCachePath());
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(JasperReportsCache.class, ex);
            log.error((Object)ex);
        }
    }

    @Override
    public void shutdown() throws Exception {
    }
}

