/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.JasperCompileListener;
import edu.ku.brc.specify.tasks.subpane.JasperReportsCache;
import edu.ku.brc.specify.tasks.subpane.ReportCompileInfo;
import java.io.File;
import java.util.Vector;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JasperCompilerRunnable
implements Runnable {
    protected static final Logger log = Logger.getLogger(JasperCompilerRunnable.class);
    protected Thread thread;
    protected final JasperCompileListener listener;
    protected final File cachePath;
    protected final String mainReportName;
    protected final String resourceName;
    protected Vector<ReportCompileInfo> files = null;
    protected boolean compileRequired = true;

    public JasperCompilerRunnable(JasperCompileListener listener, Vector<ReportCompileInfo> files) {
        this.listener = listener;
        this.files = files;
        this.cachePath = JasperReportsCache.checkAndCreateReportsCache();
        this.mainReportName = null;
        this.resourceName = null;
    }

    public JasperCompilerRunnable(JasperCompileListener listener, String mainReportName, String resourceName) {
        this.listener = listener;
        this.mainReportName = mainReportName;
        this.resourceName = resourceName;
        this.cachePath = JasperReportsCache.checkAndCreateReportsCache();
        this.files = null;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void get() {
        this.start();
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(JasperCompilerRunnable.class, ex);
            throw new RuntimeException(ex);
        }
    }

    public boolean findFiles() {
        File reportPath;
        JasperReportsCache.refreshCacheFromDatabase();
        Vector<File> reportFiles = new Vector<File>();
        AppResourceIFace appRes = AppContextMgr.getInstance().getResource(this.mainReportName);
        if (appRes == null && this.resourceName != null) {
            appRes = AppContextMgr.getInstance().getResource(this.resourceName);
        }
        if (appRes != null) {
            String subReportsStr = appRes.getMetaData("subreports");
            if (StringUtils.isNotEmpty((String)subReportsStr)) {
                String[] subReportNames;
                String[] stringArray = subReportNames = subReportsStr.split(",");
                int n = subReportNames.length;
                int n2 = 0;
                while (n2 < n) {
                    File subReportPath;
                    String subReportName = stringArray[n2];
                    AppResourceIFace subReportAppRes = AppContextMgr.getInstance().getResource(subReportName);
                    if (subReportAppRes != null) {
                        subReportPath = new File(this.cachePath.getAbsoluteFile() + File.separator + subReportName);
                        if (!subReportPath.exists()) {
                            throw new RuntimeException("Subreport doesn't exist on disk [" + subReportPath.getAbsolutePath() + "]");
                        }
                    } else {
                        throw new RuntimeException("Couldn't load subreport [" + subReportName + "]");
                    }
                    reportFiles.add(subReportPath);
                    ++n2;
                }
            }
            if (!(reportPath = new File(this.cachePath.getAbsoluteFile() + File.separator + this.mainReportName)).exists()) {
                reportPath = new File(this.cachePath.getAbsoluteFile() + File.separator + this.resourceName);
            }
            if (!reportPath.exists()) {
                throw new RuntimeException("Report doesn't exist on disk [" + reportPath.getAbsolutePath() + "]");
            }
        } else {
            throw new RuntimeException("Couldn't load report/label [" + this.mainReportName + "]");
        }
        reportFiles.add(reportPath);
        boolean allAreCompiled = true;
        this.files = new Vector();
        for (File file : reportFiles) {
            ReportCompileInfo info = JasperReportsCache.checkReport(file);
            this.files.add(info);
            if (info.isCompiled()) continue;
            allAreCompiled = false;
        }
        this.compileRequired = !allAreCompiled;
        return !allAreCompiled;
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
        this.listener.compileComplete(null, null);
    }

    @Override
    public void run() {
        block5: {
            try {
                if (this.files == null) {
                    this.findFiles();
                }
                for (ReportCompileInfo info : this.files) {
                    if (info.isCompiled()) continue;
                    JasperCompileManager.compileReportToFile((String)info.getReportFile().getAbsolutePath(), (String)info.getCompiledFile().getAbsolutePath());
                }
                this.compileRequired = false;
                if (this.listener != null) {
                    this.listener.compileComplete(this.files.get(this.files.size() - 1).getCompiledFile(), null);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
                ex.printStackTrace();
                if (this.listener == null) break block5;
                this.listener.compileComplete(null, ex);
            }
        }
    }

    public Vector<ReportCompileInfo> getFiles() {
        return this.files;
    }

    public boolean isCompileRequired() {
        return this.compileRequired;
    }

    public File getCompiledFile() {
        if (this.files != null && this.files.size() > 0) {
            return this.files.get(this.files.size() - 1).getCompiledFile();
        }
        return null;
    }
}

