/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.ui.IconTray;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IconTrayResultsPanel
extends IconTray
implements ESResultsTablePanelIFace {
    protected ExpressSearchResultsPaneIFace esrPane;
    protected QueryForIdResultsIFace results;
    protected PropertyChangeListener propChangeListener;
    protected FormDataObjIFace prevSelection;

    public IconTrayResultsPanel() {
        super(1);
        this.iconListWidget.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                FormDataObjIFace selectedRecord = IconTrayResultsPanel.this.getSelection();
                if (IconTrayResultsPanel.this.propChangeListener != null) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(IconTrayResultsPanel.this, "selection", IconTrayResultsPanel.this.prevSelection, selectedRecord);
                    IconTrayResultsPanel.this.propChangeListener.propertyChange(pce);
                }
                IconTrayResultsPanel.this.prevSelection = selectedRecord;
            }
        });
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public boolean hasResults() {
        return false;
    }

    @Override
    public List<Integer> getListOfIds(boolean returnAll) {
        return Collections.singletonList(this.prevSelection.getId());
    }

    @Override
    public QueryForIdResultsIFace getResults() {
        return this.results;
    }

    @Override
    public Component getUIComponent() {
        return this;
    }

    @Override
    public void initialize(ExpressSearchResultsPaneIFace esResPane, QueryForIdResultsIFace esResults) {
        this.esrPane = esResPane;
        this.results = esResults;
        int tableID = this.results.getTableId();
        Vector<Integer> resultsIDs = this.results.getRecIds();
        if (resultsIDs.size() > 0) {
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(tableID);
            StringBuilder queryString = new StringBuilder("SELECT o FROM ");
            queryString.append(tableInfo.getClassName());
            queryString.append(" o WHERE o.id IN (");
            for (Integer id : resultsIDs) {
                queryString.append(id);
                queryString.append(",");
            }
            queryString.deleteCharAt(queryString.length() - 1);
            queryString.append(")");
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            DataProviderSessionIFace.QueryIFace query = session.createQuery(queryString.toString(), false);
            List<?> resultRecords = query.list();
            for (Object o : resultRecords) {
                FormDataObjIFace formObj = (FormDataObjIFace)o;
                this.addItem(formObj);
            }
        }
    }

    @Override
    public void setPropertyChangeListener(PropertyChangeListener pcl) {
        this.propChangeListener = pcl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void expandView() {
    }

    @Override
    public int[] getSelectedRows() {
        return null;
    }
}

