/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.RecordSetFactory;
import edu.ku.brc.af.core.ServiceInfo;
import edu.ku.brc.af.core.ServiceProviderIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.GradiantButton;
import edu.ku.brc.ui.GradiantLabel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.TriangleButton;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ESResultsTablePanel
extends JPanel
implements ESResultsTablePanelIFace {
    private static final Logger log = Logger.getLogger(ESResultsTablePanel.class);
    protected static final Cursor handCursor = new Cursor(12);
    protected static final Cursor defCursor = new Cursor(0);
    protected ExpressSearchResultsPaneIFace esrPane;
    protected ResultSetTableModel resultSetTableModel;
    protected JTable table;
    protected JPanel tablePane;
    protected TriangleButton expandBtn;
    protected GradiantButton showTopNumEntriesBtn;
    protected int rowCount = 0;
    protected boolean showingAllRows = false;
    protected boolean hasResults = false;
    protected boolean isEditable = false;
    protected JPopupMenu popupMenu = null;
    protected JButton delRSItems = null;
    protected Hashtable<ServiceInfo, JButton> serviceBtns = null;
    protected JPanel morePanel = null;
    protected Color bannerColor = new Color(30, 144, 255);
    protected int topNumEntries = 7;
    protected QueryForIdResultsIFace results;
    protected GradiantLabel topTitleBar;
    protected JButton moreBtn;
    protected JButton selectAllBtn = UIHelper.createMiniI18NBtn("SELECTALL");
    protected JButton deselectAllBtn = UIHelper.createMiniI18NBtn("DESELECTALL");
    protected JButton moveToRSBtn = UIHelper.createButton(IconManager.getIcon("Unmap"));
    protected RolloverCommand moveToRSCmd;
    protected JPanel botBtnPanel;
    protected PropertyChangeListener propChangeListener = null;

    public ESResultsTablePanel(ExpressSearchResultsPaneIFace esrPane, QueryForIdResultsIFace results, boolean installServices, boolean isExpandedAtStartUp) {
        this(esrPane, results, installServices, isExpandedAtStartUp, true);
    }

    public ESResultsTablePanel(final ExpressSearchResultsPaneIFace esrPane, QueryForIdResultsIFace results, boolean installServices, boolean isExpandedAtStartUp, boolean inclCloseBtn) {
        super(new BorderLayout());
        this.esrPane = esrPane;
        this.results = results;
        this.bannerColor = results.getBannerColor();
        this.isEditable = results.isEditingEnabled();
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(results.isMultipleSelection() ? 2 : 0);
        this.setBackground(this.table.getBackground());
        if (this.isEditable) {
            this.addContextMenu();
        }
        this.topTitleBar = new GradiantLabel(results.getTitle(), 2);
        this.topTitleBar.setBGBaseColor(this.bannerColor);
        this.topTitleBar.setTextColor(Color.WHITE);
        this.topTitleBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ESResultsTablePanel.this.expandBtn.doClick();
                }
            }
        });
        String description = results.getDescription();
        if (StringUtils.isNotEmpty((String)description)) {
            this.topTitleBar.setToolTipText(description);
        }
        this.expandBtn = new TriangleButton();
        this.expandBtn.setToolTipText(UIRegistry.getResourceString("CollapseTBL"));
        this.expandBtn.setForeground(this.bannerColor);
        this.expandBtn.setTextColor(Color.WHITE);
        this.showTopNumEntriesBtn = new GradiantButton(String.format(UIRegistry.getResourceString("ShowTopEntries"), this.topNumEntries));
        this.showTopNumEntriesBtn.setForeground(this.bannerColor);
        this.showTopNumEntriesBtn.setTextColor(Color.WHITE);
        this.showTopNumEntriesBtn.setVisible(false);
        this.showTopNumEntriesBtn.setCursor(handCursor);
        List<ServiceInfo> services = installServices ? this.getServices() : null;
        StringBuffer colDef = new StringBuffer("p,0px,p:g,0px,p,0px,");
        int numCols = (installServices ? services.size() : 0) + (inclCloseBtn ? 1 : 0);
        colDef.append(UIHelper.createDuplicateJGoodiesDef("p", "0px", numCols));
        PanelBuilder builder = new PanelBuilder(new FormLayout(colDef.toString(), "f:p:g"));
        CellConstraints cc = new CellConstraints();
        int col = 1;
        builder.add((Component)this.expandBtn, cc.xy(col, 1));
        builder.add((Component)this.topTitleBar, cc.xy(col += 2, 1));
        builder.add((Component)this.showTopNumEntriesBtn, cc.xy(col += 2, 1));
        col += 2;
        if (installServices && services.size() > 0) {
            this.serviceBtns = new Hashtable();
            int iconSize = AppPreferences.getLocalPrefs().getInt("banner.icon.size", 20);
            for (ServiceInfo serviceInfo : services) {
                GradiantButton btn = new GradiantButton(serviceInfo.getIcon(iconSize));
                btn.setToolTipText(serviceInfo.getTooltip());
                btn.setForeground(this.bannerColor);
                builder.add((Component)btn, cc.xy(col, 1));
                ESTableAction esta = new ESTableAction(serviceInfo.getCommandAction(), this.table, serviceInfo.getTooltip());
                esta.setProperty("gridtitle", results.getTitle());
                btn.addActionListener(esta);
                this.serviceBtns.put(serviceInfo, btn);
                col += 2;
            }
        }
        GradiantButton closeBtn = null;
        if (inclCloseBtn) {
            closeBtn = new GradiantButton(IconManager.getIcon("Close"));
            closeBtn.setToolTipText(UIRegistry.getResourceString("ESCloseTable"));
            closeBtn.setForeground(this.bannerColor);
            closeBtn.setRolloverEnabled(true);
            closeBtn.setRolloverIcon(IconManager.getIcon("CloseHover"));
            closeBtn.setPressedIcon(IconManager.getIcon("CloseHover"));
            builder.add((Component)closeBtn, cc.xy(col, 1));
            col += 2;
        }
        this.add((Component)builder.getPanel(), "North");
        this.tablePane = new JPanel(new BorderLayout());
        this.tablePane.add((Component)this.table.getTableHeader(), "First");
        JComponent comp = this.table.getColumnCount() > 3 ? new JScrollPane(this.table, 20, 30) : this.table;
        this.tablePane.add((Component)comp, "Center");
        if (this.isEditable) {
            this.delRSItems = UIHelper.createIconBtn("DelRec", "ESDelRowsTT", null);
            this.delRSItems.addActionListener(this.createRemoveItemAL());
            this.delRSItems.setEnabled(false);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        ESResultsTablePanel.this.delRSItems.setEnabled(ESResultsTablePanel.this.table.getSelectedRowCount() > 0);
                    }
                }
            });
        }
        this.add((Component)this.tablePane, "Center");
        this.moveToRSCmd = new DragSelectedRowsBtn(IconManager.getIcon("Record_Set", IconManager.IconSize.Std16));
        if (installServices) {
            PanelBuilder bottomBar = new PanelBuilder(new FormLayout("4px,p,4px,p,4px,p," + (this.delRSItems != null ? "4px,p," : "") + "f:p:g", "p"));
            bottomBar.add((Component)this.moveToRSCmd, cc.xy(2, 1));
            bottomBar.add((Component)this.selectAllBtn, cc.xy(4, 1));
            bottomBar.add((Component)this.deselectAllBtn, cc.xy(6, 1));
            if (this.delRSItems != null) {
                bottomBar.add((Component)this.delRSItems, cc.xy(8, 1));
            }
            this.botBtnPanel = bottomBar.getPanel();
            this.deselectAllBtn.setEnabled(false);
            this.selectAllBtn.setEnabled(true);
            this.moveToRSCmd.setEnabled(true);
            this.deselectAllBtn.setToolTipText(UIRegistry.getResourceString("SELALLTOOLTIP"));
            this.selectAllBtn.setToolTipText(UIRegistry.getResourceString("DESELALLTOOLTIP"));
            this.moveToRSCmd.setToolTipText(UIRegistry.getResourceString("MOVEROWSTOOLTIP"));
            this.selectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ESResultsTablePanel.this.table.selectAll();
                }
            });
            this.deselectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ESResultsTablePanel.this.table.clearSelection();
                }
            });
            this.moveToRSCmd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecordSetIFace src = (RecordSetIFace)ESResultsTablePanel.this.moveToRSCmd.getData();
                    CommandDispatcher.dispatch(new CommandAction("Record_Set", "AskForNewRS", src, null, null));
                }
            });
            this.add((Component)this.botBtnPanel, "South");
        } else {
            this.botBtnPanel = null;
        }
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ESResultsTablePanel.this.expandTable(false);
            }
        });
        if (!isExpandedAtStartUp) {
            this.expandTable(true);
        }
        this.showTopNumEntriesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ESResultsTablePanel.this.morePanel.setVisible(true);
                ESResultsTablePanel.this.showTopNumEntriesBtn.setVisible(false);
                ESResultsTablePanel.this.showingAllRows = false;
                ESResultsTablePanel.this.setDisplayRows(ESResultsTablePanel.this.rowCount, ESResultsTablePanel.this.topNumEntries);
                if (!ESResultsTablePanel.this.expandBtn.isDown()) {
                    ESResultsTablePanel.this.tablePane.setVisible(true);
                    ESResultsTablePanel.this.expandBtn.setDown(true);
                }
                ESResultsTablePanel.this.invalidate();
                ESResultsTablePanel.this.doLayout();
                esrPane.revalidateScroll();
            }
        });
        if (closeBtn != null) {
            closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ESResultsTablePanel.this.removeMe();
                        }
                    });
                }
            });
        }
        ResultSetTableModel rsm = this.createModel();
        rsm.setPropertyListener(this);
        this.resultSetTableModel = rsm;
        this.table.setRowSorter(new TableRowSorter<ResultSetTableModel>(this.resultSetTableModel));
        this.table.setRowSelectionAllowed(true);
        this.table.setModel(rsm);
        this.configColumns();
        this.rowCount = rsm.getRowCount();
        if (this.rowCount > this.topNumEntries + 2) {
            this.buildMorePanel();
            this.setDisplayRows(this.rowCount, this.topNumEntries);
        } else {
            this.setDisplayRows(this.rowCount, Integer.MAX_VALUE);
        }
        this.invalidate();
        this.doLayout();
        UIRegistry.forceTopFrameRepaint();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && ESResultsTablePanel.this.botBtnPanel != null) {
                    ESResultsTablePanel.this.deselectAllBtn.setEnabled(ESResultsTablePanel.this.table.getSelectedRowCount() > 0);
                    ESResultsTablePanel.this.selectAllBtn.setEnabled(ESResultsTablePanel.this.table.getSelectedRowCount() != ESResultsTablePanel.this.table.getRowCount());
                    ESResultsTablePanel.this.moveToRSCmd.setEnabled(ESResultsTablePanel.this.table.getSelectedRowCount() > 0);
                }
                if (ESResultsTablePanel.this.propChangeListener != null) {
                    if (!e.getValueIsAdjusting()) {
                        ESResultsTablePanel.this.propChangeListener.propertyChange(new PropertyChangeEvent(this, "selection", ESResultsTablePanel.this.table.getSelectedRowCount(), 0));
                    } else {
                        ESResultsTablePanel.this.propChangeListener.propertyChange(new PropertyChangeEvent(this, "selection", ESResultsTablePanel.this.table.getSelectedRowCount(), 0));
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ESResultsTablePanel.this.doDoubleClickOnRow(e);
            }
        });
        TableColumnModel tableColModel = this.table.getColumnModel();
        int i = 0;
        while (i < tableColModel.getColumnCount()) {
            tableColModel.getColumn(i).setCellRenderer(new BiColorTableCellRenderer());
            ++i;
        }
    }

    protected void doDoubleClickOnRow(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ESResultsTablePanel.this.propChangeListener != null) {
                        ESResultsTablePanel.this.propChangeListener.propertyChange(new PropertyChangeEvent(this, "doubleClick", 2, 0));
                    }
                    if (ESResultsTablePanel.this.serviceBtns != null) {
                        for (ServiceInfo si : ESResultsTablePanel.this.serviceBtns.keySet()) {
                            JButton defBtn;
                            if (!si.isDefault() || (defBtn = ESResultsTablePanel.this.serviceBtns.get(si)) == null) continue;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    defBtn.doClick();
                                }
                            });
                            break;
                        }
                    }
                }
            });
        }
    }

    public void startFilling() {
        this.resultSetTableModel.startDataAcquisition();
    }

    protected List<ServiceInfo> getServices() {
        List<ServiceInfo> additionalServices;
        List<ServiceInfo> services = new Vector<ServiceInfo>(ContextMgr.checkForServices(this.results.getTableId()));
        if (this.results instanceof ServiceProviderIFace && (additionalServices = ((ServiceProviderIFace)((Object)this.results)).getServices(this)) != null) {
            services.addAll(additionalServices);
        }
        if (Uploader.getCurrentUpload() != null) {
            services = Uploader.getCurrentUpload().filterServices(services);
        }
        return services;
    }

    protected ResultSetTableModel createModel() {
        return new ResultSetTableModel(this, this.results, false, false);
    }

    protected ActionListener createRemoveItemAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ESResultsTablePanel.this.removeRows(ESResultsTablePanel.this.getSelectedRows());
                        if ((this).ESResultsTablePanel.this.popupMenu != null) {
                            (this).ESResultsTablePanel.this.popupMenu.setVisible(false);
                        }
                    }
                });
            }
        };
    }

    protected void addContextMenu() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (e.isPopupTrigger() && ESResultsTablePanel.this.table.getSelectedColumnCount() > 0) {
                    if (ESResultsTablePanel.this.popupMenu != null && ESResultsTablePanel.this.popupMenu.isVisible()) {
                        ESResultsTablePanel.this.popupMenu.setVisible(false);
                    }
                    if (ESResultsTablePanel.this.popupMenu == null) {
                        ESResultsTablePanel.this.popupMenu = new JPopupMenu();
                        JMenuItem mi = ESResultsTablePanel.this.popupMenu.add(new JMenuItem(UIRegistry.getResourceString("Remove")));
                        mi.addActionListener(ESResultsTablePanel.this.createRemoveItemAL());
                    }
                    Point p = ESResultsTablePanel.this.table.getLocationOnScreen();
                    ESResultsTablePanel.this.popupMenu.setLocation(p.x + e.getX() + 1, p.y + e.getY() + 1);
                    ESResultsTablePanel.this.popupMenu.setVisible(true);
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
    }

    protected void removeRows(int[] rows) {
        ResultSetTableModel model = (ResultSetTableModel)this.table.getModel();
        Vector<Integer> ids = new Vector<Integer>();
        int i = 0;
        while (i < rows.length) {
            ids.add(model.getRowId(rows[i] - i));
            model.removeRow(rows[i] - i);
            ++i;
        }
        this.results.removeIds(ids);
        this.table.clearSelection();
    }

    @Override
    public void expandView() {
        if (!this.expandBtn.isDown()) {
            this.expandTable(false);
        }
    }

    protected void expandTable(boolean isInitial) {
        boolean isExpanded = !this.expandBtn.isDown();
        this.expandBtn.setDown(isExpanded);
        this.expandBtn.setToolTipText(isExpanded ? UIRegistry.getResourceString("CollapseTBL") : UIRegistry.getResourceString("ExpandTBL"));
        this.tablePane.setVisible(isExpanded);
        if (this.botBtnPanel != null) {
            this.botBtnPanel.setVisible(isExpanded);
        }
        if (!this.showingAllRows && this.morePanel != null) {
            this.morePanel.setVisible(isExpanded);
        }
        if (!isInitial) {
            this.invalidate();
            this.doLayout();
            this.esrPane.revalidateScroll();
        }
    }

    protected void setTitleBar() {
        this.topTitleBar.setText(this.rowCount > 0 ? String.format("%s - %d", this.results.getTitle(), this.rowCount) : this.results.getTitle());
        if (this.moreBtn != null) {
            this.moreBtn.setText(String.format(UIRegistry.getResourceString("MoreEntries"), this.rowCount - this.topNumEntries));
        }
    }

    @Override
    public QueryForIdResultsIFace getResults() {
        return this.results;
    }

    @Override
    public boolean hasResults() {
        return this.esrPane.hasResults();
    }

    @Override
    public void cleanUp() {
        ((ResultSetTableModel)this.table.getModel()).cleanUp();
        if (this.results != null) {
            this.results.cleanUp();
        }
        this.esrPane = null;
        this.results = null;
    }

    protected void configColumns() {
        UIHelper.makeTableHeadersCentered(this.table, true);
    }

    protected void buildMorePanel() {
        FormLayout formLayout = new FormLayout("15px,0px,p", "p");
        PanelBuilder builder = new PanelBuilder(formLayout);
        CellConstraints cc = new CellConstraints();
        this.moreBtn = UIHelper.createButton(String.format(UIRegistry.getResourceString("MoreEntries"), this.rowCount - this.topNumEntries));
        this.moreBtn.setCursor(handCursor);
        this.moreBtn.setBorderPainted(false);
        builder.add((Component)UIHelper.createLabel(" "), cc.xy(1, 1));
        builder.add((Component)this.moreBtn, cc.xy(3, 1));
        this.morePanel = builder.getPanel();
        Color bgColor = this.table.getBackground();
        bgColor = new Color(Math.max(bgColor.getRed() - 10, 0), Math.max(bgColor.getGreen() - 10, 0), Math.max(bgColor.getBlue() - 10, 0));
        Color fgColor = new Color(Math.min(this.bannerColor.getRed() + 10, 255), Math.min(this.bannerColor.getGreen() + 10, 255), Math.min(this.bannerColor.getBlue() + 10, 255));
        this.morePanel.setBackground(bgColor);
        this.moreBtn.setBackground(bgColor);
        this.moreBtn.setForeground(fgColor);
        this.add((Component)builder.getPanel(), "South");
        this.moreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ESResultsTablePanel.this.morePanel.setVisible(false);
                ESResultsTablePanel.this.showTopNumEntriesBtn.setVisible(true);
                ESResultsTablePanel.this.showingAllRows = true;
                ESResultsTablePanel.this.setDisplayRows(ESResultsTablePanel.this.rowCount, Integer.MAX_VALUE);
                ESResultsTablePanel.this.esrPane.revalidateScroll();
            }
        });
        this.morePanel.setVisible(false);
    }

    protected void removeMe() {
        this.esrPane.removeTable(this);
    }

    protected int[] createIndexesArray(int rows) {
        int[] indexes = new int[rows];
        int i = 0;
        while (i < rows) {
            indexes[i] = i;
            ++i;
        }
        return indexes;
    }

    protected void setDisplayRows(int numRows, int maxNum) {
        int rows = Math.min(numRows, maxNum);
    }

    public JTable getTable() {
        return this.table;
    }

    public RecordSetIFace getRecordSet(boolean returnAll) {
        boolean doReturnAll = returnAll;
        int[] rows = this.getSelectedRows();
        if (returnAll || rows.length == 0) {
            int numRows = this.table.getModel().getRowCount();
            rows = new int[numRows];
            int i = 0;
            while (i < numRows) {
                rows[i] = i;
                ++i;
            }
        }
        RecordSetIFace rs = this.getRecordSet(rows, doReturnAll);
        rs.setDbTableId(this.results.getTableId());
        return rs;
    }

    @Override
    public List<Integer> getListOfIds(boolean returnAll) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        RecordSetIFace rs = this.getRecordSet(returnAll);
        if (rs != null) {
            for (RecordSetItemIFace rsi : rs.getOrderedItems()) {
                list.add(rsi.getRecordId());
            }
        }
        return list;
    }

    public RecordSetIFace getRecordSet(int[] rows, boolean returnAll) {
        ResultSetTableModel rsm = (ResultSetTableModel)this.table.getModel();
        return rsm.getRecordSet(rows, returnAll);
    }

    @Override
    public int[] getSelectedRows() {
        int[] rows = this.table.getSelectedRows();
        int i = 0;
        while (i < rows.length) {
            rows[i] = this.table.convertRowIndexToModel(rows[i]);
            ++i;
        }
        return rows;
    }

    public String getTitle() {
        return this.results.getTitle();
    }

    @Override
    public Component getUIComponent() {
        return this;
    }

    private void autoResizeColWidth(JTable table, DefaultTableModel model) {
        table.setAutoResizeMode(0);
        table.setModel(model);
        int margin = 5;
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        int preferredWidthTotal = 0;
        int renderedWidthTotal = 0;
        int[] colWidths = new int[table.getColumnCount()];
        int[] strWidths = new int[table.getColumnCount()];
        int i = 0;
        while (i < table.getColumnCount()) {
            TableCellRenderer renderer;
            int vColIndex = i;
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer headerRenderer = col.getHeaderRenderer();
            if (headerRenderer instanceof JLabel) {
                ((JLabel)((Object)headerRenderer)).setHorizontalAlignment(0);
            }
            if ((renderer = col.getCellRenderer()) == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            int strWidth = 0;
            boolean isString = model.getColumnClass(i) == String.class;
            int r = 0;
            while (r < table.getRowCount()) {
                renderer = table.getCellRenderer(r, vColIndex);
                Object objVal = table.getValueAt(r, vColIndex);
                if (isString && objVal != null) {
                    strWidth = Math.max(strWidth, ((String)objVal).length());
                }
                comp = renderer.getTableCellRendererComponent(table, objVal, false, false, r, vColIndex);
                width = Math.max(width, comp.getPreferredSize().width);
                ++r;
            }
            preferredWidthTotal += col.getPreferredWidth();
            colWidths[i] = width += 2 * margin;
            strWidths[i] = strWidth;
            renderedWidthTotal += width;
            ++i;
        }
        if (renderedWidthTotal > preferredWidthTotal) {
            i = 0;
            while (i < table.getColumnCount()) {
                TableColumn col = colModel.getColumn(i);
                TableCellRenderer renderer = col.getCellRenderer();
                if (renderer != null) {
                    ((JLabel)((Object)renderer)).setHorizontalAlignment(strWidths[i] > 20 ? 2 : 0);
                }
                if (model.getColumnCount() > 3) {
                    col.setPreferredWidth(colWidths[i]);
                }
                ++i;
            }
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        table.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public void setPropertyChangeListener(PropertyChangeListener pcl) {
        this.propChangeListener = pcl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.rowCount = (Integer)evt.getNewValue();
        if (this.rowCount > 0) {
            this.setTitleBar();
            this.esrPane.addTable(this);
            this.esrPane.revalidateScroll();
            if (this.propChangeListener != null) {
                this.propChangeListener.propertyChange(new PropertyChangeEvent(this, "loaded", this.rowCount, this.rowCount));
            }
            this.autoResizeColWidth(this.table, (DefaultTableModel)this.table.getModel());
        }
    }

    @Override
    public void initialize(ExpressSearchResultsPaneIFace esrPaneArg, QueryForIdResultsIFace resultsArg) {
    }

    class DragSelectedRowsBtn
    extends RolloverCommand
    implements GhostActionable {
        public DragSelectedRowsBtn(ImageIcon imgIcon) {
            super(null, imgIcon);
            this.dragFlavors.add(new DataFlavorTableExt(RecordSetTask.class, "Record_Set", ESResultsTablePanel.this.results.getTableId()));
            this.createMouseInputAdapter();
        }

        @Override
        public Object getData() {
            if (ESResultsTablePanel.this.results.getRecIds() != null && ESResultsTablePanel.this.results.getRecIds().size() > 0) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(ESResultsTablePanel.this.results.getTableId());
                if (tableInfo != null) {
                    RecordSetIFace rs = RecordSetFactory.getInstance().createRecordSet();
                    rs.setDbTableId(ESResultsTablePanel.this.results.getTableId());
                    if (ESResultsTablePanel.this.table.getSelectedRowCount() > 0) {
                        int[] nArray = ESResultsTablePanel.this.getSelectedRows();
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int inx = nArray[n2];
                            int id = ESResultsTablePanel.this.results.getRecIds().get(inx);
                            rs.addItem(id);
                            ++n2;
                        }
                    } else {
                        int i = 0;
                        while (i < ESResultsTablePanel.this.results.size()) {
                            rs.addItem(ESResultsTablePanel.this.results.getRecIds().get(i));
                            ++i;
                        }
                    }
                    return rs;
                }
            } else {
                log.error((Object)"results doesn't have any ids.");
            }
            return null;
        }

        @Override
        public Object getDataForClass(Class<?> classObj) {
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(ESResultsTablePanel.this.results.getTableId());
            if (tableInfo != null) {
                return tableInfo.getClassObj();
            }
            return null;
        }
    }

    class ESTableAction
    implements ActionListener {
        protected CommandAction cmd;
        protected RecordSetIFace recordSet;
        protected JTable estTable;
        protected Properties props = new Properties();
        protected String msg;

        public ESTableAction(CommandAction cmd, JTable estTable, String msg) {
            this.cmd = cmd;
            this.estTable = estTable;
            this.msg = msg;
            this.props.put("jtable", estTable);
        }

        public void setProperty(String key, Object value) {
            this.props.put(key, value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIRegistry.getStatusBar().setText(this.msg);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean doSetCmdData;
                        CommandAction cmdAction = (CommandAction)ESTableAction.this.cmd.clone();
                        boolean bl = doSetCmdData = cmdAction.getData() == null;
                        if (doSetCmdData) {
                            cmdAction.setData(ESResultsTablePanel.this.getRecordSet(false));
                        }
                        cmdAction.addProperties(ESTableAction.this.props);
                        CommandDispatcher.dispatch(cmdAction);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

