/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxLayoutManager;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanel;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.specify.tasks.subpane.SIQueryForIdResults;
import edu.ku.brc.specify.tasks.subpane.SearchInfoTableResults;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ESResultsSubPane
extends BaseSubPane
implements ExpressSearchResultsPaneIFace,
CommandListener {
    private static final Logger log = Logger.getLogger(ESResultsSubPane.class);
    protected JPanel contentPanel;
    protected NavBoxLayoutManager layoutMgr;
    protected JScrollPane scrollPane;
    protected ImageIcon icon = null;
    protected List<ESResultsTablePanelIFace> expTblResults = new Vector<ESResultsTablePanelIFace>();
    protected NavBox navBox = null;
    protected int positionOfUnIndexed = -1;
    protected boolean showing = false;
    protected boolean added = false;
    protected JButton moreInfoHelpBtn = null;
    protected JButton moreInfoCaptionBtn = null;
    protected Vector<ESResultsTablePanelIFace> expTblResultsCache = new Vector();
    protected JPanel explainPanel = null;
    protected Comparator<ESResultsTablePanelIFace> sorter;

    public ESResultsSubPane(String name, Taskable task, boolean includeExplainPane) {
        super(name, task, false);
        this.setPreferredSize(new Dimension(600, 600));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.layoutMgr = new NavBoxLayoutManager(0, 2);
        this.contentPanel = new JPanel(this.layoutMgr);
        this.scrollPane = new JScrollPane(this.contentPanel);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.sorter = new Comparator<ESResultsTablePanelIFace>(){

            @Override
            public int compare(ESResultsTablePanelIFace left, ESResultsTablePanelIFace right) {
                Integer leftOrder = left.getResults().getDisplayOrder();
                Integer rightOrder = right.getResults().getDisplayOrder();
                return leftOrder.compareTo(rightOrder);
            }
        };
        if (includeExplainPane) {
            this.explainPanel = new JPanel(new BorderLayout());
            this.explainPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            String helpContext = this.getHelpTarget();
            this.moreInfoHelpBtn = UIHelper.createHelpIconButton(helpContext);
            this.moreInfoCaptionBtn = UIHelper.createButton(UIRegistry.getResourceString("EXPRESSSEARCH_TELL_ME_MORE"));
            this.moreInfoCaptionBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.moreInfoCaptionBtn.setFocusable(false);
            this.moreInfoCaptionBtn.setForeground(Color.GRAY);
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,p,f:p:g", "p"));
            this.explainPanel.add((Component)this.moreInfoCaptionBtn, "Center");
            pb.add((Component)this.moreInfoHelpBtn, cc.xy(1, 1));
            pb.add((Component)this.moreInfoCaptionBtn, cc.xy(2, 1));
            this.explainPanel.add((Component)pb.getPanel(), "West");
            HelpMgr.registerComponent((AbstractButton)this.moreInfoHelpBtn, helpContext);
            HelpMgr.registerComponent((AbstractButton)this.moreInfoCaptionBtn, helpContext);
        }
        CommandDispatcher.register("Express_Search", this);
    }

    public boolean contains(QueryForIdResultsIFace results) {
        for (ESResultsTablePanelIFace ertp : this.expTblResults) {
            if (ertp.getResults() != results) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addSearchResults(QueryForIdResultsIFace results) {
        if (results instanceof SIQueryForIdResults) {
            ESResultsTablePanel resultsTable = new ESResultsTablePanel(this, results, results.shouldInstallServices(), results.isExpanded()){

                @Override
                protected ResultSetTableModel createModel() {
                    return new SearchInfoTableResults((ESResultsTablePanelIFace)this, (SIQueryForIdResults)this.results);
                }
            };
        } else {
            ESResultsTablePanel resultsTable = this.createResultsTable(results);
            resultsTable.startFilling();
        }
    }

    protected ESResultsTablePanel createResultsTable(QueryForIdResultsIFace results) {
        return new ESResultsTablePanel(this, results, results.shouldInstallServices(), results.isExpanded());
    }

    public void reset() {
        for (ESResultsTablePanelIFace esrtp : new Vector<ESResultsTablePanelIFace>(this.expTblResults)) {
            this.removeTable(esrtp);
        }
    }

    @Override
    public boolean hasResults() {
        return this.expTblResults.size() > 0;
    }

    @Override
    public void removeTable(ESResultsTablePanelIFace expressTableResultsBase) {
        this.expTblResults.remove(expressTableResultsBase);
        expressTableResultsBase.cleanUp();
        this.contentPanel.remove(expressTableResultsBase.getUIComponent());
        this.contentPanel.invalidate();
        this.contentPanel.doLayout();
        this.contentPanel.repaint();
        this.scrollPane.revalidate();
        this.scrollPane.doLayout();
        this.scrollPane.repaint();
    }

    @Override
    public void addTable(ESResultsTablePanelIFace expTblRes) {
        this.expTblResultsCache.remove(expTblRes);
        QueryForIdResultsIFace results = expTblRes.getResults();
        if (results.getIconName() == null) {
            log.error((Object)("Icon name is null for [" + results.getTitle() + "]"));
        }
        this.contentPanel.removeAll();
        this.expTblResults.add(expTblRes);
        Collections.sort(this.expTblResults, this.sorter);
        for (ESResultsTablePanelIFace etr : this.expTblResults) {
            this.contentPanel.add(etr.getUIComponent());
        }
        this.layoutMgr.removeAll();
        for (ESResultsTablePanelIFace etr : this.expTblResults) {
            this.layoutMgr.addLayoutComponent(etr.getUIComponent(), null);
        }
        if (this.explainPanel != null) {
            this.contentPanel.add(this.explainPanel);
        }
        this.validate();
        this.repaint();
        expTblRes.getUIComponent().repaint();
    }

    @Override
    public Icon getIcon() {
        return this.icon != null ? this.icon : super.getIcon();
    }

    @Override
    public String getHelpTarget() {
        return "ESTellMeMore";
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    protected void adjustDisplay() {
        if (this.expTblResults.size() == 1) {
            this.expTblResults.get(0).expandView();
        }
    }

    @Override
    public void showingPane(boolean show) {
    }

    @Override
    public void revalidateScroll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ESResultsSubPane.this.contentPanel.invalidate();
                ESResultsSubPane.this.scrollPane.revalidate();
            }
        });
    }

    @Override
    public boolean aboutToShutdown() {
        super.aboutToShutdown();
        LinkedList<Component> toRemove = new LinkedList<Component>();
        int i = 0;
        while (i < this.contentPanel.getComponentCount()) {
            Component comp = this.contentPanel.getComponent(i);
            if (comp instanceof ESResultsTablePanel) {
                ((ESResultsTablePanel)comp).cleanUp();
                toRemove.add(comp);
            }
            ++i;
        }
        for (Component comp : toRemove) {
            this.contentPanel.remove(comp);
        }
        this.expTblResults.clear();
        return true;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("Express_Search") && cmdAction.isAction("SearchComplete")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ESResultsSubPane.this.adjustDisplay();
                }
            });
        }
    }

    @Override
    public boolean doQueriesSynchronously() {
        return false;
    }

    @Override
    public void done() {
    }
}

