/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.services;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.init.BldrPickList;
import edu.ku.brc.specify.config.init.BldrPickListItem;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.specify.tools.schemalocale.PickListEditorDlg;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class PickListUtils {
    private static Comparator<PickListItem> pliComparatorOrd = new Comparator<PickListItem>(){

        @Override
        public int compare(PickListItem o1, PickListItem o2) {
            return o1.getOrdinal().compareTo(o2.getOrdinal());
        }
    };
    private static Comparator<PickListItem> pliComparatorTitle = new Comparator<PickListItem>(){

        @Override
        public int compare(PickListItem o1, PickListItem o2) {
            return o1.getTitle().compareTo(o2.getTitle());
        }
    };
    private static Comparator<BldrPickListItem> bldrPliComparatorTitle = new Comparator<BldrPickListItem>(){

        @Override
        public int compare(BldrPickListItem o1, BldrPickListItem o2) {
            return o1.getTitle().compareTo(o2.getTitle());
        }
    };

    public static List<PickList> getPickLists(LocalizableIOIFace localizableIO, boolean doAll, boolean isSystemPL) {
        List<PickList> items;
        block12: {
            items = null;
            if (localizableIO != null) {
                items = localizableIO.getPickLists(null);
            } else {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        Vector<PickList> plItems = new Vector<PickList>();
                        String sysPLSQL = "";
                        if (!doAll) {
                            sysPLSQL = " AND isSystem = " + (isSystemPL ? 1 : 0);
                        }
                        String sqlStr = "FROM PickList WHERE collectionId = COLLID" + sysPLSQL;
                        String sql = QueryAdjusterForDomain.getInstance().adjustSQL(sqlStr);
                        List<?> pickLists = session.getDataList(sql);
                        for (Object obj : pickLists) {
                            PickList pl = (PickList)obj;
                            pl.getPickListItems().size();
                            plItems.add(pl);
                        }
                        items = plItems;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(PickListEditorDlg.class, ex);
                        if (session != null) {
                            session.close();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
        }
        Collections.sort(items);
        return items;
    }

    protected static String getPickListXMLName() {
        Discipline dsp = AppContextMgr.getInstance().getClassObject(Discipline.class);
        Collection col = AppContextMgr.getInstance().getClassObject(Collection.class);
        return String.format("%s_%s.xml", dsp.getName(), col.getCollectionName());
    }

    private static PickList createPickList(BldrPickList bpl, Collection currCollection) {
        PickList pickList = DataBuilder.createPickList(bpl.getName(), bpl.getType(), bpl.getTableName(), bpl.getFieldName(), bpl.getFormatter(), bpl.getReadOnly(), bpl.getSizeLimit(), bpl.getIsSystem(), bpl.getSortType(), currCollection);
        pickList.setIsSystem(bpl.getIsSystem());
        pickList.setTimestampCreated(bpl.getTimestampCreated());
        pickList.setTimestampModified(bpl.getTimestampModified());
        pickList.setVersion(bpl.getVersion());
        pickList.setCollection(currCollection);
        if (bpl.getItems() != null) {
            for (BldrPickListItem item : bpl.getItems()) {
                PickListItem pli = (PickListItem)pickList.addItem(item.getTitle(), item.getValue(), item.getOrdinal());
                pli.setTimestampCreated(item.getTimestampCreated());
                pli.setTimestampModified(item.getTimestampModified());
                pli.setVersion(item.getVersion());
            }
        }
        return pickList;
    }

    public static boolean importPickLists(LocalizableIOIFace localizableIO, Collection collection) {
        boolean wasErr;
        Integer cnt;
        block16: {
            FileDialog dlg = new FileDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString(PickListUtils.getI18n("PL_IMPORT")), 0);
            dlg.setDirectory(UIRegistry.getUserHomeDir());
            dlg.setFile(PickListUtils.getPickListXMLName());
            UIHelper.centerAndShow(dlg);
            String dirStr = dlg.getDirectory();
            String fileName = dlg.getFile();
            if (StringUtils.isEmpty((String)dirStr) || StringUtils.isEmpty((String)fileName)) {
                return false;
            }
            String path = String.valueOf(dirStr) + fileName;
            File file = new File(path);
            if (!file.exists()) {
                UIRegistry.showLocalizedError(PickListUtils.getI18n("PL_FILE_NOT_EXIST"), file.getAbsoluteFile());
                return false;
            }
            List<BldrPickList> bldrPickLists = DataBuilder.getBldrPickLists(null, file);
            cnt = null;
            wasErr = false;
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    session.beginTransaction();
                    HashMap<String, PickList> plHash = new HashMap<String, PickList>();
                    List<PickList> items = PickListUtils.getPickLists(localizableIO, true, false);
                    for (PickList pl : items) {
                        plHash.put(pl.getName(), pl);
                    }
                    for (BldrPickList bpl : bldrPickLists) {
                        PickList pickList = (PickList)plHash.get(bpl.getName());
                        if (pickList == null) {
                            pickList = PickListUtils.createPickList(bpl, collection);
                            session.saveOrUpdate(pickList);
                            if (cnt == null) {
                                cnt = 0;
                            }
                            cnt = cnt + 1;
                            continue;
                        }
                        if (PickListUtils.pickListsEqual(pickList, bpl)) continue;
                        session.delete(pickList);
                        collection.getPickLists().remove(pickList);
                        pickList = PickListUtils.createPickList(bpl, collection);
                        session.saveOrUpdate(pickList);
                        collection.getPickLists().add(pickList);
                        if (cnt == null) {
                            cnt = 0;
                        }
                        cnt = cnt + 1;
                    }
                    session.commit();
                }
                catch (Exception ex) {
                    wasErr = true;
                    if (session != null) {
                        session.rollback();
                    }
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PickListEditorDlg.class, ex);
                    if (session != null) {
                        session.close();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        String key = wasErr ? "PL_ERR_IMP" : (cnt != null ? "PL_WASIMPORT" : "PL_MATCHIMP");
        UIRegistry.displayInfoMsgDlgLocalized(PickListUtils.getI18n(key), cnt);
        return true;
    }

    public static Collection getCollectionFromAppContext() {
        Collection collection = null;
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                collection = (Collection)session.getData("FROM Collection WHERE collectionId = " + collection.getId());
                collection.getPickLists().size();
                collection.getNumberingSchemes().size();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PickListEditorDlg.class, ex);
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return collection;
    }

    public static boolean equals(Boolean v1, Boolean v2) {
        return v1 == null ? v2 == null : v1.equals(v2);
    }

    public static boolean equals(Byte v1, Byte v2) {
        return v1 == null ? v2 == null : v1.equals(v2);
    }

    public static boolean equals(Integer v1, Integer v2) {
        return v1 == null ? v2 == null : v1.equals(v2);
    }

    private static boolean pickListsEqual(PickList pl, BldrPickList bpl) {
        if (!StringUtils.equals((String)pl.getName(), (String)bpl.getName())) {
            return false;
        }
        if (!StringUtils.equals((String)pl.getTableName(), (String)bpl.getTableName())) {
            return false;
        }
        if (!StringUtils.equals((String)pl.getFieldName(), (String)bpl.getFieldName())) {
            return false;
        }
        if (!StringUtils.equals((String)pl.getFormatter(), (String)bpl.getFormatter())) {
            return false;
        }
        if (!PickListUtils.equals(pl.getType(), bpl.getType())) {
            return false;
        }
        if (!PickListUtils.equals(pl.getReadOnly(), bpl.getReadOnly())) {
            return false;
        }
        if (!PickListUtils.equals(pl.getSizeLimit(), bpl.getSizeLimit())) {
            return false;
        }
        if (!PickListUtils.equals(pl.getIsSystem(), bpl.getIsSystem())) {
            return false;
        }
        if (!PickListUtils.equals(pl.getSortType(), bpl.getSortType())) {
            return false;
        }
        Vector<PickListItem> plis = new Vector<PickListItem>(pl.getPickListItems());
        Vector<BldrPickListItem> bplis = bpl.getItems();
        if (plis.size() == 0 && (bplis == null || bplis.size() == 0)) {
            return true;
        }
        if (plis.size() != bplis.size()) {
            return false;
        }
        if (pl.getSortType() == 2) {
            Collections.sort(plis, pliComparatorOrd);
            Collections.sort(bplis);
        } else {
            Collections.sort(plis, pliComparatorTitle);
            Collections.sort(bplis, bldrPliComparatorTitle);
        }
        int i = 0;
        while (i < plis.size()) {
            PickListItem pli = plis.get(i);
            BldrPickListItem bpli = bplis.get(i);
            if (!StringUtils.equals((String)pli.getTitle(), (String)bpli.getTitle())) {
                return false;
            }
            if (!StringUtils.equals((String)pli.getValue(), (String)bpli.getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void exportPickList(LocalizableIOIFace localizableIO, HashSet<String> hash) {
        Window window;
        boolean isDialog;
        List<PickList> items = PickListUtils.getPickLists(localizableIO, true, false);
        ArrayList<PickList> selectedItems = new ArrayList<PickList>();
        if (hash != null) {
            for (PickList pl : items) {
                if (!hash.contains(pl.getName())) continue;
                selectedItems.add(pl);
            }
        }
        ToggleButtonChooserDlg<PickList> pickDlg = (isDialog = (window = UIRegistry.getTopWindow()) instanceof Dialog) ? new ToggleButtonChooserDlg<PickList>((Dialog)window, PickListUtils.getI18n("PL_EXPORT"), items) : new ToggleButtonChooserDlg<PickList>((Frame)((JFrame)window), PickListUtils.getI18n("PL_EXPORT"), items);
        pickDlg.setUseScrollPane(true);
        pickDlg.setAddSelectAll(true);
        pickDlg.createUI();
        pickDlg.setSelectedObjects(selectedItems);
        UIHelper.centerAndShow(pickDlg);
        Integer cnt = null;
        if (!pickDlg.isCancelled()) {
            items = pickDlg.getSelectedObjects();
            String dlgTitle = UIRegistry.getResourceString(PickListUtils.getI18n("RIE_ExportResource"));
            FileDialog dlg = isDialog ? new FileDialog((Dialog)window, dlgTitle, 1) : new FileDialog((Frame)window, dlgTitle, 1);
            dlg.setDirectory(UIRegistry.getUserHomeDir());
            dlg.setFile(PickListUtils.getPickListXMLName());
            UIHelper.centerAndShow(dlg);
            String dirStr = dlg.getDirectory();
            String fileName = dlg.getFile();
            if (StringUtils.isNotEmpty((String)dirStr) && StringUtils.isNotEmpty((String)fileName)) {
                String ext = FilenameUtils.getExtension((String)fileName);
                if (StringUtils.isEmpty((String)ext) || !ext.equalsIgnoreCase("xml")) {
                    fileName = String.valueOf(fileName) + ".xml";
                }
                try {
                    File xmlFile = new File(String.valueOf(dirStr) + File.separator + fileName);
                    ArrayList<BldrPickList> bldrPickLists = new ArrayList<BldrPickList>();
                    for (PickList pl : items) {
                        bldrPickLists.add(new BldrPickList(pl));
                    }
                    DataBuilder.writePickListsAsXML(xmlFile, bldrPickLists);
                    cnt = bldrPickLists.size();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                UIRegistry.displayInfoMsgDlgLocalized(PickListUtils.getI18n(cnt != null ? "PL_WASEXPORT" : "PL_ERR_IMP"), cnt);
            }
        }
    }

    public static String getI18n(String s) {
        return "SystemSetupTask." + s;
    }
}

