/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.services;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.services.GenericKMLGenerator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CollectingEventLocalityKMLGenerator {
    private static final Logger log = Logger.getLogger(CollectingEventLocalityKMLGenerator.class);
    protected static String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static String KML_NAMESPACE_DECL = "<kml xmlns=\"http://earth.google.com/kml/2.0\">\n";
    protected List<FormDataObjIFace> dataObjs = new Vector<FormDataObjIFace>();
    protected List<String> labels = new Vector<String>();
    protected Hashtable<String, String> speciesToImageMapper;
    protected String textColor = "000000";
    protected String placemarkIconURL;
    protected String balloonStyleBgColor;
    protected String balloonStyleTextColor;
    protected String balloonStyleText;
    protected String description;

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public void addDataObj(FormDataObjIFace ce, String label) {
        this.dataObjs.add(ce);
        this.labels.add(label);
    }

    public void clear() {
        this.dataObjs.clear();
        this.labels.clear();
    }

    public void setSpeciesToImageMapper(Hashtable<String, String> speciesToImageMapper) {
        this.speciesToImageMapper = speciesToImageMapper;
    }

    public void outputToFile(String filename) throws IOException {
        BufferedWriter writer;
        block16: {
            writer = new BufferedWriter(new FileWriter(filename));
            writer.write(XML_DECLARATION);
            writer.write(KML_NAMESPACE_DECL);
            writer.write("<Document>\n");
            if (StringUtils.isNotEmpty((String)this.description)) {
                writer.append("<description><![CDATA[");
                writer.append(this.description);
                writer.append("]]></description>");
            }
            writer.write(GenericKMLGenerator.generateStyle(this.placemarkIconURL, this.balloonStyleBgColor, this.balloonStyleTextColor, this.balloonStyleText));
            boolean isDoingCollectingEvents = false;
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    int i = 0;
                    while (i < this.dataObjs.size()) {
                        String label = this.labels.get(i);
                        FormDataObjIFace dataObj = this.dataObjs.get(i);
                        session.attach(dataObj);
                        String kmlStr = null;
                        if (dataObj instanceof CollectingEvent) {
                            kmlStr = this.generatePlacemark((CollectingEvent)dataObj, label);
                            isDoingCollectingEvents = true;
                        } else if (dataObj instanceof Locality) {
                            kmlStr = this.generatePlacemark((Locality)dataObj, label);
                        } else if (dataObj instanceof CollectionObject) {
                            kmlStr = this.generatePlacemark((CollectionObject)dataObj, label);
                        }
                        if (kmlStr != null) {
                            writer.write(kmlStr);
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        writer.write("</Document>\n");
        writer.write("</kml>\n");
        writer.flush();
        writer.close();
    }

    protected String generatePathForLocalities() {
        int cnt = 0;
        StringBuilder sb = new StringBuilder("<Placemark>\n");
        sb.append(GenericKMLGenerator.generateXmlElement("styleUrl", "#custom"));
        sb.append("\n");
        sb.append("<LineString>\n");
        sb.append("<coordinates>");
        for (FormDataObjIFace dataObj : this.dataObjs) {
            Locality loc;
            Locality locality = loc = dataObj instanceof CollectingEvent ? ((CollectingEvent)dataObj).getLocality() : (Locality)dataObj;
            if (loc == null || loc.getLongitude1() == null || loc.getLatitude1() == null) continue;
            sb.append(loc.getLongitude1());
            sb.append(",");
            sb.append(loc.getLatitude1());
            sb.append(",");
            sb.append("0.0\n");
            ++cnt;
        }
        sb.append("</coordinates>\n");
        sb.append("</LineString>\n");
        sb.append("</Placemark>\n\n\n");
        return cnt > 0 ? sb.toString() : null;
    }

    protected String generatePlacemark(Locality loc, String label) {
        if (loc == null || loc.getLatitude1() == null || loc.getLongitude1() == null) {
            return null;
        }
        BigDecimal lat = loc.getLatitude1();
        BigDecimal lon = loc.getLongitude1();
        StringBuilder sb = new StringBuilder("<Placemark>\n");
        sb.append(GenericKMLGenerator.generateXmlElement("styleUrl", "#custom"));
        sb.append("\n");
        sb.append("<name>");
        if (label != null) {
            sb.append(label);
        } else {
            sb.append(loc.getLocalityName());
        }
        sb.append("</name>\n");
        sb.append("<description><![CDATA[");
        sb.append("<table>\n");
        sb.append("<tr>\n");
        sb.append("<td style=\"color:#" + this.textColor + "; text-align:right\">" + UIRegistry.getResourceString("Latitude") + ":</td>\n");
        sb.append("<td style=\"color:#" + this.textColor + "\" >" + lat.doubleValue() + "</td></tr>\n");
        sb.append("<tr><td style=\"color:#" + this.textColor + "; text-align:right\">" + UIRegistry.getResourceString("Longitude") + ":</td>\n");
        sb.append("<td style=\"color:#" + this.textColor + "\" >" + lon.doubleValue() + "</td>\n");
        if (loc.getGeography() != null) {
            sb.append("<tr><td style=\"color:#" + this.textColor + "; text-align:right\">" + UIRegistry.getResourceString("Geography") + ":</td>\n");
            sb.append("<td style=\"color:#" + this.textColor + "\" >" + loc.getGeography().getFullName() + "</td>\n");
        }
        sb.append("</tr>\n");
        sb.append("</table>]]></description>\n");
        sb.append("<LookAt>\n");
        sb.append("<latitude>");
        sb.append(lat.doubleValue());
        sb.append("</latitude>\n");
        sb.append("<longitude>");
        sb.append(lon.doubleValue());
        sb.append("</longitude>\n");
        sb.append("<range>300000.00</range>\n");
        sb.append("</LookAt>\n");
        sb.append("<Point>\n");
        sb.append("<coordinates>");
        sb.append(lon.doubleValue());
        sb.append(",");
        sb.append(lat.doubleValue());
        sb.append("</coordinates>\n");
        sb.append("</Point>\n");
        sb.append("</Placemark>\n\n\n");
        log.debug((Object)("Generated placemark:\n " + sb.toString()));
        return sb.toString();
    }

    protected String generatePlacemark(CollectingEvent ce, String label) {
        if (ce == null || ce.getLocality() == null || ce.getLocality().getLatitude1() == null || ce.getLocality().getLongitude1() == null) {
            return null;
        }
        Locality loc = ce.getLocality();
        BigDecimal lat = loc.getLatitude1();
        BigDecimal lon = loc.getLongitude1();
        Calendar start = ce.getStartDate();
        DateFormat dfStart = DateFormat.getDateInstance();
        String startString = "";
        if (start != null) {
            dfStart.setCalendar(start);
            startString = dfStart.format(start.getTime());
        }
        Calendar end = ce.getEndDate();
        DateFormat dfEnd = DateFormat.getDateInstance();
        String endString = "";
        if (end != null) {
            dfEnd.setCalendar(end);
            endString = dfEnd.format(end.getTime());
        }
        Vector<String> agentNames = new Vector<String>();
        for (Collector c : ce.getCollectors()) {
            if (StringUtils.isEmpty((String)c.getAgent().getFirstName())) {
                agentNames.add(c.getAgent().getLastName());
                continue;
            }
            agentNames.add(String.valueOf(c.getAgent().getFirstName()) + " " + c.getAgent().getLastName());
        }
        Hashtable<Pair<Object, Object>, CollectionObject> coHash = new Hashtable<Pair<Object, Object>, CollectionObject>();
        Vector<Pair<Object, Object>> genusSpecies = new Vector<Pair<Object, Object>>();
        for (CollectionObject co : ce.getCollectionObjects()) {
            String genus = null;
            String species = null;
            for (Determination d : co.getDeterminations()) {
                if (!d.isCurrentDet()) continue;
                Taxon t = d.getPreferredTaxon();
                species = t.getName();
                genus = t.getParent().getName();
                break;
            }
            Pair<Object, Object> genusSpeciesPair = new Pair<Object, Object>(genus, species);
            genusSpecies.add(genusSpeciesPair);
            coHash.put(genusSpeciesPair, co);
        }
        DBTableInfo colObjTableInfo = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId());
        DBFieldInfo catalogNumberFI = colObjTableInfo.getFieldByColumnName("CatalogNumber");
        UIFieldFormatterIFace formatter = catalogNumberFI.getFormatter();
        StringBuilder sb = new StringBuilder("<Placemark>\n");
        sb.append(GenericKMLGenerator.generateXmlElement("styleUrl", "#custom"));
        sb.append("\n");
        sb.append("<name>");
        if (label != null) {
            sb.append(label);
        }
        if (StringUtils.isNotEmpty((String)startString)) {
            sb.append(startString);
            if (StringUtils.isNotEmpty((String)endString) && !startString.equals(endString)) {
                sb.append(" - ");
                sb.append(endString);
            }
        }
        sb.append("</name>\n");
        sb.append("<description><![CDATA[");
        sb.append("<h3>" + UIRegistry.getResourceString("GE_COLLECTOR") + ":</h3>\n<ul>\n");
        for (String agent : agentNames) {
            sb.append("<li>");
            sb.append(agent);
            sb.append("</li>\n");
        }
        sb.append("</ul>\n");
        if (genusSpecies.size() > 0) {
            sb.append("<br/><h3>" + UIRegistry.getResourceString("GE_COLLECTION_OBJECTS") + ":</h3>\n<table>\n");
            AppPreferences remotePrefs = AppPreferences.getRemote();
            String primaryURL = remotePrefs.get("google.earth.primaryurl", null);
            String primaryURLTitle = remotePrefs.get("google.earth.primaryurltitle", null);
            String secondaryURL = remotePrefs.get("google.earth.secondaryurl", null);
            String secondaryURLTitle = remotePrefs.get("google.earth.secondaryurltitle", null);
            sb.append("<tr>");
            sb.append("<th><center>");
            sb.append(UIRegistry.getResourceString("GE_CATALOG_NUMBER"));
            sb.append("</center></th>\n");
            sb.append("<th>");
            sb.append(UIRegistry.getResourceString("GE_TAXONOMY"));
            sb.append("</b></th>\n");
            if (StringUtils.isNotEmpty((String)primaryURL)) {
                sb.append("<th style=\"color:#" + this.textColor + "\"><center>" + UIRegistry.getResourceString("GE_PRIMARY") + "</center></th>\n");
            }
            if (StringUtils.isNotEmpty((String)secondaryURL)) {
                sb.append("<th style=\"color:#" + this.textColor + "\"><center>" + UIRegistry.getResourceString("GE_SECONDARY") + "</center></th>\n");
            }
            sb.append("</tr>\n");
            for (Pair pair : genusSpecies) {
                String linkTextColor;
                sb.append("<tr>\n");
                sb.append("<td><center>");
                if (formatter != null) {
                    sb.append(formatter.formatToUI(((CollectionObject)coHash.get(pair)).getCatalogNumber()));
                } else {
                    sb.append(((CollectionObject)coHash.get(pair)).getCatalogNumber());
                }
                sb.append("</center></td>\n");
                String taxonomicName = String.valueOf(pair.first != null ? (String)pair.first : "") + " " + (pair.second != null ? (String)pair.second : "");
                sb.append("<td><i>");
                sb.append(taxonomicName);
                sb.append("</i></td>\n");
                String string = linkTextColor = this.textColor.startsWith("F") ? "WHITE" : "BLACK";
                if (StringUtils.isNotEmpty((String)primaryURL)) {
                    String primaryURLStr = String.format(primaryURL, pair.first, pair.second);
                    sb.append("<td><a style=\"color:" + linkTextColor + "\" href=\"" + primaryURLStr + "\"><center>");
                    sb.append(primaryURLTitle);
                    sb.append("</a></center></td>\n");
                }
                if (StringUtils.isNotEmpty((String)secondaryURL)) {
                    String secondaryURLStr = String.format(secondaryURL, pair.first, pair.second);
                    sb.append("<td><a style=\"color:" + linkTextColor + "\" href=\"" + secondaryURLStr + "\"><center>");
                    sb.append(secondaryURLTitle);
                    sb.append("</a></center></td>\n");
                }
                if (this.speciesToImageMapper != null) {
                    String imgSrc = this.speciesToImageMapper.get(taxonomicName);
                    if (imgSrc != null) {
                        sb.append("<td><img src=\"");
                        sb.append(imgSrc);
                        sb.append("\"/></td>\n");
                    } else {
                        sb.append("<td>&nbsp;</td>\n");
                    }
                }
                sb.append("</tr>\n");
            }
            sb.append("</table>\n");
        }
        sb.append("]]></description>\n");
        sb.append("<LookAt>\n");
        sb.append("<latitude>");
        sb.append(lat.doubleValue());
        sb.append("</latitude>\n");
        sb.append("<longitude>");
        sb.append(lon.doubleValue());
        sb.append("</longitude>\n");
        sb.append("<range>300000.00</range>\n");
        sb.append("</LookAt>\n");
        sb.append("<Point>\n");
        sb.append("<coordinates>");
        sb.append(lon.doubleValue());
        sb.append(",");
        sb.append(lat.doubleValue());
        sb.append("</coordinates>\n");
        sb.append("</Point>\n");
        sb.append("</Placemark>\n\n\n");
        log.debug((Object)("Generated placemark:\n " + sb.toString()));
        return sb.toString();
    }

    private void appendCellTR(StringBuilder sb, Integer tableId, String colName, String titleArg, String value) {
        DBTableInfo ti;
        String title = titleArg;
        if (titleArg == null && tableId != null && (ti = DBTableIdMgr.getInstance().getInfoById(tableId)) != null) {
            if (colName != null) {
                DBFieldInfo fi = ti.getFieldByColumnName(colName);
                if (fi != null) {
                    title = fi.getTitle();
                }
            } else {
                title = ti.getTitle();
            }
        }
        if (StringUtils.isNotEmpty((String)title) && StringUtils.isNotEmpty((String)value)) {
            sb.append("<tr><td style=\"color:#" + this.textColor + "; text-align:right\">" + title + ":</td><td style=\"color:#" + this.textColor + "\" >" + value + "</td></tr>\n");
        }
    }

    protected String generatePlacemark(CollectionObject colObj, String label) {
        if (colObj == null || colObj.getCollectingEvent() == null || colObj.getCollectingEvent().getLocality() == null) {
            return null;
        }
        CollectingEvent ce = colObj.getCollectingEvent();
        Locality loc = ce.getLocality();
        if (loc.getLatitude1() == null || loc.getLongitude1() == null) {
            return null;
        }
        BigDecimal lat = loc.getLatitude1();
        BigDecimal lon = loc.getLongitude1();
        DBTableInfo ceti = DBTableIdMgr.getInstance().getInfoById(CollectingEvent.getClassTableId());
        StringBuilder title = new StringBuilder(colObj.getIdentityTitle());
        String taxonStr = null;
        String startDateStr = null;
        String geoStr = null;
        for (Determination det : colObj.getDeterminations()) {
            Taxon taxon;
            if (!det.getIsCurrent().booleanValue() || (taxon = det.getTaxon()) == null) continue;
            taxonStr = taxon.getFullName();
        }
        if (ce.getStartDate() != null) {
            Object dateFmtObj;
            DBFieldInfo sdFI = ceti.getFieldByColumnName("StartDate");
            UIFieldFormatterIFace fmtr = sdFI.getFormatter();
            if (fmtr == null) {
                fmtr = UIFieldFormatterMgr.getInstance().getFormatter("PartialDate");
            }
            if (fmtr != null && (dateFmtObj = fmtr.formatToUI(ce.getStartDate(), ce.getStartDatePrecision())) != null) {
                startDateStr = dateFmtObj.toString();
            }
        }
        if (loc.getGeography() != null) {
            geoStr = loc.getGeography().getFullName();
        }
        StringBuilder sb = new StringBuilder("<Placemark>\n");
        sb.append(GenericKMLGenerator.generateXmlElement("styleUrl", "#custom"));
        sb.append("\n");
        sb.append("<name>");
        if (label != null) {
            sb.append(label);
        } else {
            sb.append(title.toString());
        }
        sb.append("</name>\n");
        sb.append("<description><![CDATA[");
        sb.append("<table>\n");
        this.appendCellTR(sb, CollectingEvent.getClassTableId(), "StartDate", "Start Date", startDateStr);
        this.appendCellTR(sb, Taxon.getClassTableId(), null, "Taxon", taxonStr);
        this.appendCellTR(sb, Locality.getClassTableId(), "Latitude1", "Latitude", LatLonConverter.convertToDDDDDD(loc.getLatitude1(), LatLonConverter.DEGREES_FORMAT.String, LatLonConverter.DIRECTION.NorthSouth, 4));
        this.appendCellTR(sb, Locality.getClassTableId(), "Longitude1", "Longitude", LatLonConverter.convertToDDDDDD(loc.getLongitude1(), LatLonConverter.DEGREES_FORMAT.String, LatLonConverter.DIRECTION.EastWest, 4));
        this.appendCellTR(sb, Geography.getClassTableId(), null, "Geography", geoStr);
        sb.append("</table>]]></description>\n");
        sb.append("<LookAt>\n");
        sb.append("<latitude>");
        sb.append(lat.doubleValue());
        sb.append("</latitude>\n");
        sb.append("<longitude>");
        sb.append(lon.doubleValue());
        sb.append("</longitude>\n");
        sb.append("<range>300000.00</range>\n");
        sb.append("</LookAt>\n");
        sb.append("<Point>\n");
        sb.append("<coordinates>");
        sb.append(lon.doubleValue());
        sb.append(",");
        sb.append(lat.doubleValue());
        sb.append("</coordinates>\n");
        sb.append("</Point>\n");
        sb.append("</Placemark>\n\n\n");
        log.debug((Object)("Generated placemark:\n " + sb.toString()));
        return sb.toString();
    }

    public void setPlacemarkIconURL(String placemarkIconURL) {
        this.placemarkIconURL = placemarkIconURL;
    }

    public void setBalloonStyleBgColor(String balloonStyleBgColor) {
        this.balloonStyleBgColor = balloonStyleBgColor;
    }

    public void setBalloonStyleTextColor(String balloonStyleTextColor) {
        this.balloonStyleTextColor = balloonStyleTextColor;
    }

    public void setBalloonStyleText(String balloonStyleText) {
        this.balloonStyleText = balloonStyleText;
    }
}

