/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskCommandDef;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.BarChartPane;
import edu.ku.brc.af.tasks.subpane.ChartPane;
import edu.ku.brc.af.tasks.subpane.PieChartPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsHandlerIFace;
import edu.ku.brc.dbsupport.QueryResultsListener;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.ImageFilter;
import edu.ku.brc.helpers.UIFileFilter;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.rstools.ExportFileConfigurationFactory;
import edu.ku.brc.specify.rstools.ExportToFile;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.DatasetNavBoxMgr;
import edu.ku.brc.specify.tasks.ReportsTask;
import edu.ku.brc.specify.tasks.SGRTask;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tasks.WorkbenchEditorCreator;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportIFace;
import edu.ku.brc.specify.tasks.subpane.wb.ImageFrame;
import edu.ku.brc.specify.tasks.subpane.wb.ImportColumnInfo;
import edu.ku.brc.specify.tasks.subpane.wb.ImportDataFileInfo;
import edu.ku.brc.specify.tasks.subpane.wb.SelectNewOrExistingDlg;
import edu.ku.brc.specify.tasks.subpane.wb.TemplateEditor;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchBackupMgr;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchJRDataSource;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchValidator;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.specify.ui.ChooseRecordSetDlg;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WorkbenchTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(WorkbenchTask.class);
    public static int MAX_ROWS = 4000;
    public static final int GLASSPANE_FONT_SIZE = 20;
    public static final DataFlavor DATASET_FLAVOR = new DataFlavor(WorkbenchTask.class, "DataSet");
    public static final String WORKBENCH = "Workbench";
    public static final String WORKBENCHTEMPLATE = "WorkbenchTemplate";
    public static final String NEW_WORKBENCH = "WB.NewWorkbench";
    public static final String IMPORT_DATA_FILE = "WB.ImportFile";
    public static final String SELECTED_WORKBENCH = "WB.SelectedWorkbench";
    public static final String WB_BARCHART = "WB.CreateBarChart";
    public static final String PRINT_REPORT = "WB.PrintReport";
    public static final String WB_TOP10_REPORT = "WB.Top10Report";
    public static final String WB_IMPORTCARDS = "WB.ImportCardImages";
    public static final String EXPORT_DATA_FILE = "WB.ExportData";
    public static final String EXPORT_TEMPLATE = "WB.ExportTemplate";
    public static final String NEW_WORKBENCH_FROM_TEMPLATE = "WB.NewDataSetFromTemplate";
    public static final String EXPORT_RS_TO_WB = "WB.ExportRStoWB";
    public static final String IMAGES_FILE_PATH = "wb.imagepath";
    public static final String IMPORT_FILE_PATH = "wb.importfilepath";
    public static final String EXPORT_FILE_PATH = "wb.exportfilepath";
    public static String[] boolStrings = new String[]{UIRegistry.getResourceString("WB_TRUE"), UIRegistry.getResourceString("WB_FALSE"), UIRegistry.getResourceString("WB_TRUE_ABBR"), UIRegistry.getResourceString("WB_FALSE_ABBR"), UIRegistry.getResourceString("WB_YES"), UIRegistry.getResourceString("WB_NO"), UIRegistry.getResourceString("WB_YES_ABBR"), UIRegistry.getResourceString("WB_NO_ABBR"), "1", "0"};
    protected static SoftReference<DBTableIdMgr> databasechema = null;
    protected static boolean isCustomizedSchema = false;
    protected NavBox workbenchNavBox;
    protected Vector<ToolBarDropDownBtn> tbList = new Vector();
    protected Vector<JComponent> menus = new Vector();
    protected Vector<NavBoxItemIFace> reportsList = new Vector();
    protected Vector<NavBoxItemIFace> enableNavBoxList = new Vector();
    protected boolean doingStarterPane = false;
    public final DatasetNavBoxMgr datasetNavBoxMgr;

    public static boolean isCustomizedSchema() {
        return isCustomizedSchema;
    }

    public WorkbenchTask() {
        super(WORKBENCH, UIRegistry.getResourceString(WORKBENCH));
        CommandDispatcher.register(WORKBENCH, this);
        CommandDispatcher.register("Preferences", this);
        if (AppContextMgr.isSecurityOn()) {
            log.debug((Object)("add? " + this.getPermissions().canAdd() + " modify? " + this.getPermissions().canModify() + " delete? " + this.getPermissions().canDelete() + " view? " + this.getPermissions().canView()));
        } else {
            log.debug((Object)"security off");
        }
        this.datasetNavBoxMgr = new DatasetNavBoxMgr(this);
        if (WorkbenchDataItem.getMaxWBCellLength() == null) {
            int max = Math.min(AppPreferences.getLocalPrefs().getInt("MAX_WBCELL_LENGTH", 512), Short.MAX_VALUE);
            if (UIRegistry.isMobile()) {
                max = Math.min(max, 512);
            }
            WorkbenchDataItem.setMaxWBCellLength(max);
        }
        WorkbenchTask.getDatabaseSchema();
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            int wbTblId = Workbench.getClassTableId();
            RolloverCommand roc = null;
            NavBox navBox = new NavBox(UIRegistry.getResourceString("Actions"));
            if (this.isPermitted()) {
                WorkbenchTask.makeDnDNavBtn(navBox, UIRegistry.getResourceString("WB_IMPORTDATA"), "Import16", UIRegistry.getResourceString("WB_IMPORTDATA_TT"), new CommandAction(WORKBENCH, IMPORT_DATA_FILE, wbTblId), null, false, false);
                WorkbenchTask.makeDnDNavBtn(navBox, UIRegistry.getResourceString("WB_IMPORT_CARDS"), "ImportImages", UIRegistry.getResourceString("WB_IMPORTCARDS_TT"), new CommandAction(WORKBENCH, WB_IMPORTCARDS, wbTblId), null, false, false);
                roc = (RolloverCommand)((Object)WorkbenchTask.makeDnDNavBtn(navBox, UIRegistry.getResourceString("WB_NEW_DATASET"), "NewDataSet", UIRegistry.getResourceString("WB_NEW_DATASET_TT"), new CommandAction(WORKBENCH, NEW_WORKBENCH, wbTblId), null, false, false));
                roc.addDropDataFlavor(DATASET_FLAVOR);
            }
            if (this.isPermitted()) {
                roc = (RolloverCommand)((Object)WorkbenchTask.makeDnDNavBtn(navBox, UIRegistry.getResourceString("WB_EXPORT_DATA"), "Export16", UIRegistry.getResourceString("WB_EXPORT_DATA_TT"), new CommandAction(WORKBENCH, EXPORT_DATA_FILE, wbTblId), null, true, false));
                roc.addDropDataFlavor(DATASET_FLAVOR);
                roc.addDragDataFlavor(new DataFlavor(Workbench.class, EXPORT_DATA_FILE));
                this.enableNavBoxList.add((NavBoxItemIFace)((Object)roc));
                roc = (RolloverCommand)((Object)WorkbenchTask.makeDnDNavBtn(navBox, UIRegistry.getResourceString("WB_EXPORT_TEMPLATE"), "ExportExcel16", UIRegistry.getResourceString("WB_EXPORT_TEMPLATE_TT"), new CommandAction(WORKBENCH, EXPORT_TEMPLATE, wbTblId), null, true, false));
                roc.addDropDataFlavor(DATASET_FLAVOR);
                roc.addDragDataFlavor(new DataFlavor(Workbench.class, EXPORT_TEMPLATE));
                this.enableNavBoxList.add((NavBoxItemIFace)((Object)roc));
                WorkbenchTask.makeDnDNavBtn(navBox, UIRegistry.getResourceString("WB_EXPORTFROMDBTOWB"), "Export16", UIRegistry.getResourceString("WB_EXPORTFROMDBTOWB_TT"), new CommandAction(WORKBENCH, EXPORT_RS_TO_WB, wbTblId), null, false, false);
            }
            this.navBoxes.add(navBox);
            this.workbenchNavBox = this.datasetNavBoxMgr.createWorkbenchNavBox(WORKBENCH);
            if (this.commands != null && (!AppContextMgr.isSecurityOn() || this.canViewReports())) {
                NavBox reportsNavBox = new NavBox(UIRegistry.getResourceString("Reports"));
                this.navBoxes.add(reportsNavBox);
                for (AppResourceIFace ap : AppContextMgr.getInstance().getResourceByMimeType("jrxml/report")) {
                    Properties params = ap.getMetaDataMap();
                    String tableid = params.getProperty("tableid");
                    if (!StringUtils.isNotEmpty((String)tableid) || Integer.parseInt(tableid) != Workbench.getClassTableId()) continue;
                    params.put("title", ap.getDescription());
                    params.put("file", ap.getName());
                    String iconNameStr = params.getProperty("icon");
                    if (StringUtils.isEmpty((String)iconNameStr)) {
                        iconNameStr = this.name;
                    }
                    this.commands.add(new TaskCommandDef(ap.getDescription(), iconNameStr, params));
                }
                for (TaskCommandDef tcd : this.commands) {
                    String tableIdStr = tcd.getParams().getProperty("tableid");
                    if (tableIdStr != null) {
                        CommandAction cmdAction = new CommandAction(WORKBENCH, PRINT_REPORT, Workbench.getClassTableId());
                        cmdAction.addStringProperties(tcd.getParams());
                        cmdAction.getProperties().put("icon", IconManager.getIcon(tcd.getIconName()));
                        NavBoxItemIFace nbi = WorkbenchTask.makeDnDNavBtn(reportsNavBox, tcd.getName(), tcd.getIconName(), cmdAction, null, true, false);
                        this.reportsList.add(nbi);
                        this.enableNavBoxList.add(nbi);
                        roc = (RolloverCommand)((Object)nbi);
                        roc.addDropDataFlavor(DATASET_FLAVOR);
                        roc.addDragDataFlavor(new DataFlavor(Workbench.class, "Report"));
                        roc.setToolTip(UIRegistry.getResourceString("WB_PRINTREPORT_TT"));
                        continue;
                    }
                    log.error((Object)"Interaction Command is missing the table id");
                }
                CommandAction cmdAction = new CommandAction(WORKBENCH, WB_BARCHART, Workbench.getClassTableId());
                cmdAction.getProperties().put("icon", IconManager.getIcon("Bar_Chart", IconManager.STD_ICON_SIZE));
                roc = (RolloverCommand)((Object)WorkbenchTask.makeDnDNavBtn(reportsNavBox, UIRegistry.getResourceString("CHART"), "Bar_Chart", cmdAction, null, true, false));
                this.enableNavBoxList.add((NavBoxItemIFace)((Object)roc));
                roc.addDropDataFlavor(DATASET_FLAVOR);
                roc.addDragDataFlavor(new DataFlavor(Workbench.class, "Report"));
                roc.setToolTip(UIRegistry.getResourceString("WB_BARCHART_TT"));
                cmdAction = new CommandAction(WORKBENCH, WB_TOP10_REPORT, Workbench.getClassTableId());
                cmdAction.getProperties().put("icon", IconManager.getIcon("Pie_Chart", IconManager.STD_ICON_SIZE));
                roc = (RolloverCommand)((Object)WorkbenchTask.makeDnDNavBtn(reportsNavBox, UIRegistry.getResourceString("WB_TOP10"), "Pie_Chart", cmdAction, null, true, false));
                this.enableNavBoxList.add((NavBoxItemIFace)((Object)roc));
                roc.addDropDataFlavor(DATASET_FLAVOR);
                roc.addDragDataFlavor(new DataFlavor(Workbench.class, "Report"));
                roc.setToolTip(UIRegistry.getResourceString("WB_TOP10_TT"));
            }
            this.navBoxes.add(this.workbenchNavBox);
            this.updateNavBoxUI(this.workbenchNavBox.getCount());
        }
        MAX_ROWS = AppPreferences.getRemote().getInt("MAX_ROWS", MAX_ROWS);
        this.isShowDefault = true;
    }

    public NavBox getDatasetNavBox() {
        return this.workbenchNavBox;
    }

    public static int getMaxRows() {
        return MAX_ROWS;
    }

    public static DBTableIdMgr getDatabaseSchema() {
        DBTableIdMgr schema = null;
        if (databasechema != null) {
            schema = databasechema.get();
        }
        if (schema == null) {
            schema = new DBTableIdMgr(false);
            File customSchemaFile = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "specify_workbench_datamodel.xml");
            File customDefFile = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "specify_workbench_upload_def.xml");
            if (customSchemaFile.exists() && !customDefFile.exists()) {
                log.error((Object)"a customized specify_workbench_datamodel.xml was found but not loaded because a customized specify_workbench_upload_def.xml was not found");
            } else if (!customSchemaFile.exists() && customDefFile.exists()) {
                log.error((Object)"a customized specify_workbench_upload_def.xml was found but not loaded because a customized specify_workbench_datamodel.xml was not found");
            }
            if (customSchemaFile.exists() && customDefFile.exists()) {
                schema.initialize(customSchemaFile);
                isCustomizedSchema = true;
            } else {
                schema.initialize(new File(XMLHelper.getConfigDirPath("specify_workbench_datamodel.xml")));
            }
            databasechema = new SoftReference<DBTableIdMgr>(schema);
            SchemaLocalizerXMLHelper schemaLocalizer = new SchemaLocalizerXMLHelper(SpLocaleContainer.WORKBENCH_SCHEMA, schema);
            schemaLocalizer.load(true);
            schemaLocalizer.setTitlesIntoSchema();
            DBTableIdMgr mgr = databasechema.get();
            DBTableInfo taxonOnly = mgr.getInfoById(4000);
            if (taxonOnly != null) {
                taxonOnly.setTitle(UIRegistry.getResourceString("WB_TAXONIMPORT_ONLY"));
            }
        }
        return schema;
    }

    protected boolean canViewReports() {
        Taskable reportsTask = ContextMgr.getTaskByClass(ReportsTask.class);
        return reportsTask != null && reportsTask.getPermissions().canView();
    }

    protected Workbench getWorkbenchFromCmd(Object cmdActionObj, String helpContext) {
        CommandAction subCmd;
        if (cmdActionObj != null && cmdActionObj instanceof CommandAction && (subCmd = (CommandAction)cmdActionObj).getTableId() == Workbench.getClassTableId()) {
            Workbench wb = WorkbenchTask.selectWorkbench(subCmd, helpContext);
            if (wb != null) {
                return wb;
            }
            log.error((Object)"No Workbench selected or found.");
        }
        return null;
    }

    protected void editWorkbenchProps(RolloverCommand roc) {
        Workbench workbench;
        if (roc != null && (workbench = WorkbenchTask.loadWorkbench((RecordSetIFace)((CommandAction)roc.getData()).getProperty("workbench"))) != null && this.fillInWorkbenchNameAndAttrs(workbench, workbench.getName(), true)) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    session.beginTransaction();
                    Workbench mergedWB = session.merge(workbench);
                    mergedWB.getWorkbenchTemplate().setName(mergedWB.getName());
                    session.saveOrUpdate(mergedWB);
                    session.commit();
                    session.flush();
                    roc.setLabelText(workbench.getName());
                    NavBox.refresh((NavBoxItemIFace)((Object)roc));
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    log.error((Object)ex);
                    session.close();
                }
            }
            finally {
                session.close();
            }
        }
    }

    public static RolloverCommand getNavBtnById(NavBox navBox, Integer recordId, String cmdAttrName) {
        if (recordId != null) {
            for (NavBoxItemIFace nbi : navBox.getItems()) {
                RecordSetItemIFace rsi;
                Object data;
                RolloverCommand roc = (RolloverCommand)((Object)nbi);
                if (roc == null || (data = roc.getData()) == null) continue;
                RecordSetIFace rs = null;
                if (data instanceof CommandAction) {
                    CommandAction cmd = (CommandAction)data;
                    Object prop = cmd.getProperty(cmdAttrName);
                    if (prop instanceof RecordSetIFace) {
                        rs = (RecordSetIFace)prop;
                    }
                } else if (data instanceof RecordSetIFace) {
                    rs = (RecordSetIFace)data;
                }
                if (rs == null || (rsi = rs.getOnlyItem()) == null || rsi.getRecordId().intValue() != recordId.intValue()) continue;
                return roc;
            }
        }
        return null;
    }

    protected int getCountOfPanesForTemplate(Integer templateId) {
        int count = 0;
        for (SubPaneIFace sbi : SubPaneMgr.getInstance().getSubPanes()) {
            if (sbi.getTask() != this || !(sbi instanceof WorkbenchPaneSS)) continue;
            WorkbenchPaneSS wbp = (WorkbenchPaneSS)sbi;
            if (templateId == null) {
                log.error((Object)"templateId is null");
                return count;
            }
            if (wbp.getWorkbench() == null) {
                log.error((Object)"wbp.getWorkbench() is null");
                return count;
            }
            if (wbp.getWorkbench().getWorkbenchTemplate() == null) {
                log.error((Object)"wbp.getWorkbench().getWorkbenchTemplate() is null");
                return count;
            }
            if (wbp.getWorkbench().getWorkbenchTemplate().getWorkbenchTemplateId() == null) {
                log.error((Object)"wbp.getWorkbench().getWorkbenchTemplate().getWorkbenchTemplateId() is null");
                return count;
            }
            if (wbp.getWorkbench().getWorkbenchTemplate().getWorkbenchTemplateId().longValue() != templateId.longValue()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.doingStarterPane = true;
        this.starterPane = StartUpTask.createFullImageSplashPanel(this.title, this);
        return this.starterPane;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        String label = UIRegistry.getResourceString(this.name);
        String hint = UIRegistry.getResourceString("workbench_hint");
        ToolBarDropDownBtn btn = this.createToolbarButton(label, this.iconName, hint);
        this.toolbarItems.add(new ToolBarItemDesc(btn));
        return this.toolbarItems;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    public static boolean askUserForInfo(String viewSetName, String dlgTitle, Workbench workbench, boolean isEdit) {
        ViewBasedDisplayDialog editorDlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "Global", viewSetName, null, dlgTitle, UIRegistry.getResourceString("OK"), null, null, isEdit, 8);
        editorDlg.preCreateUI();
        editorDlg.setData(workbench);
        editorDlg.getMultiView().preValidate();
        editorDlg.setModal(true);
        editorDlg.setVisible(true);
        if (!editorDlg.isCancelled()) {
            editorDlg.getMultiView().getDataFromUI();
        }
        editorDlg.dispose();
        return !editorDlg.isCancelled();
    }

    protected TemplateEditor showColumnMapperDlg(ImportDataFileInfo dataFileInfo, WorkbenchTemplate template, String titleKey) throws Exception {
        TemplateEditor mapper;
        if (template != null) {
            mapper = new TemplateEditor((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString(titleKey), template);
            if (!this.isPermitted()) {
                mapper.setReadOnly(true);
            }
        } else {
            mapper = new TemplateEditor((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString(titleKey), dataFileInfo);
            if (dataFileInfo == null) {
                Dimension size = mapper.getSize();
                size.width += 120;
                mapper.setSize(size);
            }
        }
        if (!this.templateIsEditable(template)) {
            UIRegistry.showLocalizedMsg("WorkbenchTask.ExportedDatasetTemplateNotEditable");
            mapper.setReadOnly(true);
        }
        UIHelper.centerAndShow(mapper);
        return mapper;
    }

    protected boolean templateIsEditable(WorkbenchTemplate template) {
        if (template != null) {
            for (Workbench wb : template.getWorkbenches()) {
                int rowCount;
                if (wb.getExportedFromTableName() == null || (rowCount = BasicSQLUtils.getCountAsInt("select count(workbenchrowid) from workbenchrow where workbenchid = " + wb.getId())) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    protected WorkbenchTemplate createTemplate(TemplateEditor mapper, String filePath) {
        WorkbenchTemplate workbenchTemplate = null;
        try {
            workbenchTemplate = new WorkbenchTemplate();
            workbenchTemplate.initialize();
            workbenchTemplate.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
            Set<WorkbenchTemplateMappingItem> items = workbenchTemplate.getWorkbenchTemplateMappingItems();
            Collection<WorkbenchTemplateMappingItem> newItems = mapper.updateAndGetNewItems();
            for (WorkbenchTemplateMappingItem item : newItems) {
                log.debug((Object)(String.valueOf(item.getFieldName()) + " " + item.getViewOrder() + "  " + item.getOrigImportColumnIndex()));
            }
            for (WorkbenchTemplateMappingItem wbtmi : newItems) {
                wbtmi.setWorkbenchTemplate(workbenchTemplate);
                items.add(wbtmi);
            }
            workbenchTemplate.setSrcFilePath(filePath);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
            ex.printStackTrace();
        }
        return workbenchTemplate;
    }

    protected boolean colsMatchByName(WorkbenchTemplateMappingItem wbItem, ImportColumnInfo fileItem) {
        boolean result = false;
        if (wbItem != null && fileItem != null) {
            if (StringUtils.isNotEmpty((String)wbItem.getImportedColName()) && StringUtils.isNotEmpty((String)fileItem.getColName())) {
                result = wbItem.getImportedColName().equalsIgnoreCase(fileItem.getColName());
            }
            if (!result && StringUtils.isNotEmpty((String)wbItem.getFieldName())) {
                result = wbItem.getFieldName().equalsIgnoreCase(fileItem.getColName());
            }
        }
        return result;
    }

    protected int indexOfName(Vector<?> cols, String colName) {
        int c = 0;
        for (Object col : cols) {
            if (col.toString().equalsIgnoreCase(colName)) {
                return c;
            }
            ++c;
        }
        return -1;
    }

    public List<?> selectExistingTemplate(Vector<ImportColumnInfo> colInfo, String helpContext) {
        HashMap unMappedCols;
        Vector<WorkbenchTemplate> matchingTemplates;
        WorkbenchTemplate selection;
        block20: {
            selection = null;
            if (colInfo != null) {
                Collections.sort(colInfo);
            }
            matchingTemplates = new Vector<WorkbenchTemplate>();
            unMappedCols = new HashMap();
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    List<?> list = session.getDataList("From WorkbenchTemplate");
                    for (Object obj : list) {
                        WorkbenchTemplate template = (WorkbenchTemplate)obj;
                        if (colInfo == null) {
                            template.forceLoad();
                            matchingTemplates.add(template);
                            continue;
                        }
                        if (colInfo.size() != template.getWorkbenchTemplateMappingItems().size()) continue;
                        boolean match = true;
                        Vector<WorkbenchTemplateMappingItem> items = new Vector<WorkbenchTemplateMappingItem>(template.getWorkbenchTemplateMappingItems());
                        Vector<ImportColumnInfo> mapped = new Vector<ImportColumnInfo>();
                        for (ImportColumnInfo col : colInfo) {
                            int idx = this.indexOfName(items, col.getColName());
                            if (idx != -1) {
                                mapped.add(col);
                                items.get(idx).setViewOrder(Short.valueOf(col.getColInx().toString()));
                                items.get(idx).setOrigImportColumnIndex(Short.valueOf(col.getColInx().toString()));
                                continue;
                            }
                            match = false;
                            break;
                        }
                        if (!match) continue;
                        Vector<WorkbenchTemplateMappingItem> unmapped = new Vector<WorkbenchTemplateMappingItem>();
                        for (WorkbenchTemplateMappingItem item : items) {
                            if (this.indexOfName(mapped, item.getImportedColName()) != -1) continue;
                            unmapped.add(item);
                        }
                        if (unmapped.size() == 0) {
                            matchingTemplates.insertElementAt(template, 0);
                        } else {
                            matchingTemplates.add(template);
                        }
                        unMappedCols.put(template, unmapped);
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    log.error((Object)ex);
                    ex.printStackTrace();
                    session.close();
                    break block20;
                }
            }
            catch (Throwable throwable) {
                session.close();
                throw throwable;
            }
            session.close();
        }
        Vector<Comparable<Boolean>> result = new Vector<Comparable<Boolean>>();
        if (matchingTemplates.size() > 0) {
            SelectNewOrExistingDlg dlg = new SelectNewOrExistingDlg((Frame)UIRegistry.get("frame"), "WB_CHOOSE_DATASET_REUSE_TITLE", "WB_CREATE_NEW_MAPPING", "WB_USE_EXISTING_MAPPING", helpContext, matchingTemplates);
            UIHelper.centerAndShow(dlg);
            if (dlg.getBtnPressed() == 1) {
                if (!dlg.isCreateNew()) {
                    selection = (WorkbenchTemplate)dlg.getSelectedObject();
                    Vector unmapped = (Vector)unMappedCols.get(selection);
                    if (unmapped != null && unmapped.size() > 0) {
                        String msg;
                        StringBuilder flds = new StringBuilder();
                        for (Object info : unmapped) {
                            if (flds.length() != 0) {
                                flds.append(", ");
                            }
                            flds.append(info.toString());
                        }
                        String string = msg = unmapped.get(0) instanceof ImportColumnInfo ? String.format(UIRegistry.getResourceString("WB_UNMAPPED_NOT_IMPORTED"), flds.toString()) : String.format(UIRegistry.getResourceString("WB_UNUSED_NOT_INCLUDED"), flds.toString());
                        if (!UIRegistry.displayConfirm(UIRegistry.getResourceString("WB_INCOMPLETE_MAP_TITLE"), msg, UIRegistry.getResourceString("YES"), UIRegistry.getResourceString("NO"), 2)) {
                            result.add(Boolean.valueOf(true));
                            return result;
                        }
                    }
                    result.add(Boolean.valueOf(true));
                    result.add(selection);
                    result.add((Comparable<Boolean>)unMappedCols.get(selection));
                    return result;
                }
                result.add(Boolean.valueOf(true));
                return result;
            }
            result.add(Boolean.valueOf(false));
            return result;
        }
        result.add(Boolean.valueOf(true));
        return result;
    }

    protected boolean loadTemplateFromData(WorkbenchTemplate template) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            session.attach(template);
            for (Workbench wb : template.getWorkbenches()) {
                wb.getName();
                template.getWorkbenchTemplateMappingItems().size();
            }
            return true;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return false;
    }

    public static boolean getExportInfo(Properties props, String defaultFileName) {
        String fileName;
        String extension = "";
        for (ExportFileConfigurationFactory.ExportableType type : ExportFileConfigurationFactory.getExportList()) {
            if (type.getMimeType() != ExportFileConfigurationFactory.XLS_MIME_TYPE) continue;
            props.setProperty("mimetype", type.getMimeType());
            extension = type.getExtension();
            break;
        }
        JFileChooser chooser = new JFileChooser(WorkbenchTask.getDefaultDirPath(EXPORT_FILE_PATH));
        chooser.setDialogTitle(UIRegistry.getResourceString("CHOOSE_WORKBENCH_EXPORT_FILE"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new UIFileFilter("xls", UIRegistry.getResourceString("WB_EXCELFILES")));
        if (defaultFileName != null) {
            chooser.setSelectedFile(new File(String.valueOf(chooser.getCurrentDirectory().getPath()) + File.separator + defaultFileName + ".xls"));
        }
        if (chooser.showSaveDialog(UIRegistry.get("frame")) != 0) {
            UIRegistry.getStatusBar().setText("");
            return false;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("WB_EXPORT_NOFILENAME"));
            return false;
        }
        String path = chooser.getCurrentDirectory().getPath();
        if (StringUtils.isNotEmpty((String)path)) {
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            localPrefs.put(EXPORT_FILE_PATH, path);
        }
        if (StringUtils.isEmpty((String)FilenameUtils.getExtension((String)(fileName = file.getName())))) {
            fileName = String.valueOf(fileName) + (fileName.endsWith(".") ? "" : ".") + extension;
        }
        if (StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        if (file.exists()) {
            PanelBuilder builder = new PanelBuilder(new FormLayout("p:g", "c:p:g"));
            CellConstraints cc = new CellConstraints();
            String msg = String.format("<html><p>%s<br><br>%s<br></p></html>", UIRegistry.getResourceString("WB_FILE_EXISTS"), UIRegistry.getResourceString("WB_OK_TO_OVERWRITE"));
            builder.add((Component)UIHelper.createLabel(msg), cc.xy(1, 1));
            builder.setDefaultDialogBorder();
            CustomDialog confirmer = new CustomDialog((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString("WB_FILE_EXISTS_TITLE"), true, 3, builder.getPanel(), 2);
            UIHelper.centerAndShow(confirmer);
            confirmer.dispose();
            if (confirmer.isCancelled()) {
                return false;
            }
        }
        props.setProperty("fileName", String.valueOf(path) + File.separator + fileName);
        return true;
    }

    protected void exportWorkbench(CommandAction cmdAction) {
        CommandAction subCmd;
        Workbench workbench = null;
        Object data = cmdAction.getData();
        if (data instanceof CommandAction && (subCmd = (CommandAction)data) != cmdAction && subCmd.getTableId() == cmdAction.getTableId()) {
            workbench = WorkbenchTask.selectWorkbench(subCmd, "WorkbenchExportDataSet");
        }
        if (workbench == null) {
            workbench = WorkbenchTask.selectWorkbench(cmdAction, "WorkbenchExportDataSet");
        }
        if (workbench != null) {
            CommandAction command = new CommandAction("Plugins", "ExportList");
            command.setProperty("tool", ExportToFile.class);
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                session.attach(workbench);
                workbench.forceLoad();
                Vector<WorkbenchRow> rowData = workbench.getWorkbenchRowsAsList();
                Vector<Comparable<WorkbenchTemplate>> exportData = new Vector<Comparable<WorkbenchTemplate>>(rowData.size() + 1);
                exportData.add(workbench.getWorkbenchTemplate());
                exportData.addAll(rowData);
                command.setData(exportData);
                Properties props = new Properties();
                if (!WorkbenchTask.getExportInfo(props, workbench.getName())) {
                    return;
                }
                try {
                    session.close();
                    session = null;
                    workbench.forceLoad();
                    WorkbenchTask.sendExportCommand(props, workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems(), command);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    log.error((Object)ex);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    protected void exportWorkbenchTemplate(CommandAction cmdAction) {
        CommandAction subCmd;
        WorkbenchTemplate workbenchTemplate = null;
        Object data = cmdAction.getData();
        if (data instanceof CommandAction && (subCmd = (CommandAction)data) != cmdAction) {
            if (subCmd.getTableId() == cmdAction.getTableId()) {
                workbenchTemplate = this.selectWorkbenchTemplate(subCmd, "WB_EXPORT_TEMPLATE", null, "WorkbenchExportExcelTemplate");
            } else {
                return;
            }
        }
        if (workbenchTemplate == null) {
            workbenchTemplate = this.selectWorkbenchTemplate(cmdAction, "WB_EXPORT_TEMPLATE", null, "WorkbenchExportExcelTemplate");
        }
        if (workbenchTemplate != null) {
            CommandAction command = new CommandAction("Plugins", "ExportList");
            command.setProperty("tool", ExportToFile.class);
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                session.attach(workbenchTemplate);
                workbenchTemplate.checkMappings(WorkbenchTask.getDatabaseSchema());
                Vector<WorkbenchTemplate> newDataRow = new Vector<WorkbenchTemplate>(1);
                newDataRow.add(workbenchTemplate);
                command.setData(newDataRow);
                Properties props = new Properties();
                if (!WorkbenchTask.getExportInfo(props, null)) {
                    return;
                }
                try {
                    session.close();
                    session = null;
                    WorkbenchTask.sendExportCommand(props, workbenchTemplate.getWorkbenchTemplateMappingItems(), command);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    log.error((Object)ex);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    protected void createWorkbenchFromTemplate(CommandAction cmdAction) {
        Workbench wb = WorkbenchTask.selectWorkbench(cmdAction, "WB_CHOOSE_DATASET_REUSE_TITLE", null, "WorkbenchEditMapping", false);
        if (wb != null) {
            WorkbenchTemplate workbenchTemplate = wb.getWorkbenchTemplate();
            if (workbenchTemplate == null) {
                workbenchTemplate = this.selectWorkbenchTemplate(cmdAction, "WB_CHOOSE_DATASET_REUSE_TITLE", null, "WorkbenchEditMapping");
            }
            if (workbenchTemplate != null) {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    try {
                        Workbench workbench;
                        workbenchTemplate = this.cloneWorkbenchTemplate(workbenchTemplate);
                        if (workbenchTemplate != null && (workbench = this.createNewWorkbenchDataObj(null, workbenchTemplate)) != null) {
                            workbench.setWorkbenchTemplate(workbenchTemplate);
                            workbenchTemplate.addWorkbenches(workbench);
                            this.fillandSaveWorkbench(null, workbench);
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                        log.error((Object)ex);
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
    }

    public static void sendExportCommand(Properties props, Set<WorkbenchTemplateMappingItem> items, CommandAction cmdAction) {
        ConfigureExternalDataIFace config = ExportFileConfigurationFactory.getConfiguration(props);
        config.setFirstRowHasHeaders(true);
        Vector<WorkbenchTemplateMappingItem> colHeads = new Vector<WorkbenchTemplateMappingItem>(items);
        Collections.sort(colHeads);
        String[] heads = new String[colHeads.size()];
        int h = 0;
        while (h < colHeads.size()) {
            heads[h] = colHeads.get(h).getCaption();
            ++h;
        }
        config.setHeaders(heads);
        cmdAction.addProperties(config.getProperties());
        CommandDispatcher.dispatch(cmdAction);
    }

    protected Workbench createNewWorkbenchFromFile() {
        File currDir;
        File file = null;
        JFileChooser chooser = new JFileChooser(WorkbenchTask.getDefaultDirPath(IMPORT_FILE_PATH));
        chooser.setDialogTitle(UIRegistry.getResourceString("CHOOSE_WORKBENCH_IMPORT_FILE"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        String[] exts = new String[]{"xls", "csv"};
        chooser.setFileFilter(new UIFileFilter(exts, UIRegistry.getResourceString("WB_EXCELANDCSVFILES")));
        String currDirPath = AppPreferences.getLocalPrefs().get(IMPORT_FILE_PATH, null);
        if (currDirPath != null && (currDir = new File(currDirPath)).isDirectory() && currDir.exists()) {
            chooser.setCurrentDirectory(currDir);
        }
        if (chooser.showOpenDialog(UIRegistry.get("frame")) != 0) {
            UIRegistry.getStatusBar().setText("");
            return null;
        }
        file = chooser.getSelectedFile();
        if (file.exists()) {
            ImportDataFileInfo dataFileInfo;
            if (StringUtils.isNotEmpty((String)file.getPath())) {
                AppPreferences localPrefs = AppPreferences.getLocalPrefs();
                localPrefs.put(IMPORT_FILE_PATH, file.getParent());
            }
            if ((dataFileInfo = new ImportDataFileInfo()).load(file)) {
                Workbench workbench = this.createNewWorkbench(dataFileInfo, file);
                return workbench;
            }
            if (dataFileInfo.getConfig() == null || dataFileInfo.getConfig().getStatus() != ConfigureExternalDataIFace.Status.Cancel) {
                JStatusBar statusBar = UIRegistry.getStatusBar();
                statusBar.setErrorMessage(String.format(UIRegistry.getResourceString("WB_PARSE_FILE_ERROR"), file.getName()));
            }
        }
        return null;
    }

    protected Workbench createNewWorkbench(ImportDataFileInfo dataFileInfo, File inputFile) {
        Workbench workbench;
        WorkbenchTemplate workbenchTemplate;
        String wbName = inputFile != null ? FilenameUtils.getBaseName((String)inputFile.getName()) : null;
        List<?> selection = this.selectExistingTemplate(inputFile != null ? dataFileInfo.getColInfo() : null, inputFile != null ? "WorkbenchImportData" : "WorkbenchNewDataSet");
        if (selection.size() == 0 || !((Boolean)selection.get(0)).booleanValue()) {
            return null;
        }
        WorkbenchTemplate workbenchTemplate2 = workbenchTemplate = selection.size() > 1 ? (WorkbenchTemplate)selection.get(1) : null;
        if (workbenchTemplate == null) {
            TemplateEditor dlg = null;
            try {
                dlg = this.showColumnMapperDlg(dataFileInfo, null, "WB_MAPPING_EDITOR");
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                log.error((Object)ex);
            }
            if (dlg != null && !dlg.isCancelled()) {
                workbenchTemplate = this.createTemplate(dlg, inputFile != null ? inputFile.getAbsolutePath() : "");
            }
            if (dlg != null) {
                dlg.dispose();
            }
        } else {
            try {
                workbenchTemplate = (WorkbenchTemplate)workbenchTemplate.clone();
            }
            catch (CloneNotSupportedException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                log.error((Object)ex);
                workbenchTemplate = null;
            }
        }
        if (workbenchTemplate != null && (workbench = this.createNewWorkbenchDataObj(wbName, workbenchTemplate)) != null) {
            workbench.setWorkbenchTemplate(workbenchTemplate);
            workbenchTemplate.addWorkbenches(workbench);
            this.fillandSaveWorkbench(dataFileInfo, workbench);
            return workbench;
        }
        return null;
    }

    protected Workbench createNewWorkbenchDataObj(String wbName, WorkbenchTemplate workbenchTemplate) {
        Workbench workbench = new Workbench();
        workbench.initialize();
        workbench.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
        if (StringUtils.isNotEmpty((String)wbName)) {
            workbench.setName(wbName);
        }
        if (workbenchTemplate != null) {
            workbenchTemplate.setSpecifyUser(workbench.getSpecifyUser());
            workbench.setWorkbenchTemplate(workbenchTemplate);
            workbenchTemplate.getWorkbenches().add(workbench);
            if (this.fillInWorkbenchNameAndAttrs(workbench, wbName, false)) {
                workbenchTemplate.setName(workbench.getName());
                return workbench;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean fillInWorkbenchNameAndAttrs(Workbench workbench, String wbName, boolean skipFirstCheck) {
        block11: {
            skip = skipFirstCheck;
            session = DataProviderFactory.getInstance().createSession();
            try {
                newWorkbenchName = wbName;
                alwaysAsk = true;
                foundWB = null;
                shouldCheck = false;
                canEdit = this.isPermitted();
                while (true) {
                    if (StringUtils.isEmpty((String)newWorkbenchName)) {
                        alwaysAsk = true;
                    } else {
                        foundWB = session.getData(Workbench.class, "name", newWorkbenchName, DataProviderSessionIFace.CompareType.Equals);
                        if (foundWB != null && !skip) {
                            UIRegistry.getStatusBar().setErrorMessage(String.format(UIRegistry.getResourceString("WB_DATASET_EXISTS"), new Object[]{newWorkbenchName}));
                            workbench.setName("");
                        }
                        skip = false;
                    }
                    oldName = workbench.getName();
                    if (foundWB == null && (!StringUtils.isNotEmpty((String)newWorkbenchName) || newWorkbenchName.length() <= 64) && !alwaysAsk) continue;
                    alwaysAsk = false;
                    if (WorkbenchTask.askUserForInfo("Workbench", UIRegistry.getResourceString("WB_DATASET_INFO"), workbench, canEdit) && canEdit) {
                        newWorkbenchName = workbench.getName();
                        if (StringUtils.isNotEmpty((String)newWorkbenchName) && newWorkbenchName.length() > 64) {
                            UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("WB_NAME_TOO_LONG"));
                        }
                        foundWB = workbench;
                        continue;
                    }
                    UIRegistry.getStatusBar().setText("");
                    session.close();
                    return false;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                WorkbenchTask.log.error((Object)ex);
                session.close();
                break block11;
            }
            catch (Throwable var12_13) {
                session.close();
                throw var12_13;
            }
            {
                if (shouldCheck = oldName == null || oldName.equals(newWorkbenchName) == false) ** continue;
            }
            session.close();
        }
        UIRegistry.getStatusBar().setText("");
        return true;
    }

    protected boolean loadRsIntoWb(RecordSetIFace rs, Workbench wb) {
        boolean result = false;
        DBTableInfo tbl = DBTableIdMgr.getInstance().getInfoById(rs.getDbTableId());
        wb.setExportedFromTableName(tbl.getClassName());
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        Class<?> cls = rs.getDataClassFormItems();
        try {
            try {
                try {
                    WorkbenchValidator wbv = new WorkbenchValidator(wb);
                    for (RecordSetItemIFace item : rs.getItems()) {
                        DataModelObjBase obj = (DataModelObjBase)session.get(cls, item.getRecordId());
                        if (obj == null) continue;
                        obj.forceLoad();
                        wbv.getUploader().loadRecordToWb(obj, wb);
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof WorkbenchValidator.WorkbenchValidatorException || ex instanceof UploaderException) {
                        WorkbenchValidator.WorkbenchValidatorException wvEx = null;
                        if (ex instanceof WorkbenchValidator.WorkbenchValidatorException) {
                            wvEx = (WorkbenchValidator.WorkbenchValidatorException)ex;
                        } else if (ex.getCause() instanceof WorkbenchValidator.WorkbenchValidatorException) {
                            wvEx = (WorkbenchValidator.WorkbenchValidatorException)ex.getCause();
                        }
                        if (wvEx != null && wvEx.getStructureErrors().size() > 0) {
                            Uploader.showStructureErrors(wvEx.getStructureErrors());
                        }
                    } else {
                        throw ex;
                    }
                    UIRegistry.showLocalizedError("WorkbenchPaneSS.UnableToAutoValidate");
                }
                result = true;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                ex.printStackTrace();
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
        return result;
    }

    protected void fillandSaveWorkbench(final Object contents, final Workbench workbench) {
        if (workbench != null) {
            String msg = contents instanceof ImportDataFileInfo ? String.format(UIRegistry.getResourceString("WB_IMPORTING_DATASET"), workbench.getName()) : String.format(UIRegistry.getResourceString("WB_LOADING_RS_TO_DB"), workbench.getName());
            UIRegistry.writeGlassPaneMsg(msg, 20);
            edu.ku.brc.helpers.SwingWorker worker = new edu.ku.brc.helpers.SwingWorker(){

                @Override
                public Object construct() {
                    if (contents == null) {
                        workbench.addRow();
                    } else if (contents instanceof ImportDataFileInfo ? ((ImportDataFileInfo)contents).loadData(workbench) == DataImportIFace.Status.Error : contents instanceof RecordSetIFace && !WorkbenchTask.this.loadRsIntoWb((RecordSetIFace)contents, workbench)) {
                        return null;
                    }
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    try {
                        try {
                            session.beginTransaction();
                            session.save(workbench);
                            session.commit();
                            session.flush();
                            WorkbenchTask.this.datasetNavBoxMgr.addWorkbench(workbench);
                            WorkbenchTask.this.updateNavBoxUI(null);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                            ex.printStackTrace();
                            UIRegistry.clearGlassPaneMsg();
                            session.close();
                        }
                    }
                    finally {
                        session.close();
                    }
                    return null;
                }

                @Override
                public void finished() {
                    UIRegistry.clearGlassPaneMsg();
                    WorkbenchTask.this.createEditorForWorkbench(workbench, null, false, true);
                }
            };
            worker.start();
        } else {
            UIRegistry.getStatusBar().setText("");
        }
    }

    protected String createWorkbenchName(Workbench workbench) {
        String srcPath = workbench.getSrcFilePath();
        if (StringUtils.isEmpty((String)srcPath)) {
            srcPath = workbench.getWorkbenchTemplate().getSrcFilePath();
        }
        if (StringUtils.isNotEmpty((String)srcPath)) {
            return new File(srcPath).getName();
        }
        return UIRegistry.getResourceString("WB_DATASET");
    }

    protected void createEditorForWorkbench(Workbench workbench, DataProviderSessionIFace session, boolean showImageView, boolean doInbackground) {
        if (workbench == null) {
            return;
        }
        final SimpleGlassPane glassPane = doInbackground ? UIRegistry.writeSimpleGlassPaneMsg(String.format(UIRegistry.getResourceString("WB_LOADING_DATASET"), workbench.getName()), 20) : null;
        WorkbenchEditorCreator wbec = new WorkbenchEditorCreator(workbench, session, showImageView, this, !this.isPermitted()){

            @Override
            public void progressUpdated(List<Integer> chunks) {
                if (glassPane != null) {
                    glassPane.setProgress(chunks.get(chunks.size() - 1));
                }
            }

            @Override
            public void completed(WorkbenchPaneSS workbenchPane) {
                if (workbenchPane != null) {
                    WorkbenchTask.this.addSubPaneToMgr(workbenchPane);
                    if (glassPane != null) {
                        UIRegistry.clearSimpleGlassPaneMsg();
                    }
                    if (workbenchPane != null && workbenchPane.isDoIncremental()) {
                        workbenchPane.validateAll(null);
                    }
                }
                if (glassPane != null) {
                    UIRegistry.clearSimpleGlassPaneMsg();
                }
            }
        };
        if (doInbackground) {
            wbec.runInBackground();
        } else {
            wbec.runInForeground();
        }
    }

    public void opening(WorkbenchPaneSS pane) {
        Workbench workbench = pane.getWorkbench();
        RolloverCommand roc = WorkbenchTask.getNavBtnById(this.workbenchNavBox, workbench.getWorkbenchId(), "workbench");
        if (roc != null) {
            roc.setEnabled(false);
        } else {
            log.error((Object)("Couldn't find RolloverCommand for WorkbenchId [" + workbench.getWorkbenchId() + "]"));
        }
        this.updateNavBoxUI(null);
    }

    public void closing(SubPaneIFace pane) {
        Workbench workbench;
        if (pane != null && (workbench = ((WorkbenchPaneSS)pane).getWorkbench()) != null) {
            RolloverCommand roc = WorkbenchTask.getNavBtnById(this.workbenchNavBox, workbench.getWorkbenchId(), "workbench");
            if (roc != null) {
                roc.setEnabled(true);
            } else {
                log.error((Object)("Couldn't find RolloverCommand for WorkbenchId [" + workbench.getWorkbenchId() + "]"));
            }
            this.updateNavBoxUI(null);
        }
    }

    protected WorkbenchTemplate cloneWorkbenchTemplate(WorkbenchTemplate workbenchTemplateArg) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            session.attach(workbenchTemplateArg);
            workbenchTemplateArg.forceLoad();
            WorkbenchTemplate workbenchTemplate = (WorkbenchTemplate)workbenchTemplateArg.clone();
            return workbenchTemplate;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
            ex.printStackTrace();
        }
        finally {
            try {
                session.close();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                log.error((Object)ex);
            }
        }
        return null;
    }

    protected void deleteWorkbench(RecordSetIFace recordSet) {
        final Workbench workbench = WorkbenchTask.loadWorkbench(recordSet);
        if (workbench == null) {
            return;
        }
        if (!UIRegistry.displayConfirm(UIRegistry.getResourceString("WB_DELET_DS_TITLE"), String.format(UIRegistry.getResourceString("WB_DELET_DS_MSG"), workbench.getName()), UIRegistry.getResourceString("Delete"), UIRegistry.getResourceString("CANCEL"), 3)) {
            return;
        }
        UIRegistry.writeSimpleGlassPaneMsg(String.format(UIRegistry.getResourceString("WB_DELETING_DATASET"), workbench.getName()), 20);
        WorkbenchTask thisTask = this;
        edu.ku.brc.helpers.SwingWorker worker = new edu.ku.brc.helpers.SwingWorker(){
            String backupName;

            @Override
            public Object construct() {
                block12: {
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    session.attach(workbench);
                    UIRegistry.getStatusBar().setProgressRange(workbench.getName(), 0, workbench.getWorkbenchRows().size() + 3);
                    UIRegistry.getStatusBar().setIndeterminate(workbench.getName(), false);
                    workbench.getWorkbenchTemplate().checkMappings(WorkbenchTask.getDatabaseSchema());
                    UIRegistry.getStatusBar().incrementValue(workbench.getName());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.getStatusBar().setText(String.format(UIRegistry.getResourceString("WB_PREPARING_DELETE"), workbench.getName()));
                        }
                    });
                    for (WorkbenchRow row : workbench.getWorkbenchRows()) {
                        row.forceLoad();
                        UIRegistry.getStatusBar().incrementValue(workbench.getName());
                    }
                    this.backupName = WorkbenchBackupMgr.backupWorkbench(workbench);
                    UIRegistry.getStatusBar().incrementValue(workbench.getName());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.getStatusBar().setText(String.format(UIRegistry.getResourceString("WB_DELETING"), workbench.getName()));
                        }
                    });
                    try {
                        try {
                            session.beginTransaction();
                            session.delete(workbench);
                            session.commit();
                            session.flush();
                            UIRegistry.getStatusBar().incrementValue(workbench.getName());
                            WorkbenchTask.this.datasetNavBoxMgr.removeWorkbench(workbench);
                            WorkbenchTask.this.updateNavBoxUI(null);
                            ((SGRTask)ContextMgr.getTaskByClass(SGRTask.class)).deleteResultsForWorkbench(workbench);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                            ex.printStackTrace();
                            try {
                                session.close();
                            }
                            catch (Exception ex2) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex2);
                                log.error((Object)ex2);
                            }
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            session.close();
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                            log.error((Object)ex);
                        }
                        throw throwable;
                    }
                    try {
                        session.close();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                        log.error((Object)ex);
                    }
                }
                log.info((Object)("Deleted a Workbench [" + workbench.getName() + "]"));
                return null;
            }

            @Override
            public void finished() {
                UIRegistry.clearSimpleGlassPaneMsg();
                if (StringUtils.isNotEmpty((String)this.backupName)) {
                    UIRegistry.getStatusBar().setText(String.format(UIRegistry.getResourceString("WB_DEL_BACKED_UP"), workbench.getName(), this.backupName));
                }
                AppPreferences.getLocalPrefs().remove("WB.AutoValidatePref." + workbench.getId());
                AppPreferences.getLocalPrefs().remove("WB.AutoMatchPref." + workbench.getId());
            }
        };
        worker.start();
    }

    public static boolean askUserForReportProps() {
        ViewBasedDisplayDialog editorDlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "Global", "ReportProperties", null, UIRegistry.getResourceString("WB_BASIC_LABEL_PROPERTIES"), UIRegistry.getResourceString("OK"), null, null, true, 8);
        editorDlg.preCreateUI();
        editorDlg.setData(AppPreferences.getLocalPrefs());
        editorDlg.getMultiView().preValidate();
        editorDlg.setModal(true);
        editorDlg.setHelpContext("WB_LABEL_PROPS");
        editorDlg.setVisible(true);
        if (!editorDlg.isCancelled()) {
            editorDlg.getMultiView().getDataFromUI();
        }
        editorDlg.dispose();
        return !editorDlg.isCancelled();
    }

    protected void doReport(CommandAction cmdAction) {
        Workbench workbench = WorkbenchTask.selectWorkbench(cmdAction, "WorkbenchReporting");
        if (workbench == null) {
            return;
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        session.attach(workbench);
        WorkbenchTemplate workbenchTemplate = workbench.getWorkbenchTemplate();
        Set<WorkbenchTemplateMappingItem> mappings = workbenchTemplate.getWorkbenchTemplateMappingItems();
        Vector<WorkbenchTemplateMappingItem> items = new Vector<WorkbenchTemplateMappingItem>();
        items.addAll(mappings);
        session.close();
        String actionStr = cmdAction.getPropertyAsString("action");
        if (StringUtils.isNotEmpty((String)actionStr) && !actionStr.equals("PrintWBItems")) {
            boolean isBasicLabel = actionStr.equals("PrintBasicLabel");
            boolean go = false;
            go = isBasicLabel ? WorkbenchTask.askUserForReportProps() : true;
            if (go) {
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.setDbTableId(Workbench.getClassTableId());
                rs.addItem(workbench.getWorkbenchId());
                session = DataProviderFactory.getInstance().createSession();
                session.attach(workbench);
                workbench.forceLoad();
                WorkbenchJRDataSource dataSrc = new WorkbenchJRDataSource(workbench, workbench.getWorkbenchRowsAsList(), !isBasicLabel);
                session.close();
                final CommandAction cmd = new CommandAction("Reports", "RPT.PrintReport", dataSrc);
                if (isBasicLabel) {
                    cmd.setProperty("title", "Labels");
                    cmd.setProperty("file", "basic_label.jrxml");
                    cmd.setProperty("skip-parameter-prompt", "true");
                    cmd.setProperty("params", "title=" + AppPreferences.getLocalPrefs().get("reportProperties.title", "") + ";subtitle=" + AppPreferences.getLocalPrefs().get("reportProperties.subTitle", "") + ";footer=" + AppPreferences.getLocalPrefs().get("reportProperties.footer", ""));
                    cmd.setProperty("icon", IconManager.getIcon("Labels16"));
                }
                cmd.setProperty("OriginatingTask", this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandDispatcher.dispatch(cmd);
                    }
                });
            }
            return;
        }
        WorkbenchTemplateMappingItem selectMappingItem = this.selectMappingItem(items);
        if (selectMappingItem != null) {
            RecordSet rs = new RecordSet();
            rs.initialize();
            rs.setDbTableId(Workbench.getClassTableId());
            rs.addItem(workbench.getWorkbenchId());
            final CommandAction cmd = new CommandAction("Reports", "RPT.PrintReport", rs);
            cmd.setProperty("title", selectMappingItem.getCaption());
            cmd.setProperty("file", "wb_items.jrxml");
            cmd.setProperty("params", "colnum=" + selectMappingItem.getWorkbenchTemplateMappingItemId() + ";" + "title=" + selectMappingItem.getCaption());
            cmd.setProperty("OriginatingTask", this);
            ImageIcon cmdIcon = (ImageIcon)cmdAction.getProperty("icon");
            if (cmdIcon != null) {
                cmd.getProperties().put("icon", cmdIcon);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommandDispatcher.dispatch(cmd);
                }
            });
        }
    }

    public static Workbench selectWorkbench(CommandAction cmdAction, String helpContext) {
        return WorkbenchTask.selectWorkbench(cmdAction, "WB_CHOOSE_DATASET", null, helpContext, false);
    }

    /*
     * Unable to fully structure code
     */
    public static Workbench selectWorkbench(CommandAction cmdAction, String titleKey, String labelKey, String helpContext, boolean showAll) {
        workbench = null;
        session = DataProviderFactory.getInstance().createSession();
        try {
            recordSet = (RecordSetIFace)cmdAction.getProperty("workbench");
            if (recordSet == null) {
                data = cmdAction.getData();
                if (data instanceof CommandAction) {
                    recordSet = (RecordSetIFace)((CommandAction)data).getProperty("workbench");
                } else if (data instanceof RecordSetIFace) {
                    recordSet = (RecordSetIFace)data;
                }
            }
            if (recordSet != null && recordSet.getDbTableId() != Workbench.getClassTableId()) {
                UIRegistry.getStatusBar().setText("");
                return null;
            }
            if (recordSet != null) ** GOTO lbl51
            list = session.getDataList("From Workbench where SpecifyUserID = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId());
            if (list.size() == 0) {
                UIRegistry.getStatusBar().setText("");
                return null;
            }
            if (list.size() == 1) {
                ((Workbench)list.get(0)).getWorkbenchTemplate().checkMappings(WorkbenchTask.getDatabaseSchema());
                var15_18 = (Workbench)list.get(0);
                return var15_18;
            }
            if (!showAll) {
                block26: for (SubPaneIFace sbi : SubPaneMgr.getInstance().getSubPanes()) {
                    if (!(sbi instanceof WorkbenchPaneSS)) continue;
                    wbp = (WorkbenchPaneSS)sbi;
                    for (Workbench wb : list) {
                        if (wb.getWorkbenchId().intValue() != wbp.getWorkbench().getWorkbenchId().intValue()) continue;
                        list.remove(wb);
                        continue block26;
                    }
                }
            }
            if (list.size() == 0) {
                WorkbenchTask.log.error((Object)"All workbenches are open.");
                return null;
            }
            Collections.sort(list);
            session.close();
            session = null;
            dlg = new ChooseFromListDlg<?>((Frame)UIRegistry.get("frame"), StringUtils.isNotEmpty((String)titleKey) != false ? UIRegistry.getResourceString(titleKey) : null, StringUtils.isNotEmpty((String)labelKey) != false ? UIRegistry.getResourceString(labelKey) : null, 7, list, helpContext);
            dlg.setModal(true);
            UIHelper.centerAndShow(dlg);
            if (!dlg.isCancelled()) {
                session = DataProviderFactory.getInstance().createSession();
                workbench = (Workbench)dlg.getSelectedObject();
                session.attach(workbench);
                workbench.getWorkbenchTemplate().forceLoad();
            } else {
                UIRegistry.getStatusBar().setText("");
                return null;
lbl51:
                // 1 sources

                try {
                    workbench = session.get(Workbench.class, recordSet.getOrderedItems().iterator().next().getRecordId());
                    workbench.getWorkbenchTemplate().forceLoad();
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    WorkbenchTask.log.error((Object)ex);
                }
            }
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    WorkbenchTask.log.error((Object)ex);
                }
            }
        }
        return workbench;
    }

    protected WorkbenchTemplate selectWorkbenchTemplate(CommandAction cmdAction, String titleKey, String labelKey, String helpContext) {
        Workbench workbench = WorkbenchTask.selectWorkbench(cmdAction, titleKey, labelKey, helpContext, true);
        if (workbench != null) {
            return workbench.getWorkbenchTemplate();
        }
        return null;
    }

    protected WorkbenchTemplateMappingItem selectMappingItem(Vector<WorkbenchTemplateMappingItem> items) {
        Collections.sort(items);
        ToggleButtonChooserDlg<WorkbenchTemplateMappingItem> dlg = new ToggleButtonChooserDlg<WorkbenchTemplateMappingItem>((Frame)UIRegistry.get("frame"), "WB_SELECT_FIELD_TITLE", "WB_SELECT_FIELD", items, 7, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setHelpContext("WorkbenchReporting");
        dlg.setModal(true);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        return dlg.isCancelled() ? null : dlg.getSelectedObject();
    }

    protected void doChart(CommandAction cmdAction, boolean doBarChart) {
        Workbench workbench = WorkbenchTask.selectWorkbench(cmdAction, "WorkbenchChart");
        if (workbench == null) {
            return;
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        session.attach(workbench);
        WorkbenchTemplate workbenchTemplate = workbench.getWorkbenchTemplate();
        Set<WorkbenchTemplateMappingItem> mappings = workbenchTemplate.getWorkbenchTemplateMappingItems();
        Vector<WorkbenchTemplateMappingItem> items = new Vector<WorkbenchTemplateMappingItem>();
        items.addAll(mappings);
        session.close();
        WorkbenchTemplateMappingItem selectMappingItem = this.selectMappingItem(items);
        if (selectMappingItem != null) {
            final Vector<Object> data = new Vector<Object>();
            try {
                String sql = "SELECT CellData as Name, count(CellData) as Cnt FROM workbenchdataitem di inner join workbenchrow rw on di.WorkbenchRowId = rw.WorkbenchRowId where rw.WorkBenchId = " + workbench.getWorkbenchId() + " and WorkbenchTemplateMappingItemId = " + selectMappingItem.getWorkbenchTemplateMappingItemId() + " group by CellData order by Cnt desc, Name asc";
                Connection conn = DBConnection.getInstance().createConnection();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                int count = 0;
                while (rs.next() && (doBarChart || count < 10)) {
                    data.add(rs.getString(1));
                    data.add(rs.getInt(2));
                    ++count;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                log.error((Object)ex);
            }
            QueryResultsHandlerIFace qrhi = new QueryResultsHandlerIFace(){

                @Override
                public void init(QueryResultsListener listener, List<QueryResultsContainerIFace> list) {
                }

                @Override
                public void init(QueryResultsListener listener, QueryResultsContainerIFace qrc) {
                }

                @Override
                public void startUp() {
                }

                @Override
                public void cleanUp() {
                }

                @Override
                public List<Object> getDataObjects() {
                    return data;
                }

                @Override
                public boolean isPairs() {
                    return true;
                }
            };
            String chartTitle = String.format(UIRegistry.getResourceString("WB_CHART_TITLE"), selectMappingItem.getCaption());
            ChartPane chart = doBarChart ? new BarChartPane(chartTitle, this) : new PieChartPane(chartTitle, this);
            chart.setTitle(chartTitle);
            chart.setHandler(qrhi);
            chart.allResultsBack(null);
            this.addSubPaneToMgr(chart);
        }
    }

    protected void updateNavBoxUI(Integer wbCount) {
        Integer count = wbCount;
        if (count == null) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            count = session.getDataCount(Workbench.class, "specifyUser", AppContextMgr.getInstance().getClassObject(SpecifyUser.class), DataProviderSessionIFace.CompareType.Equals);
            session.close();
        }
        boolean enabled = count != null && count > 0 && !this.areAllOpen();
        for (NavBoxItemIFace nbi : this.enableNavBoxList) {
            nbi.setEnabled(enabled);
        }
    }

    protected boolean areAllOpen() {
        for (NavBoxItemIFace nbi : this.workbenchNavBox.getItems()) {
            if (!((RolloverCommand)((Object)nbi)).isEnabled()) continue;
            return false;
        }
        return true;
    }

    protected void editTemplate(WorkbenchTemplate wbTemplate) {
        this.loadTemplateFromData(wbTemplate);
        TemplateEditor dlg = null;
        wbTemplate.checkMappings(WorkbenchTask.getDatabaseSchema());
        try {
            dlg = this.showColumnMapperDlg(null, wbTemplate, "WB_MAPPING_EDITOR");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
            log.error((Object)ex);
        }
        if (dlg != null && !dlg.isCancelled()) {
            this.updateGeoRefInfoAfterTemplateEdit(wbTemplate, dlg.getDeletedItems(), dlg.updateAndGetNewItems());
        }
        if (dlg != null) {
            dlg.dispose();
        }
    }

    protected void updateGeoRefInfoAfterTemplateEdit(final WorkbenchTemplate wbTemplate, final Collection<WorkbenchTemplateMappingItem> deletedItems, final Collection<WorkbenchTemplateMappingItem> newItems) {
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getResourceString("WB_SAVING_TEMPLATE_CHANGES"), 20);
        SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    try {
                        for (WorkbenchTemplateMappingItem item : newItems) {
                            log.error((Object)item.getFieldName());
                        }
                        session.beginTransaction();
                        WorkbenchTemplate workbenchTemplate = session.merge(wbTemplate);
                        Set<WorkbenchTemplateMappingItem> items = workbenchTemplate.getWorkbenchTemplateMappingItems();
                        block12: for (WorkbenchTemplateMappingItem delItem : deletedItems) {
                            for (WorkbenchTemplateMappingItem wbtmi : items) {
                                if (delItem.getWorkbenchTemplateMappingItemId().longValue() != wbtmi.getWorkbenchTemplateMappingItemId().longValue()) continue;
                                items.remove(wbtmi);
                                wbtmi.setWorkbenchTemplate(null);
                                if (wbtmi.getWorkbenchDataItems() != null) {
                                    for (WorkbenchDataItem wbdi : wbtmi.getWorkbenchDataItems()) {
                                        wbdi.getWorkbenchRow().getWorkbenchDataItems().remove(wbdi);
                                        wbdi.setWorkbenchRow(null);
                                        session.delete(wbdi);
                                        wbdi.setWorkbenchTemplateMappingItem(null);
                                    }
                                    wbtmi.getWorkbenchDataItems().clear();
                                }
                                session.delete(wbtmi);
                                continue block12;
                            }
                        }
                        for (WorkbenchTemplateMappingItem wbtmi : newItems) {
                            wbtmi.setWorkbenchTemplate(workbenchTemplate);
                            items.add(wbtmi);
                            session.saveOrUpdate(wbtmi);
                        }
                        WorkbenchTemplateMappingItem aGeoRefMapping = null;
                        for (WorkbenchTemplateMappingItem wbtmi : workbenchTemplate.getWorkbenchTemplateMappingItems()) {
                            if (aGeoRefMapping != null || !wbtmi.getTableName().equals("locality") || !wbtmi.getFieldName().equalsIgnoreCase("latitude1") && !wbtmi.getFieldName().equalsIgnoreCase("latitude2") && !wbtmi.getFieldName().equalsIgnoreCase("longitude1") && !wbtmi.getFieldName().equalsIgnoreCase("longitude2")) continue;
                            aGeoRefMapping = wbtmi;
                            break;
                        }
                        if (aGeoRefMapping != null) {
                            for (Workbench wb : workbenchTemplate.getWorkbenches()) {
                                wb.forceLoad();
                                int rowCount = wb.getWorkbenchRows().size();
                                int count = 0;
                                for (WorkbenchRow wbRow : wb.getWorkbenchRows()) {
                                    wbRow.updateGeoRefTextFldsIfNecessary(aGeoRefMapping);
                                    glassPane.setProgress((int)(100.0 * (double)count++ / (double)rowCount));
                                }
                            }
                        }
                        session.saveOrUpdate(workbenchTemplate);
                        for (Workbench wb : workbenchTemplate.getWorkbenches()) {
                            session.saveOrUpdate(wb);
                        }
                        session.commit();
                        session.flush();
                        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("WB_SAVED_MAPPINGS"));
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                        log.error((Object)ex);
                        ex.printStackTrace();
                        try {
                            session.close();
                        }
                        catch (Exception ex2) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex2);
                            log.error((Object)ex2);
                        }
                    }
                }
                finally {
                    try {
                        session.close();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                        log.error((Object)ex);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                UIRegistry.clearSimpleGlassPaneMsg();
            }
        };
        sw.execute();
    }

    public static String getDefaultDirPath(String prefKey) {
        String homeDir = System.getProperty("user.home");
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        String path = localPrefs.get(prefKey, homeDir);
        File pathDir = new File(path);
        if (pathDir.exists() && pathDir.isDirectory()) {
            return path;
        }
        return UIRegistry.getUserHomeDir();
    }

    public static boolean importImages(Workbench workbench, Vector<File> fileList, WorkbenchPaneSS pane, boolean isNew, boolean doOneImagePerRow) {
        boolean isOK;
        block23: {
            isOK = false;
            DataProviderSessionIFace session = null;
            try {
                try {
                    if (pane != null) {
                        pane.checkCurrentEditState();
                    }
                    if (isNew) {
                        session = DataProviderFactory.getInstance().createSession();
                        session.beginTransaction();
                    }
                    if (doOneImagePerRow) {
                        int i = 0;
                        while (i < fileList.size()) {
                            int inx;
                            File file = fileList.get(i);
                            WorkbenchRow row = workbench.addRow();
                            if (pane != null) {
                                pane.addRowToSpreadSheet();
                            }
                            if ((inx = row.addImage(file)) > -1 && i % 5 == 0) {
                                final String msg = String.valueOf(workbench.getName()) + " (" + i + " / " + fileList.size() + ")";
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        UIRegistry.writeGlassPaneMsg(String.format(UIRegistry.getResourceString("WB_LOADING_IMGS_DATASET"), msg), 20);
                                    }
                                });
                            }
                            ++i;
                        }
                    } else {
                        WorkbenchRow row = workbench.addRow();
                        if (pane != null) {
                            pane.addRowToSpreadSheet();
                        }
                        int i = 0;
                        while (i < fileList.size()) {
                            int inx = row.addImage(fileList.get(i));
                            if (inx > -1 && i % 5 == 0) {
                                final String msg = String.valueOf(workbench.getName()) + " (" + i + " / " + fileList.size() + ")";
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        UIRegistry.writeGlassPaneMsg(String.format(UIRegistry.getResourceString("WB_LOADING_IMGS_DATASET"), msg), 20);
                                    }
                                });
                            }
                            ++i;
                        }
                    }
                    if (session != null) {
                        session.saveOrUpdate(workbench);
                        session.commit();
                        session.flush();
                    }
                    isOK = true;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    log.error((Object)ex);
                    UIRegistry.clearGlassPaneMsg();
                    if (session == null) break block23;
                    try {
                        session.close();
                    }
                    catch (Exception ex2) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex2);
                        log.error((Object)ex2);
                        UIRegistry.clearGlassPaneMsg();
                    }
                }
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                        log.error((Object)ex);
                        UIRegistry.clearGlassPaneMsg();
                    }
                }
            }
        }
        return isOK;
    }

    protected boolean filterSelectedFileNames(File[] files, Vector<File> fileList, ImageFilter imageFilter) {
        if (files == null || files.length == 0) {
            return false;
        }
        Hashtable<String, Boolean> badFileExts = new Hashtable<String, Boolean>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String fileName = files[i].getName();
                if (imageFilter.isImageFile(fileName)) {
                    fileList.add(files[i]);
                } else {
                    badFileExts.put(FilenameUtils.getExtension((String)fileName), true);
                }
            }
            ++i;
        }
        if (badFileExts.size() > 0) {
            StringBuffer badExtStrBuf = new StringBuffer();
            for (String ext : badFileExts.keySet()) {
                if (badExtStrBuf.length() > 0) {
                    badExtStrBuf.append(", ");
                }
                badExtStrBuf.append(ext);
            }
            if (fileList.size() == 0) {
                JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("WB_WRONG_IMG_NO_IMAGES"), badExtStrBuf.toString()), UIRegistry.getResourceString("WARNING"), 0);
                return false;
            }
            Object[] options = new Object[]{UIRegistry.getResourceString("Continue"), UIRegistry.getResourceString("Stop")};
            if (JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("WB_WRONG_IMG_SOME_IMAGES"), badExtStrBuf.toString()), this.title, 0, 2, null, options, options[1]) == 1) {
                return false;
            }
        }
        return true;
    }

    protected boolean wbCanAcceptRecordSet(WorkbenchTemplate wbt, RecordSetIFace rs) {
        Integer wbTblId = this.getRootTblId(wbt);
        return wbTblId != null && wbTblId.equals(rs.getDbTableId());
    }

    protected Integer getRootTblId(WorkbenchTemplate wbt) {
        Vector<Integer> tbls = new Vector<Integer>();
        tbls.add(CollectionObject.getClassTableId());
        tbls.add(CollectingEvent.getClassTableId());
        tbls.add(Locality.getClassTableId());
        tbls.add(Geography.getClassTableId());
        tbls.add(Taxon.getClassTableId());
        tbls.add(Accession.getClassTableId());
        tbls.add(ReferenceWork.getClassTableId());
        tbls.add(Agent.getClassTableId());
        for (Integer tbl : tbls) {
            for (WorkbenchTemplateMappingItem mi : wbt.getWorkbenchTemplateMappingItems()) {
                if (!mi.getSrcTableId().equals(tbl) && (mi.getSrcTableId() != 4000 || tbl != Taxon.getClassTableId())) continue;
                return tbl;
            }
        }
        return null;
    }

    protected List<WorkbenchTemplate> getTemplatesForExport(RecordSetIFace rs) {
        Vector<WorkbenchTemplate> result = new Vector<WorkbenchTemplate>();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            for (WorkbenchTemplate wbt : session.getDataList(WorkbenchTemplate.class)) {
                wbt.forceLoad();
                if (!this.wbCanAcceptRecordSet(wbt, rs)) continue;
                result.add(wbt);
            }
        }
        finally {
            session.close();
        }
        Collections.sort(result, new Comparator<WorkbenchTemplate>(){

            @Override
            public int compare(WorkbenchTemplate arg0, WorkbenchTemplate arg1) {
                return arg0.getName().toLowerCase().compareTo(arg1.getName().toLowerCase());
            }
        });
        return result;
    }

    protected void exportRStoDS(CommandAction action) {
        Vector<Integer> tblIds = new Vector<Integer>();
        ChooseRecordSetDlg dlg = new ChooseRecordSetDlg(tblIds);
        dlg.setHelpContext("wb_recordset");
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            if (dlg.getSelectedRecordSet().getNumItems() > AppPreferences.getRemote().getInt("MAX_ROWS", MAX_ROWS)) {
                UIRegistry.showLocalizedError("WorkbenchTask.RecordSetTooLargeToExport", AppPreferences.getRemote().getInt("MAX_ROWS", MAX_ROWS));
                return;
            }
            List<WorkbenchTemplate> choices = this.getTemplatesForExport(dlg.getSelectedRecordSet());
            if (choices.size() > 0) {
                ChooseFromListDlg<WorkbenchTemplate> wbtdlg = new ChooseFromListDlg<WorkbenchTemplate>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WB_CHOOSE_EXPORT_WB_TITLE"), 7, choices);
                wbtdlg.setHelpContext("wb_recordset");
                wbtdlg.setVisible(true);
                if (!wbtdlg.isCancelled()) {
                    try {
                        Workbench workbench = this.createNewWorkbenchDataObj(null, (WorkbenchTemplate)wbtdlg.getSelectedObject().clone());
                        if (workbench != null) {
                            this.fillandSaveWorkbench(dlg.getSelectedRecordSet(), workbench);
                        }
                    }
                    catch (CloneNotSupportedException ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                        ex.printStackTrace();
                        log.error((Object)ex);
                    }
                }
            } else {
                UIRegistry.showLocalizedMsg("WB_UNABLE_TO_EXPORT_RS", "WB_NO_TEMPLATES_TO_EXPORT_RS_TO", DBTableIdMgr.getInstance().getInfoById(dlg.getSelectedRecordSet().getDbTableId()).getClassObj().getSimpleName());
            }
        }
    }

    public void importCardImages(Workbench workbench, boolean doOneImagePerRow) {
        boolean creatingNewWb;
        ImageFilter imageFilter = new ImageFilter();
        JFileChooser chooser = new JFileChooser(WorkbenchTask.getDefaultDirPath(IMAGES_FILE_PATH));
        chooser.setDialogTitle(UIRegistry.getResourceString("WB_CHOOSE_IMAGES"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(imageFilter);
        if (chooser.showOpenDialog(UIRegistry.get("frame")) != 0) {
            UIRegistry.getStatusBar().setText("");
            return;
        }
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.put(IMAGES_FILE_PATH, chooser.getCurrentDirectory().getAbsolutePath());
        Vector<File> fileList = new Vector<File>();
        if (!this.filterSelectedFileNames(chooser.getSelectedFiles(), fileList, imageFilter)) {
            return;
        }
        for (File f : fileList) {
            if (ImageFrame.testImageFile(f.getAbsolutePath())) continue;
            JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("WB_WRONG_IMAGE_TYPE_OR_CORRUPTED_IMAGE"), f.getAbsolutePath()), UIRegistry.getResourceString("WARNING"), 0);
            return;
        }
        boolean bl = creatingNewWb = workbench == null;
        if (creatingNewWb) {
            WorkbenchTemplate workbenchTemplate;
            List<?> selection = this.selectExistingTemplate(null, "WorkbenchImportImages");
            if (selection.size() == 0 || !((Boolean)selection.get(0)).booleanValue()) {
                return;
            }
            WorkbenchTemplate workbenchTemplate2 = workbenchTemplate = selection.size() > 1 ? (WorkbenchTemplate)selection.get(1) : null;
            if (workbenchTemplate == null) {
                TemplateEditor dlg = null;
                try {
                    dlg = this.showColumnMapperDlg(null, null, "WB_MAPPING_EDITOR");
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    log.error((Object)ex);
                }
                if (dlg != null && !dlg.isCancelled()) {
                    workbenchTemplate = this.createTemplate(dlg, null);
                }
                if (dlg != null) {
                    dlg.dispose();
                }
            } else {
                workbenchTemplate = this.cloneWorkbenchTemplate(workbenchTemplate);
            }
            if (workbenchTemplate != null) {
                workbench = this.createNewWorkbenchDataObj("", workbenchTemplate);
            }
        }
        if (workbench != null) {
            UIRegistry.writeGlassPaneMsg(String.format(UIRegistry.getResourceString("WB_LOADING_IMGS_DATASET"), workbench.getName()), 20);
            this.doImageImport(workbench, fileList, creatingNewWb, doOneImagePerRow);
        }
    }

    protected void doImageImport(final Workbench importWB, final Vector<File> fileList, final boolean isNew, final boolean doOneImagePerRow) {
        edu.ku.brc.helpers.SwingWorker worker = new edu.ku.brc.helpers.SwingWorker(){
            protected boolean isOK = false;
            protected WorkbenchPaneSS pane;
            {
                this.pane = !bl ? (WorkbenchPaneSS)SubPaneMgr.getInstance().getCurrentSubPane() : null;
            }

            @Override
            public Object construct() {
                this.isOK = WorkbenchTask.importImages(importWB, fileList, this.pane, isNew, doOneImagePerRow);
                return null;
            }

            @Override
            public void finished() {
                UIRegistry.clearGlassPaneMsg();
                if (this.isOK) {
                    if (isNew) {
                        WorkbenchTask.this.datasetNavBoxMgr.addWorkbench(importWB);
                        WorkbenchTask.getBoxByTitle(WorkbenchTask.this.workbenchNavBox, importWB.getName()).setEnabled(false);
                        try {
                            this.pane = new WorkbenchPaneSS(importWB.getName(), WorkbenchTask.this, importWB, false, !WorkbenchTask.this.isPermitted());
                            WorkbenchTask.this.addSubPaneToMgr(this.pane);
                            this.pane.setChanged(false);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                            log.error((Object)ex);
                            return;
                        }
                    } else {
                        this.pane.setChanged(true);
                    }
                    this.pane.newImagesAdded();
                }
            }
        };
        worker.start();
    }

    public static boolean showLoadStatus(WorkbenchRow row, boolean hasMoreFiles) {
        String key = "WB_ERROR_IMAGE_GENERIC";
        switch (row.getLoadStatus()) {
            case TooLarge: {
                key = "WB_ERROR_IMAGE_TOOLARGE";
                break;
            }
            case OutOfMemory: {
                key = "WB_ERROR_IMAGE_MEMORY";
                break;
            }
        }
        JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setErrorMessage(UIRegistry.getResourceString(key), row.getLoadException());
        if (hasMoreFiles) {
            return UIRegistry.displayConfirmLocalized("WB_ERROR_LOAD_IMAGE", key, UIRegistry.getResourceString("Continue"), "WB_STOP_LOADING", 0);
        }
        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString(key), UIRegistry.getResourceString("WB_ERROR_LOAD_IMAGE"), 0);
        return false;
    }

    public static Workbench loadWorkbench(RecordSetIFace recordSet) {
        if (recordSet != null) {
            return WorkbenchTask.loadWorkbench(recordSet.getOnlyItem().getRecordId(), null);
        }
        return null;
    }

    public static Workbench loadWorkbench(Integer workbenchId, DataProviderSessionIFace session) {
        DataProviderSessionIFace mySession = session != null ? session : DataProviderFactory.getInstance().createSession();
        try {
            if (workbenchId != null) {
                Workbench workbench = mySession.get(Workbench.class, workbenchId);
                if (workbench != null) {
                    workbench.getWorkbenchId();
                }
                Workbench workbench2 = workbench;
                return workbench2;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
            log.error((Object)ex);
        }
        finally {
            if (session == null) {
                mySession.close();
            }
        }
        return null;
    }

    protected WorkbenchTemplate loadWorkbenchTemplate(RecordSetIFace recordSet) {
        if (recordSet != null) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                WorkbenchTemplate workbenchTemplate = session.get(WorkbenchTemplate.class, recordSet.getOnlyItem().getRecordId());
                if (workbenchTemplate != null) {
                    workbenchTemplate.checkMappings(WorkbenchTask.getDatabaseSchema());
                }
                WorkbenchTemplate workbenchTemplate2 = workbenchTemplate;
                return workbenchTemplate2;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                log.error((Object)ex);
            }
            finally {
                session.close();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void workbenchSelected(CommandAction cmdAction) {
        Object cmdData = cmdAction.getData();
        if (cmdData != null && cmdData instanceof CommandAction && cmdData != cmdAction) {
            CommandAction subCmd = (CommandAction)cmdData;
            if (subCmd.getTableId() != Workbench.getClassTableId()) return;
            if (subCmd.isAction(cmdAction.getAction())) return;
            subCmd.setProperty("workbench", cmdAction.getProperty("workbench"));
            this.processWorkbenchCommands(subCmd);
            subCmd.getProperties().remove("workbench");
            return;
        } else if (cmdData instanceof RecordSetIFace) {
            Workbench workbench = WorkbenchTask.loadWorkbench((RecordSetIFace)cmdData);
            if (workbench != null) {
                this.createEditorForWorkbench(workbench, null, false, true);
                return;
            } else {
                log.error((Object)"Workbench was null!");
            }
            return;
        } else {
            Workbench workbench = WorkbenchTask.loadWorkbench((RecordSetIFace)cmdAction.getProperty("workbench"));
            if (workbench != null) {
                this.createEditorForWorkbench(workbench, null, false, true);
                return;
            } else {
                log.error((Object)"Workbench was null!");
            }
        }
    }

    public void uploadWorkbenches(final List<Integer> workbenchIds) {
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            protected RecordSet bldRS(Integer wbId) {
                RecordSet result = new RecordSet();
                result.initialize();
                result.addItem(wbId);
                return result;
            }

            protected WorkbenchPaneSS getWbSS(Workbench wb) {
                WorkbenchPaneSS wbSS = null;
                for (SubPaneIFace sb : SubPaneMgr.getInstance().getSubPanes()) {
                    Workbench pwb;
                    if (!(sb instanceof WorkbenchPaneSS) || (pwb = ((WorkbenchPaneSS)sb).getWorkbench()) != wb) continue;
                    wbSS = (WorkbenchPaneSS)sb;
                    break;
                }
                return wbSS;
            }

            @Override
            protected Object doInBackground() throws Exception {
                for (Integer wbId : workbenchIds) {
                    try {
                        RecordSet rs = this.bldRS(wbId);
                        final Workbench wb = WorkbenchTask.loadWorkbench(rs);
                        if (wb != null) {
                            System.out.println("loaded " + wb.getName());
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    WorkbenchTask.this.createEditorForWorkbench(wb, null, false, false);
                                }
                            });
                            final WorkbenchPaneSS wbSS = this.getWbSS(wb);
                            if (wbSS == null) continue;
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    wbSS.doDatasetUpload();
                                    System.out.println("opened uploader for " + wb.getName());
                                }
                            });
                            boolean validated = Uploader.getCurrentUpload().validateData(false);
                            if (validated) {
                                System.out.println("validated uploader for " + wb.getName());
                                Uploader.getCurrentUpload().uploadIt(false);
                                if (Uploader.getCurrentUpload().getCurrentOp() != "WB_UPLOAD_SUCCESS") {
                                    System.out.println("upload failed for " + wb.getName());
                                } else {
                                    System.out.println("uploaded " + wb.getName());
                                }
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Uploader.getCurrentUpload().closeMainForm(true);
                                    SubPaneMgr.getInstance().removePane(wbSS);
                                }
                            });
                            System.out.println("closed uploader for " + wb.getName());
                            continue;
                        }
                        System.out.println("No workbench with id = " + wbId);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        };
        worker.execute();
    }

    public static Class<?> getDataType(WorkbenchTemplateMappingItem wbtmi) {
        if (wbtmi.getSrcTableId() == null) {
            return String.class;
        }
        DBTableIdMgr schema = WorkbenchTask.getDatabaseSchema();
        DBTableInfo tableInfo = schema.getInfoById(wbtmi.getSrcTableId());
        if (tableInfo == null) {
            throw new RuntimeException("Cannot find TableInfo in DBTableIdMgr for ID=" + wbtmi.getSrcTableId());
        }
        for (DBFieldInfo fi : tableInfo.getFields()) {
            String type;
            if (!fi.getName().equals(wbtmi.getFieldName()) || !StringUtils.isNotEmpty((String)(type = fi.getType()))) continue;
            if (type.equals("calendar_date")) {
                return Calendar.class;
            }
            if (type.equals("text")) {
                return String.class;
            }
            if (type.equals("boolean")) {
                return Boolean.class;
            }
            if (type.equals("short")) {
                return Short.class;
            }
            if (type.equals("byte")) {
                return Byte.class;
            }
            try {
                return Class.forName(type);
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WorkbenchTask.class, e);
                log.error((Object)e);
            }
        }
        throw new RuntimeException("Could not find [" + wbtmi.getFieldName() + "]");
    }

    @Override
    public ImageIcon getIcon(int size) {
        IconManager.IconSize iSize = IconManager.IconSize.Std16;
        if (size != 16) {
            IconManager.IconSize[] iconSizeArray = IconManager.IconSize.values();
            int n = iconSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconManager.IconSize ic = iconSizeArray[n2];
                if (ic.size() == size) {
                    iSize = ic;
                    break;
                }
                ++n2;
            }
        }
        if (this.doingStarterPane) {
            this.doingStarterPane = false;
        }
        return IconManager.getIcon(WORKBENCH, iSize);
    }

    protected void processWorkbenchCommands(CommandAction cmdAction) {
        RecordSetIFace rs;
        boolean isClickedOn = true;
        UsageTracker.incrUsageCount("WB." + cmdAction.getAction());
        if (cmdAction.isAction(SELECTED_WORKBENCH)) {
            this.workbenchSelected(cmdAction);
        } else if (cmdAction.isAction(IMPORT_DATA_FILE)) {
            if (isClickedOn) {
                this.createNewWorkbenchFromFile();
            }
        } else if (cmdAction.isAction(EXPORT_DATA_FILE)) {
            this.exportWorkbench(cmdAction);
        } else if (cmdAction.isAction(EXPORT_TEMPLATE)) {
            this.exportWorkbenchTemplate(cmdAction);
        } else if (cmdAction.isAction(EXPORT_RS_TO_WB)) {
            this.exportRStoDS(cmdAction);
        } else if (cmdAction.isAction(WB_IMPORTCARDS)) {
            if (isClickedOn) {
                this.importCardImages(null, true);
            }
        } else if (cmdAction.isAction(NEW_WORKBENCH_FROM_TEMPLATE)) {
            this.createWorkbenchFromTemplate(cmdAction);
        } else if (cmdAction.isAction(NEW_WORKBENCH)) {
            if (isClickedOn) {
                this.createNewWorkbench(null, null);
            } else {
                this.createWorkbenchFromTemplate(cmdAction);
            }
        } else if (cmdAction.isAction(WB_BARCHART)) {
            this.doChart(cmdAction, true);
        } else if (cmdAction.isAction(WB_TOP10_REPORT)) {
            this.doChart(cmdAction, false);
        } else if (cmdAction.isAction(PRINT_REPORT)) {
            this.doReport(cmdAction);
        } else if (cmdAction.isAction("Delete") && cmdAction.getData() instanceof RecordSetIFace && (rs = (RecordSetIFace)cmdAction.getData()).getDbTableId() == Workbench.getClassTableId()) {
            this.deleteWorkbench(rs);
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        cmdAction.isAction("AppRestart");
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        AppPreferences appPrefs;
        super.doCommand(cmdAction);
        UIRegistry.getStatusBar().setText("");
        if (cmdAction.isType(WORKBENCH)) {
            this.processWorkbenchCommands(cmdAction);
        } else if (cmdAction.isType("Preferences") && (appPrefs = (AppPreferences)cmdAction.getData()) != null) {
            MAX_ROWS = appPrefs.getInt("MAX_ROWS", 2000);
        }
    }

    public boolean isPermitted() {
        return !AppContextMgr.isSecurityOn() || this.getPermissions().canView();
    }

    @Override
    protected boolean[][] getPermsArray() {
        return new boolean[][]{{true, true, true, true}, {true, true, true, true}, {true, true, true, true}, new boolean[4]};
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel("WorkbenchTask.PermTitle", "WorkbenchTask.PermEnable", "WorkbenchTask.PermUpload", null, null);
    }
}

