/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.google.common.base.Function;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchRowImage;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Window;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

abstract class WorkbenchEditorCreator {
    private static final Logger log = Logger.getLogger(WorkbenchEditorCreator.class);
    final Workbench workbench;
    final DataProviderSessionIFace session;
    final boolean showImageView;
    final BaseTask thisTask;
    private final boolean isReadOnly;
    private final SwingWorker<WorkbenchPaneSS, Integer> worker;

    public WorkbenchEditorCreator(Workbench workbench, DataProviderSessionIFace session, boolean showImageView, BaseTask thisTask, boolean isReadOnly) {
        this.workbench = workbench;
        this.session = session;
        this.showImageView = showImageView;
        this.thisTask = thisTask;
        this.isReadOnly = isReadOnly;
        this.worker = new SwingWorker<WorkbenchPaneSS, Integer>(){

            @Override
            public WorkbenchPaneSS doInBackground() {
                return WorkbenchEditorCreator.this.doIt((Function<Integer, Void>)((Function)new Function<Integer, Void>(){

                    public Void apply(Integer progress) {
                        this.publish(new Integer[]{progress});
                        return null;
                    }
                }));
            }

            @Override
            protected void process(List<Integer> chunks) {
                WorkbenchEditorCreator.this.progressUpdated(chunks);
            }

            @Override
            public void done() {
                WorkbenchPaneSS workbenchPane;
                try {
                    workbenchPane = (WorkbenchPaneSS)this.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                WorkbenchEditorCreator.this.completed(workbenchPane);
            }
        };
    }

    public void runInForeground() {
        this.completed(this.doIt(new Function<Integer, Void>(){

            public Void apply(Integer arg0) {
                return null;
            }
        }));
    }

    public void runInBackground() {
        this.worker.execute();
    }

    public abstract void completed(WorkbenchPaneSS var1);

    public abstract void progressUpdated(List<Integer> var1);

    private WorkbenchPaneSS doIt(Function<Integer, Void> updateProgress) {
        WorkbenchPaneSS workbenchPane;
        block18: {
            boolean usingExistingSession = this.session != null;
            DataProviderSessionIFace tmpSession = DataProviderFactory.getInstance().createSession();
            workbenchPane = null;
            try {
                try {
                    if (!usingExistingSession) {
                        tmpSession.attach(this.workbench);
                    }
                    int rowCount = this.workbench.getWorkbenchRows().size() + 1;
                    this.workbench.getWorkbenchTemplate().checkMappings(WorkbenchTask.getDatabaseSchema());
                    int count = 0;
                    for (WorkbenchRow row : this.workbench.getWorkbenchRows()) {
                        row.forceLoad();
                        updateProgress.apply((Object)((int)(100.0 * (double)(++count) / (double)rowCount)));
                    }
                    updateProgress.apply((Object)100);
                    boolean convertedAnImage = false;
                    Set<WorkbenchRow> rows = this.workbench.getWorkbenchRows();
                    if (rows != null) {
                        for (WorkbenchRow row : rows) {
                            Set<WorkbenchRowImage> rowImages = row.getWorkbenchRowImages();
                            if (rowImages == null) {
                                rowImages = new HashSet<WorkbenchRowImage>();
                                row.setWorkbenchRowImages(rowImages);
                            }
                            if (row.getCardImageFullPath() == null) continue;
                            WorkbenchRowImage rowImage = new WorkbenchRowImage();
                            rowImage.initialize();
                            rowImage.setCardImageFullPath(row.getCardImageFullPath());
                            rowImage.setImageOrder(0);
                            row.setCardImageData(null);
                            row.setCardImageFullPath(null);
                            rowImage.setWorkbenchRow(row);
                            rowImages.add(rowImage);
                            convertedAnImage = true;
                        }
                    }
                    workbenchPane = new WorkbenchPaneSS(this.workbench.getName(), this.thisTask, this.workbench, this.showImageView, this.isReadOnly);
                    if (convertedAnImage) {
                        Window topFrame = UIRegistry.getTopWindow();
                        String message = UIRegistry.getResourceString("WB_DATASET_IMAGE_CONVERSION_NOTIFICATION");
                        String msgTitle = UIRegistry.getResourceString("WB_DATASET_IMAGE_CONVERSION_NOTIFICATION_TITLE");
                        JOptionPane.showMessageDialog(topFrame, message, msgTitle, 1);
                        workbenchPane.setChanged(true);
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                    log.error((Object)ex);
                    ex.printStackTrace();
                    if (usingExistingSession || tmpSession == null) break block18;
                    try {
                        tmpSession.close();
                    }
                    catch (Exception ex2) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex2);
                        log.error((Object)ex2);
                    }
                }
            }
            finally {
                if (!usingExistingSession && tmpSession != null) {
                    try {
                        tmpSession.close();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(WorkbenchTask.class, ex);
                        log.error((Object)ex);
                    }
                }
            }
        }
        return workbenchPane;
    }
}

