/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.BackupServiceFactory;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.subpane.WebServiceSubPane;
import edu.ku.brc.specify.web.HttpLargeFileTransfer;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.commons.lang.StringUtils;

public class WebSearchTask
extends BaseTask {
    public static final String WEBSEARCH = "WebSearch";
    public static final String WS_BK_SEND = "WS_BK_SEND";
    public static final String WEBSRCH_MSG = "WEBSRCH_MSG";
    protected static final String WEBSEARCH_ICON = "Plugins";
    protected NavBox navBox = null;

    public WebSearchTask() {
        super(WEBSEARCH, UIRegistry.getResourceString(WEBSEARCH));
        CommandDispatcher.register(WEBSEARCH, this);
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
        }
    }

    @Override
    public SubPaneIFace getStarterPane() {
        if (this.starterPane != null) {
            return this.starterPane;
        }
        this.starterPane = new WebServiceSubPane(WEBSEARCH, this, false);
        return this.starterPane;
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        super.subPaneRemoved(subPane);
        if (this.starterPane != null && (this.starterPane == subPane || this.subPanes.size() == 0)) {
            this.starterPane.shutdown();
            this.starterPane = null;
            TaskMgr.reenableAllDisabledTasks();
            TaskMgr.getTask("Startup").requestContext();
        }
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    public void createAndSendBackup() {
        BackupServiceFactory.getInstance().doBackUp(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("Done")) {
                    WebSearchTask.this.startCompression((String)evt.getNewValue());
                }
            }
        });
    }

    private void startCompression(String fileName) {
        if (StringUtils.isNotEmpty((String)fileName)) {
            try {
                final File file = File.createTempFile("Bkup", ".gz");
                final HttpLargeFileTransfer httpFileTransfer = new HttpLargeFileTransfer();
                httpFileTransfer.compressFile(fileName, file.getAbsolutePath(), new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("Done")) {
                            WebSearchTask.this.startUpload(httpFileTransfer, false, file);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void startUpload(HttpLargeFileTransfer httpFileTransfer, boolean isSiteFile, File compressedFile) {
        httpFileTransfer.transferFile(compressedFile.getAbsolutePath(), "http://localhost:8080/uploader/UploaderServlet", isSiteFile, null);
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        String menuDesc = "Specify.SYSTEM_MENU";
        this.menuItems = new Vector();
        if (this.permissions == null || this.permissions.canModify()) {
            String menuTitle = "Web Search";
            String mneu = "PluginsTask.PLUGIN_MNEU";
            String desc = "PluginsTask.PLUGIN_DESC";
            JMenuItem mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    WebSearchTask.this.requestContext();
                }
            });
            MenuItemDesc rsMI = new MenuItemDesc(mi, menuDesc);
            rsMI.setPosition(MenuItemDesc.Position.Bottom);
            this.menuItems.add(rsMI);
        }
        return this.menuItems;
    }

    protected void processWebSearchCommands(CommandAction cmdAction) {
        UsageTracker.incrUsageCount("WS." + cmdAction.getType());
        if (cmdAction.isAction(WS_BK_SEND)) {
            this.createAndSendBackup();
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(WEBSEARCH)) {
            this.processWebSearchCommands(cmdAction);
        }
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArrayArray[2] = blArray;
        blArrayArray[3] = new boolean[4];
        return blArrayArray;
    }

    @Override
    public boolean isPermissionsSettable() {
        return false;
    }
}

