/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.SecurityOption;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxAction;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.CommandActionForDB;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.SpVisualQuery;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.InfoRequestTask;
import edu.ku.brc.specify.tasks.InteractionsTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.subpane.VisualQueryPanel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VisualQueryTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(VisualQueryTask.class);
    private static final String VISUALQUERY = "VisualQueryTask";
    private static final String VISQRY_MENU = "VISQRY_MENU";
    private static final String VISQRY_MNU = "VISQRY_MNU";
    private static final String VISQRY_TITLE = "VISQRY_TITLE";
    private static final String VISQRY_SECURITY = "VISQRYEDIT";
    protected NavBox actionNavBox = null;
    protected NavBox visQueryNavBox = null;
    protected NavBoxItemIFace openNavBtn = null;
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected ToolBarDropDownBtn toolBarBtn = null;

    public VisualQueryTask() {
        super(VISUALQUERY, UIRegistry.getResourceString(VISQRY_TITLE));
        this.iconName = "VisualQuery";
    }

    @Override
    public void initialize() {
        block10: {
            if (!this.isInitialized) {
                super.initialize();
                this.extendedNavBoxes.clear();
                this.navBoxes.add(this.actionNavBox);
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        this.visQueryNavBox = new NavBox(this.title);
                        List<SpVisualQuery> visSearches = session.getDataList(SpVisualQuery.class);
                        Iterator<SpVisualQuery> iter = visSearches.iterator();
                        while (iter.hasNext()) {
                            this.addVisQuery(iter.next());
                        }
                        this.navBoxes.add(this.visQueryNavBox);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(InfoRequestTask.class, ex);
                        log.error((Object)ex);
                        if (session != null) {
                            session.close();
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
        }
        this.isShowDefault = true;
    }

    protected void addVisQuery(SpVisualQuery spVisQuery) {
        NavBoxItemIFace nbi = VisualQueryTask.makeDnDNavBtn(this.visQueryNavBox, spVisQuery.getIdentityTitle(), this.iconName, null, (CommandAction)new CommandActionForDB("Data_Entry", "Edit", SpVisualQuery.getClassTableId(), spVisQuery.getId()), new CommandAction(VISUALQUERY, "Delete", spVisQuery), true, true);
        this.setUpDraggable(nbi, new DataFlavor[]{Trash.TRASH_FLAVOR, InteractionsTask.LOAN_FLAVOR}, new NavBoxAction("Data_Entry", "Edit"));
        this.visQueryNavBox.validate();
        this.visQueryNavBox.repaint();
        NavBox.refresh(this.visQueryNavBox);
    }

    @Override
    public void preInitialize() {
        CommandDispatcher.register("Record_Set", this);
        CommandDispatcher.register("Preferences", this);
        CommandDispatcher.register(VISUALQUERY, this);
        this.actionNavBox = new NavBox(UIRegistry.getResourceString("Actions"));
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = new VisualQueryPanel(this.name, this);
        return this.starterPane;
    }

    protected void prefsChanged(CommandAction cmdAction) {
        Object value;
        AppPreferences appPrefs = (AppPreferences)cmdAction.getData();
        if (appPrefs == AppPreferences.getRemote() && (value = cmdAction.getProperties().get("VisualQuerytask.OnTaskbar")) != null && value instanceof Boolean) {
            JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
            Boolean isChecked = (Boolean)value;
            if (isChecked.booleanValue()) {
                TaskMgr.addToolbarBtn(this.toolBarBtn, toolBar.getComponentCount() - 1);
            } else {
                TaskMgr.removeToolbarBtn(this.toolBarBtn);
            }
            toolBar.validate();
            toolBar.repaint();
        }
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        RecordSetTask rsTask = (RecordSetTask)ContextMgr.getTaskByClass(RecordSetTask.class);
        List<NavBoxIFace> nbs = rsTask.getNavBoxes();
        if (nbs != null) {
            this.extendedNavBoxes.addAll(nbs);
        }
        return this.extendedNavBoxes;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        String label = UIRegistry.getResourceString(VISQRY_MENU);
        String hint = UIRegistry.getResourceString(VISQRY_MENU);
        this.toolBarBtn = this.createToolbarButton(label, this.iconName, hint);
        this.toolbarItems = new Vector();
        if (AppPreferences.getRemote().getBoolean("VISUALQUERY_TASK", false).booleanValue()) {
            this.toolbarItems.add(new ToolBarItemDesc(this.toolBarBtn));
        }
        return this.toolbarItems;
    }

    @Override
    public List<SecurityOptionIFace> getAdditionalSecurityOptions() {
        ArrayList<SecurityOptionIFace> list = new ArrayList<SecurityOptionIFace>();
        SecurityOption secOpt = new SecurityOption(VISQRY_SECURITY, UIRegistry.getResourceString(VISQRY_TITLE), "Task", new BasicPermisionPanel(VISQRY_TITLE, "VISQRY_VIEW", "VISQRY_EDIT"));
        boolean[][] blArrayArray = new boolean[4][];
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArrayArray[0] = blArray;
        blArrayArray[1] = new boolean[4];
        blArrayArray[2] = new boolean[4];
        blArrayArray[3] = new boolean[4];
        this.addPerms(secOpt, blArrayArray);
        list.add(secOpt);
        return list;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("Record_Set")) {
            cmdAction.isAction("Clicked");
        }
        if (cmdAction.isType("Preferences")) {
            this.prefsChanged(cmdAction);
        }
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        String DATA_MENU = "Specify.DATA_MENU";
        SecurityMgr secMgr = SecurityMgr.getInstance();
        this.menuItems = new Vector();
        String menuDesc = UIRegistry.getResourceString(VISQRY_MENU);
        String securityName = this.buildTaskPermissionName(VISQRY_SECURITY);
        if (!AppContextMgr.isSecurityOn() || secMgr.getPermission(securityName) != null && !secMgr.getPermission(securityName).hasNoPerm()) {
            JMenuItem mi = UIHelper.createLocalizedMenuItem(VISQRY_MENU, VISQRY_MNU, VISQRY_TITLE, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VisualQueryTask.this.requestContext();
                        }
                    });
                }
            });
            MenuItemDesc mid = new MenuItemDesc(mi, "Specify.DATA_MENU");
            mid.setPosition(MenuItemDesc.Position.Bottom, menuDesc);
            this.menuItems.add(mid);
        }
        return this.menuItems;
    }
}

