/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.tasks.BaseTreeTask;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class TreeTaskMgr
implements CommandListener {
    private static final int SYNC_INTERVAL = 300;
    private static TreeTaskMgr instance = new TreeTaskMgr();
    private static Timer lockCheckTimer = null;
    private static Hashtable<BaseTreeTask<?, ?, ?>, Vector<RolloverCommand>> unlockBtnHash = new Hashtable();
    private Vector<BaseTreeTask<?, ?, ?>> treeTasks = new Vector();

    static {
        lockCheckTimer = new Timer(true);
        lockCheckTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                TreeTaskMgr.checkLocks();
            }
        }, 300000L, 300000L);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (lockCheckTimer != null) {
                            lockCheckTimer.cancel();
                        }
                    }
                });
                return null;
            }
        });
    }

    private TreeTaskMgr() {
        CommandDispatcher.register("App", this);
    }

    public static TreeTaskMgr getInstance() {
        return instance;
    }

    public void add(BaseTreeTask<?, ?, ?> treeTask) {
        this.treeTasks.add(treeTask);
    }

    public void fillNavBoxes(NavBox treeNB, NavBox treeDefNB, NavBox unlockNB, NavBox browseNB) {
        Collections.sort(this.treeTasks);
        for (BaseTreeTask<?, ?, ?> treeTask : this.treeTasks) {
            RolloverCommand roc;
            NavBoxItemIFace nb;
            if (!treeTask.isTreeOnByDefault()) continue;
            DBTableInfo treeTI = DBTableIdMgr.getInstance().getByClassName(treeTask.getTreeClass().getName());
            PermissionSettings treePerms = treeTI.getPermissions();
            Action edtTreeAction = treePerms != null && treePerms.canView() ? treeTask.getTreeEditAction() : null;
            Action edtTreeDefAction = SpecifyUser.isCurrentUserType(SpecifyUserTypes.UserType.Manager) ? treeTask.getTreeDefEditAction() : null;
            Action unlockTreeAction = treeTask.getTreeUnlockAction();
            Action browseTreeAction = treeTask.getTreeBrowseAction();
            Vector<RolloverCommand> rocs = null;
            if (edtTreeAction == null && edtTreeDefAction == null && unlockTreeAction == null) continue;
            rocs = unlockBtnHash.get(treeTask);
            if (rocs == null) {
                rocs = new Vector();
                unlockBtnHash.put(treeTask, rocs);
            }
            if (edtTreeAction != null) {
                nb = BaseTask.makeDnDNavBtn(treeNB, treeTI.getTitle(), treeTask.getTreeClass().getSimpleName(), null, null, null, false, false);
                roc = (RolloverCommand)((Object)nb);
                roc.addActionListener(edtTreeAction);
                roc.setToolTip(UIRegistry.getResourceString("TASK.SHRTDESC." + treeTask.getTreeClass().getSimpleName()));
                treeNB.add(nb);
            }
            if (edtTreeDefAction != null) {
                nb = BaseTask.makeDnDNavBtn(treeDefNB, treeTI.getTitle(), treeTask.getTreeClass().getSimpleName(), null, null, null, false, false);
                roc = (RolloverCommand)((Object)nb);
                roc.addActionListener(edtTreeDefAction);
                roc.setToolTip(UIRegistry.getResourceString("TASK.SHRTDESC." + treeTask.getTreeDefClass().getSimpleName()));
                treeDefNB.add(nb);
            }
            if (unlockTreeAction != null) {
                nb = BaseTask.makeDnDNavBtn(treeDefNB, treeTI.getTitle(), treeTask.getTreeClass().getSimpleName(), null, null, null, false, false);
                roc = (RolloverCommand)((Object)nb);
                roc.addActionListener(unlockTreeAction);
                roc.setToolTip(UIRegistry.getResourceString("TASK.UNLOCK." + treeTask.getTreeClass().getSimpleName()));
                unlockNB.add(nb);
                rocs.add(roc);
            }
            if (browseTreeAction == null) continue;
            nb = BaseTask.makeDnDNavBtn(treeDefNB, treeTI.getTitle(), treeTask.getTreeClass().getSimpleName(), null, null, null, false, false);
            roc = (RolloverCommand)((Object)nb);
            roc.addActionListener(browseTreeAction);
            roc.setToolTip(UIRegistry.getResourceString("TASK.UNLOCK." + treeTask.getTreeClass().getSimpleName()));
            browseNB.add(nb);
        }
    }

    public static void checkLocks() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTaskMgr.checkLocksInternal();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkLocksInternal() {
        TreeTaskMgr treeTaskMgr = instance;
        synchronized (treeTaskMgr) {
            for (BaseTreeTask<?, ?, ?> treeTask : unlockBtnHash.keySet()) {
                Object tdi = treeTask.getCurrentTreeDef();
                if (tdi == null) continue;
                DBTableInfo treeDefTI = DBTableIdMgr.getInstance().getByClassName(tdi.getClass().getName());
                boolean isLocked = TaskSemaphoreMgr.isLockedOrInUse("def", treeDefTI.getClassObj().getSimpleName(), TaskSemaphoreMgr.SCOPE.Discipline);
                Vector<RolloverCommand> rocs = unlockBtnHash.get(treeTask);
                if (rocs == null) continue;
                String iconName = isLocked ? "Security" : treeTask.getTreeClass().getSimpleName();
                ImageIcon icon = IconManager.getIcon(iconName, IconManager.STD_ICON_SIZE);
                for (RolloverCommand roc : rocs) {
                    roc.setIcon(icon);
                }
            }
        }
    }

    public Vector<BaseTreeTask<?, ?, ?>> getTreeTasks() {
        return new Vector(this.treeTasks);
    }

    @Override
    public void doCommand(CommandAction cmdActionArg) {
    }
}

