/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.tasks.BaseTreeTask;
import edu.ku.brc.specify.ui.treetables.TreeNodePopupMenu;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.Transient;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class TaxonTreeTask
extends BaseTreeTask<Taxon, TaxonTreeDef, TaxonTreeDefItem> {
    public static final String TAXON = "TaxonTree";

    public TaxonTreeTask() {
        super(TAXON, UIRegistry.getResourceString(TAXON));
        this.treeClass = Taxon.class;
        this.treeDefClass = TaxonTreeDef.class;
        this.commandTypeString = TAXON;
        this.initialize();
    }

    @Override
    @Transient
    protected TaxonTreeDef getCurrentTreeDef() {
        return (TaxonTreeDef)((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(Taxon.class);
    }

    protected void fillRecordSet(Taxon taxon, RecordSet recordSet) {
        String sql = "SELECT DISTINCT co.CollectionObjectID FROM taxon as tx INNER JOIN determination as dt ON tx.TaxonID = " + (taxon.getIsAccepted() != false ? "dt.PreferredTaxonID " : "dt.TaxonID ") + "INNER JOIN collectionobject as co ON dt.CollectionObjectID = co.CollectionObjectID " + "WHERE tx.TaxonID = " + taxon.getId() + " AND co.CollectionMemberID = COLMEMID";
        Vector<Integer> list = new Vector<Integer>();
        this.fillListWithIds(sql, list);
        for (Integer id : list) {
            recordSet.addItem(id);
        }
    }

    @Override
    protected TreeTableViewer<Taxon, TaxonTreeDef, TaxonTreeDefItem> createTreeViewer(String titleArg, boolean isEditMode) {
        final TreeTableViewer<Taxon, TaxonTreeDef, TaxonTreeDefItem> ttv = super.createTreeViewer(titleArg, isEditMode);
        if (ttv != null) {
            final TreeNodePopupMenu popup = ttv.getPopupMenu();
            JMenuItem getDeters = new JMenuItem(UIRegistry.getResourceString("TTV_ASSOC_COS"));
            getDeters.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Taxon taxon = (Taxon)ttv.getSelectedNode(popup.getList());
                    if (taxon.getDeterminationCount(false) == 0) {
                        UIRegistry.displayInfoMsgDlgLocalized("TTV_TAXON_NO_DETERS_FOR_NODE", new Object[0]);
                        UIRegistry.getStatusBar().setLocalizedText("TTV_TAXON_NO_DETERS_FOR_NODE", new Object[0]);
                        return;
                    }
                    final RecordSet recordSet = TaxonTreeTask.this.createColObjRSFromTaxon(taxon);
                    UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("TTV_OPENING_CO_FORM"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CommandDispatcher.dispatch(new CommandAction("Data_Entry", "Edit", recordSet));
                        }
                    });
                }
            });
            popup.add(getDeters, true);
            JMenuItem lifeMapperDisplay = new JMenuItem("Lifemapper");
            lifeMapperDisplay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Taxon taxon = (Taxon)ttv.getSelectedNode(popup.getList());
                    RecordSet recordSet = TaxonTreeTask.this.createColObjRSFromTaxon(taxon);
                    final Pair<Taxon, RecordSet> pair = new Pair<Taxon, RecordSet>(taxon, recordSet);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UsageTracker.incrUsageCount("LM.TreeSearchReq");
                            CommandDispatcher.dispatch(new CommandAction("Lifemapper", "Display", pair));
                        }
                    });
                }
            });
            popup.add(lifeMapperDisplay, true);
            if (!isEditMode) {
                JMenuItem taxonMenu = new JMenuItem(UIRegistry.getResourceString("TTV_NEW_CHILD"));
                taxonMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final Taxon taxon = (Taxon)ttv.getSelectedNode(popup.getList());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UsageTracker.incrUsageCount("TREE.AddKidFrView");
                                Pair<Taxon, String> pair = new Pair<Taxon, String>(taxon, "createchild");
                                CommandDispatcher.dispatch(new CommandAction("Data_Entry", "OpenNewView", pair));
                            }
                        });
                    }
                });
                popup.add(taxonMenu, true);
            }
        }
        return ttv;
    }

    private RecordSet createColObjRSFromTaxon(Taxon taxonObj) {
        RecordSet recordSet = new RecordSet();
        recordSet.initialize();
        recordSet.set("TTV", CollectionObject.getClassTableId(), RecordSet.GLOBAL);
        this.fillRecordSet(taxonObj, recordSet);
        return recordSet;
    }

    @Override
    public String getHelpTarget() {
        return "Trees_About";
    }
}

