/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.tasks.TaskConfigItemIFace;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TaskConfigureDlg
extends CustomDialog {
    protected boolean includeAddPanels = false;
    protected String helpContext;
    protected String stdTitleKey;
    protected String miscTitleKey;
    protected String mvRightTTKey;
    protected String mvLeftTTKey;
    protected Vector<TaskConfigItemIFace> stdViews = null;
    protected Vector<TaskConfigItemIFace> miscViews = null;
    protected Vector<TaskConfigItemIFace> removedItems = null;
    protected JButton mvToMiscBtn;
    protected JButton mvToStdBtn;
    protected ItemsOrderPanel stdPanel;
    protected ItemsOrderPanel miscPanel;
    protected boolean hasChanged = false;

    public TaskConfigureDlg(Vector<TaskConfigItemIFace> stdList, Vector<TaskConfigItemIFace> miscList, boolean includeAddPanels, String helpContext, String titleKey, String stdTitle, String miscTitle, String mvRightTTKey, String mvLeftTTKey) {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString(titleKey), true, 7, null);
        this.stdViews = stdList;
        this.miscViews = miscList;
        this.includeAddPanels = includeAddPanels;
        this.helpContext = helpContext;
        this.stdTitleKey = stdTitle;
        this.miscTitleKey = miscTitle;
        this.mvRightTTKey = mvRightTTKey;
        this.mvLeftTTKey = mvLeftTTKey;
    }

    @Override
    public void createUI() {
        super.createUI();
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.helpContext);
        this.stdPanel = new ItemsOrderPanel(this.stdTitleKey, this.stdViews, true, this.includeAddPanels);
        this.miscPanel = new ItemsOrderPanel(this.miscTitleKey, this.miscViews, false, this.includeAddPanels);
        this.mvToMiscBtn = UIHelper.createIconBtn("Map", this.mvRightTTKey, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TaskConfigureDlg.this.moveToMisc();
            }
        });
        this.mvToStdBtn = UIHelper.createIconBtn("Unmap", this.mvLeftTTKey, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TaskConfigureDlg.this.moveToStd();
            }
        });
        CellConstraints cc = new CellConstraints();
        PanelBuilder middlePanel = new PanelBuilder(new FormLayout("c:p:g", "p, 2px, p"));
        middlePanel.add((Component)this.mvToMiscBtn, cc.xy(1, 1));
        middlePanel.add((Component)this.mvToStdBtn, cc.xy(1, 3));
        PanelBuilder middlePanel2 = new PanelBuilder(new FormLayout("c:p:g", "f:p:g, p, f:p:g"));
        middlePanel2.add((Component)middlePanel.getPanel(), cc.xy(1, 2));
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("p:g,5px,p,10px,p:g", "f:p:g"));
        mainPB.add((Component)this.stdPanel, cc.xy(1, 1));
        mainPB.add((Component)middlePanel2.getPanel(), cc.xy(3, 1));
        mainPB.add((Component)this.miscPanel, cc.xy(5, 1));
        mainPB.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentPanel = mainPB.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width, 500);
        size.height = Math.max(size.height, 350);
        this.setSize(size);
        this.stdPanel.getOrderList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    TaskConfigureDlg.this.moveToMisc();
                }
            }
        });
        this.miscPanel.getOrderList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    TaskConfigureDlg.this.moveToStd();
                }
            }
        });
    }

    protected void moveToMisc() {
        int inx = this.stdPanel.getOrderList().getSelectedIndex();
        if (inx > -1) {
            Object dev = this.stdPanel.getOrderList().getSelectedValue();
            ((DefaultListModel)this.stdPanel.getOrderList().getModel()).removeElement(dev);
            ((DefaultListModel)this.miscPanel.getOrderList().getModel()).addElement(dev);
        }
    }

    protected void moveToStd() {
        int inx = this.miscPanel.getOrderList().getSelectedIndex();
        if (inx > -1) {
            Object dev = this.miscPanel.getOrderList().getSelectedValue();
            ((DefaultListModel)this.miscPanel.getOrderList().getModel()).removeElement(dev);
            ((DefaultListModel)this.stdPanel.getOrderList().getModel()).addElement(dev);
        }
    }

    protected void setHasChanged(boolean hasChangedArg) {
        this.hasChanged = hasChangedArg;
        this.getOkBtn().setEnabled(this.hasChanged);
    }

    protected void addItem(JList list, Vector<TaskConfigItemIFace> itemList) {
    }

    public Vector<TaskConfigItemIFace> getRemovedItems() {
        return this.removedItems;
    }

    protected void removeItem(JList list) {
        TaskConfigItemIFace item;
        int index = list.getSelectedIndex();
        if (index > -1 && (item = (TaskConfigItemIFace)((DefaultListModel)list.getModel()).get(index)) != null) {
            if (this.removedItems == null) {
                this.removedItems = new Vector();
            }
            this.removedItems.add(item);
            ((DefaultListModel)list.getModel()).remove(index);
            this.setHasChanged(true);
            list.repaint();
        }
    }

    protected void editItem(JList list) {
    }

    protected void itemSelected() {
        this.mvToMiscBtn.setEnabled(!this.stdPanel.getOrderList().isSelectionEmpty());
        this.mvToStdBtn.setEnabled(!this.miscPanel.getOrderList().isSelectionEmpty());
    }

    @Override
    protected void okButtonPressed() {
        this.stdPanel.doOrderItems();
        this.miscPanel.doOrderItems();
        super.okButtonPressed();
    }

    public class ItemsOrderPanel
    extends JPanel {
        protected JList orderList;
        protected DefaultListModel orderModel;
        protected JButton orderUpBtn;
        protected JButton orderDwnBtn;
        protected EditDeleteAddPanel edaPanel = null;
        protected Vector<TaskConfigItemIFace> items;
        protected Vector<TaskConfigItemIFace> hiddenItems = new Vector();

        public ItemsOrderPanel(String titleKey, final Vector<TaskConfigItemIFace> items, boolean orderOnLeft, boolean includeAREPanel) {
            PanelBuilder outer = new PanelBuilder(new FormLayout(orderOnLeft ? "p,2px,f:p:g" : "f:p:g,2px,p", "p,2px,f:p:g" + (includeAREPanel ? ",2px,p" : "")), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            this.items = items;
            Collections.sort(items);
            this.orderModel = new DefaultListModel();
            for (TaskConfigItemIFace item : items) {
                if (item.isVisible()) {
                    this.orderModel.addElement(item);
                    continue;
                }
                this.hiddenItems.add(item);
            }
            this.orderList = new JList(this.orderModel);
            this.orderList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ItemsOrderPanel.this.updateEnabledState();
                    TaskConfigureDlg.this.itemSelected();
                }
            });
            this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "TCGD_MOVE_UP", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int inx = ItemsOrderPanel.this.orderList.getSelectedIndex();
                    TaskConfigItemIFace item = (TaskConfigItemIFace)ItemsOrderPanel.this.orderModel.getElementAt(inx);
                    ItemsOrderPanel.this.orderModel.remove(inx);
                    ItemsOrderPanel.this.orderModel.insertElementAt(item, inx - 1);
                    ItemsOrderPanel.this.orderList.setSelectedIndex(inx - 1);
                    ItemsOrderPanel.this.updateEnabledState();
                }
            });
            this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "TCGD_MOVE_DOWN", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int inx = ItemsOrderPanel.this.orderList.getSelectedIndex();
                    TaskConfigItemIFace item = (TaskConfigItemIFace)ItemsOrderPanel.this.orderModel.getElementAt(inx);
                    ItemsOrderPanel.this.orderModel.remove(inx);
                    ItemsOrderPanel.this.orderModel.insertElementAt(item, inx + 1);
                    ItemsOrderPanel.this.orderList.setSelectedIndex(inx + 1);
                    ItemsOrderPanel.this.updateEnabledState();
                }
            });
            if (includeAREPanel) {
                this.edaPanel = new EditDeleteAddPanel(null, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TaskConfigureDlg.this.removeItem(ItemsOrderPanel.this.orderList);
                    }
                }, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TaskConfigureDlg.this.addItem(ItemsOrderPanel.this.orderList, items);
                    }
                });
                this.edaPanel.getAddBtn().setEnabled(true);
            }
            PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
            upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
            upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
            int col = orderOnLeft ? 3 : 1;
            outer.add((Component)UIHelper.createLabel(UIRegistry.getResourceString(titleKey), 0), cc.xy(col, 1));
            JScrollPane sp = UIHelper.createScrollPane(this.orderList);
            outer.add((Component)sp, cc.xy(col, 3));
            if (this.edaPanel != null) {
                outer.add((Component)this.edaPanel, cc.xy(col, 5));
            }
            outer.add((Component)upDownPanel.getPanel(), cc.xy(orderOnLeft ? 1 : 3, 3));
            outer.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }

        protected void updateEnabledState() {
            int inx = this.orderList.getSelectedIndex();
            this.orderUpBtn.setEnabled(inx > 0);
            this.orderDwnBtn.setEnabled(inx > -1 && inx < this.orderModel.size() - 1);
            if (this.edaPanel != null) {
                this.edaPanel.setEnabled(inx > -1);
                this.edaPanel.getAddBtn().setEnabled(true);
            }
        }

        public void doOrderItems() {
            this.items.clear();
            int order = 0;
            while (order < this.orderModel.size()) {
                TaskConfigItemIFace item = (TaskConfigItemIFace)this.orderModel.get(order);
                item.setOrder(order);
                this.items.add(item);
                ++order;
            }
            for (TaskConfigItemIFace item : this.hiddenItems) {
                item.setOrder(order++);
                this.items.add(item);
            }
        }

        public JList getOrderList() {
            return this.orderList;
        }

        protected DefaultListModel getOrderModel() {
            return this.orderModel;
        }
    }
}

