/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.SecurityOption;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.DroppableFormObject;
import edu.ku.brc.af.tasks.subpane.DroppableTaskPane;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.CollapsableSepExtraCompFactory;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.formatters.QueryComboboxEditor;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory;
import edu.ku.brc.af.ui.weblink.WebLinkConfigDlg;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.ResourceImportExportDlg;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.busrules.CollectionObjectBusRules;
import edu.ku.brc.specify.datamodel.busrules.PickListBusRules;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.BaseTreeTask;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tasks.TreeTaskMgr;
import edu.ku.brc.specify.tasks.services.PickListUtils;
import edu.ku.brc.specify.tools.schemalocale.PickListEditorDlg;
import edu.ku.brc.specify.tools.schemalocale.SchemaToolsDlg;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.Trash;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SystemSetupTask
extends BaseTask
implements FormPane.FormPaneAdjusterIFace,
BusinessRulesOkDeleteIFace {
    private static final Logger log = Logger.getLogger(SystemSetupTask.class);
    private static final String RESIMPORTEXPORT_SECURITY = "RESIMPORTEXPORT";
    private static final String SCHEMACONFIG_SECURITY = "SCHEMACONFIG";
    private static final String WBSCHEMACONFIG_SECURITY = "WBSCHEMACONFIG";
    private static final String CANCELLED = "_Cancelled_";
    private static final String PICKLIST = "PickList";
    public static final String SYSTEMSETUPTASK = "SystemSetup";
    public static final DataFlavor SYSTEMSETUPTASK_FLAVOR = new DataFlavor(SystemSetupTask.class, "SystemSetup");
    protected NavBox globalNavBox = null;
    protected NavBox navBox = null;
    protected PickListBusRules pickListBusRules = new PickListBusRules();
    protected FormPane formPane = null;
    protected Vector<Pair<BaseTreeTask<?, ?, ?>, JMenuItem>> treeUpdateMenuItems = new Vector();
    protected NavBoxButton lockDBBtn;

    public SystemSetupTask() {
        super(SYSTEMSETUPTASK, UIRegistry.getResourceString(SYSTEMSETUPTASK));
        CommandDispatcher.register(SYSTEMSETUPTASK, this);
        CommandDispatcher.register("Data_Entry", this);
        this.isShowDefault = true;
    }

    protected String getTitle(PickList pickList) {
        return pickList.getName();
    }

    protected void createSysNavBtn(NavBox sysNavBox, int tableId, final boolean useJoinAndSpecCols) {
        final DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(tableId);
        sysNavBox.add(NavBox.createBtnWithTT(ti.getTitle(), ti.getShortClassName(), "", IconManager.STD_ICON_SIZE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemSetupTask.this.startEditor(ti.getClassObj(), SystemSetupTask.SYSTEMSETUPTASK, ti.getShortClassName(), useJoinAndSpecCols);
            }
        }));
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            NavBox sysNavBox = new NavBox(UIRegistry.getResourceString("CORE_DATA_OBJECTS"));
            this.createSysNavBtn(sysNavBox, Institution.getClassTableId(), false);
            this.createSysNavBtn(sysNavBox, Division.getClassTableId(), false);
            this.createSysNavBtn(sysNavBox, Discipline.getClassTableId(), false);
            this.createSysNavBtn(sysNavBox, Collection.getClassTableId(), false);
            this.navBoxes.add(sysNavBox);
            NavBox collNavBox = new NavBox(UIRegistry.getResourceString("COLL_DATA_OBJECTS"));
            this.createSysNavBtn(collNavBox, PrepType.getClassTableId(), true);
            collNavBox.add(NavBox.createBtnWithTT(UIRegistry.getResourceString("PICKLIST_EDITOR"), PICKLIST, "", IconManager.STD_ICON_SIZE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickListEditorDlg dlg = new PickListEditorDlg(null, false, false);
                    dlg.createUI();
                    dlg.setSize(400, 500);
                    dlg.setVisible(true);
                }
            }));
            String btnTitle = UIRegistry.getResourceString(PickListUtils.getI18n("PL_EXPORT"));
            collNavBox.add(NavBox.createBtnWithTT(btnTitle, PICKLIST, "", IconManager.STD_ICON_SIZE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickListUtils.exportPickList(null, null);
                }
            }));
            btnTitle = UIRegistry.getResourceString(PickListUtils.getI18n("PL_IMPORT"));
            collNavBox.add(NavBox.createBtnWithTT(btnTitle, PICKLIST, "", IconManager.STD_ICON_SIZE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection collection = PickListUtils.getCollectionFromAppContext();
                    if (PickListUtils.importPickLists(null, collection)) {
                        collection = PickListUtils.getCollectionFromAppContext();
                        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
                    }
                }
            }));
            SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
            String sql = String.format("SELECT COUNT(*) FROM specifyuser su INNER JOIN specifyuser_spprincipal sup ON su.SpecifyUserID = sup.SpecifyUserID INNER JOIN spprincipal p ON sup.SpPrincipalID = p.SpPrincipalID WHERE p.Name = 'Administrator' AND su.Name = '%s'", spUser.getName());
            if (BasicSQLUtils.getCountAsInt(sql) > 0) {
                this.lockDBBtn = (NavBoxButton)NavBox.createBtnWithTT("Lock", SYSTEMSETUPTASK, "", IconManager.STD_ICON_SIZE, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SystemSetupTask.this.loadUnlockDB(false);
                    }
                });
                collNavBox.add(this.lockDBBtn);
            }
            this.loadUnlockDB(true);
            this.navBoxes.add(collNavBox);
            if (AppPreferences.getLocalPrefs().getBoolean("SHOW_ADDOBJ_PREF", true).booleanValue()) {
                collNavBox.add(NavBox.createBtnWithTT("Adding Data Prefs", SYSTEMSETUPTASK, "", IconManager.STD_ICON_SIZE, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SystemSetupTask.this.showAddObjPrefs();
                    }
                }));
                this.navBoxes.add(collNavBox);
            }
            collNavBox.add(NavBox.createBtnWithTT(UIRegistry.getResourceString("SYSSTP_SHOW_USERS_LOGGED"), SYSTEMSETUPTASK, "", IconManager.STD_ICON_SIZE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SystemSetupTask.this.showUsersLoggedIn();
                }
            }));
            this.navBoxes.add(collNavBox);
        }
        this.isShowDefault = true;
    }

    private void showAddObjPrefs() {
        Component comp;
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        Integer colId = collection.getId();
        boolean isPrepTypeOK = false;
        String defVal = CollectionObjectBusRules.getDefValForPrepTypeHaveOnForm();
        if (StringUtils.isNotEmpty((String)defVal)) {
            isPrepTypeOK = CollectionObjectBusRules.getPrepTypeIdFromDefVal(defVal) != null;
        }
        AppPreferences remote = AppPreferences.getRemote();
        String CO_CREATE_PREP = "CO_CREATE_PREP";
        String[] keys = new String[]{"CO_CREATE_COA", CO_CREATE_PREP, "CO_CREATE_DET"};
        Properties props = new Properties();
        int i = 0;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String fullKey = String.valueOf(key) + "_" + colId;
            if (i == 1 && !isPrepTypeOK) {
                remote.putBoolean(fullKey, false);
            }
            props.put(key, remote.getBoolean(fullKey, false));
            ++i;
            ++n2;
        }
        FormPane pane = new FormPane("AddObjPrefs", (Taskable)this, SYSTEMSETUPTASK, "AddObjPrefs", "edit", (Object)props, 1024, null);
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("SYSSTP_AOBTN"), true, pane);
        pane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        dlg.createUI();
        if (!isPrepTypeOK && (comp = pane.getMultiView().getCurrentViewAsFormViewObj().getControlByName(CO_CREATE_PREP)) != null) {
            comp.setEnabled(false);
            UIRegistry.showLocalizedError("SYSSTP_AOPREP_ERR");
        }
        pane.getMultiView().setData(props);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            pane.getMultiView().getCurrentViewAsFormViewObj().getDataFromUI();
            String[] stringArray2 = keys;
            int n3 = keys.length;
            int n4 = 0;
            while (n4 < n3) {
                String key = stringArray2[n4];
                Object val = props.get(key);
                if (val != null) {
                    remote.putBoolean(String.valueOf(key) + "_" + colId, (Boolean)val);
                }
                ++n4;
            }
        }
    }

    private void showUsersLoggedIn() {
        String sql = " SELECT Name, IsLoggedIn, IsLoggedInReport, LoginCollectionName, LoginDisciplineName FROM specifyuser WHERE IsLoggedIn <> 0";
        Vector<Object[]> dataRows = BasicSQLUtils.query(sql);
        Object[][] data = new Object[dataRows.size()][5];
        int i = 0;
        while (i < dataRows.size()) {
            data[i] = dataRows.get(i);
            ++i;
        }
        DefaultTableModel model = new DefaultTableModel(data, new Object[]{"User", "Is Logged In", "Is Logged In to Report", "Login Collection", "Login Discipline"});
        JTable table = new JTable(model);
        UIHelper.makeTableHeadersCentered(table, true);
        JScrollPane scrollPane = UIHelper.createScrollPane(table);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        CustomDialog infoDlg = new CustomDialog(null, "Users Logged In", true, 1, (Component)panel);
        infoDlg.setCancelLabel("Close");
        infoDlg.createUI();
        infoDlg.setSize(600, 300);
        infoDlg.setVisible(true);
    }

    private void setLockBtntitle(Boolean isLocked) {
        if (this.lockDBBtn != null) {
            String btnTitle = UIRegistry.getLocalizedMessage(isLocked == null || isLocked == false ? "SYSSTP_BTN_BLOCK" : "SYSSTP_BTN_ALLOW", new Object[0]);
            this.lockDBBtn.setLabelText(btnTitle);
        }
    }

    private void loadUnlockDB(boolean doJustBtnLabel) {
        Vector<Object[]> rows = BasicSQLUtils.query(DBConnection.getInstance().getConnection(), "SELECT IsDBClosed, DbClosedBy FROM spversion ORDER BY TimestampCreated DESC");
        if (rows.size() > 0) {
            Object[] row = rows.get(rows.size() - 1);
            Boolean isDBClosed = (Boolean)row[0];
            String dbClosedBy = (String)row[1];
            if (!doJustBtnLabel) {
                String updateStr = "UPDATE spversion SET IsDBClosed=%d, DbClosedBy=%s";
                if (isDBClosed == null || !isDBClosed.booleanValue()) {
                    isDBClosed = true;
                    SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                    if (spUser == null) {
                        return;
                    }
                    dbClosedBy = String.format("'%s'", spUser.getName());
                } else {
                    isDBClosed = false;
                    dbClosedBy = "NULL";
                }
                updateStr = String.format(updateStr, isDBClosed != false ? 1 : 0, dbClosedBy);
                int rv = BasicSQLUtils.update(updateStr);
                if (rv == 1) {
                    UIRegistry.displayInfoMsgDlgLocalized(isDBClosed != false ? "SYSSTP_LCK_MSG" : "SYSSTP_UNLCK_MSG", new Object[0]);
                    this.setLockBtntitle(isDBClosed);
                }
            } else {
                this.setLockBtntitle(isDBClosed);
            }
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        for (Pair<BaseTreeTask<?, ?, ?>, JMenuItem> mi : this.treeUpdateMenuItems) {
            mi.getSecond().setVisible(mi.getFirst().isTreeOnByDefault());
        }
    }

    @Override
    public void requestContext() {
        if (!this.isAnyOtherUsersOn() && SubPaneMgr.getInstance().aboutToShutdown()) {
            ContextMgr.requestContext(this);
            if (this.starterPane == null) {
                if (this.formPane == null) {
                    super.requestContext();
                } else {
                    SubPaneMgr.getInstance().showPane(this.formPane);
                }
            } else {
                SubPaneMgr.getInstance().addPane(this.starterPane);
            }
            TaskMgr.disableAllEnabledTasks();
        }
    }

    protected void editWebLinks() {
        UsageTracker.incrUsageCount("SS.EDTWEBLNK");
        WebLinkConfigDlg dlg = WebLinkMgr.getInstance().editWebLinks(null, false);
        if (dlg.getBtnPressed() == 1 && dlg.hasChanged()) {
            WebLinkMgr.getInstance().write();
        }
    }

    protected void addPickList(PickList pickList, boolean isNew) {
        final String nameStr = pickList.getName();
        if (pickList.getIsSystem().booleanValue()) {
            RolloverCommand rolloverCommand = (RolloverCommand)((Object)NavBox.createBtnWithTT(nameStr, PICKLIST, "", IconManager.STD_ICON_SIZE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SystemSetupTask.this.startEditor(PickList.class, "name", nameStr, SystemSetupTask.this.name, SystemSetupTask.PICKLIST);
                }
            }));
        }
    }

    public void addPopMenu(final RolloverCommand roc, PickList pickList) {
        if (roc.getLabelText() != null) {
            final JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem delMenuItem = new JMenuItem(UIRegistry.getResourceString("Delete"));
            if (!pickList.getIsSystem().booleanValue()) {
                delMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CommandDispatcher.dispatch(new CommandAction(SystemSetupTask.SYSTEMSETUPTASK, "Delete", roc));
                    }
                });
            } else {
                delMenuItem.setEnabled(false);
            }
            popupMenu.add(delMenuItem);
            JMenuItem viewMenuItem = new JMenuItem(UIRegistry.getResourceString("EDIT"));
            viewMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemSetupTask.this.startEditor(PickList.class, "name", roc.getName(), roc.getName(), SystemSetupTask.PICKLIST);
                }
            });
            popupMenu.add(viewMenuItem);
            MouseAdapter mouseListener = new MouseAdapter(){

                private boolean showIfPopupTrigger(MouseEvent mouseEvent) {
                    if (roc.isEnabled() && mouseEvent.isPopupTrigger() && popupMenu.getComponentCount() > 0) {
                        popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        return true;
                    }
                    return false;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (roc.isEnabled()) {
                        this.showIfPopupTrigger(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (roc.isEnabled()) {
                        this.showIfPopupTrigger(mouseEvent);
                    }
                }
            };
            roc.addMouseListener(mouseListener);
        }
    }

    protected boolean checkForPaneWithData(Class<?> clazz) {
        for (SubPaneIFace pane : SubPaneMgr.getInstance().getSubPanes()) {
            java.util.Collection collection;
            JComponent uiComp = pane.getUIComponent();
            if (!(uiComp instanceof FormPane)) continue;
            Object dataObj = ((FormPane)uiComp).getData();
            if (dataObj instanceof java.util.Collection && (collection = (java.util.Collection)dataObj).size() > 0) {
                dataObj = collection.iterator().next();
            }
            if (dataObj == null || dataObj.getClass() != clazz) continue;
            SubPaneMgr.getInstance().showPane(pane);
            return true;
        }
        return false;
    }

    protected boolean checkForPaneWithName(String tabName) {
        for (SubPaneIFace pane : SubPaneMgr.getInstance().getSubPanes()) {
            JComponent uiComp = pane.getUIComponent();
            if (!(uiComp instanceof FormPane) || !pane.getPaneName().equals(tabName)) continue;
            SubPaneMgr.getInstance().showPane(pane);
            return true;
        }
        return false;
    }

    protected void startEditor(Class<?> clazz, String iconNameArg, String viewName, boolean useJoinAndSpecCols) {
        if (this.formPane != null) {
            if (!this.formPane.aboutToShutdown()) {
                return;
            }
            SubPaneMgr.getInstance().removePane(this.formPane);
        }
        this.formPane = null;
        TaskMgr.disableAllEnabledTasks();
        UsageTracker.incrUsageCount("SS.EDT." + viewName);
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(clazz.getName());
        String tiTitle = tableInfo.getTitle();
        if (!this.checkForPaneWithName(tiTitle)) {
            List<?> dataItems;
            block15: {
                dataItems = null;
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    try {
                        StringBuffer sb = new StringBuffer();
                        sb.append("FROM ");
                        sb.append(clazz.getName());
                        sb.append(" as ");
                        sb.append(tableInfo.getAbbrev());
                        if (useJoinAndSpecCols) {
                            String specialCols;
                            String joins = QueryAdjusterForDomain.getInstance().getJoinClause(tableInfo, true, null, true);
                            if (StringUtils.isNotEmpty((String)joins)) {
                                sb.append(" ");
                                sb.append(joins);
                            }
                            if (StringUtils.isNotEmpty((String)(specialCols = QueryAdjusterForDomain.getInstance().getSpecialColumns(tableInfo, true)))) {
                                sb.append(" WHERE ");
                                sb.append(specialCols);
                            }
                        }
                        log.debug((Object)sb.toString());
                        dataItems = session.getDataList(sb.toString());
                        if (dataItems.get(0) instanceof Object[]) {
                            Vector dataList = new Vector();
                            for (Object row : dataItems) {
                                Object[] cols = (Object[])row;
                                dataList.add(cols[0]);
                            }
                            dataItems = dataList;
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SystemSetupTask.class, ex);
                        log.error((Object)ex);
                        session.close();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    throw throwable;
                }
                session.close();
            }
            if (dataItems != null) {
                ViewIFace view = AppContextMgr.getInstance().getView("Common", viewName);
                if (view == null) {
                    view = AppContextMgr.getInstance().getView(null, viewName);
                }
                this.formPane = this.createFormPanel(tiTitle, view.getViewSetName(), view.getName(), "edit", dataItems, 1, IconManager.getIcon(clazz.getSimpleName(), IconManager.IconSize.Std16));
                this.starterPane = null;
                TaskMgr.disableAllEnabledTasks();
            }
        }
    }

    protected void startEditor(Class<?> clazz, String fieldName, String value, String iconNameArg, String viewName) {
        String plTitle;
        String string = plTitle = value == null ? UIRegistry.getResourceString("PL_NEWPICKLIST") : value;
        if (!this.checkForPaneWithName(plTitle)) {
            PickList dataObj;
            block8: {
                dataObj = null;
                if (value != null) {
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    try {
                        try {
                            dataObj = session.getData(clazz, fieldName, value, DataProviderSessionIFace.CompareType.Equals);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(SystemSetupTask.class, ex);
                            log.error((Object)ex);
                            session.close();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        session.close();
                        throw throwable;
                    }
                    session.close();
                } else {
                    PickList pl = new PickList();
                    pl.initialize();
                    dataObj = pl;
                }
            }
            ViewIFace view = AppContextMgr.getInstance().getView(SYSTEMSETUPTASK, viewName);
            this.formPane = this.createFormPanel(plTitle, view.getViewSetName(), view.getName(), "edit", dataObj, 0, IconManager.getIcon(iconNameArg, IconManager.IconSize.Std16), this);
            this.starterPane = null;
        }
    }

    protected void startEditorDlg(Class<?> clazz, String viewName) {
        UsageTracker.incrUsageCount("SS.EDT." + viewName);
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(clazz.getName());
        String tiTitle = tableInfo.getTitle();
        if (!this.checkForPaneWithName(tiTitle)) {
            List<?> dataItems;
            block9: {
                dataItems = null;
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    try {
                        StringBuffer sb = new StringBuffer();
                        sb.append("FROM ");
                        sb.append(clazz.getName());
                        sb.append(" as ");
                        sb.append(tableInfo.getAbbrev());
                        log.debug((Object)sb.toString());
                        dataItems = session.getDataList(sb.toString());
                        if (dataItems.get(0) instanceof Object[]) {
                            Vector dataList = new Vector();
                            for (Object row : dataItems) {
                                Object[] cols = (Object[])row;
                                dataList.add(cols[0]);
                            }
                            dataItems = dataList;
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SystemSetupTask.class, ex);
                        log.error((Object)ex);
                        session.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    throw throwable;
                }
                session.close();
            }
            if (dataItems != null) {
                FormPane pane = new FormPane(tableInfo.getTitle(), (Taskable)this, SYSTEMSETUPTASK, viewName, "edit", null, 1, null);
                CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), tableInfo.getTitle(), true, pane);
                dlg.setWhichBtns(1);
                dlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
                pane.getMultiView().setData(dataItems);
                UIHelper.centerAndShow(dlg);
            }
        }
    }

    protected void addDraggableDataFlavors(NavBoxButton roc) {
        roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        roc.addDragDataFlavor(DroppableTaskPane.DROPPABLE_PANE_FLAVOR);
    }

    protected PickList deletePickList(PickList pickList, DataProviderSessionIFace sessionArg) {
        DataProviderSessionIFace session = sessionArg == null ? DataProviderFactory.getInstance().createSession() : sessionArg;
        try {
            try {
                session.beginTransaction();
                session.delete(pickList);
                session.commit();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SystemSetupTask.class, ex);
                log.warn((Object)ex);
                if (sessionArg == null) {
                    session.close();
                }
            }
        }
        finally {
            if (sessionArg == null) {
                session.close();
            }
        }
        return pickList;
    }

    protected NavBoxItemIFace getBoxByName(String boxName) {
        for (NavBoxItemIFace nbi : this.navBox.getItems()) {
            if (!((NavBoxButton)nbi).getLabelText().equals(boxName)) continue;
            return nbi;
        }
        return null;
    }

    protected void deletePickListFromUI(NavBoxItemIFace boxItem, PickList pickList) {
        NavBoxItemIFace nb;
        NavBoxItemIFace navBoxItemIFace = nb = boxItem != null ? boxItem : this.getBoxByName(this.getTitle(pickList));
        if (nb != null) {
            this.navBox.remove(nb);
            this.navBox.invalidate();
            this.navBox.setSize(this.navBox.getPreferredSize());
            this.navBox.doLayout();
            this.navBox.repaint();
            NavBoxMgr.getInstance().invalidate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
            UIRegistry.forceTopFrameRepaint();
        }
    }

    protected void doSchemaConfig(final Byte schemaType, final DBTableIdMgr tableMgr) {
        SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        boolean ok = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).checkToOverrideLogins(spUser.getName());
        if (!ok) {
            TaskMgr.getTask("Startup").requestContext();
            return;
        }
        UsageTracker.incrUsageCount("SS.SCHEMACFG");
        UIRegistry.getStatusBar().setIndeterminate(SYSTEMSETUPTASK, true);
        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString(SystemSetupTask.getI18NKey("LOADING_LOCALES")));
        UIRegistry.getStatusBar().repaint();
        SwingWorker workerThread = new SwingWorker(){

            @Override
            public Object construct() {
                Locale.getAvailableLocales();
                return null;
            }

            @Override
            public void finished() {
                UIRegistry.getStatusBar().setText("");
                UIRegistry.getStatusBar().setProgressDone(SystemSetupTask.SYSTEMSETUPTASK);
                JComponent videoBtn = CollapsableSepExtraCompFactory.getInstance().getComponent("Schema", "Config");
                SchemaToolsDlg dlg = new SchemaToolsDlg((Frame)UIRegistry.getTopWindow(), schemaType, tableMgr);
                dlg.setExtraBtn(videoBtn);
                dlg.setVisible(true);
                if (!dlg.isCancelled()) {
                    TaskMgr.getTask("Startup").requestContext();
                }
            }
        };
        workerThread.start();
    }

    public static boolean askBeforeStartingTool() {
        if (SubPaneMgr.getInstance().aboutToShutdown()) {
            Object[] options = new Object[]{UIRegistry.getResourceString("CONTINUE"), UIRegistry.getResourceString("CANCEL")};
            return JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage(SystemSetupTask.getI18NKey("REI_MSG"), new Object[0]), UIRegistry.getResourceString(SystemSetupTask.getI18NKey("REI_TITLE")), 0, 3, null, options, options[0]) == 0;
        }
        return false;
    }

    protected String pickUserName() {
        Division division = AppContextMgr.getInstance().getClassObject(Division.class);
        String currUserName = AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getName();
        String postSQL = String.format(" FROM specifyuser su INNER JOIN agent a ON su.SpecifyUserID = a.SpecifyUserID INNER JOIN division d ON a.DivisionID = d.UserGroupScopeId WHERE su.Name <> '%s' AND d.UserGroupScopeId = %d", currUserName, division.getId());
        int count = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) " + postSQL);
        if (count == 0) {
            return null;
        }
        int choice = UIRegistry.askYesNoLocalized("SYSSTP_CHSE_ME", "SYSSTP_CHSE_DIF", UIRegistry.getResourceString("SYSSTP_CHSE_USER"), "SYSSTP_CHSE_USER_TITLE");
        if (choice == 0) {
            return null;
        }
        Vector<Object> names = BasicSQLUtils.querySingleCol("SELECT su.Name " + postSQL);
        if (names.size() == 1) {
            return names.get(0).toString();
        }
        ChooseFromListDlg<Object> dlg = new ChooseFromListDlg<Object>((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("SYSSTP_CHSE_USER_TITLE"), names);
        UIHelper.centerAndShow(dlg);
        return !dlg.isCancelled() ? dlg.getSelectedObject().toString() : CANCELLED;
    }

    protected void doResourceImportExport() {
        if (SystemSetupTask.askBeforeStartingTool()) {
            String userName = this.pickUserName();
            if (userName != null && userName.equals(CANCELLED)) {
                return;
            }
            if (userName == null) {
                userName = AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getName();
            }
            ResourceImportExportDlg dlg = new ResourceImportExportDlg((SpecifyAppContextMgr)AppContextMgr.getInstance(), userName);
            dlg.setVisible(true);
            if (dlg.hasChanged()) {
                UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
            } else {
                TaskMgr.getTask("Startup").requestContext();
            }
        }
    }

    protected void doTreeUpdate(BaseTreeTask<?, ?, ?> tree) {
        try {
            boolean success = ((TreeDefIface)tree.getCurrentTreeDef()).updateAllNodes(null, true, false);
            if (success) {
                UIRegistry.displayInfoMsgDlgLocalized("SystemSetupTask.TREE_UPDATE_SUCCESS", tree.getTitle());
            }
        }
        catch (Exception ex) {
            UIRegistry.displayErrorDlgLocalized("SystemSetupTask.TREE_UPDATE_DISASTER", tree.getTitle());
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SystemSetupTask.class, ex);
        }
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = StartUpTask.createFullImageSplashPanel(this.title, this);
        return this.starterPane;
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        super.subPaneRemoved(subPane);
        if (subPane instanceof SimpleDescPane || this.subPanes.size() == 0) {
            final boolean isGlobalShutdown = SubPaneMgr.getInstance().isGlobalShutdown();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubPaneMgr.getInstance().getSubPanes().size() == 0 && !isGlobalShutdown) {
                        TaskMgr.reenableAllDisabledTasks();
                        TaskMgr.getTask("Startup").requestContext();
                    }
                }
            });
        }
    }

    private static String getI18NKey(String key) {
        return "SystemSetupTask." + key;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        JMenuItem mi;
        String mneu;
        String titleArg;
        String COLSETUP_MENU = "Specify.COLSETUP_MENU";
        String TREES_MENU = "Specify.TREES_MENU";
        String SYSTEM_MENU = "Specify.SYSTEM_MENU";
        String FULL_SYSTEM_MENU = "Specify.SYSTEM_MENU/Specify.COLSETUP_MENU";
        String FULL_TREE_MENU = "Specify.SYSTEM_MENU/Specify.TREES_MENU";
        SecurityMgr secMgr = SecurityMgr.getInstance();
        this.menuItems = new Vector();
        String menuDesc = UIRegistry.getResourceString("Specify.TREES_MENU");
        JMenu formsMenu = UIHelper.createLocalizedMenu("Specify.FORMS_MENU", "Specify.FORMS_MNEU");
        MenuItemDesc mid = new MenuItemDesc(formsMenu, "Specify.SYSTEM_MENU");
        mid.setPosition(MenuItemDesc.Position.Top, menuDesc);
        mid.setSepPosition(MenuItemDesc.Position.After);
        this.menuItems.add(mid);
        JMenu treesMenu = UIHelper.createLocalizedMenu("Specify.TREES_MENU", "Specify.TREES_MNEU");
        mid = new MenuItemDesc(treesMenu, "Specify.SYSTEM_MENU");
        mid.setPosition(MenuItemDesc.Position.Top, menuDesc);
        this.menuItems.add(mid);
        JMenu setupMenu = UIHelper.createLocalizedMenu("Specify.COLSETUP_MENU", "Specify.COLSETUP_MNEU");
        mid = new MenuItemDesc(setupMenu, "Specify.SYSTEM_MENU");
        mid.setPosition(MenuItemDesc.Position.Top, menuDesc);
        this.menuItems.add(mid);
        if (!AppContextMgr.isSecurityOn() || this.getPermissions() != null && this.getPermissions().canAdd()) {
            titleArg = SystemSetupTask.getI18NKey("COLL_CONFIG");
            mneu = SystemSetupTask.getI18NKey("COLL_CONFIG_MNEU");
            mi = UIHelper.createLocalizedMenuItem(titleArg, mneu, titleArg, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SystemSetupTask.this.requestContext();
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU/Specify.COLSETUP_MENU");
            mid.setPosition(MenuItemDesc.Position.Top, "Specify.SYSTEM_MENU/Specify.COLSETUP_MENU");
            this.menuItems.add(mid);
        }
        if (!AppContextMgr.isSecurityOn() || SpecifyUser.isCurrentUserType(SpecifyUserTypes.UserType.Manager)) {
            Vector trees = new Vector(TreeTaskMgr.getInstance().getTreeTasks());
            Collections.sort(trees, new Comparator<BaseTreeTask<?, ?, ?>>(){

                @Override
                public int compare(BaseTreeTask<?, ?, ?> arg0, BaseTreeTask<?, ?, ?> arg1) {
                    return arg0.getTitle().compareTo(arg1.getTitle());
                }
            });
            for (final BaseTreeTask<?, ?, ?> tree : trees) {
                titleArg = String.valueOf(UIRegistry.getResourceString(SystemSetupTask.getI18NKey("Tree_MENU"))) + " " + tree.getTitle();
                mneu = SystemSetupTask.getI18NKey("Trees_MNU");
                mi = UIHelper.createMenuItemWithAction(null, titleArg, mneu, titleArg, true, null);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SystemSetupTask.this.doTreeUpdate(tree);
                            }
                        });
                    }
                });
                mi.setVisible(tree.isTreeOnByDefault());
                this.treeUpdateMenuItems.add(new Pair(tree, mi));
                mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU/Specify.TREES_MENU");
                mid.setPosition(MenuItemDesc.Position.After, menuDesc);
                this.menuItems.add(mid);
            }
        }
        String securityName = this.buildTaskPermissionName(RESIMPORTEXPORT_SECURITY);
        if (!AppContextMgr.isSecurityOn() || secMgr.getPermission(securityName) != null && !secMgr.getPermission(securityName).hasNoPerm()) {
            titleArg = SystemSetupTask.getI18NKey("RIE_MENU");
            mneu = SystemSetupTask.getI18NKey("RIE_MNU");
            mi = UIHelper.createLocalizedMenuItem(titleArg, mneu, titleArg, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SystemSetupTask.this.doResourceImportExport();
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU");
            mid.setPosition(MenuItemDesc.Position.Bottom, menuDesc);
            mid.setSepPosition(MenuItemDesc.Position.After);
            this.menuItems.add(mid);
        }
        securityName = this.buildTaskPermissionName(SCHEMACONFIG_SECURITY);
        if (!AppContextMgr.isSecurityOn() || secMgr.getPermission(securityName) != null && secMgr.getPermission(securityName).canView()) {
            titleArg = SystemSetupTask.getI18NKey("SCHEMA_CONFIG_MENU");
            mneu = SystemSetupTask.getI18NKey("SCHEMA_CONFIG_MNU");
            mi = UIHelper.createLocalizedMenuItem(titleArg, mneu, titleArg, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SystemSetupTask.this.doSchemaConfig(SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance());
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU");
            mid.setPosition(MenuItemDesc.Position.Bottom);
            this.menuItems.add(mid);
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            if (localPrefs.getBoolean("QCBX_EDITOR", false).booleanValue()) {
                menuDesc = UIRegistry.getResourceString(titleArg);
                titleArg = SystemSetupTask.getI18NKey("QCBXEDITOR_MENU");
                mneu = SystemSetupTask.getI18NKey("QCBXEDITOR_MNEU");
                mi = UIHelper.createLocalizedMenuItem(titleArg, mneu, titleArg, true, null);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        TypeSearchForQueryFactory.getInstance().save();
                        QueryComboboxEditor tse = new QueryComboboxEditor();
                        UIHelper.centerAndShow(tse);
                    }
                });
                mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU");
                mid.setPosition(MenuItemDesc.Position.Bottom);
                this.menuItems.add(mid);
            }
        }
        if (!AppContextMgr.isSecurityOn() || secMgr.getPermission(WBSCHEMACONFIG_SECURITY) != null && secMgr.getPermission(WBSCHEMACONFIG_SECURITY).canAdd()) {
            titleArg = SystemSetupTask.getI18NKey("WBSCHEMA_CONFIG_MENU");
            mneu = SystemSetupTask.getI18NKey("WBSCHEMA_CONFIG_MNU");
            mi = UIHelper.createLocalizedMenuItem(titleArg, mneu, titleArg, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SystemSetupTask.this.doWorkBenchSchemaConfig();
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU");
            mid.setPosition(MenuItemDesc.Position.Bottom, menuDesc);
            this.menuItems.add(mid);
        }
        return this.menuItems;
    }

    private void doWorkBenchSchemaConfig() {
        final DBTableIdMgr tableMgr = new DBTableIdMgr(false);
        tableMgr.initialize(new File(XMLHelper.getConfigDirPath("specify_workbench_datamodel.xml")));
        final Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        String sql = String.format("SELECT COUNT(*) FROM splocalecontainer WHERE DisciplineID = %d AND SchemaType = %d", discipline.getId(), SpLocaleContainer.WORKBENCH_SCHEMA);
        int containerCnt = BasicSQLUtils.getCountAsInt(sql);
        if (containerCnt == 0) {
            UIRegistry.getStatusBar().setIndeterminate(SYSTEMSETUPTASK, true);
            SwingWorker worker = new SwingWorker(){
                private boolean isOK = false;

                @Override
                public Object construct() {
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            session.beginTransaction();
                            Discipline disp = session.get(Discipline.class, discipline.getId());
                            BuildSampleDatabase bsd = new BuildSampleDatabase();
                            bsd.loadSchemaLocalization(disp, SpLocaleContainer.WORKBENCH_SCHEMA, tableMgr, null, null, BuildSampleDatabase.UpdateType.eBuildNew, session);
                            session.commit();
                            this.isOK = true;
                        }
                        catch (Exception ex) {
                            try {
                                session.rollback();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            log.error((Object)ex);
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(SystemSetupTask.class, ex);
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                    return null;
                }

                @Override
                public void finished() {
                    UIRegistry.getStatusBar().setProgressDone(SystemSetupTask.SYSTEMSETUPTASK);
                    if (this.isOK) {
                        SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.WORKBENCH_SCHEMA, discipline.getId(), tableMgr, SchemaI18NService.getCurrentLocale());
                        SystemSetupTask.this.doSchemaConfig(SpLocaleContainer.WORKBENCH_SCHEMA, tableMgr);
                    }
                }
            };
            worker.start();
        } else {
            SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.WORKBENCH_SCHEMA, discipline.getId(), tableMgr, SchemaI18NService.getCurrentLocale());
            this.doSchemaConfig(SpLocaleContainer.WORKBENCH_SCHEMA, tableMgr);
        }
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    private void pickListSaved(PickList pickList) {
        boolean fnd = false;
        boolean resort = false;
        if (this.navBox != null) {
            for (NavBoxItemIFace nbi : this.navBox.getItems()) {
                if (nbi.getData() == null || ((Integer)nbi.getData()).intValue() != pickList.getPickListId().intValue()) continue;
                fnd = true;
                String oldName = ((RolloverCommand)((Object)nbi)).getLabelText();
                if (oldName.equals(pickList.getName())) break;
                ((RolloverCommand)((Object)nbi)).setLabelText(pickList.getName());
                resort = true;
                break;
            }
        }
        if (!fnd) {
            this.addPickList(pickList, true);
        } else if (resort) {
            this.navBox.sort();
        }
        SubPaneIFace subPane = SubPaneMgr.getInstance().getCurrentSubPane();
        if (subPane != null && subPane.getPaneName().startsWith(UIRegistry.getResourceString("PL_NEWPICKLIST"))) {
            SubPaneMgr.getInstance().renamePane(subPane, pickList.getName());
        }
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel(SYSTEMSETUPTASK, "ENABLE", null, null, null);
    }

    @Override
    public List<SecurityOptionIFace> getAdditionalSecurityOptions() {
        ArrayList<SecurityOptionIFace> list = new ArrayList<SecurityOptionIFace>();
        SecurityOption secOpt = new SecurityOption(RESIMPORTEXPORT_SECURITY, UIRegistry.getResourceString("RIE_TITLE"), "Task", new BasicPermisionPanel("RIE_TITLE", "RIE_SEC_IMPORT", "RIE_SEC_EXPORT"));
        boolean[][] blArrayArray = new boolean[4][];
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArrayArray[0] = blArray;
        blArrayArray[1] = new boolean[4];
        blArrayArray[2] = new boolean[4];
        blArrayArray[3] = new boolean[4];
        this.addPerms(secOpt, blArrayArray);
        list.add(secOpt);
        secOpt = new SecurityOption(SCHEMACONFIG_SECURITY, UIRegistry.getResourceString(SystemSetupTask.getI18NKey("SCHEMA_CONFIG")), "Task", new BasicPermisionPanel(SystemSetupTask.getI18NKey("SCHEMA_CONFIG"), "Enable"));
        boolean[][] blArrayArray2 = new boolean[4][];
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray2[0] = blArray2;
        blArrayArray2[1] = new boolean[4];
        blArrayArray2[2] = new boolean[4];
        blArrayArray2[3] = new boolean[4];
        this.addPerms(secOpt, blArrayArray2);
        list.add(secOpt);
        secOpt = new SecurityOption(WBSCHEMACONFIG_SECURITY, UIRegistry.getResourceString(SystemSetupTask.getI18NKey("WBSCHEMA_CONFIG")), "Task", new BasicPermisionPanel(SystemSetupTask.getI18NKey("WBSCHEMA_CONFIG"), "Enable"));
        boolean[][] blArrayArray3 = new boolean[4][];
        boolean[] blArray3 = new boolean[4];
        blArray3[0] = true;
        blArrayArray3[0] = blArray3;
        blArrayArray3[1] = new boolean[4];
        blArrayArray3[2] = new boolean[4];
        blArrayArray3[3] = new boolean[4];
        this.addPerms(secOpt, blArrayArray3);
        list.add(secOpt);
        return list;
    }

    protected void processSysSetupCommands(CommandAction cmdAction) {
        Object data;
        Object object = data = cmdAction.getData() instanceof DroppableFormObject ? ((DroppableFormObject)cmdAction.getData()).getData() : cmdAction.getData();
        if (data instanceof NavBoxButton) {
            data = ((NavBoxButton)data).getData();
        }
        if (cmdAction.isAction("Delete") && data instanceof Integer) {
            final Integer id = (Integer)data;
            UIRegistry.getStatusBar().setIndeterminate(SYSTEMSETUPTASK, true);
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            PickList pickList = session.getData(PickList.class, "pickListId", id, DataProviderSessionIFace.CompareType.Equals);
                            if (pickList != null) {
                                SystemSetupTask.this.pickListBusRules.okToDelete(pickList, session, SystemSetupTask.this);
                            }
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(SystemSetupTask.class, ex);
                            log.error((Object)ex);
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                    return null;
                }

                @Override
                public void finished() {
                    UIRegistry.getStatusBar().setProgressDone(SystemSetupTask.SYSTEMSETUPTASK);
                }
            };
            worker.start();
        }
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        if ((!AppContextMgr.isSecurityOn() || SpecifyUser.isCurrentUserType(SpecifyUserTypes.UserType.Manager)) && AppPreferences.getLocalPrefs().getBoolean("SYSSETUP_TOOLBAR", false).booleanValue()) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SystemSetupTask.this.requestContext();
                }
            };
            this.toolbarItems = new Vector();
            this.toolbarItems.add(new ToolBarItemDesc(this.createToolbarButton("System Setup", this.iconName, "", null, al)));
        }
        return this.toolbarItems;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(SYSTEMSETUPTASK)) {
            this.processSysSetupCommands(cmdAction);
        } else if (cmdAction.isType("Data_Entry")) {
            Object data;
            Object object = data = cmdAction.getData() instanceof DroppableFormObject ? ((DroppableFormObject)cmdAction.getData()).getData() : cmdAction.getData();
            if (cmdAction.isAction("Save") && data instanceof PickList) {
                this.pickListSaved((PickList)data);
            }
        } else if (cmdAction.isType("App")) {
            this.doProcessAppCommands(cmdAction);
        }
    }

    @Override
    public void adjustForm(FormViewObj fvo) {
        new PickListBusRules().adjustForm(fvo);
    }

    @Override
    public void doDeleteDataObj(Object dataObj, DataProviderSessionIFace session, boolean doDelete) {
        UIRegistry.getStatusBar().setProgressDone(SYSTEMSETUPTASK);
        if (dataObj instanceof PickList) {
            PickList pickList = (PickList)dataObj;
            if (doDelete) {
                this.deletePickList(pickList, session);
                if (pickList != null) {
                    if (!pickList.getIsSystem().booleanValue()) {
                        this.deletePickListFromUI(null, pickList);
                        SubPaneIFace sp = SubPaneMgr.getInstance().getSubPaneByName(pickList.getName());
                        if (sp != null) {
                            SubPaneMgr.getInstance().removePane(sp);
                        }
                    } else {
                        UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("PL_NO_DEL_SYSPL"));
                    }
                }
            } else {
                UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("PL_NO_DEL_PL_INUSE"));
            }
        }
    }

    @Override
    protected boolean[][] getPermsArray() {
        return new boolean[][]{{true, true, true, true}, new boolean[4], new boolean[4], new boolean[4]};
    }
}

