/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.busrules.StorageBusRules;
import edu.ku.brc.specify.tasks.BaseTreeTask;
import edu.ku.brc.specify.ui.treetables.TreeNodePopupMenu;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.persistence.Transient;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class StorageTreeTask
extends BaseTreeTask<Storage, StorageTreeDef, StorageTreeDefItem> {
    public static final String STORAGE = "StorageTree";

    public StorageTreeTask() {
        super(STORAGE, UIRegistry.getResourceString(STORAGE));
        this.treeClass = Storage.class;
        this.treeDefClass = StorageTreeDef.class;
        this.commandTypeString = STORAGE;
        this.businessRules = new StorageBusRules();
        this.initialize();
    }

    @Override
    @Transient
    protected StorageTreeDef getCurrentTreeDef() {
        return (StorageTreeDef)((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(Storage.class);
    }

    protected void showPreparations(TreeTableViewer<Storage, StorageTreeDef, StorageTreeDefItem> ttv, JList list) {
        Storage storage = ttv.getSelectedNode(list);
        ttv.initializeNodeAssociations(storage);
        if (storage.getPreparations().size() == 0) {
            UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("TTV_TAXON_NO_COS_FOR_NODE"));
            return;
        }
        RecordSet recordSet = new RecordSet();
        recordSet.initialize();
        recordSet.set("TTV", CollectionObject.getClassTableId(), RecordSet.GLOBAL);
        Hashtable<Integer, Boolean> duplicateHash = new Hashtable<Integer, Boolean>();
        String sql = "SELECT p.CollectionObjectID FROM storage as st INNER JOIN preparation as p ON st.StorageID = p.StorageID WHERE st.StorageID = " + storage.getStorageId() + " AND p.CollectionMemberID = COLMEMID";
        Vector<Integer> idList = new Vector<Integer>();
        this.fillListWithIds(sql, idList);
        for (Integer id : idList) {
            duplicateHash.put(id, true);
        }
        sql = "SELECT co.CollectionObjectID FROM storage as st INNER JOIN container as cn ON st.StorageID = cn.StorageID INNER JOIN collectionobject co ON co.ContainerID = cn.ContainerID WHERE st.StorageID = " + storage.getStorageId() + " AND co.CollectionMemberID = COLMEMID";
        this.fillListWithIds(sql, idList);
        for (Integer id : idList) {
            duplicateHash.put(id, true);
        }
        for (Integer id : duplicateHash.keySet()) {
            recordSet.addItem(id);
        }
        final RecordSet rs = recordSet;
        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("TTV_OPENING_CO_FORM"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommandDispatcher.dispatch(new CommandAction("Data_Entry", "Edit", rs));
            }
        });
    }

    @Override
    protected TreeTableViewer<Storage, StorageTreeDef, StorageTreeDefItem> createTreeViewer(String titleArg, boolean isEditMode) {
        final TreeTableViewer<Storage, StorageTreeDef, StorageTreeDefItem> ttv = super.createTreeViewer(titleArg, isEditMode);
        if (ttv != null) {
            final TreeNodePopupMenu popup = ttv.getPopupMenu();
            JMenuItem coMenuItem = new JMenuItem(UIRegistry.getResourceString("TTV_ASSOC_COS"));
            coMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StorageTreeTask.this.showPreparations(ttv, popup.getList());
                }
            });
            popup.add(coMenuItem, true);
        }
        return ttv;
    }
}

