/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class StatsTrackerTask
extends edu.ku.brc.af.tasks.StatsTrackerTask {
    private static final Logger log = Logger.getLogger(StatsTrackerTask.class);
    private static final String DATABASE = "Database";
    private static final String resourceName = "CollStats";
    private boolean hasChanged = false;
    private JProgressBar progress;
    private Hashtable<Class<?>, Boolean> tablesHash = new Hashtable();
    private Vector<Pair<String, String>> queries = new Vector();
    private Collection collection = null;
    private Discipline discipline = null;
    private Division division = null;
    private Institution institution = null;

    public StatsTrackerTask() {
        CommandDispatcher.register(DATABASE, this);
    }

    @Override
    public void initialize() {
        super.initialize();
        Element rootElement = AppContextMgr.getInstance().getResourceAsDOM(resourceName);
        if (rootElement != null) {
            List rows = rootElement.selectNodes("/statistics/tables/table");
            for (Object obj : rows) {
                Element statElement = (Element)obj;
                String tableClassName = XMLHelper.getAttr(statElement, "class", null);
                if (!StringUtils.isNotEmpty((String)tableClassName)) continue;
                Class<?> cls = null;
                try {
                    cls = Class.forName(tableClassName);
                    this.tablesHash.put(cls, true);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(StatsTrackerTask.class, ex);
                    ex.printStackTrace();
                }
            }
        } else {
            log.error((Object)"Couldn't find resource [CollStats]");
        }
    }

    @Override
    protected void showClosingFrame() {
        if (this.hasChanged) {
            ImageIcon img = IconManager.getIcon("SpecifySplash");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,150px", "f:p:g,2px,p"));
            pb.setDefaultDialogBorder();
            JLabel lbl = new JLabel(img);
            pb.add((Component)lbl, cc.xyw(1, 1, 2));
            lbl = UIHelper.createI18NLabel("SPECIFY_SHUTDOWN", 0);
            lbl.setFont(lbl.getFont().deriveFont(18.0f));
            pb.add((Component)lbl, cc.xy(1, 3));
            this.progress = new JProgressBar(0, 100);
            pb.add((Component)this.progress, cc.xy(2, 3));
            JFrame frame = new JFrame();
            frame.setUndecorated(true);
            frame.setContentPane(pb.getPanel());
            frame.pack();
            UIHelper.centerAndShow(frame);
        }
    }

    @Override
    protected void completed() {
        this.collection = null;
        this.discipline = null;
        this.division = null;
        this.institution = null;
        this.queries.clear();
    }

    @Override
    protected boolean starting() {
        if (this.collection == null) {
            this.collection = AppContextMgr.getInstance().getClassObject(Collection.class);
            this.discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
            this.division = AppContextMgr.getInstance().getClassObject(Division.class);
            this.institution = AppContextMgr.getInstance().getClassObject(Institution.class);
            this.queries.clear();
            Element rootElement = AppContextMgr.getInstance().getResourceAsDOM(resourceName);
            if (rootElement != null) {
                List rows = rootElement.selectNodes("/statistics/stats/stat");
                for (Object obj : rows) {
                    Element statElement = (Element)obj;
                    String statsName = XMLHelper.getAttr(statElement, "name", null);
                    if (!StringUtils.isNotEmpty((String)statsName)) continue;
                    String sqlStr = QueryAdjusterForDomain.getInstance().adjustSQL(statElement.getText());
                    this.queries.add(new Pair<String, String>(statsName, sqlStr));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected PropertyChangeListener getPCLForWorker() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName()) && StatsTrackerTask.this.progress != null) {
                    StatsTrackerTask.this.progress.setValue((Integer)evt.getNewValue());
                }
            }
        };
    }

    @Override
    protected void sendStats() throws Exception {
        super.sendStats();
        this.sendCollectionStats();
        this.sendActivityStats(false);
    }

    @Override
    protected Vector<NameValuePair> collectSecondaryStats(boolean doSendSecondaryStats) {
        boolean isAnon = false;
        if (this.institution != null) {
            isAnon = this.institution.isSendStatsAnonymous();
        }
        if (doSendSecondaryStats || !isAnon) {
            Vector<NameValuePair> stats = new Vector<NameValuePair>();
            this.appendBasicCollStats(stats);
            if (this.hasChanged) {
                if (this.progress != null) {
                    this.progress.setIndeterminate(true);
                }
                if (this.queries.size() > 0) {
                    int count = 0;
                    double total = this.queries.size();
                    for (Pair<String, String> p : this.queries) {
                        String statsName = (String)p.first;
                        if (!StringUtils.isNotEmpty((String)statsName)) continue;
                        ++count;
                        this.addStat(statsName, stats, (String)p.second);
                        if (this.progress != null) {
                            this.progress.setIndeterminate(false);
                        }
                        this.worker.setProgressValue((int)(100.0 * ((double)count / total)));
                    }
                    this.worker.setProgressValue(100);
                } else {
                    log.error((Object)"Couldn't find resource [CollStats]");
                }
            }
            return stats;
        }
        return null;
    }

    protected void appendBasicCollStats(Vector<NameValuePair> stats) {
        SpecifyUser su = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        if (su != null) {
            stats.add(new NameValuePair("specifyuser", StatsTrackerTask.fixParam(su.getName())));
        }
        if (this.collection != null) {
            Integer estSize = this.collection.getEstimatedSize();
            String estSizeStr = estSize != null ? Integer.toString(estSize) : "";
            stats.add(new NameValuePair("Collection_estsize", estSizeStr));
            stats.add(new NameValuePair("Collection_number", StatsTrackerTask.fixParam(this.collection.getRegNumber())));
            stats.add(new NameValuePair("Collection_website", StatsTrackerTask.fixParam(this.collection.getWebSiteURI())));
            stats.add(new NameValuePair("Collection_portal", StatsTrackerTask.fixParam(this.collection.getWebPortalURI())));
            stats.add(new NameValuePair("Collection_name", StatsTrackerTask.fixParam(this.collection.getCollectionName())));
        }
        if (this.discipline != null) {
            stats.add(new NameValuePair("Discipline_number", StatsTrackerTask.fixParam(this.discipline.getRegNumber())));
            stats.add(new NameValuePair("Discipline_name", StatsTrackerTask.fixParam(this.discipline.getName())));
        }
        if (this.division != null) {
            stats.add(new NameValuePair("Division_number", StatsTrackerTask.fixParam(this.division.getRegNumber())));
            stats.add(new NameValuePair("Division_name", StatsTrackerTask.fixParam(this.division.getName())));
        }
        if (this.institution != null) {
            stats.add(new NameValuePair("Institution_number", StatsTrackerTask.fixParam(this.institution.getRegNumber())));
            stats.add(new NameValuePair("Institution_name", StatsTrackerTask.fixParam(this.institution.getName())));
        }
    }

    private void collectStatsData(String colNm, String regNum, String sql, StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(';');
        }
        sb.append(String.format("{%s, %s [", colNm, regNum));
        int c = 0;
        for (Object[] row : BasicSQLUtils.query(sql)) {
            Integer yr = (Integer)row[0];
            Long cnt = (Long)row[1];
            if (yr != null) {
                if (c > 0) {
                    sb.append(',');
                }
                sb.append(String.format("%d=%d", yr, cnt));
            }
            ++c;
        }
        sb.append("]}");
    }

    private void addEncodedPair(Vector<NameValuePair> stats, String valName, String value) {
        String val = "";
        try {
            val = URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stats.add(new NameValuePair(valName, val));
    }

    private void appendCollectingStats(Vector<NameValuePair> stats) {
        String ALL_YEAR_CATS = "ALL_YEAR_CATS_STAT";
        String LAST_COL_YEAR_STAT = "LAST_COL_YEAR_STAT";
        int currentYear = Calendar.getInstance().get(1);
        AppPreferences remotePrefs = AppPreferences.getRemote();
        int lastColYear = remotePrefs.getInt("LAST_COL_YEAR_STAT", -1);
        boolean doAllYears = remotePrefs.getBoolean("ALL_YEAR_CATS_STAT", true);
        if (lastColYear != currentYear) {
            doAllYears = true;
        }
        StringBuilder allYearsSB = new StringBuilder();
        StringBuilder last30DaysSB = new StringBuilder();
        for (Object[] colRow : BasicSQLUtils.query("SELECT CollectionID,CollectionName,RegNumber FROM collection")) {
            Integer colId = (Integer)colRow[0];
            String colNm = (String)colRow[1];
            String regNum = (String)colRow[2];
            if (doAllYears) {
                String sql = String.format("SELECT YR,COUNT(YR) FROM (SELECT YEAR(if (CatalogedDate IS NULL, TimestampCreated, CatalogedDate)) AS YR FROM collectionobject WHERE CollectionMemberID = %d) T1 GROUP BY YR ORDER BY YR", colId);
                this.collectStatsData(colNm, regNum, sql, allYearsSB);
            }
            String tmp = "SELECT MN, COUNT(MN) FROM (SELECT MONTH(DT) MN, YEAR(DT) YR FROM (SELECT if (CatalogedDate IS NULL, TimestampCreated, CatalogedDate) AS DT FROM collectionobject WHERE CollectionMemberID = %d) T1 WHERE YEAR(DT) = %d) T2 GROUP BY MN";
            String sql = String.format(tmp, colId, currentYear);
            this.collectStatsData(colNm, regNum, sql, last30DaysSB);
        }
        if (doAllYears) {
            this.addEncodedPair(stats, "catbyyr", allYearsSB.toString());
            remotePrefs.putBoolean("ALL_YEAR_CATS_STAT", false);
            remotePrefs.putInt("LAST_COL_YEAR_STAT", currentYear);
        }
        this.addEncodedPair(stats, "catbymn", last30DaysSB.toString());
        Vector<Object[]> instRresults = BasicSQLUtils.query("SELECT Name, RegNumber FROM institution");
        if (instRresults.size() > 0) {
            Object[] instRow = instRresults.get(0);
            String instName = (String)instRow[0];
            String regNum = (String)instRow[1];
            String[] actionStr = new String[]{"ins", "upd", "rmv"};
            int action = 0;
            while (action < 3) {
                StringBuilder auditSB = new StringBuilder();
                String tmp = "SELECT * FROM (SELECT a.TableNum, Count(a.TableNum) as Cnt FROM spauditlog AS a WHERE a.Action = %d GROUP BY a.TableNum) T1 ORDER BY Cnt DESC";
                String sql = String.format(tmp, action);
                this.collectStatsData(instName, regNum, sql, auditSB);
                this.addEncodedPair(stats, "audit_" + actionStr[action], auditSB.toString());
                ++action;
            }
        }
    }

    private void checkTableType(CommandAction cmdActionArg) {
        if (cmdActionArg.getData() instanceof FormDataObjIFace) {
            FormDataObjIFace data = (FormDataObjIFace)cmdActionArg.getData();
            if (this.tablesHash != null && this.tablesHash.get(data.getClass()) != null) {
                this.hasChanged = true;
            }
        }
    }

    private void sendCollectionStats() throws Exception {
        String collStatsCheckURL = UIRegistry.getResourceString("StatsTrackerTask.COLLSTATSURL");
        if (StringUtils.isNotEmpty((String)collStatsCheckURL)) {
            Vector<NameValuePair> stats = this.createPostParameters(false);
            this.appendCollectingStats(stats);
            StatsTrackerTask.sendStats(collStatsCheckURL, stats, this.getClass().getName());
        }
    }

    private void sendActivityStats(boolean isLoggingIn) throws Exception {
        String url = UIRegistry.getResourceString("StatsTrackerTask.ACTIVITYSURL");
        if (StringUtils.isNotEmpty((String)url)) {
            Vector<NameValuePair> stats = this.createPostParameters(false);
            this.appendBasicCollStats(stats);
            stats.add(new NameValuePair("Type", isLoggingIn ? "0" : "1"));
            StatsTrackerTask.sendStats(url, stats, this.getClass().getName());
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart") || cmdAction.isAction("StartUp")) {
            try {
                this.sendActivityStats(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdActionArg) {
        super.doCommand(cmdActionArg);
        if (cmdActionArg.isType(DATABASE)) {
            this.checkTableType(cmdActionArg);
        }
    }
}

