/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.specify.config.FixAttachments;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentManagerIface;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.WebStoreAttachmentMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StartUpTask
extends edu.ku.brc.af.tasks.StartUpTask {
    private static final Logger log = Logger.getLogger(StartUpTask.class);
    private static final String USE_FILE_PATH_PREF = "attachment.use_path";
    private static final String ATTACHMENT_URL_PREF = "attachment.url";
    private static final String ATTACHMENT_PATH_PREF = "attachment.path";
    private static final String WELCOME_BTN_PREF = "StartupTask.OnTaskbar";
    private static final String SPECIFY_SPLASH = "SpecifySplash";
    private ToolBarDropDownBtn welcomeBtn;
    private int indexOfTBB = 0;

    public StartUpTask() {
        CommandDispatcher.register("Preferences", this);
        this.configureAttachmentManager();
    }

    protected void configureAttachmentManager() {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        boolean isUsingPath = localPrefs.getBoolean(USE_FILE_PATH_PREF, true);
        boolean wasOK = false;
        if (!isUsingPath) {
            wasOK = this.configureAttachmentManager(AppPreferences.getGlobalPrefs());
        }
        if (!wasOK) {
            wasOK = this.configureAttachmentManager(localPrefs);
        }
        if (!wasOK) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.showLocalizedError("AttachmentUtils.NOT_AVAIL");
                }
            });
        }
    }

    protected boolean configureAttachmentManager(AppPreferences prefs) {
        Boolean useFilePath = prefs.getBoolean(USE_FILE_PATH_PREF, null);
        String attchURL = prefs.get(ATTACHMENT_URL_PREF, null);
        String filePath = prefs.get(ATTACHMENT_PATH_PREF, null);
        useFilePath = useFilePath == null ? true : useFilePath;
        AttachmentManagerIface attachMgr = null;
        String msgPath = "";
        String errorKey = "NOT_AVAIL";
        if (StringUtils.isNotEmpty((String)attchURL)) {
            useFilePath = false;
            AttachmentUtils.setConfigForPath(useFilePath);
            WebStoreAttachmentMgr webAssetMgr = new WebStoreAttachmentMgr();
            if (webAssetMgr.isInitialized(attchURL)) {
                attachMgr = webAssetMgr;
            }
        } else {
            useFilePath = true;
            File attLoc = null;
            File location = UIRegistry.getAppDataSubDir("AttachmentStorage", true);
            try {
                File file = attLoc = filePath != null && !UIRegistry.isMobile() ? new File(filePath) : location;
                if (!AttachmentUtils.isAttachmentDirMounted(attLoc)) {
                    try {
                        msgPath = attLoc.getCanonicalPath();
                    }
                    catch (IOException e) {
                        msgPath = attLoc.getAbsolutePath();
                    }
                } else {
                    attachMgr = new FileStoreAttachmentManager(attLoc);
                }
                if (filePath == null) {
                    prefs.put(ATTACHMENT_PATH_PREF, location.getAbsolutePath());
                }
            }
            catch (IOException e1) {
                log.warn((Object)("Problems setting the FileStoreAttachmentManager at [" + location + "]"));
                String string = errorKey = useFilePath != false ? "LOC_BAD" : "URL_BAD";
            }
        }
        if (attachMgr == null) {
            final String errKey = errorKey;
            log.warn((Object)("Problems setting the AttachmentManager at [" + msgPath + "]"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.showLocalizedError("AttachmentUtils." + errKey);
                }
            });
        } else {
            prefs.putBoolean(USE_FILE_PATH_PREF, useFilePath);
        }
        AttachmentUtils.setAttachmentManager(attachMgr);
        return true;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        if (AppPreferences.getGlobalPrefs().getBoolean("CHECK_ATTCH_ERR", true).booleanValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FixAttachments fixAttachments = new FixAttachments();
                    fixAttachments.checkForBadAttachments();
                }
            });
        }
        return super.getStarterPane();
    }

    @Override
    public JPanel createSplashPanel() {
        AppPreferences ap = AppPreferences.getLocalPrefs();
        int width = ap.getInt("Startup.Image.width", 400);
        int height = ap.getInt("Startup.Image.height", 700);
        Image img = null;
        ImageIcon bgImg = IconManager.getIcon(SPECIFY_SPLASH);
        img = bgImg.getIconWidth() > width || bgImg.getIconHeight() > height ? GraphicsUtils.getScaledImage(bgImg, width, height, true) : bgImg.getImage();
        JPanel splashPanel = new JPanel(new BorderLayout());
        splashPanel.setOpaque(false);
        splashPanel.add((Component)new JLabel(new ImageIcon(img)), "Center");
        return splashPanel;
    }

    public static SubPaneIFace createFullImageSplashPanel(String title, Taskable task) {
        return new SimpleDescPane(title, task, IconManager.getIcon(SPECIFY_SPLASH));
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        this.welcomeBtn = this.createToolbarButton(UIRegistry.getResourceString("Startup"), "InnerAppIcon", null);
        this.welcomeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpTask.this.requestContext();
            }
        });
        String discipline = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
        boolean hasWelcome = AppPreferences.getRemote().getBoolean(WELCOME_BTN_PREF + discipline, true);
        if (hasWelcome) {
            this.toolbarItems.add(new ToolBarItemDesc(this.welcomeBtn));
        }
        return this.toolbarItems;
    }

    protected void prefsChanged(CommandAction cmdAction) {
        AppPreferences remotePrefs = (AppPreferences)cmdAction.getData();
        if (remotePrefs == AppPreferences.getRemote()) {
            String ds = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
            boolean hasWelcome = remotePrefs.getBoolean("StartupTask.OnTaskbar." + ds, true);
            JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
            if (!hasWelcome) {
                this.indexOfTBB = toolBar.getComponentIndex(this.welcomeBtn);
                TaskMgr.removeToolbarBtn(this.welcomeBtn);
                toolBar.validate();
                toolBar.repaint();
            } else {
                int curInx = toolBar.getComponentIndex(this.welcomeBtn);
                if (curInx == -1) {
                    int inx = this.indexOfTBB != -1 ? this.indexOfTBB : 0;
                    TaskMgr.addToolbarBtn(this.welcomeBtn, inx);
                    toolBar.validate();
                    toolBar.repaint();
                }
                this.welcomeBtn.setIcon(IconManager.getIcon("InnerAppIcon", IconManager.IconSize.Std24));
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isConsumed()) {
            return;
        }
        if (cmdAction.isType("Preferences")) {
            this.prefsChanged(cmdAction);
        }
    }
}

