/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.auth.specify.permission.BasicSpPermission;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.PasswordStrengthUI;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValPasswordField;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.subpane.security.SecurityAdminPane;
import edu.ku.brc.specify.tasks.subpane.security.SecuritySummaryDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SecurityAdminTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(SecurityAdminTask.class);
    public static final String SECURITY_ADMIN = "SecurityAdmin";
    protected SubPaneIFace starterPane = null;

    public SecurityAdminTask() {
        super(SECURITY_ADMIN, UIRegistry.getResourceString(SECURITY_ADMIN));
        CommandDispatcher.register(SECURITY_ADMIN, this);
        this.iconName = "Security";
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
        }
    }

    @Override
    public SubPaneIFace getStarterPane() {
        if (this.starterPane == null && SubPaneMgr.getInstance().aboutToShutdown()) {
            SecurityAdminPane userGroupAdminPane = new SecurityAdminPane(this.title, this);
            userGroupAdminPane.createMainControlUI();
            this.starterPane = userGroupAdminPane;
            TaskMgr.disableAllEnabledTasks();
        }
        return this.starterPane;
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        super.subPaneRemoved(subPane);
        if (this.starterPane != null && (this.starterPane == subPane || this.subPanes.size() == 0)) {
            this.starterPane.shutdown();
            this.starterPane = null;
            TaskMgr.reenableAllDisabledTasks();
            TaskMgr.getTask("Startup").requestContext();
        }
    }

    private void changePassword() {
        final ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "SystemSetup", "ChangePassword", null, UIRegistry.getResourceString(this.getKey("CHG_PWD_TITLE")), "OK", null, null, true, 792);
        dlg.setWhichBtns(3);
        dlg.setFormAdjuster(new FormPane.FormPaneAdjusterIFace(){

            @Override
            public void adjustForm(FormViewObj fvo) {
                ValPasswordField oldPwdVTF = (ValPasswordField)fvo.getCompById("1");
                final ValPasswordField newPwdVTF = (ValPasswordField)fvo.getCompById("2");
                final ValPasswordField verPwdVTF = (ValPasswordField)fvo.getCompById("3");
                final PasswordStrengthUI pwdStrenthUI = (PasswordStrengthUI)fvo.getCompById("4");
                Institution institution = AppContextMgr.getInstance().getClassObject(Institution.class);
                byte minPwdLen = institution.getMinimumPwdLength();
                newPwdVTF.setMinLen(minPwdLen);
                verPwdVTF.setMinLen(minPwdLen);
                pwdStrenthUI.setMinPwdLen(minPwdLen);
                DocumentAdaptor da = new DocumentAdaptor(){

                    @Override
                    protected void changed(DocumentEvent e) {
                        super.changed(e);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String pwdStr = new String(newPwdVTF.getPassword());
                                String verStr = new String(verPwdVTF.getPassword());
                                boolean pwdOK = pwdStrenthUI.checkStrength(pwdStr) && pwdStr.equals(verStr) && newPwdVTF.getState() == UIValidatable.ErrorType.Valid;
                                dlg.getOkBtn().setEnabled(pwdOK);
                                pwdStrenthUI.repaint();
                            }
                        });
                    }
                };
                oldPwdVTF.getDocument().addDocumentListener(da);
                verPwdVTF.getDocument().addDocumentListener(da);
                newPwdVTF.getDocument().addDocumentListener(da);
            }
        });
        Hashtable valuesHash = new Hashtable();
        dlg.setData(valuesHash);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            String newPwd2;
            int pwdLen = 6;
            String oldPwd = (String)valuesHash.get("OldPwd");
            String newPwd1 = (String)valuesHash.get("NewPwd1");
            if (newPwd1.equals(newPwd2 = (String)valuesHash.get("NewPwd2"))) {
                if (newPwd1.length() >= pwdLen) {
                    SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                    String spuOldPwd = spUser.getPassword();
                    String newEncryptedPwd = null;
                    String oldDecryptedPwd = Encryption.decrypt(spuOldPwd, oldPwd);
                    if (oldDecryptedPwd != null && oldDecryptedPwd.equals(oldPwd)) {
                        newEncryptedPwd = Encryption.encrypt(newPwd2, newPwd2);
                        spUser.setPassword(newEncryptedPwd);
                        if (!DataModelObjBase.save(spUser)) {
                            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(this.getKey("PWD_ERR_SAVE")), Color.RED);
                        }
                    } else {
                        UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(this.getKey("PWD_ERR_BAD")), Color.RED);
                    }
                    if (newEncryptedPwd != null) {
                        Pair<String, String> masterPwd = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
                        String encryptedMasterUP = UserAndMasterPasswordMgr.encrypt((String)masterPwd.first, (String)masterPwd.second, newPwd2);
                        if (StringUtils.isNotEmpty((String)encryptedMasterUP)) {
                            AppPreferences.getLocalPrefs().put(UserAndMasterPasswordMgr.getInstance().getMasterPrefPath(true), encryptedMasterUP);
                            UIHelper.setTextToClipboard(encryptedMasterUP);
                            UIRegistry.showLocalizedMsg(1, "INFORMATION", "SPUSR_KEYGEN", new Object[0]);
                        } else {
                            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(this.getKey("PWD_ERR_RTRV")), Color.RED);
                        }
                    } else {
                        UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(this.getKey("PWD_ERR_BAD")), Color.RED);
                    }
                } else {
                    UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getFormattedResStr(this.getKey("PWD_ERR_LEN"), pwdLen), Color.RED);
                }
            } else {
                UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(this.getKey("PWD_ERR_NOTSAME")), Color.RED);
            }
        }
    }

    private String getKey(String key) {
        return "SecurityAdminTask." + key;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        MenuItemDesc mid;
        this.menuItems = new Vector();
        String menuTitle = this.getKey("SHOW_SECURITY_SUMMARY_MENU");
        String mneu = this.getKey("SHOW_SECURITY_SUMMARY_MNEU");
        String desc = this.getKey("SHOW_SECURITY_SUMMARY_DESC");
        JMenuItem mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SecuritySummaryDlg dlg = new SecuritySummaryDlg(null);
                dlg.setVisible(true);
            }
        });
        String menuDesc = "Specify.SYSTEM_MENU/Specify.COLSETUP_MENU";
        MenuItemDesc showSummaryMenuDesc = new MenuItemDesc(mi, menuDesc);
        showSummaryMenuDesc.setPosition(MenuItemDesc.Position.After, UIRegistry.getResourceString(this.getKey("SECURITY_TOOLS_MENU")));
        String securityName = this.buildTaskPermissionName(SECURITY_ADMIN);
        if (!AppContextMgr.isSecurityOn() || SecurityMgr.getInstance().checkPermission(securityName, BasicSpPermission.view)) {
            menuTitle = this.getKey("SECURITY_TOOLS_MENU");
            mneu = this.getKey("SECURITY_TOOLS_MNEU");
            desc = this.getKey("SECURITY_TOOLS_DESC");
            mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (SubPaneMgr.getInstance().aboutToShutdown()) {
                        SecurityAdminTask.this.requestContext();
                    }
                }
            });
            mid = new MenuItemDesc(mi, menuDesc);
            mid.setPosition(MenuItemDesc.Position.After, UIRegistry.getResourceString("SystemSetupTask.COLL_CONFIG"));
            this.menuItems.add(mid);
            this.menuItems.add(showSummaryMenuDesc);
        }
        menuTitle = this.getKey("MASTER_PWD_MENU");
        mneu = this.getKey("MASTER_PWD_MNEU");
        desc = this.getKey("MASTER_PWD_DESC");
        mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                UserAndMasterPasswordMgr.getInstance().editMasterInfo(spUser.getName(), DBConnection.getInstance().getDatabaseName(), true);
            }
        });
        mid = new MenuItemDesc(mi, UIHelper.isMacOS() ? "HELP" : "HELP/ABOUT", UIHelper.isMacOS() ? MenuItemDesc.Position.Bottom : MenuItemDesc.Position.Before);
        this.menuItems.add(mid);
        menuTitle = this.getKey("CHANGE_PWD_MENU");
        mneu = this.getKey("CHANGE_PWD_MNEU");
        desc = this.getKey("CHANGE_PWD_DESC");
        mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SecurityAdminTask.this.changePassword();
            }
        });
        mid = new MenuItemDesc(mi, mid.getMenuPath(), UIHelper.isMacOS() ? MenuItemDesc.Position.Bottom : MenuItemDesc.Position.Before);
        this.menuItems.add(mid);
        return this.menuItems;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        String securityName = this.buildTaskPermissionName(SECURITY_ADMIN);
        if ((!AppContextMgr.isSecurityOn() || SecurityMgr.getInstance().checkPermission(securityName, BasicSpPermission.view)) && AppPreferences.getLocalPrefs().getBoolean("SEC_TOOLBAR", false).booleanValue()) {
            this.toolbarItems = new Vector();
            this.toolbarItems.add(new ToolBarItemDesc(this.createToolbarButton("Security", this.iconName, "")));
        }
        return this.toolbarItems;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(SECURITY_ADMIN)) {
            this.processAdminCommands(cmdAction);
        }
    }

    void processAdminCommands(CommandAction cmdAction) {
        log.error((Object)"not implemented");
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel(SECURITY_ADMIN, "ENABLE", null, null, null);
    }

    @Override
    protected boolean[][] getPermsArray() {
        return new boolean[][]{{true, true, true, true}, new boolean[4], new boolean[4], new boolean[4]};
    }
}

