/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.sgr.datamodel.BatchMatchResultSet;
import edu.ku.brc.sgr.datamodel.DataModel;
import edu.ku.brc.sgr.datamodel.MatchConfiguration;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.plugins.sgr.BatchResultPropertyEditor;
import edu.ku.brc.specify.plugins.sgr.BatchResultsMgr;
import edu.ku.brc.specify.plugins.sgr.HistogramChart;
import edu.ku.brc.specify.plugins.sgr.RecordSetBatchMatch;
import edu.ku.brc.specify.plugins.sgr.SGRBatchScenario;
import edu.ku.brc.specify.plugins.sgr.SGRMatcherUI;
import edu.ku.brc.specify.plugins.sgr.SGRPluginImpl;
import edu.ku.brc.specify.plugins.sgr.WorkBenchBatchMatch;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tasks.WorkbenchEditorCreator;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class SGRTask
extends BaseTask {
    public static final int GLASSPANE_FONT_SIZE = 20;
    public static final DataFlavor TOOLS_FLAVOR = new DataFlavor(SGRTask.class, "SGRTask");
    public static final DataFlavor BATCH_RESULTS_FLAVOR = new DataFlavor(BatchMatchResultSet.class, "Batch Match Results");
    private static final DataFlavor MATCHER_FLAVOR = new DataFlavor(MatchConfiguration.class, "SGR Matcher");
    public static final String SGR = "SGR";
    public static final String EXPORT_RS = "ExportRecordSet";
    public static final String EXPORT_LIST = "ExportList";
    public static final String EXPORT_JTABLE = "ExportJTable";
    private static final String SGR_PROCESS = "SGR.Process";
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected ToolBarDropDownBtn toolBarBtn = null;
    protected Vector<NavBoxItemIFace> toolsNavBoxList = new Vector();
    private NavBox batchMatchResultsBox;
    private NavBox matchersNavBox;
    protected NavBox workbenchNavBox;

    public SGRTask() {
        super(SGR, UIRegistry.getResourceString(SGR));
        CommandDispatcher.register(SGR, this);
        CommandDispatcher.register("App", this);
    }

    private void loadDefaultMatchers() {
        Discipline disc = AppContextMgr.getInstance().getClassObject(Discipline.class);
        File file = XMLHelper.getConfigDir(String.valueOf(disc.getType()) + File.separator + "default_sgr_matchers.xml");
        if (file.exists()) {
            Collection mcs = DataModel.importMatchConfigurations((File)file);
            edu.ku.brc.specify.datamodel.Collection coll = AppContextMgr.getInstance().getClassObject(edu.ku.brc.specify.datamodel.Collection.class);
            Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
            String fq = "-institution_code:\"" + inst.getCode() + "\" -collection_code:\"" + coll.getCode() + "\"";
            for (MatchConfiguration mc : mcs) {
                mc.updateFilterQuery(fq);
            }
            AppPreferences.getRemote().putBoolean("SGR_DEFAULT_MATCHERS_LOADED", true);
        }
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            DataModel.startDbSession((Function)new Function<Object, Connection>(){

                public Connection apply(Object arg0) {
                    return DBConnection.getInstance().createConnection();
                }
            });
            this.toolsNavBoxList.clear();
            if (this.isVisible) {
                UIRegistry.loadAndPushResourceBundle("specify_plugins");
                this.extendedNavBoxes.clear();
                this.matchersNavBox = this.makeMatchersNavBox();
                this.navBoxes.add(this.matchersNavBox);
                this.batchMatchResultsBox = this.makeBatchResultsNavBox();
                this.navBoxes.add(this.batchMatchResultsBox);
                WorkbenchTask wbTask = (WorkbenchTask)ContextMgr.getTaskByClass(WorkbenchTask.class);
                this.workbenchNavBox = wbTask.datasetNavBoxMgr.createWorkbenchNavBox(SGR);
                UIRegistry.popResourceBundle();
            }
        }
        this.isShowDefault = true;
    }

    private NavBox makeMatchersNavBox() {
        NavBox matchersBox = new NavBox(UIRegistry.getResourceString("SGR_MATCHERS_TITLE"));
        this.fillMatchersNavBox(matchersBox);
        return matchersBox;
    }

    private void fillMatchersNavBox(NavBox matchersBox) {
        Object object;
        List matchers = DataModel.getMatcherConfigurations();
        for (MatchConfiguration mc : matchers) {
            object = this.addMatcherToNavBox(mc, matchersBox, true);
        }
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        RolloverCommand createMatcherBtn = (RolloverCommand)((Object)SGRTask.makeDnDNavBtn(matchersBox, UIRegistry.getResourceString("SGR_CREATE_MATCHER"), "PlusSign", new CommandAction(SGR, "new_matcher"), null, false, false));
        if (AppPreferences.getLocalPrefs().getBoolean("ENABLE_SGR_MATCHER_IMPORT_EXPORT", false).booleanValue()) {
            RolloverCommand exportMatcherBtn = (RolloverCommand)((Object)SGRTask.makeDnDNavBtn(matchersBox, UIRegistry.getResourceString("SGR_EXPORT_MATCHER"), "PlusSign", new CommandAction(SGR, "export_matcher"), null, false, false));
            exportMatcherBtn.addDropDataFlavor(MATCHER_FLAVOR);
            object = (RolloverCommand)((Object)SGRTask.makeDnDNavBtn(matchersBox, UIRegistry.getResourceString("SGR_IMPORT_MATCHERS"), "PlusSign", new CommandAction(SGR, "import_matchers"), null, false, false));
        }
        UIRegistry.popResourceBundle();
    }

    private NavBoxItemIFace addMatcherToNavBox(MatchConfiguration mc, NavBox nb, boolean addSorted) {
        final NavBoxItemIFace nbi = SGRTask.makeDnDNavBtn(nb, mc.name(), "SGRMatchers", null, new CommandAction(SGR, SGR_PROCESS, mc, null, mc), null, true, 0, addSorted);
        nbi.setData(mc);
        ((RolloverCommand)((Object)nbi)).addDragDataFlavor(MATCHER_FLAVOR);
        JPopupMenu popupMenu = new JPopupMenu();
        UIHelper.createLocalizedMenuItem(popupMenu, "SGR_EDIT_MATCH_CONFIGURATION", "", null, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SGRMatcherUI mui = SGRMatcherUI.dialogForEditing((Frame)UIRegistry.getTopWindow(), nbi);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        mui.setVisible(true);
                    }
                });
            }
        });
        if (this.permissions == null || this.permissions.canDelete()) {
            CommandAction delCmdAction = new CommandAction(SGR, "Delete", nbi);
            ((NavBoxButton)nbi).setDeleteCommandAction(delCmdAction);
            ((RolloverCommand)((Object)nbi)).addDragDataFlavor(Trash.TRASH_FLAVOR);
        }
        ((RolloverCommand)((Object)nbi)).setPopupMenu(popupMenu);
        ((RolloverCommand)((Object)nbi)).addDropDataFlavor(RecordSetTask.RECORDSET_FLAVOR);
        ((RolloverCommand)((Object)nbi)).addDropDataFlavor(WorkbenchTask.DATASET_FLAVOR);
        return nbi;
    }

    private NavBox makeBatchResultsNavBox() {
        NavBox batchResultsBox = new NavBox(UIRegistry.getResourceString("SGR_BATCH_RESULTS"));
        List resultSets = DataModel.getBatchMatchResultSets();
        for (BatchMatchResultSet rs : resultSets) {
            BatchResultsMgr nbi = new BatchResultsMgr(rs, this.permissions);
            batchResultsBox.insertSorted(nbi);
        }
        RolloverCommand createBatchBtn = (RolloverCommand)((Object)SGRTask.makeDnDNavBtn(batchResultsBox, UIRegistry.getResourceString("SGR_DO_BATCH"), "PlusSign", new CommandAction(SGR, "do_batch"), null, false, false));
        createBatchBtn.addDropDataFlavor(RecordSetTask.RECORDSET_FLAVOR);
        createBatchBtn.addDropDataFlavor(WorkbenchTask.DATASET_FLAVOR);
        return batchResultsBox;
    }

    private void setEnableBatchBtnForWorkbench(Workbench workbench, boolean enabled) {
        for (NavBoxItemIFace nbi : this.batchMatchResultsBox.getItems()) {
            BatchMatchResultSet resultSet;
            try {
                resultSet = (BatchMatchResultSet)nbi.getData();
            }
            catch (ClassCastException e) {
                continue;
            }
            if (workbench.getId() == null || resultSet.getRecordSetId() != (long)workbench.getId().intValue()) continue;
            nbi.setEnabled(enabled);
        }
    }

    @Override
    public void requestContext() {
        ContextMgr.requestContext(this);
        if (this.starterPane == null) {
            super.requestContext();
        } else {
            SubPaneMgr.getInstance().showPane(this.starterPane);
        }
        UsageTracker.incrUsageCount("SGR.StartSGR");
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        if (subPane == this.starterPane) {
            this.starterPane = null;
        }
    }

    @Override
    public SubPaneIFace getStarterPane() {
        if (this.starterPane == null) {
            this.starterPane = StartUpTask.createFullImageSplashPanel(this.title, this);
        }
        return this.starterPane;
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        this.extendedNavBoxes.add(this.workbenchNavBox);
        return this.extendedNavBoxes;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        String label = UIRegistry.getResourceString(SGR);
        String hint = UIRegistry.getResourceString("export_hint");
        this.toolBarBtn = this.createToolbarButton(label, this.iconName, hint);
        this.toolbarItems = new Vector();
        this.toolbarItems.add(new ToolBarItemDesc(this.toolBarBtn));
        return this.toolbarItems;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        this.menuItems = new Vector();
        String menuDesc = "Specify.SYSTEM_MENU";
        if (this.permissions == null || this.permissions.canModify()) {
            String menuTitle = "SGRTask.PLUGIN_MENU";
            String mneu = "SGRTask.PLUGIN_MNEU";
            String desc = "SGRTask.PLUGIN_DESC";
            JMenuItem mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SGRTask.this.requestContext();
                }
            });
            MenuItemDesc miDesc = new MenuItemDesc(mi, menuDesc);
            miDesc.setPosition(MenuItemDesc.Position.Bottom);
            miDesc.setSepPosition(MenuItemDesc.Position.Before);
            this.menuItems.add(miDesc);
        }
        return this.menuItems;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(SGR)) {
            BatchMatchResultSet resultSet;
            Workbench workbench;
            if (cmdAction.isAction(SGR_PROCESS)) {
                this.processCommand(cmdAction);
            } else if (cmdAction.isAction("new_matcher")) {
                this.createNewMatcher();
            } else if (cmdAction.isAction("export_matcher")) {
                this.exportMatchers(cmdAction);
            } else if (cmdAction.isAction("import_matchers")) {
                this.importMatchers();
            } else if (cmdAction.isAction("do_batch")) {
                this.doBatchMatch(cmdAction);
            } else if (cmdAction.isAction("Delete")) {
                NavBoxItemIFace nbi = (NavBoxItemIFace)cmdAction.getData();
                Object toDelete = nbi.getData();
                if (toDelete instanceof BatchMatchResultSet) {
                    this.deleteBatchMatchResultSet(nbi);
                } else if (toDelete instanceof MatchConfiguration) {
                    this.deleteMatchConfiguration(nbi);
                }
            } else if (cmdAction.isAction("WB.SelectedWorkbench")) {
                Object cmdData = cmdAction.getData();
                Workbench workbench2 = null;
                workbench2 = cmdData instanceof RecordSetIFace ? WorkbenchTask.loadWorkbench((RecordSetIFace)cmdData) : WorkbenchTask.loadWorkbench((RecordSetIFace)cmdAction.getProperty("workbench"));
                if (workbench2 != null) {
                    this.createEditorForWorkbench(workbench2, null, false, true, null, null);
                }
            } else if (cmdAction.isAction("selected_resultset") && (workbench = WorkbenchTask.loadWorkbench((int)(resultSet = (BatchMatchResultSet)cmdAction.getData()).getRecordSetId().longValue(), null)) != null) {
                this.createEditorForWorkbench(workbench, null, false, true, null, resultSet);
            }
        } else if (cmdAction.isType("Preferences")) {
            this.prefsChanged(cmdAction);
        } else if (cmdAction.isType("App")) {
            if (cmdAction.isAction("AppRestart")) {
                this.loadDefaultMatchers();
                this.matchersNavBox.clear();
                this.fillMatchersNavBox(this.matchersNavBox);
            } else if (cmdAction.isAction("StartUp")) {
                this.loadDefaultMatchers();
            }
        }
    }

    private void createNewMatcher() {
        try {
            final SGRMatcherUI mui = SGRMatcherUI.dialogForNewConfig((Frame)UIRegistry.getTopWindow(), new Function<MatchConfiguration, Void>(){

                public Void apply(MatchConfiguration mc) {
                    UIRegistry.loadAndPushResourceBundle("specify_plugins");
                    SGRTask.this.addMatcherToNavBox(mc, SGRTask.this.matchersNavBox, false);
                    UIRegistry.popResourceBundle();
                    NavBox.refresh(SGRTask.this.matchersNavBox);
                    return null;
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mui.setVisible(true);
                }
            });
            UsageTracker.incrUsageCount("SGR.NewMatcher");
        }
        catch (SGRMatcherUI.AvailableIndicesFetchException e) {
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            UIRegistry.showLocalizedError("SGR_ERROR_SERVER_FAILED_GETTING_INDICES");
            UIRegistry.popResourceBundle();
        }
    }

    private void importMatchers() {
        JFileChooser chooser = new JFileChooser(WorkbenchTask.getDefaultDirPath("wb.exportfilepath"));
        chooser.setDialogTitle(UIRegistry.getResourceString("SGR_CHOOSE_MATCHER_IMPORT_FILE"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(UIRegistry.get("frame")) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        Collection mcs = DataModel.importMatchConfigurations((File)file);
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        for (MatchConfiguration matchConfiguration : mcs) {
            this.addMatcherToNavBox(matchConfiguration, this.matchersNavBox, false);
        }
        UIRegistry.popResourceBundle();
        NavBox.refresh(this.matchersNavBox);
    }

    private void exportMatchers(CommandAction cmdAction) {
        List mcs;
        if (cmdAction.getData() == cmdAction) {
            mcs = DataModel.getMatcherConfigurations();
            ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString("SGR_CHOOSE_MATCHERS_TO_EXPORT"), mcs);
            dlg.setMultiSelect(true);
            UIHelper.centerAndShow(dlg);
            if (dlg.isCancelled()) {
                return;
            }
            mcs = dlg.getSelectedObjects();
        } else {
            mcs = ImmutableList.of((Object)((MatchConfiguration)cmdAction.getData()));
        }
        JFileChooser chooser = new JFileChooser(WorkbenchTask.getDefaultDirPath("wb.exportfilepath"));
        chooser.setDialogTitle(UIRegistry.getResourceString("CHOOSE_MATCHER_EXPORT_FILE"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showSaveDialog(UIRegistry.get("frame")) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(DataModel.exportMatchConfigurations(mcs).toString());
            fw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processCommand(CommandAction cmdAction) {
        Workbench workbench;
        MatchConfiguration selectedMatcher;
        if (cmdAction.getData() instanceof MatchConfiguration) {
            selectedMatcher = (MatchConfiguration)cmdAction.getData();
            workbench = WorkbenchTask.selectWorkbench(cmdAction, null);
        } else {
            selectedMatcher = (MatchConfiguration)cmdAction.getSrcObj();
            workbench = WorkbenchTask.selectWorkbench((CommandAction)cmdAction.getData(), "sgr_matcher_create");
        }
        this.createEditorForWorkbench(workbench, null, false, true, selectedMatcher, null);
    }

    protected void createEditorForWorkbench(Workbench workbench, DataProviderSessionIFace session, boolean showImageView, boolean doInbackground, final MatchConfiguration matchConfiguration, final BatchMatchResultSet resultSet) {
        if (workbench == null) {
            return;
        }
        final SimpleGlassPane glassPane = doInbackground ? UIRegistry.writeSimpleGlassPaneMsg(String.format(UIRegistry.getResourceString("WB_LOADING_DATASET"), workbench.getName()), 20) : null;
        WorkbenchTask wbTask = (WorkbenchTask)ContextMgr.getTaskByClass(WorkbenchTask.class);
        WorkbenchEditorCreator wbec = new WorkbenchEditorCreator(workbench, session, showImageView, this, !wbTask.isPermitted()){

            @Override
            public void progressUpdated(List<Integer> chunks) {
                if (glassPane != null) {
                    glassPane.setProgress(chunks.get(chunks.size() - 1));
                }
            }

            @Override
            public void completed(WorkbenchPaneSS workbenchPane) {
                SGRTask.this.addSubPaneToMgr(workbenchPane);
                if (resultSet != null) {
                    SGRPluginImpl sgr = (SGRPluginImpl)workbenchPane.getPlugin(SGRPluginImpl.class);
                    sgr.setBatchMatchResults(resultSet);
                } else if (matchConfiguration != null) {
                    SGRPluginImpl sgr = (SGRPluginImpl)workbenchPane.getPlugin(SGRPluginImpl.class);
                    sgr.setMatcherConfiguration(matchConfiguration);
                    workbenchPane.showPanel(WorkbenchPaneSS.PanelType.Form);
                }
                if (glassPane != null) {
                    UIRegistry.clearSimpleGlassPaneMsg();
                }
                if (workbenchPane != null && workbenchPane.isDoIncremental()) {
                    workbenchPane.validateAll(null);
                }
            }
        };
        if (doInbackground) {
            wbec.runInBackground();
        } else {
            wbec.runInForeground();
        }
    }

    public void opening(WorkbenchPaneSS pane) {
        if (this.workbenchNavBox == null) {
            return;
        }
        Workbench workbench = pane.getWorkbench();
        RolloverCommand roc = WorkbenchTask.getNavBtnById(this.workbenchNavBox, workbench.getWorkbenchId(), "workbench");
        if (roc != null) {
            roc.setEnabled(false);
        }
        this.setEnableBatchBtnForWorkbench(workbench, false);
    }

    public void closing(SubPaneIFace pane) {
        RolloverCommand roc;
        Workbench workbench;
        try {
            workbench = ((WorkbenchPaneSS)pane).getWorkbench();
        }
        catch (ClassCastException e) {
            return;
        }
        this.setEnableBatchBtnForWorkbench(workbench, true);
        if (workbench != null && (roc = WorkbenchTask.getNavBtnById(this.workbenchNavBox, workbench.getWorkbenchId(), "workbench")) != null) {
            roc.setEnabled(true);
        }
    }

    public void deleteResultsForWorkbench(Workbench workbench) {
        ImmutableList nbis = ImmutableList.copyOf(this.batchMatchResultsBox.getItems());
        for (NavBoxItemIFace nbi : nbis) {
            BatchMatchResultSet resultSet;
            try {
                resultSet = (BatchMatchResultSet)nbi.getData();
            }
            catch (ClassCastException e) {
                continue;
            }
            if (resultSet.getRecordSetId() != (long)workbench.getId().intValue()) continue;
            this.deleteBatchMatchResultSet(nbi);
        }
    }

    private ChooseFromListDlg<MatchConfiguration> makeSelectMatcherDlg() {
        List mcs = DataModel.getMatcherConfigurations();
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        String title = UIRegistry.getResourceString("SGR_SELECT_MATCHER");
        UIRegistry.popResourceBundle();
        ChooseFromListDlg<MatchConfiguration> selectMatcherDlg = new ChooseFromListDlg<MatchConfiguration>((Frame)UIRegistry.get("frame"), title, 7, mcs);
        selectMatcherDlg.setHelpContext("sgr_matchresults_matcher");
        UIHelper.centerAndShow(selectMatcherDlg);
        return selectMatcherDlg;
    }

    private void doBatchMatch(CommandAction cmdAction) {
        SGRBatchScenario scenario = null;
        if (cmdAction.getData() instanceof RecordSetIFace) {
            ChooseFromListDlg<MatchConfiguration> selectMatcherDlg = this.makeSelectMatcherDlg();
            if (selectMatcherDlg.isCancelled()) {
                return;
            }
            MatchConfiguration matchConfig = selectMatcherDlg.getSelectedObject();
            RecordSetIFace recordSet = (RecordSetIFace)cmdAction.getData();
            scenario = RecordSetBatchMatch.newScenario(recordSet, matchConfig);
        } else if (cmdAction.getData() instanceof CommandAction) {
            CommandAction internal = (CommandAction)cmdAction.getData();
            if (internal.getAction().equals("WB.SelectedWorkbench")) {
                ChooseFromListDlg<MatchConfiguration> selectMatcherDlg = this.makeSelectMatcherDlg();
                if (selectMatcherDlg.isCancelled()) {
                    return;
                }
                MatchConfiguration matchConfig = selectMatcherDlg.getSelectedObject();
                RecordSetIFace recordSet = (RecordSetIFace)internal.getProperty("workbench");
                scenario = WorkBenchBatchMatch.newScenario(recordSet, matchConfig);
            } else {
                Workbench workbench = WorkbenchTask.selectWorkbench(cmdAction, "sgr_matchresults_matcher");
                if (workbench == null) {
                    return;
                }
                ChooseFromListDlg<MatchConfiguration> selectMatcherDlg = this.makeSelectMatcherDlg();
                if (selectMatcherDlg.isCancelled()) {
                    return;
                }
                MatchConfiguration matchConfig = selectMatcherDlg.getSelectedObject();
                scenario = WorkBenchBatchMatch.newScenario(workbench.getId(), matchConfig);
            }
        }
        if (scenario != null) {
            BatchMatchResultSet resultSet = scenario.getResultSet();
            scenario.start();
            BatchResultsMgr nbi = new BatchResultsMgr(resultSet, scenario, this.permissions);
            this.batchMatchResultsBox.insert(nbi, true, false, 0);
            final BatchResultPropertyEditor editor = new BatchResultPropertyEditor(nbi);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    editor.setVisible(true);
                }
            });
            UsageTracker.incrUsageCount("SGR.BatchMatch");
        }
    }

    protected void deleteBatchMatchResultSet(NavBoxItemIFace nbi) {
        ((BatchResultsMgr)nbi).delete();
        this.deleteDnDBtn(this.batchMatchResultsBox, nbi);
    }

    protected void deleteMatchConfiguration(NavBoxItemIFace nbi) {
        MatchConfiguration mc = (MatchConfiguration)nbi.getData();
        for (SubPaneIFace pane : SubPaneMgr.getInstance().getSubPanes()) {
            WorkbenchPaneSS workbenchPane;
            try {
                workbenchPane = (WorkbenchPaneSS)pane;
            }
            catch (ClassCastException e) {
                continue;
            }
            SGRPluginImpl sgr = (SGRPluginImpl)workbenchPane.getPlugin(SGRPluginImpl.class);
            if (sgr.getMatcher() != mc) continue;
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            UIRegistry.showLocalizedError("SGR_CANT_DELETE_OPEN_MATCHER");
            UIRegistry.popResourceBundle();
            return;
        }
        try {
            mc.delete();
        }
        catch (RuntimeException e) {
            if (!Pattern.compile("foreign key constraint fails").matcher(e.getMessage()).find()) {
                throw e;
            }
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            UIRegistry.showLocalizedError("SGR_CANT_DELETE_MATCHER");
            UIRegistry.popResourceBundle();
            return;
        }
        this.deleteDnDBtn(this.matchersNavBox, nbi);
    }

    public void addHistogram(BatchMatchResultSet resultSet, SGRBatchScenario scenario, float f) {
        HistogramChart histoPane = new HistogramChart(resultSet.name(), this, resultSet, scenario, f);
        this.addSubPaneToMgr(histoPane);
        UsageTracker.incrUsageCount("SGR.Histogram");
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel(SGR, "ENABLE", null, null, null);
    }

    protected void prefsChanged(CommandAction cmdAction) {
        Object value;
        AppPreferences appPrefs = (AppPreferences)cmdAction.getData();
        if (appPrefs == AppPreferences.getRemote() && (value = cmdAction.getProperties().get("SGRtask.OnTaskbar")) != null && value instanceof Boolean) {
            JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
            Boolean isChecked = (Boolean)value;
            if (isChecked.booleanValue()) {
                TaskMgr.addToolbarBtn(this.toolBarBtn, toolBar.getComponentCount() - 1);
            } else {
                TaskMgr.removeToolbarBtn(this.toolBarBtn);
            }
            toolBar.validate();
            toolBar.repaint();
        }
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }
}

