/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskCommandDef;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.PageSetupDlg;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.ReportsTask;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.LabelsPane;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.specify.tasks.subpane.qb.SearchResultReportServiceInfo;
import edu.ku.brc.specify.tools.ireportspecify.MainFrameSpecify;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostActionableDropManager;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import edu.ku.brc.ui.dnd.Trash;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReportsBaseTask
extends BaseTask {
    protected static final Logger log = Logger.getLogger(ReportsBaseTask.class);
    public static final String REPORTS = "Reports";
    public static final String REPORTS_MIME = "jrxml/report";
    public static final String LABELS_MIME = "jrxml/label";
    public static final String SUBREPORTS_MIME = "jrxml/subreport";
    public static final String RECORDSET_PARAM = "itemnum";
    public static final String NEWRECORDSET_ACTION = "RPT.NewRecordSet";
    public static final String PRINT_REPORT = "RPT.PrintReport";
    public static final String OPEN_EDITOR = "RPT.OpenEditor";
    public static final String RUN_REPORT = "RPT.RunReport";
    public static final String REFRESH = "RPT.Refresh";
    public static final String IMPORT = "RPT.Import";
    public static final String REPORT_DELETED = "RPT.ReportDeleted";
    public static final String PRINT_GRID = "RPT.PrintTable";
    protected DataFlavor defaultFlavor = null;
    protected DataFlavor reportFlavor = new DataFlavor(SpReport.class, "SpReport");
    protected DataFlavor runReportFlavor = new DataFlavor(SpReport.class, "RPT.RunReport");
    protected List<Pair<String, String>> navMimeDefs = null;
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected Vector<NavBoxItemIFace> reportsList = new Vector();
    protected NavBox actionNavBox = null;
    protected NavBox reportsNavBox = null;
    protected NavBox labelsNavBox = null;
    protected String reportHintKey = "REPORT_TT";
    protected NavBoxItemIFace oneNbi = null;

    public ReportsBaseTask(String name, String title) {
        super(name, title);
        this.isShowDefault = true;
    }

    @Override
    public void preInitialize() {
        CommandDispatcher.register(REPORTS, this);
        CommandDispatcher.register("Record_Set", this);
        this.actionNavBox = new NavBox(UIRegistry.getResourceString("Actions"));
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            CommandAction cmdAction = new CommandAction(REPORTS, PRINT_GRID);
            ContextMgr.registerService(20, PRINT_GRID, -1, cmdAction, this, "Print", UIRegistry.getResourceString("PRINT_GRID_TT"));
            this.extendedNavBoxes.clear();
            this.reportsList.clear();
            this.navBoxes.add(this.actionNavBox);
            if (this.isVisible) {
                this.addROCs();
            }
        }
    }

    protected List<TaskCommandDef> getAppResCommandsByMimeType(String mimeType, String reportType, String defaultIcon, Integer classTableId) {
        LinkedList<TaskCommandDef> result = new LinkedList<TaskCommandDef>();
        Vector<Integer> excludedTableIds = new Vector<Integer>();
        excludedTableIds.add(79);
        Vector<String> subReports = new Vector<String>();
        for (AppResourceIFace ap : AppContextMgr.getInstance().getResourceByMimeType(mimeType)) {
            String localIconName;
            Properties params = ap.getMetaDataMap();
            String tableid = params.getProperty("tableid");
            if (!StringUtils.isNotEmpty((String)tableid)) continue;
            String subReps = params.getProperty("subreports");
            if (subReps != null) {
                String[] subRepNames;
                String[] stringArray = subRepNames = StringUtils.split((String)subReps, (String)",");
                int n = subRepNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String subRepName = stringArray[n2];
                    subReports.add(subRepName.trim());
                    ++n2;
                }
            }
            String rptType = params.getProperty("reporttype");
            Integer tblId = Integer.parseInt(tableid);
            if (excludedTableIds.indexOf(tblId) != -1 || classTableId != null && !tblId.equals(classTableId) || !StringUtils.isEmpty((String)reportType) && (!StringUtils.isNotEmpty((String)rptType) || !reportType.equals(rptType))) continue;
            params.put("name", ap.getName());
            params.put("title", ap.getDescription() == null ? ap.getName() : ap.getDescription());
            params.put("file", ap.getName());
            params.put("mimetype", mimeType);
            Object param = params.get("isimport");
            if (param != null && param.equals("1")) {
                params.put("appresource", ap);
            }
            if ((param = params.get("hasrsdropparam")) != null) {
                params.put(RECORDSET_PARAM, param);
            }
            if (StringUtils.isEmpty((String)(localIconName = params.getProperty("icon")))) {
                localIconName = defaultIcon;
            }
            result.add(new TaskCommandDef(ap.getDescription(), localIconName, params));
        }
        if (subReports.size() > 0) {
            int r = result.size() - 1;
            while (r >= 0) {
                TaskCommandDef def = (TaskCommandDef)result.get(r);
                if (subReports.indexOf(def.getName()) != -1) {
                    result.remove(r);
                }
                --r;
            }
        }
        return result;
    }

    protected void addROCs() {
        for (Pair<String, String> navMime : this.navMimeDefs) {
            NavBox navBox;
            if (navMime.getSecond().equals(REPORTS_MIME)) {
                if (this.reportsNavBox == null) {
                    this.reportsNavBox = new NavBox(navMime.getFirst());
                }
                navBox = this.reportsNavBox;
            } else if (navMime.getSecond().equals(LABELS_MIME)) {
                if (this.labelsNavBox == null) {
                    this.labelsNavBox = new NavBox(navMime.getFirst());
                }
                navBox = this.labelsNavBox;
            } else {
                navBox = new NavBox(navMime.getFirst());
            }
            List<TaskCommandDef> cmds = this.getAppResCommandsByMimeType(navMime.getSecond(), "Report", navMime.getFirst(), null);
            cmds.addAll(this.getAppResCommandsByMimeType(navMime.getSecond(), "Invoice", navMime.getFirst(), null));
            for (TaskCommandDef tcd : cmds) {
                DBTableInfo tblFo;
                String tableIdStr = tcd.getParams().getProperty("tableid");
                if (tableIdStr == null) continue;
                boolean makeROC = true;
                if (AppContextMgr.isSecurityOn() && (tblFo = DBTableIdMgr.getInstance().getInfoById(Integer.valueOf(tableIdStr))) != null) {
                    makeROC = tblFo.getPermissions().canView();
                }
                if (!makeROC) continue;
                this.makeROCForCommand(tcd, navBox);
            }
            this.navBoxes.add(navBox);
            this.commands.addAll(cmds);
        }
    }

    protected RolloverCommand makeROCForCommand(TaskCommandDef tcd, NavBox navBox) {
        DataFlavorTableExt dfx;
        boolean canBeRsDropSite;
        CommandAction cmdAction = new CommandAction(REPORTS, PRINT_REPORT, tcd.getParams().getProperty("tableid"));
        cmdAction.addProperties(tcd.getParams());
        cmdAction.getProperties().put("icon", IconManager.getIcon(tcd.getIconName(), IconManager.IconSize.Std16));
        cmdAction.getProperties().put("task name", this.getName());
        String spRepName = cmdAction.getProperties().getProperty("name").replace(".jrxml", "");
        RecordSet repRS = null;
        Integer tblContext = null;
        if (spRepName != null) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                SpReport rep = (SpReport)session.getData("from SpReport where name = '" + StringEscapeUtils.escapeSql((String)spRepName) + "'");
                if (rep != null) {
                    rep.forceLoad();
                    if (rep.getReportObject() instanceof SpQuery) {
                        SpQuery q = (SpQuery)rep.getReportObject();
                        if (q.getContextTableId() != -1) {
                            tblContext = new Integer(q.getContextTableId().shortValue());
                            cmdAction.getProperties().put("tblcontext", tblContext);
                            cmdAction.getProperties().put("queryid", q.getId());
                        }
                    } else if (rep.getReportObject() instanceof Workbench) {
                        cmdAction.getProperties().put("tblcontext", (Object)Workbench.getClassTableId());
                        cmdAction.getProperties().put("workbenchid", rep.getReportObject().getId());
                    }
                    repRS = new RecordSet();
                    repRS.initialize();
                    repRS.set(rep.getAppResource().getDescription(), SpReport.getClassTableId(), RecordSet.GLOBAL);
                    repRS.addItem(rep.getId());
                    cmdAction.setProperty("spreport", repRS);
                }
            }
            finally {
                session.close();
            }
        }
        CommandAction delCmd = null;
        if (!(repRS == null && cmdAction.getProperties().get("isimport") == null || AppContextMgr.isSecurityOn() && !this.getPermissions().canDelete())) {
            delCmd = new CommandAction(REPORTS, "Delete", repRS);
            if (cmdAction.getProperties().get("isimport") != null) {
                delCmd.getProperties().put("name", cmdAction.getProperties().getProperty("name"));
                delCmd.getProperties().put("appresource", cmdAction.getProperties().get("appresource"));
                cmdAction.getProperties().remove("appresource");
            }
        }
        NavBoxItemIFace nbi = ReportsBaseTask.makeDnDNavBtn(navBox, tcd.getName(), tcd.getIconName(), cmdAction, delCmd, true, true);
        this.reportsList.add(nbi);
        RolloverCommand roc = (RolloverCommand)((Object)nbi);
        String tblIdStr = tcd.getParams().getProperty("tableid");
        String dropStr = tcd.getParams().getProperty("hasrsdropparam");
        boolean bl = canBeRsDropSite = dropStr != null ? dropStr.equals("1") : true;
        if (StringUtils.isEmpty((String)tblIdStr) && canBeRsDropSite) {
            roc.addDropDataFlavor(RecordSetTask.RECORDSET_FLAVOR);
        } else if (tblContext == null && canBeRsDropSite) {
            dfx = new DataFlavorTableExt(RecordSetTask.RECORDSET_FLAVOR.getDefaultRepresentationClass(), RecordSetTask.RECORDSET_FLAVOR.getHumanPresentableName(), new int[]{Integer.parseInt(tblIdStr)});
            roc.addDropDataFlavor(dfx);
        }
        roc.addDragDataFlavor(this.reportFlavor);
        if (cmdAction.getProperties().get("spreport") != null) {
            roc.addDragDataFlavor(this.reportFlavor);
            if (tblContext != null) {
                dfx = new DataFlavorTableExt(RecordSetTask.RECORDSET_FLAVOR.getDefaultRepresentationClass(), RecordSetTask.RECORDSET_FLAVOR.getHumanPresentableName(), new int[]{tblContext});
                roc.addDropDataFlavor(dfx);
            }
        }
        if (delCmd != null) {
            roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        }
        roc.setToolTip(UIRegistry.getResourceString(this.reportHintKey));
        roc.setEnabled(true);
        return roc;
    }

    public void doLabels(String labelName, String labelTitle, Object data, Properties params, Taskable originatingTask, ImageIcon paneIcon) {
        LabelsPane labelsPane = new LabelsPane(labelTitle, originatingTask != null ? originatingTask : this, params);
        labelsPane.setIcon(paneIcon);
        this.addSubPaneToMgr(labelsPane);
        labelsPane.createReport(labelName, data, params);
        this.starterPane = null;
    }

    protected boolean checkForALotOfLabels(RecordSetIFace recordSet) {
        if (recordSet.getNumItems() > 200) {
            Object[] options = new Object[]{UIRegistry.getResourceString("Create_New_Report"), UIRegistry.getResourceString("CANCEL")};
            int n = JOptionPane.showOptionDialog(UIRegistry.get("frame"), String.format(UIRegistry.getResourceString("LotsOfLabels"), recordSet.getNumItems()), UIRegistry.getResourceString("LotsOfLabelsTitle"), 0, 3, null, options, options[0]);
            if (n == 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        LabelsPane labelsPane = new LabelsPane(this.name, (Taskable)this, null);
        labelsPane.setLabelText("Welcome to Specify's Label Maker");
        this.starterPane = labelsPane;
        return this.starterPane;
    }

    protected String askForLabelName() {
        Object data;
        this.initialize();
        NavBoxItemIFace nbi = null;
        if (this.reportsList.size() == 1) {
            nbi = this.reportsList.get(0);
        } else {
            ChooseFromListDlg<NavBoxItemIFace> dlg = new ChooseFromListDlg<NavBoxItemIFace>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ChooseLabel"), this.reportsList, IconManager.getIcon(this.name, IconManager.IconSize.Std24));
            dlg.setMultiSelect(false);
            dlg.setModal(true);
            dlg.setVisible(true);
            if (!dlg.isCancelled()) {
                nbi = dlg.getSelectedObject();
            }
        }
        if (nbi != null && nbi.getData() != null && (data = nbi.getData()) instanceof CommandAction) {
            return ((CommandAction)data).getPropertyAsString("file");
        }
        return null;
    }

    protected Properties convertDataToMap(Object data) {
        if (data instanceof Map) {
            return (Properties)data;
        }
        throw new RuntimeException("Why isn't the data a Properties!");
    }

    protected int countLabelsWithSimilarTableIds(int tableId, boolean needsRecordSet) {
        this.oneNbi = null;
        int count = 0;
        for (NavBoxItemIFace nbi : this.reportsList) {
            Object data = nbi.getData();
            if (!(data instanceof CommandAction)) continue;
            CommandAction cmdAction = (CommandAction)data;
            String tableIDStr = cmdAction.getPropertyAsString("tableid");
            boolean needsRS = this.getNeedsRecordSet(cmdAction.getPropertyAsString("reqrs"));
            if (StringUtils.isNumeric((String)tableIDStr) && (!needsRecordSet || needsRS)) {
                if (Integer.parseInt(tableIDStr) != tableId) continue;
                this.oneNbi = nbi;
                ++count;
                continue;
            }
            log.error((Object)("Attr [tableid] value[" + tableIDStr + "] is not numeric for[" + nbi.getTitle() + "]!"));
        }
        return count;
    }

    protected void createLabelFromSelectedRecordSet(Object data) {
        if (data instanceof RecordSet && ContextMgr.getCurrentContext() == this) {
            Object nbData;
            RecordSetIFace rs = (RecordSetIFace)data;
            String fileName = null;
            if (this.countLabelsWithSimilarTableIds(rs.getDbTableId(), true) > 1) {
                fileName = this.askForLabelName();
            } else if (this.oneNbi != null && (nbData = this.oneNbi.getData()) instanceof CommandAction) {
                fileName = ((CommandAction)nbData).getPropertyAsString("file");
            }
            if (fileName != null) {
                this.doLabels(fileName, "Labels", data, null, this, null);
            }
        }
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        RecordSetTask rsTask = (RecordSetTask)ContextMgr.getTaskByClass(RecordSetTask.class);
        List<NavBoxIFace> nbs = rsTask.getNavBoxes();
        if (nbs != null) {
            this.extendedNavBoxes.addAll(nbs);
        }
        return this.extendedNavBoxes;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        String label = UIRegistry.getResourceString(this.name);
        String localIconName = this.name;
        String hint = UIRegistry.getResourceString("labels_hint");
        ToolBarDropDownBtn btn = this.createToolbarButton(label, localIconName, hint);
        this.toolbarItems.add(new ToolBarItemDesc(btn));
        return this.toolbarItems;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    protected void processRecordSetCommands(CommandAction cmdAction) {
        Object data = cmdAction.getData();
        UsageTracker.incrUsageCount("RP." + cmdAction.getType() + (data != null ? "." + data.getClass().getSimpleName() : ""));
        if (cmdAction.isAction("Clicked")) {
            Object srcObj = cmdAction.getSrcObj();
            Object dstObj = cmdAction.getDstObj();
            log.debug((Object)("********* In Labels doCommand src[" + srcObj + "] dst[" + dstObj + "] data[" + data + "] context[" + ContextMgr.getCurrentContext() + "]"));
            if (ContextMgr.getCurrentContext() == this) {
                this.createLabelFromSelectedRecordSet(srcObj);
            }
        }
    }

    protected void printReport(CommandAction cmdAction) {
        boolean canRunWithoutRS;
        String paramList;
        Properties params = cmdAction.getProperties();
        if (params == null) {
            params = new Properties();
        }
        if (StringUtils.isNotEmpty((String)(paramList = cmdAction.getPropertyAsString("params")))) {
            params.putAll((Map<?, ?>)UIHelper.parseProperties(paramList));
        }
        String impStr = params.getProperty("isimport");
        String rsDropStr = params.getProperty("hasrsdropparam");
        RecordSet spRep = (RecordSet)params.get("spreport");
        if (spRep != null) {
            CommandAction runner = new CommandAction(REPORTS, RUN_REPORT, cmdAction);
            CommandDispatcher.dispatch(runner);
            return;
        }
        boolean bl = canRunWithoutRS = spRep != null || impStr != null && impStr.equals("1") && rsDropStr != null && rsDropStr.equals("0");
        if (cmdAction.getData() instanceof RecordSetIFace || canRunWithoutRS) {
            RecordSetIFace recordSet;
            RecordSetIFace recordSetIFace = recordSet = cmdAction.getData() instanceof RecordSetIFace ? (RecordSetIFace)cmdAction.getData() : null;
            if (recordSet != null && recordSet.getDbTableId() != null && recordSet.getDbTableId() == 1 && cmdAction.getPropertyAsString("title") == null) {
                cmdAction.setProperty("file", "fish_label.jrxml");
                cmdAction.setProperty("title", "Fish Labels");
            } else if (recordSet != null && recordSet.getDbTableId() != null && recordSet.getDbTableId() == 52 && cmdAction.getPropertyAsString("title") == null) {
                cmdAction.setProperty("file", "LoanInvoice.jrxml");
                cmdAction.setProperty("title", "Loan Invoice");
            }
            if (recordSet == null || this.checkForALotOfLabels(recordSet)) {
                String labelFileName = cmdAction.getPropertyAsString("file");
                if (StringUtils.isEmpty((String)labelFileName)) {
                    labelFileName = this.askForLabelName();
                }
                if (StringUtils.isNotEmpty((String)labelFileName)) {
                    Taskable originatingTask = (Taskable)cmdAction.getProperty("OriginatingTask");
                    this.doLabels(labelFileName, cmdAction.getPropertyAsString("title"), recordSet, params, originatingTask == null ? this : originatingTask, (ImageIcon)cmdAction.getProperty("icon"));
                }
            }
        } else if (cmdAction.getData() instanceof JRDataSource) {
            String labelFileName = cmdAction.getPropertyAsString("file");
            if (StringUtils.isEmpty((String)labelFileName)) {
                labelFileName = this.askForLabelName();
            }
            if (StringUtils.isNotEmpty((String)labelFileName)) {
                Taskable originatingTask = (Taskable)cmdAction.getProperty("OriginatingTask");
                this.doLabels(labelFileName, cmdAction.getPropertyAsString("title"), cmdAction.getData(), params, originatingTask, (ImageIcon)cmdAction.getProperty("icon"));
            }
        } else {
            String tableIDStr = cmdAction.getPropertyAsString("tableid");
            if (StringUtils.isNotEmpty((String)tableIDStr) && StringUtils.isNumeric((String)tableIDStr)) {
                RecordSetIFace recordSet = RecordSetTask.askForRecordSet(Integer.parseInt(tableIDStr));
                if (recordSet != null) {
                    this.doLabels(cmdAction.getPropertyAsString("file"), cmdAction.getPropertyAsString("title"), recordSet, params, this, (ImageIcon)cmdAction.getProperty("icon"));
                } else {
                    UIRegistry.displayLocalizedStatusBarText("RecordSetTask.NoRecordsets", new Object[0]);
                }
            }
        }
    }

    protected void processReportCommands(CommandAction cmdAction) {
        Object data = cmdAction.getData();
        UsageTracker.incrUsageCount("RP." + cmdAction.getType() + (data != null ? "." + data.getClass().getSimpleName() : ""));
        if (cmdAction.isAction(NEWRECORDSET_ACTION)) {
            if (cmdAction.getData() instanceof GhostActionable) {
                GhostActionable ga = (GhostActionable)cmdAction.getData();
                GhostMouseInputAdapter gpa = ga.getMouseInputAdapter();
                for (NavBoxItemIFace nbi : this.reportsList) {
                    if (!(nbi instanceof GhostActionable)) continue;
                    gpa.addGhostDropListener(new GhostActionableDropManager(UIRegistry.getGlassPane(), nbi.getUIComponent(), ga));
                }
            }
        } else if (cmdAction.isAction(PRINT_REPORT)) {
            if (data instanceof CommandAction && ((CommandAction)data).isAction(RUN_REPORT)) {
                this.runReport(cmdAction);
            }
            if (cmdAction.getData() instanceof RecordSetIFace) {
                RecordSetIFace rs = (RecordSetIFace)cmdAction.getData();
                if (rs.getDbTableId() != null && rs.getDbTableId() == SpReport.getClassTableId() || cmdAction.getProperty("spreport") != null) {
                    this.runReport(cmdAction);
                } else {
                    this.printReport(cmdAction);
                }
            } else if (data instanceof CommandAction && ((CommandAction)data).isAction(PRINT_REPORT)) {
                this.printReport((CommandAction)data);
            } else {
                this.printReport(cmdAction);
            }
        } else if (cmdAction.isAction(RUN_REPORT)) {
            boolean doRun = true;
            if (data instanceof CommandAction && ((CommandAction)data).isAction(PRINT_REPORT)) {
                boolean bl = doRun = ((CommandAction)data).getProperty("spreport") != null;
            }
            if (doRun) {
                this.runReport(cmdAction);
            } else {
                this.printReport((CommandAction)data);
            }
        } else if (cmdAction.isAction(REFRESH)) {
            this.refreshCommands();
        } else if (cmdAction.isAction(IMPORT)) {
            this.importReport();
        } else if (cmdAction.isAction(PRINT_GRID)) {
            this.printGrid(cmdAction);
        } else if (cmdAction.isAction("Delete")) {
            RolloverCommand roc;
            RecordSetIFace recordSet = null;
            if (cmdAction.getData() instanceof RecordSetIFace) {
                recordSet = (RecordSetIFace)cmdAction.getData();
            } else if (cmdAction.getData() instanceof RolloverCommand && (roc = (RolloverCommand)cmdAction.getData()).getData() instanceof RecordSetIFace) {
                recordSet = (RecordSetIFace)roc.getData();
            }
            if (recordSet != null || cmdAction.getProperties().get("name") != null) {
                String theTitle;
                String theName;
                if (recordSet != null) {
                    theTitle = theName = recordSet.getName();
                } else {
                    theName = cmdAction.getProperties().getProperty("name");
                    theTitle = ((AppResourceIFace)cmdAction.getProperties().get("appresource")).getDescription();
                }
                int option = JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("REP_CONFIRM_DELETE"), theName), UIRegistry.getResourceString("REP_CONFIRM_DELETE_TITLE"), 0, 3, null, null, 1);
                if (option == 0) {
                    SpAppResource res = (SpAppResource)cmdAction.getProperty("appresource");
                    Integer resOrRepId = null;
                    Integer repId = null;
                    if (res != null) {
                        resOrRepId = res.getId();
                    } else {
                        RecordSetItemIFace item = recordSet.getOnlyItem();
                        if (item != null) {
                            resOrRepId = repId = item.getRecordId();
                        }
                    }
                    ReportsBaseTask.deleteReportAndResource(repId, (AppResourceIFace)cmdAction.getProperty("appresource"));
                    this.deleteReportFromUI(theTitle);
                    if (resOrRepId != null) {
                        CommandDispatcher.dispatch(new CommandAction(REPORTS, REPORT_DELETED, resOrRepId));
                    }
                }
            }
        }
    }

    protected void printGrid(final CommandAction cmdAction) {
        String pageTitle = cmdAction.getProperty("gridtitle").toString();
        final PageSetupDlg pageSetup = new PageSetupDlg();
        pageSetup.createUI();
        pageSetup.setPageTitle(pageTitle);
        pageSetup.setVisible(true);
        if (pageSetup.isCancelled()) {
            return;
        }
        SwingWorker<Integer, Integer> backupWorker = new SwingWorker<Integer, Integer>(){
            protected Exception excpt = null;

            @Override
            protected Integer doInBackground() throws Exception {
                JTable table = (JTable)cmdAction.getProperty("jtable");
                if (table != null) {
                    try {
                        LabelsPane labelsPane = new LabelsPane(ReportsBaseTask.this.name, (Taskable)ReportsBaseTask.this, null);
                        DynamicReport dr = ReportsBaseTask.this.buildReport(table.getModel(), pageSetup);
                        JRTableModelDataSource ds = new JRTableModelDataSource(table.getModel());
                        JasperPrint jp = DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
                        labelsPane.reportFinished(jp);
                        SubPaneMgr.getInstance().addPane(labelsPane);
                    }
                    catch (Exception ex) {
                        this.excpt = ex;
                        ex.printStackTrace();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                UIRegistry.getStatusBar().setProgressDone(ReportsBaseTask.PRINT_GRID);
                UIRegistry.clearSimpleGlassPaneMsg();
                if (this.excpt != null) {
                    UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("REP_ERR_GRDRPT"), this.excpt);
                }
            }
        };
        JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setIndeterminate(PRINT_GRID, true);
        UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("REP_GRID_RPT", cmdAction.getProperty("gridtitle").toString()), 24);
        backupWorker.execute();
    }

    public DynamicReport buildReport(TableModel model, PageSetupDlg pageSetupDlg) throws Exception {
        String fontName = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        java.awt.Font[] fontArray = ge.getAllFonts();
        int n = fontArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.awt.Font font = fontArray[n2];
            String fName = font.getFamily().toLowerCase();
            if (StringUtils.contains((String)fName, (String)"sansserif") || StringUtils.contains((String)fName, (String)"arial") || StringUtils.contains((String)fName, (String)"verdana")) {
                fontName = font.getFamily();
            }
            ++n2;
        }
        if (fontName == null) {
            fontName = "Times New Roman";
        }
        FastReportBuilder drb = new FastReportBuilder();
        Style columDetail = new Style();
        columDetail.setBorder(Border.THIN);
        Style columDetailWhite = new Style();
        columDetailWhite.setBorder(Border.THIN);
        columDetailWhite.setBackgroundColor(Color.WHITE);
        columDetailWhite.setFont(new Font(10, fontName, true));
        columDetailWhite.setHorizontalAlign(HorizontalAlign.CENTER);
        columDetailWhite.setBlankWhenNull(true);
        Style columDetailWhiteBold = new Style();
        columDetailWhiteBold.setBorder(Border.THIN);
        columDetailWhiteBold.setBackgroundColor(Color.WHITE);
        Style titleStyle = new Style();
        titleStyle.setFont(new Font(14, fontName, true));
        Style oddRowStyle = new Style();
        oddRowStyle.setBorder(Border.NO_BORDER);
        oddRowStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        Color veryLightGrey = new Color(240, 240, 240);
        oddRowStyle.setBackgroundColor(veryLightGrey);
        oddRowStyle.setTransparency(Transparency.OPAQUE);
        int i = 0;
        while (i < model.getColumnCount()) {
            String colName = model.getColumnName(i);
            Class<Object> dataClass = model.getColumnClass(i);
            if (dataClass == Object.class && model.getRowCount() > 0) {
                Object data = model.getValueAt(0, i);
                if (data != null) {
                    dataClass = data.getClass();
                } else {
                    int j = 1;
                    while (j < model.getRowCount()) {
                        data = model.getValueAt(j, i);
                        if (dataClass != null) {
                            dataClass = data.getClass();
                            break;
                        }
                        ++j;
                    }
                    if (dataClass == null) {
                        dataClass = String.class;
                    }
                }
            }
            ColumnBuilder colBldr = ColumnBuilder.getInstance().setColumnProperty(colName, dataClass.getName());
            int bracketInx = colName.indexOf(91);
            if (bracketInx > -1) {
                colName = colName.substring(0, bracketInx - 1);
            }
            colBldr.setTitle(colName);
            colBldr.setStyle(columDetailWhite);
            AbstractColumn column = colBldr.build();
            drb.addColumn(column);
            Style headerStyle = new Style();
            headerStyle.setFont(new Font(12, fontName, true));
            headerStyle.setBorder(Border.THIN);
            headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
            headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
            headerStyle.setBackgroundColor(new Color(80, 80, 80));
            headerStyle.setTransparency(Transparency.OPAQUE);
            headerStyle.setTextColor(new Color(255, 255, 255));
            column.setHeaderStyle(headerStyle);
            ++i;
        }
        drb.setTitle(pageSetupDlg.getPageTitle());
        drb.setTitleStyle(titleStyle);
        drb.setLeftMargin(20);
        drb.setRightMargin(20);
        drb.setTopMargin(10);
        drb.setBottomMargin(10);
        drb.setPrintBackgroundOnOddRows(true);
        drb.setOddRowBackgroundStyle(oddRowStyle);
        drb.setColumnsPerPage(new Integer(1));
        drb.setUseFullPageWidth(true);
        drb.setColumnSpace(new Integer(5));
        Page[] pageSizes = new Page[]{Page.Page_Letter_Portrait(), Page.Page_Legal_Portrait(), Page.Page_A4_Portrait(), Page.Page_Letter_Landscape(), Page.Page_Legal_Landscape(), Page.Page_A4_Landscape()};
        int pageSizeInx = pageSetupDlg.getPageSize() + (pageSetupDlg.isPortrait() ? 0 : 3);
        drb.setPageSizeAndOrientation(pageSizes[pageSizeInx]);
        DynamicReport dr = drb.build();
        return dr;
    }

    public static void deleteReportAndResource(Integer reportId, AppResourceIFace appRes) {
        Integer resourceId = null;
        if (reportId == null) {
            resourceId = ((SpAppResource)appRes).getId();
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        boolean transOpen = false;
        try {
            try {
                String hql = reportId != null ? "from SpReport where id = " + reportId : "from SpReport where appResourceId = " + resourceId;
                SpReport rep = (SpReport)session.getData(hql);
                SpAppResource repRes = null;
                if (rep != null) {
                    repRes = rep.getAppResource();
                } else {
                    hql = "from SpAppResource where id = " + resourceId;
                    repRes = (SpAppResource)session.getData(hql);
                }
                if (repRes != null) {
                    ((SpecifyAppContextMgr)AppContextMgr.getInstance()).removeAppResourceSp(repRes.getSpAppResourceDir(), repRes);
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ReportsBaseTask.class, e);
                if (transOpen) {
                    session.rollback();
                }
                e.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
    }

    protected void deleteReportFromUI(String btnName) {
        Pair<NavBoxIFace, NavBoxItemIFace> btn = this.findDnDBtn(btnName);
        if (btn != null) {
            this.reportsList.remove(btn.getSecond());
            this.deleteDnDBtn(btn.getFirst(), btn.getSecond());
        }
    }

    protected void refreshCommands() {
        this.commands.clear();
        this.reportsList.clear();
        this.reportsNavBox.clear();
        this.labelsNavBox.clear();
        this.addROCs();
        this.reportsNavBox.invalidate();
        this.reportsNavBox.setSize(this.reportsNavBox.getPreferredSize());
        this.reportsNavBox.doLayout();
        this.reportsNavBox.repaint();
        this.labelsNavBox.invalidate();
        this.labelsNavBox.setSize(this.reportsNavBox.getPreferredSize());
        this.labelsNavBox.doLayout();
        this.labelsNavBox.repaint();
        NavBoxMgr.getInstance().invalidate();
        NavBoxMgr.getInstance().doLayout();
        NavBoxMgr.getInstance().repaint();
        UIRegistry.forceTopFrameRepaint();
    }

    protected SpReport loadReport(RecordSet repRS) {
        SpReport result = null;
        if (repRS != null && repRS.getDbTableId() == SpReport.getClassTableId()) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                result = session.get(SpReport.class, repRS.getOrderedItems().iterator().next().getRecordId());
                result.forceLoad();
            }
            finally {
                session.close();
            }
        } else {
            UIRegistry.showError("RecordSet was NULL or not of type report!");
        }
        return result;
    }

    protected NavBoxItemIFace selectReport(String helpContext) {
        Vector<NavBoxItemIFace> options = this.reportsList;
        if (options.size() == 0) {
            UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("NO_RUNNABLE_REPORTS"));
            return null;
        }
        ChooseFromListDlg<NavBoxItemIFace> dlg = new ChooseFromListDlg<NavBoxItemIFace>((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString("REP_CHOOSE_REPORT"), null, 7, options, helpContext);
        dlg.setModal(true);
        UIHelper.centerAndShow(dlg);
        NavBoxItemIFace selection = dlg.getSelectedObject();
        if (!dlg.isCancelled() && selection != null) {
            return selection;
        }
        return null;
    }

    protected void importReport() {
        FileDialog fileDialog = new FileDialog((Frame)UIRegistry.get("frame"), UIRegistry.getResourceString("CHOOSE_WORKBENCH_IMPORT_FILE"), 0);
        fileDialog.setDirectory(WorkbenchTask.getDefaultDirPath("wb.importfilepath"));
        fileDialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return FilenameUtils.getExtension((String)filename).equalsIgnoreCase("jrxml");
            }
        });
        UIHelper.centerAndShow(fileDialog);
        fileDialog.dispose();
        String fileName = fileDialog.getFile();
        String path = fileDialog.getDirectory();
        if (StringUtils.isNotEmpty((String)path)) {
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            localPrefs.put("wb.importfilepath", path);
        }
        if (!StringUtils.isNotEmpty((String)fileName) || !StringUtils.isNotEmpty((String)path)) {
            return;
        }
        File file = new File(String.valueOf(path) + File.separator + fileName);
        if (file.exists() && MainFrameSpecify.importJasperReport(file, true, null)) {
            this.refreshCommands();
        }
    }

    protected void runReport(CommandAction cmdAction) {
        Object data;
        NavBoxItemIFace toRun = null;
        SpReport spRepToRun = null;
        CommandAction runAction = null;
        CommandAction repAction = null;
        RecordSetIFace rs = null;
        if (cmdAction.isAction(RUN_REPORT)) {
            runAction = cmdAction;
            data = cmdAction.getData();
            if (data instanceof CommandAction && ((CommandAction)data).isAction(PRINT_REPORT)) {
                repAction = (CommandAction)data;
            }
        } else if (cmdAction.isAction(PRINT_REPORT)) {
            repAction = cmdAction;
            data = cmdAction.getData();
            if (data instanceof CommandAction && ((CommandAction)data).isAction(RUN_REPORT)) {
                runAction = (CommandAction)data;
            } else if (data instanceof RecordSetIFace) {
                rs = (RecordSetIFace)data;
            }
        }
        if (runAction != null && repAction == null) {
            CommandAction cmd;
            toRun = this.selectReport("ReportRunReport");
            if (toRun != null && (cmd = (CommandAction)toRun.getData()).getProperty("spreport") != null) {
                RecordSet repRS = (RecordSet)cmd.getProperty("spreport");
                spRepToRun = this.loadReport(repRS);
            }
        } else if ((runAction != null || rs != null) && repAction != null) {
            spRepToRun = this.loadReport((RecordSet)repAction.getProperty("spreport"));
        }
        if (spRepToRun != null) {
            if (spRepToRun.getReportObject() instanceof WorkbenchTemplate) {
                WorkbenchTemplate repTemplate = (WorkbenchTemplate)spRepToRun.getReportObject();
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    List<Workbench> wbs = session.getDataList(Workbench.class, "specifyUser", AppContextMgr.getInstance().getClassObject(SpecifyUser.class), DataProviderSessionIFace.CompareType.Equals);
                    Vector<Workbench> choices = new Vector<Workbench>();
                    for (Workbench wb : wbs) {
                        if (!repTemplate.containsAllMappings(wb.getWorkbenchTemplate())) continue;
                        choices.add(wb);
                    }
                    if (choices.size() == 0) {
                        UIRegistry.displayInfoMsgDlgLocalized("ReportsBaseTask.NO_WBS_FOR_REPORT", spRepToRun.getName());
                        return;
                    }
                    Workbench repWB = null;
                    if (choices.size() == 1) {
                        repWB = (Workbench)choices.get(0);
                    } else {
                        ChooseFromListDlg wbDlg = new ChooseFromListDlg((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ReportsBaseTesk.SELECT_WB"), choices, IconManager.getIcon(this.name, IconManager.IconSize.Std24));
                        UIHelper.centerAndShow(wbDlg);
                        repWB = (Workbench)wbDlg.getSelectedObject();
                        if (wbDlg.isCancelled() || repWB == null) {
                            return;
                        }
                    }
                    RecordSet wbRS = new RecordSet();
                    wbRS.initialize();
                    wbRS.set(repWB.getName(), Workbench.getClassTableId(), RecordSet.GLOBAL);
                    wbRS.addItem(repWB.getId());
                    rs = wbRS;
                }
                finally {
                    session.close();
                }
            }
            QueryBldrPane.runReport(spRepToRun, spRepToRun.getName(), rs);
        } else if (toRun != null) {
            CommandDispatcher.dispatch((CommandAction)toRun.getData());
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart")) {
            CommandDispatcher.unregister(REPORTS, this);
            CommandDispatcher.unregister("Record_Set", this);
            if (this.isInitialized) {
                this.reportsList.clear();
                this.reportsNavBox.clear();
                this.labelsNavBox.clear();
                this.isInitialized = false;
            }
            this.initialize();
            CommandDispatcher.register(REPORTS, this);
            CommandDispatcher.register("Record_Set", this);
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(REPORTS)) {
            this.processReportCommands(cmdAction);
        } else if (cmdAction.isType("Record_Set")) {
            this.processRecordSetCommands(cmdAction);
        }
    }

    protected boolean getNeedsRecordSet(String needsRSStr) {
        boolean needsRS = true;
        if (StringUtils.isNotEmpty((String)needsRSStr) && StringUtils.isAlpha((String)needsRSStr)) {
            needsRS = Boolean.parseBoolean(needsRSStr);
        }
        return needsRS;
    }

    @Override
    public String getPermissionName() {
        return REPORTS;
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[2] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray[3] = blArray2;
        return blArrayArray;
    }

    protected boolean repContextIsActive(AppResourceIFace repResource) {
        AppResourceIFace match = AppContextMgr.getInstance().getResource(repResource.getName());
        return match != null && match.getMimeType().equalsIgnoreCase(repResource.getMimeType());
    }

    protected SortedSet<SearchResultReportServiceInfo> getReports(int tableId, QueryBldrPane queryBuilder) {
        Taskable reportsTask;
        TreeSet<SearchResultReportServiceInfo> reports = new TreeSet<SearchResultReportServiceInfo>(new Comparator<SearchResultReportServiceInfo>(){

            @Override
            public int compare(SearchResultReportServiceInfo o1, SearchResultReportServiceInfo o2) {
                return o1.getReportName().compareTo(o2.getReportName());
            }
        });
        boolean buildEm = true;
        if (AppContextMgr.isSecurityOn() && (reportsTask = ContextMgr.getTaskByClass(ReportsTask.class)) != null) {
            buildEm = reportsTask.getPermissions().canView();
        }
        if (buildEm) {
            if (queryBuilder != null) {
                for (SpReport rep : queryBuilder.getReportsForQuery()) {
                    if (!this.repContextIsActive(rep.getAppResource())) continue;
                    reports.add(new SearchResultReportServiceInfo(rep.getName(), rep.getName(), true, null, rep.getAppResource().getId(), rep.getRepeats()));
                }
            }
            if (tableId != -1) {
                List<AppResourceIFace> reps = AppContextMgr.getInstance().getResourceByMimeType(LABELS_MIME);
                reps.addAll(AppContextMgr.getInstance().getResourceByMimeType(REPORTS_MIME));
                for (AppResourceIFace rep : reps) {
                    String tblIdStr = rep.getMetaData("tableid");
                    if (tblIdStr == null) continue;
                    if (tableId == Integer.valueOf(tblIdStr)) {
                        reports.add(new SearchResultReportServiceInfo(rep.getDescription(), rep.getName(), false, null, ((SpAppResource)rep).getId(), null));
                        continue;
                    }
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    try {
                        SpReport spRep = (SpReport)session.getData("from SpReport where appResourceId = " + ((SpAppResource)rep).getId());
                        if (spRep == null || spRep.getQuery() == null || spRep.getQuery().getContextTableId().intValue() != tableId) continue;
                        reports.add(new SearchResultReportServiceInfo(rep.getDescription(), rep.getName(), false, spRep.getId(), ((SpAppResource)rep).getId(), null));
                    }
                    finally {
                        session.close();
                    }
                }
            }
        }
        return reports;
    }
}

