/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.ServiceInfo;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.RecordSetItem;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.prefs.FormattingPrefsPanel;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.RecordSetProxy;
import edu.ku.brc.specify.ui.ChooseRecordSetDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DataActionEvent;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RecordSetTask
extends BaseTask
implements PropertyChangeListener {
    private static final Logger log = Logger.getLogger(RecordSetTask.class);
    public static final String RECORD_SET = "Record_Set";
    public static final String SAVE_RECORDSET = "Save";
    public static final String ADD_TO_NAV_BOX = "AddToNavBox";
    public static final DataFlavor RECORDSET_FLAVOR = new DataFlavor(RecordSetTask.class, "Record_Set");
    protected Vector<DataFlavor> draggableFlavors = new Vector();
    protected Vector<DataFlavor> droppableFlavors = new Vector();
    protected NavBox navBox = null;

    public RecordSetTask() {
        super(RECORD_SET, UIRegistry.getResourceString(RECORD_SET));
        this.draggableFlavors.add(Trash.TRASH_FLAVOR);
        CommandDispatcher.register(RECORD_SET, this);
        CommandDispatcher.register("Preferences", this);
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            block23: {
                super.initialize();
                for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                    ContextMgr.registerService(1, ti.getTitle(), ti.getTableId(), new CommandAction(RECORD_SET, SAVE_RECORDSET), this, RECORD_SET, UIRegistry.getResourceString("CreateRecordSetTT"));
                }
                this.navBox = new NavBox(this.title);
                SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                String sqlStr = "SELECT rs.RecordSetID, Type, rs.Name, TableID, rs.Remarks FROM recordset as rs INNER JOIN specifyuser ON rs.SpecifyUserID = specifyuser.SpecifyUserID WHERE type = 0 AND specifyuser.specifyUserID = " + spUser.getId() + " AND CollectionMemberID = " + collection.getId();
                Connection connection = null;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    try {
                        connection = DBConnection.getInstance().createConnection();
                        stmt = connection.createStatement();
                        rs = stmt.executeQuery(sqlStr);
                        while (rs.next()) {
                            int dbTableId = rs.getInt(4);
                            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(dbTableId);
                            RecordSetProxy rsProxy = new RecordSetProxy(rs.getInt(1), rs.getByte(2), rs.getString(3), dbTableId, rs.getString(5), tableInfo.getClassObj());
                            this.addToNavBox(rsProxy);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                            break block23;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(RecordSetTask.class, e);
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(RecordSetTask.class, e);
                    }
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(RecordSetTask.class, e);
                }
            }
            this.navBoxes.add(this.navBox);
        }
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        if (AppContextMgr.isSecurityOn() && this.permissions != null && !this.permissions.canView()) {
            return null;
        }
        return super.getNavBoxes();
    }

    protected NavBoxItemIFace addToNavBox(RecordSetIFace recordSet) {
        ImageIcon rsIcon;
        boolean delOK = this.permissions == null || this.permissions.canDelete();
        boolean modOK = this.permissions == null || this.permissions.canModify();
        CommandAction delCmdAction = delOK ? new CommandAction(RECORD_SET, "Delete", recordSet) : null;
        RolloverCommand roc = (RolloverCommand)((Object)RecordSetTask.makeDnDNavBtn(this.navBox, recordSet.getName(), RECORD_SET, null, delCmdAction, true, true));
        roc.setData(recordSet);
        this.addPopMenu(roc, delOK, modOK);
        NavBoxItemIFace nbi = (NavBoxItemIFace)((Object)roc);
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(recordSet.getDbTableId());
        if (tblInfo != null && (rsIcon = tblInfo.getIcon(IconManager.STD_ICON_SIZE)) != null) {
            nbi.setIcon(rsIcon);
        }
        roc.addDragDataFlavor(new DataFlavorTableExt(RecordSetTask.class, RECORD_SET, recordSet.getDbTableId()));
        roc.addDropDataFlavor(new DataFlavorTableExt(RecordSetTask.class, RECORD_SET, recordSet.getDbTableId()));
        this.addDraggableDataFlavors(nbi);
        this.addDroppableDataFlavors(nbi);
        return nbi;
    }

    public void addPopMenu(final RolloverCommand roc, final boolean isOKDelete, boolean isOKModify) {
        if (roc.getLabelText() != null) {
            final JPopupMenu popupMenu = new JPopupMenu();
            if (isOKModify) {
                JMenuItem renameMenuItem = new JMenuItem(UIRegistry.getResourceString("Rename"));
                renameMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        roc.startEditting(RecordSetTask.this);
                    }
                });
                popupMenu.add(renameMenuItem);
            }
            if (isOKDelete) {
                JMenuItem delMenuItem = new JMenuItem(UIRegistry.getResourceString("Delete"));
                delMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CommandDispatcher.dispatch(new CommandAction(RecordSetTask.RECORD_SET, "Delete", roc));
                    }
                });
                popupMenu.add(delMenuItem);
            }
            JMenuItem viewMenuItem = new JMenuItem(UIRegistry.getResourceString("View"));
            viewMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CommandAction cmdAction = new CommandAction("Express_Search", "ViewRecordSet", roc);
                    cmdAction.setProperty("canModify", isOKDelete);
                    CommandDispatcher.dispatch(cmdAction);
                }
            });
            popupMenu.add(viewMenuItem);
            MouseAdapter mouseListener = new MouseAdapter(){

                private boolean showIfPopupTrigger(MouseEvent mouseEvent) {
                    if (roc.isEnabled() && mouseEvent.isPopupTrigger() && popupMenu.getComponentCount() > 0) {
                        popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        return true;
                    }
                    return false;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (roc.isEnabled()) {
                        this.showIfPopupTrigger(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (roc.isEnabled()) {
                        this.showIfPopupTrigger(mouseEvent);
                    }
                }
            };
            roc.addMouseListener(mouseListener);
        }
    }

    protected void addDraggableDataFlavors(NavBoxItemIFace nbi) {
        NavBoxButton roc = (NavBoxButton)nbi;
        for (DataFlavor df : this.draggableFlavors) {
            roc.addDragDataFlavor(df);
        }
        roc.addActionListener(new RecordSetSelectedAction((NavBoxButton)nbi, (RecordSetIFace)roc.getData()));
    }

    protected void addDroppableDataFlavors(NavBoxItemIFace nbi) {
        NavBoxButton roc = (NavBoxButton)nbi;
        for (DataFlavor df : this.droppableFlavors) {
            roc.addDropDataFlavor(df);
        }
    }

    public void saveNewRecordSet(RecordSet recordSet) {
        boolean isOKToAdd = true;
        if (isOKToAdd) {
            UsageTracker.incrUsageCount("RS.SAVENEW");
            recordSet.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
            recordSet.setOwner(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
            if (RecordSetTask.persistRecordSet(recordSet)) {
                this.addRecordSetToNavBox(recordSet);
            }
        }
    }

    public void addRecordSetToNavBox(RecordSet recordSet) {
        RecordSetProxy rsProxy = new RecordSetProxy(recordSet.getId(), recordSet.getType(), recordSet.getName(), recordSet.getDbTableId(), recordSet.getRemarks(), recordSet.getDataClass());
        NavBoxItemIFace nbi = this.addToNavBox(rsProxy);
        NavBoxMgr.getInstance().addBox(this.navBox);
        this.navBox.invalidate();
        this.navBox.setSize(this.navBox.getPreferredSize());
        this.navBox.doLayout();
        this.navBox.repaint();
        NavBoxMgr.getInstance().invalidate();
        NavBoxMgr.getInstance().doLayout();
        NavBoxMgr.getInstance().repaint();
        UIRegistry.forceTopFrameRepaint();
        CommandDispatcher.dispatch(new CommandAction("Labels", "NewRecordSet", nbi));
    }

    protected void deleteRecordSet(RecordSetIFace recordSet) {
        UsageTracker.incrUsageCount("RS.DEL");
        Connection connection = null;
        Statement updateStatement = null;
        try {
            try {
                connection = DBConnection.getInstance().createConnection();
                String deleteRS = "DELETE FROM recordset WHERE RecordSetID = " + recordSet.getRecordSetId();
                String deleteRSI = "DELETE FROM recordsetitem WHERE RecordSetID = " + recordSet.getRecordSetId();
                updateStatement = connection.createStatement();
                updateStatement.executeUpdate(deleteRSI);
                updateStatement.executeUpdate(deleteRS);
                updateStatement.clearBatch();
                updateStatement.close();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                ex.printStackTrace();
                try {
                    if (updateStatement != null) {
                        updateStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(RecordSetTask.class, e);
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetTask.class, e);
                e.printStackTrace();
            }
        }
    }

    public static void deleteItems(Integer rsId, List<Integer> rsiIds, Integer rsiId) {
        Connection connection = null;
        Statement updateStatement = null;
        try {
            try {
                connection = DBConnection.getInstance().createConnection();
                StringBuilder sb = new StringBuilder("DELETE FROM recordsetitem WHERE RecordSetID = ");
                sb.append(rsId);
                sb.append(" AND RecordID ");
                if (rsiIds != null) {
                    sb.append("in (");
                    int i = 0;
                    while (i < rsiIds.size()) {
                        if (i > 0) {
                            sb.append(',');
                        }
                        sb.append(rsiIds.get(i));
                        ++i;
                    }
                    sb.append(")");
                } else {
                    sb.append("= " + rsiId);
                }
                updateStatement = connection.createStatement();
                log.debug((Object)sb.toString());
                int numItems = updateStatement.executeUpdate(sb.toString());
                log.debug((Object)(String.valueOf(numItems) + "  " + sb.toString()));
                updateStatement.clearBatch();
                updateStatement.close();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                ex.printStackTrace();
                try {
                    if (updateStatement != null) {
                        updateStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(RecordSetTask.class, e);
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetTask.class, e);
                e.printStackTrace();
            }
        }
    }

    protected void processDeleteRSItems(CommandAction cmd) {
        block10: {
            List ids;
            RecordSetIFace rs;
            block11: {
                Object data = cmd.getData();
                if (!(data instanceof Object[])) break block10;
                rs = (RecordSetIFace)((Object[])data)[0];
                ids = (List)((Object[])data)[1];
                if (!(rs instanceof RecordSetProxy)) break block11;
                RecordSetProxy recordSet = (RecordSetProxy)rs;
                RecordSetTask.deleteItems(recordSet.getRecordSetId(), ids, null);
                break block10;
            }
            if (!(rs instanceof RecordSet)) break block10;
            RecordSet recordSet = (RecordSet)rs;
            if (recordSet.getRecordSetId() == null) {
                for (RecordSetItem rsi : new Vector<RecordSetItem>(recordSet.getRecordSetItems())) {
                    recordSet.getRecordSetItems().remove(rsi);
                }
            } else {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    try {
                        FormHelper.updateLastEdittedInfo(recordSet);
                        session.beginTransaction();
                        Vector<RecordSetItemIFace> items = new Vector<RecordSetItemIFace>(recordSet.getOrderedItems());
                        for (Integer id : ids) {
                            for (RecordSetItemIFace rsi : items) {
                                if (rsi.getRecordId().intValue() != id.intValue()) continue;
                                recordSet.removeItem(rsi);
                                session.delete(rsi);
                            }
                        }
                        items.clear();
                        session.saveOrUpdate(recordSet);
                        session.commit();
                        session.flush();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                        ex.printStackTrace();
                        session.close();
                    }
                }
                finally {
                    session.close();
                }
            }
        }
    }

    protected void deleteRecordSetFromUI(NavBoxItemIFace boxItem, RecordSetIFace recordSet) {
        this.deleteDnDBtn(this.navBox, boxItem != null ? boxItem : RecordSetTask.getBoxByTitle(this.navBox, recordSet.getName()));
    }

    public List<RecordSetIFace> getRecordSets(int tableId) {
        ArrayList<RecordSetIFace> list = new ArrayList<RecordSetIFace>();
        for (NavBoxItemIFace nbi : this.navBox.getItems()) {
            RecordSetIFace rs = (RecordSetIFace)nbi.getData();
            if (tableId != -1 && tableId != rs.getDbTableId()) continue;
            list.add(rs);
        }
        return list;
    }

    public List<RecordSetIFace> getRecordSets() {
        return this.getRecordSets(-1);
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = new SimpleDescPane(this.name, (Taskable)this, UIRegistry.getResourceString("RecordSetTask.DROP_BUNDLE_HERE"));
        return this.starterPane;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    protected void renameRecordSet(RolloverCommand roc, RecordSetIFace rs, String oldName, String newName) {
        int count;
        block13: {
            String sqlStr = "select count(rs.name) From RecordSet as rs Inner Join rs.specifyUser as user where rs.name = '" + newName + "' AND user.specifyUserId = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId();
            DataProviderSessionIFace session = null;
            count = -1;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Object result = session.getData(sqlStr);
                    count = result != null ? (Integer)result : 0;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                    if (session != null) {
                        session.close();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        if (count == 0) {
            RecordSet recordSet = null;
            if (rs instanceof RecordSetProxy) {
                recordSet = ((RecordSetProxy)rs).getRecordSet();
                ((RecordSetProxy)rs).setName(roc.getLabelText());
            } else if (rs instanceof RecordSet) {
                recordSet = (RecordSet)rs;
            }
            recordSet.setName(roc.getLabelText());
            RecordSetTask.persistRecordSet(recordSet);
        } else {
            String msg = String.format(UIRegistry.getResourceString("RecordSetTask.RENAMING_ERROR"), newName);
            UIRegistry.getStatusBar().setErrorMessage(msg);
            rs.setName(oldName);
            roc.setLabelText(oldName);
            roc.repaint();
        }
    }

    protected void createRecordSet(RecordSet recordSet) {
        if (recordSet != null) {
            UsageTracker.incrUsageCount("RS.ASKRS");
            ChooseRecordSetDlg dlg = new ChooseRecordSetDlg(recordSet.getDbTableId(), true);
            dlg.setVisible(true);
            if (!dlg.isCancelled()) {
                if (dlg.getBtnPressed() == 1) {
                    this.mergeRecordSets(recordSet, dlg.getSelectedRecordSet());
                } else {
                    String rsName = this.getUniqueRecordSetName("");
                    if (StringUtils.isNotEmpty((String)rsName)) {
                        recordSet.setName(rsName);
                        this.saveNewRecordSet(recordSet);
                    }
                }
            }
        } else {
            UIRegistry.showError("The Record Set was null and shouldn't have been!");
        }
    }

    protected void mergeRecordSets(Object srcObj, Object dstObj) {
        UsageTracker.incrUsageCount("RS.MERGE");
        String MERGE_ERR = "RecordSetTask.MERGE_ERROR";
        if (srcObj != dstObj && srcObj != null && dstObj != null && srcObj instanceof RecordSetIFace && dstObj instanceof RecordSetIFace) {
            RecordSetIFace dstRecordSet;
            RecordSetIFace srcRecordSet = srcObj instanceof RecordSetProxy ? ((RecordSetProxy)srcObj).getRecordSet() : (RecordSetIFace)srcObj;
            RecordSetIFace recordSetIFace = dstRecordSet = dstObj instanceof RecordSetProxy ? ((RecordSetProxy)dstObj).getRecordSet() : (RecordSetIFace)dstObj;
            if (srcRecordSet != null && dstRecordSet != null) {
                DBTableInfo srcTI = DBTableIdMgr.getInstance().getInfoById(srcRecordSet.getDbTableId());
                DBTableInfo dstTI = DBTableIdMgr.getInstance().getInfoById(dstRecordSet.getDbTableId());
                String mergeErrStr = String.format(UIRegistry.getResourceString(MERGE_ERR), srcTI.getShortClassName(), dstTI.getShortClassName());
                if (srcRecordSet.getDbTableId().equals(dstRecordSet.getDbTableId())) {
                    List<Object> srcIdList;
                    List<Integer> dstIdList = RecordSet.getIdList(dstRecordSet.getRecordSetId(), null);
                    if (srcRecordSet.getRecordSetId() == null) {
                        srcIdList = new Vector();
                        for (RecordSetItemIFace rsi : srcRecordSet.getOrderedItems()) {
                            srcIdList.add(rsi.getRecordId());
                        }
                    } else {
                        srcIdList = RecordSet.getIdList(srcRecordSet.getRecordSetId(), null);
                    }
                    boolean debug = true;
                    if (debug) {
                        log.debug((Object)"Source:");
                        for (Integer n : srcIdList) {
                            log.debug((Object)(" " + n));
                        }
                        log.debug((Object)"Dest:");
                        for (Integer n : dstIdList) {
                            log.debug((Object)(" " + n));
                        }
                        log.debug((Object)"");
                    }
                    Hashtable<Integer, Boolean> hashtable = new Hashtable<Integer, Boolean>();
                    for (Integer id : dstIdList) {
                        hashtable.put(id, true);
                    }
                    ArrayList<Integer> newIdsList = new ArrayList<Integer>(srcIdList.size() + dstIdList.size());
                    for (Integer n : srcIdList) {
                        if (hashtable.get(n) != null) continue;
                        newIdsList.add(n);
                    }
                    if (debug) {
                        log.debug((Object)"");
                        log.debug((Object)"New Dest:");
                        for (RecordSetItemIFace recordSetItemIFace : dstRecordSet.getItems()) {
                            log.debug((Object)(" " + recordSetItemIFace.getRecordId()));
                        }
                        log.debug((Object)"");
                    }
                    if (newIdsList.size() > 0) {
                        boolean bl;
                        block36: {
                            boolean bl2 = false;
                            boolean doRollback = false;
                            Connection connection = DBConnection.getInstance().getConnection();
                            Statement stmt = null;
                            try {
                                try {
                                    connection.setAutoCommit(false);
                                    stmt = connection.createStatement();
                                    for (Integer id : newIdsList) {
                                        stmt.executeUpdate("INSERT INTO recordsetitem (RecordSetID, RecordID) VALUES (" + dstRecordSet.getRecordSetId() + "," + id + ")");
                                    }
                                    connection.commit();
                                    bl = true;
                                }
                                catch (SQLException ex) {
                                    UsageTracker.incrSQLUsageCount();
                                    ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                                    ex.printStackTrace();
                                    doRollback = true;
                                    try {
                                        if (doRollback) {
                                            connection.rollback();
                                        }
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                        connection.setAutoCommit(true);
                                    }
                                    catch (SQLException ex2) {
                                        UsageTracker.incrSQLUsageCount();
                                        ExceptionTracker.getInstance().capture(RecordSetTask.class, ex2);
                                        ex2.printStackTrace();
                                    }
                                    break block36;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (doRollback) {
                                        connection.rollback();
                                    }
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                    connection.setAutoCommit(true);
                                }
                                catch (SQLException ex2) {
                                    UsageTracker.incrSQLUsageCount();
                                    ExceptionTracker.getInstance().capture(RecordSetTask.class, ex2);
                                    ex2.printStackTrace();
                                }
                                throw throwable;
                            }
                            try {
                                if (doRollback) {
                                    connection.rollback();
                                }
                                if (stmt != null) {
                                    stmt.close();
                                }
                                connection.setAutoCommit(true);
                            }
                            catch (SQLException ex2) {
                                UsageTracker.incrSQLUsageCount();
                                ExceptionTracker.getInstance().capture(RecordSetTask.class, ex2);
                                ex2.printStackTrace();
                            }
                        }
                        if (bl) {
                            String msg = String.format(UIRegistry.getResourceString("RecordSetTask.MERGE_SUCCESS"), srcTI.getShortClassName(), dstTI.getShortClassName());
                            UIRegistry.displayStatusBarText(msg);
                        } else {
                            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), mergeErrStr, UIRegistry.getResourceString("Error"), 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), mergeErrStr, UIRegistry.getResourceString("Error"), 0);
                }
            } else {
                log.error((Object)("The src or the dst RecordSet were null src[" + srcRecordSet + "]  dst[" + dstRecordSet + "]"));
            }
        }
    }

    public static RecordSet copyRecordSet(RecordSetIFace recordSetArg) {
        RecordSetIFace recordSet;
        RecordSetIFace recordSetIFace = recordSet = recordSetArg instanceof RecordSetProxy ? ((RecordSetProxy)recordSetArg).getRecordSet() : recordSetArg;
        if (recordSet instanceof RecordSet) {
            try {
                RecordSet rs = (RecordSet)((RecordSet)recordSet).clone();
                for (RecordSetItemIFace rsi : recordSet.getOrderedItems()) {
                    rs.addItem(rsi.getRecordId());
                }
                rs.setType(RecordSet.HIDDEN);
                return rs;
            }
            catch (CloneNotSupportedException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                throw new RuntimeException(ex);
            }
        }
        throw new RuntimeException("copyRecordSet doesn't support class of type [" + recordSet.getClass().getSimpleName() + "]");
    }

    public static RecordSetIFace loadRecordSet(RecordSetIFace recordSet) {
        if (recordSet.getRecordSetId() == null) {
            throw new RuntimeException("Try to load a RecordSet that has a null id");
        }
        if (recordSet instanceof RecordSetProxy) {
            return ((RecordSetProxy)recordSet).getRecordSet();
        }
        DataProviderSessionIFace session = null;
        try {
            RecordSet rs;
            session = DataProviderFactory.getInstance().createSession();
            RecordSet recordSet2 = rs = session.get(RecordSet.class, recordSet.getRecordSetId());
            return recordSet2;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public static boolean persistRecordSet(RecordSetIFace recordSet) {
        if (recordSet instanceof RecordSet) {
            DataProviderSessionIFace session = null;
            try {
                session = DataProviderFactory.getInstance().createSession();
                RecordSetIFace mergedRS = recordSet.getRecordSetId() != null ? session.merge(recordSet) : recordSet;
                session.beginTransaction();
                FormHelper.updateLastEdittedInfo(mergedRS);
                session.saveOrUpdate(mergedRS);
                session.commit();
                session.flush();
                return true;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                ex.printStackTrace();
                log.error((Object)ex);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
            return false;
        }
        throw new RuntimeException("Trying to save object of class[" + recordSet.getClass() + "] and it must be RecordSet.");
    }

    /*
     * Unable to fully structure code
     */
    public String getUniqueRecordSetName(String intialName) {
        rsName = null;
        do {
            block9: {
                if ((rsName = JOptionPane.showInputDialog(UIRegistry.get("frame"), String.valueOf(UIRegistry.getResourceString("RecordSetTask.ASKFORNAME")) + ":", intialName)) == null) {
                    UIRegistry.displayStatusBarText("");
                    return null;
                }
                if (!UIHelper.isValidNameForDB(rsName)) {
                    UIRegistry.displayLocalizedStatusBarError("INVALID_CHARS_NAME", new Object[0]);
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                rsName = UIHelper.escapeName(rsName);
                rsName = StringUtils.replace((String)rsName, (String)"\"", (String)"`");
                session = DataProviderFactory.getInstance().createSession();
                sql = String.format("SELECT count(*) FROM RecordSet rs INNER JOIN rs.specifyUser spu WHERE rs.name = '%s' AND rs.collectionMemberId = COLLID AND spu.specifyUserId = SPECIFYUSERID", new Object[]{rsName});
                sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
                obj = session.getData(sql);
                if (!(obj instanceof Integer)) break block9;
                if ((Integer)obj == 0) {
                    UIRegistry.displayStatusBarText("");
                    var7_7 = rsName;
                    session.close();
                    return var7_7;
                }
                ** GOTO lbl28
            }
            try {
                try {
                    throw new RuntimeException("Return value should have been an Integer!");
lbl28:
                    // 1 sources

                    UIRegistry.getStatusBar().setErrorMessage(String.format(UIRegistry.getResourceString("RecordSetTask.RS_NAME_DUP"), new Object[]{rsName}));
                    Toolkit.getDefaultToolkit().beep();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(RecordSetTask.class, ex);
                    session.close();
                }
            }
            catch (Throwable var6_8) {
                session.close();
                throw var6_8;
            }
            session.close();
        } while (rsName != null);
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof RolloverCommand) {
            RolloverCommand roc = (RolloverCommand)evt.getSource();
            this.renameRecordSet(roc, (RecordSetIFace)roc.getData(), (String)evt.getOldValue(), (String)evt.getNewValue());
        }
    }

    protected void processRecordSetCommands(CommandAction cmdAction) {
        if (cmdAction.isAction(SAVE_RECORDSET)) {
            Object data = cmdAction.getData();
            if (data instanceof RecordSetIFace) {
                String rsName;
                String intialName = "";
                RecordSetIFace recordSet = (RecordSetIFace)cmdAction.getData();
                if (recordSet.getNumItems() == 1) {
                    Object dataObj;
                    RecordSetItemIFace item = recordSet.getOrderedItems().iterator().next();
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    String sqlStr = DBTableIdMgr.getInstance().getQueryForTable(recordSet.getDbTableId(), item.getRecordId().intValue());
                    if (StringUtils.isNotEmpty((String)sqlStr) && (dataObj = session.getData(sqlStr)) != null) {
                        intialName = ((FormDataObjIFace)dataObj).getIdentityTitle();
                    }
                    session.close();
                }
                if (StringUtils.isNotEmpty((String)(rsName = this.getUniqueRecordSetName(intialName)))) {
                    RecordSet rs = (RecordSet)data;
                    rs.setName(rsName);
                    rs.setModifiedByAgent(Agent.getUserAgent());
                    this.saveNewRecordSet(rs);
                }
            }
        } else if (cmdAction.isAction("Delete")) {
            int option;
            RolloverCommand roc;
            RecordSetIFace recordSet = null;
            if (cmdAction.getData() instanceof RecordSetIFace) {
                recordSet = (RecordSetIFace)cmdAction.getData();
            } else if (cmdAction.getData() instanceof RolloverCommand && (roc = (RolloverCommand)cmdAction.getData()).getData() instanceof RecordSetIFace) {
                recordSet = (RecordSetIFace)roc.getData();
            }
            if (recordSet != null && (option = JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("RecordSetTask.CONFIRM_DELETE"), recordSet.getName()), UIRegistry.getResourceString("RecordSetTask.CONFIRM_DELETE_TITLE"), 0, 3, null, null, 1)) == 0) {
                this.deleteRecordSet(recordSet);
                this.deleteRecordSetFromUI(null, recordSet);
            }
        } else if (cmdAction.isAction("Dropped")) {
            this.mergeRecordSets(cmdAction.getSrcObj(), cmdAction.getDstObj());
        } else if (cmdAction.isAction("AskForNewRS")) {
            this.createRecordSet((RecordSet)cmdAction.getSrcObj());
        } else if (cmdAction.isAction("DELETEITEMS")) {
            this.processDeleteRSItems(cmdAction);
        } else if (cmdAction.isAction(ADD_TO_NAV_BOX)) {
            this.addToNavBox((RecordSet)cmdAction.getData());
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart")) {
            for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                String srvName = ServiceInfo.getHashKey(ti.getTitle(), this, ti.getTableId());
                ContextMgr.unregisterService(srvName);
            }
            this.isInitialized = false;
            this.initialize();
        }
    }

    protected void prefsChanged(AppPreferences appPrefs) {
        String iconNameStr;
        ImageIcon iconImage;
        if (appPrefs == AppPreferences.getRemote() && (iconImage = IconManager.getIcon(iconNameStr = appPrefs.get(FormattingPrefsPanel.getDisciplineImageName(), "CollectionObject"), IconManager.STD_ICON_SIZE)) != null) {
            for (NavBoxIFace nb : this.navBoxes) {
                for (NavBoxItemIFace nbi : nb.getItems()) {
                    RecordSetIFace rsi;
                    Object data = nbi.getData();
                    if (!(data instanceof RecordSetIFace) || (rsi = (RecordSetIFace)data).getDbTableId() != CollectionObject.getClassTableId()) continue;
                    nbi.setIcon(iconImage);
                }
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(RECORD_SET)) {
            this.processRecordSetCommands(cmdAction);
        } else if (cmdAction.isType("Preferences")) {
            this.prefsChanged((AppPreferences)cmdAction.getData());
        }
    }

    public static void addDraggableDataFlavor(DataFlavor df) {
        RecordSetTask rst = (RecordSetTask)TaskMgr.getTask(RECORD_SET);
        if (df != null && rst != null) {
            rst.draggableFlavors.add(df);
        }
    }

    public static void addDroppableDataFlavor(DataFlavor df) {
        RecordSetTask rst = (RecordSetTask)TaskMgr.getTask(RECORD_SET);
        if (df != null && rst != null) {
            rst.droppableFlavors.add(df);
        }
    }

    public static RecordSetIFace askForRecordSet(int tableId) {
        return RecordSetTask.askForRecordSet(tableId, null);
    }

    public static RecordSetIFace askForRecordSet(int tableId, Vector<RecordSetIFace> additionalRS) {
        Vector<Integer> id = new Vector<Integer>(1);
        id.add(tableId);
        return RecordSetTask.askForRecordSet(id, additionalRS, false);
    }

    public static RecordSetIFace askForRecordSet(Vector<Integer> tableIds, Vector<RecordSetIFace> additionalRS, boolean msgIfNoRecordsets) {
        UsageTracker.incrUsageCount("RS.ASKRS");
        ChooseRecordSetDlg dlg = new ChooseRecordSetDlg(tableIds);
        if (additionalRS != null && additionalRS.size() > 0) {
            dlg.addAdditionalObjectsAsRecordSets(additionalRS);
        }
        if (dlg.hasRecordSets()) {
            UIHelper.centerAndShow(dlg);
            return dlg.isCancelled() ? null : dlg.getSelectedRecordSet();
        }
        if (msgIfNoRecordsets) {
            UIRegistry.displayLocalizedStatusBarText("RecordSetTask.NoRecordsets", new Object[0]);
        }
        return null;
    }

    @Override
    protected boolean[][] getPermsArray() {
        return new boolean[][]{{true, true, true, true}, {true, true, true, true}, {true, true, true, true}, {true, true, true, true}};
    }

    class RecordSetSelectedAction
    implements ActionListener {
        private NavBoxButton ro;
        private RecordSetIFace rs;

        public RecordSetSelectedAction(NavBoxButton ro, RecordSetIFace rs) {
            this.ro = ro;
            this.rs = rs;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataActionEvent dataActionEv;
            Object src = e.getSource();
            if (e instanceof DataActionEvent) {
                dataActionEv = (DataActionEvent)e;
                if (dataActionEv.getSourceObj() != null) {
                    Object data = dataActionEv.getSourceObj().getData();
                    if (data instanceof CommandAction) {
                        CommandAction cmdAction = (CommandAction)data;
                        cmdAction.setData(this.rs);
                        CommandDispatcher.dispatch(cmdAction);
                    } else {
                        log.debug(data);
                    }
                }
            } else {
                throw new RuntimeException("How did we get here?");
            }
            CommandDispatcher.dispatch(new CommandAction(RecordSetTask.RECORD_SET, src == this.ro ? "Clicked" : "Dropped", dataActionEv.getData(), this.rs, null));
        }
    }
}

