/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.RecordSetItem;
import edu.ku.brc.specify.tasks.RecordSetTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class RecordSetProxy
implements RecordSetIFace {
    private RecordSet recordSet = null;
    protected Integer recordSetId;
    protected Byte type;
    protected String name;
    protected Integer dbTableId;
    protected Class<?> dataClass;
    protected String remarks = null;
    protected ImageIcon dataSpecificIcon = null;

    public RecordSetProxy(Integer recordSetId, Byte type, String name, Integer dbTableId, String remarks, Class<?> dataClass) {
        this.recordSetId = recordSetId;
        this.type = type;
        this.name = name;
        this.dbTableId = dbTableId;
        this.remarks = remarks;
        this.dataClass = dataClass;
        this.dataSpecificIcon = null;
    }

    @Override
    public void addAll(Collection<RecordSetItemIFace> list) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public RecordSetItemIFace addItem(Integer recordId) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public RecordSetItemIFace addItem(String recordId) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public RecordSetItemIFace addItem(RecordSetItemIFace item) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public void clearItems() {
    }

    @Override
    public Class<?> getDataClassFormItems() {
        return this.dataClass;
    }

    @Override
    public ImageIcon getDataSpecificIcon() {
        return this.dataSpecificIcon;
    }

    @Override
    public Integer getDbTableId() {
        return this.dbTableId;
    }

    @Override
    public Set<RecordSetItemIFace> getItems() {
        try {
            if (this.loadRecordSet()) {
                Set<RecordSetItemIFace> set = this.recordSet.getItems();
                return set;
            }
        }
        finally {
            this.recordSet = null;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumItems() {
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            connection = DBConnection.getInstance().createConnection();
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM recordsetitem WHERE RecordSetID = " + this.recordSetId);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(RecordSetProxy.class, ex);
            ex.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetProxy.class, e);
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public RecordSetItemIFace getOnlyItem() {
        try {
            if (this.loadRecordSet() && this.recordSet.getItems().size() == 1) {
                RecordSetItemIFace recordSetItemIFace = this.recordSet.getItems().iterator().next();
                return recordSetItemIFace;
            }
        }
        finally {
            this.recordSet = null;
        }
        return null;
    }

    @Override
    public List<RecordSetItemIFace> getOrderedItems() {
        try {
            if (this.loadRecordSet()) {
                List<RecordSetItemIFace> list = this.recordSet.getOrderedItems();
                return list;
            }
        }
        finally {
            this.recordSet = null;
        }
        return null;
    }

    private boolean loadRecordSet() {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            this.recordSet = session.getData(RecordSet.class, "recordSetId", this.recordSetId, DataProviderSessionIFace.CompareType.Equals);
            return true;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(RecordSetProxy.class, ex);
            ex.printStackTrace();
            this.recordSet = null;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return false;
    }

    public RecordSet getRecordSet() {
        try {
            RecordSet recordSet = this.loadRecordSet() ? this.recordSet : null;
            return recordSet;
        }
        finally {
            this.recordSet = null;
        }
    }

    @Override
    public Integer getRecordSetId() {
        return this.recordSetId;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public int getTableId() {
        return RecordSet.getClassTableId();
    }

    @Override
    public void removeItem(RecordSetItemIFace rsi) {
        if (!(rsi instanceof RecordSetItem)) {
            throw new RuntimeException("Trying to delete record set item from non persisten RS");
        }
        RecordSetTask.deleteItems(this.recordSetId, null, ((RecordSetItem)rsi).getRecordSetItemId());
    }

    @Override
    public void setType(Byte type) {
    }

    @Override
    public void setDataSpecificIcon(ImageIcon dataSpecificIcon) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public void setDbTableId(Integer tableId) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public void setItems(Set<RecordSetItemIFace> items) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public void setName(String nameArg) {
        this.name = nameArg;
    }

    @Override
    public void setRecordSetId(Integer recordSetId) {
        throw new RuntimeException("Can't call on proxy");
    }

    @Override
    public void setRemarks(String remarks) {
        throw new RuntimeException("Can't call on proxy");
    }
}

