/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.DroppableNavBox;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.QueryConfigureDlg;
import edu.ku.brc.specify.tasks.QueryCreatorsConfigureDlg;
import edu.ku.brc.specify.tasks.ReportServiceInfo;
import edu.ku.brc.specify.tasks.ReportsBaseTask;
import edu.ku.brc.specify.tasks.ReportsTask;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tasks.subpane.SQLQueryPane;
import edu.ku.brc.specify.tasks.subpane.qb.QBLiveDataSource;
import edu.ku.brc.specify.tasks.subpane.qb.QBQueryForIdResultsHQL;
import edu.ku.brc.specify.tasks.subpane.qb.QBReportInfoPanel;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.specify.tasks.subpane.qb.SearchResultReportServiceInfo;
import edu.ku.brc.specify.tasks.subpane.qb.TableTree;
import edu.ku.brc.specify.tasks.subpane.qb.TreeLevelQRI;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.Trash;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.SoftReference;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class QueryTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(QueryTask.class);
    public static final String QUERY = "Query";
    public static final String SAVE_QUERY = "Save";
    public static final String REFRESH_QUERIES = "RefreshQueries";
    public static final String QUERY_RESULTS_REPORT = "QueryResultsReport";
    protected static final String XML_PATH_PREF = "Query.XML.Dir";
    public static final DataFlavor QUERY_FLAVOR = new DataFlavor(QueryTask.class, "Query");
    protected QueryBldrPane queryBldrPane = null;
    protected SoftReference<TableTree> tableTree = null;
    protected SoftReference<Hashtable<String, TableTree>> tableTreeHash = null;
    protected final AtomicBoolean configurationHasChanged = new AtomicBoolean(false);
    protected Vector<ToolBarDropDownBtn> tbList = new Vector();
    protected Vector<JComponent> menus = new Vector();
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected DroppableNavBox navBox = null;
    protected NavBox actionNavBox = null;
    protected Vector<String> favQueries = new Vector();
    protected Vector<String> freqQueries;
    protected Vector<String> extraQueries;
    protected Vector<String> stdQueries = new Vector();
    protected int nonFavCount = 0;

    public QueryTask() {
        this(QUERY, UIRegistry.getResourceString(QUERY));
    }

    public QueryTask(String name, String title) {
        super(name, title);
        CommandDispatcher.register(name, this);
        CommandDispatcher.register("treedefeditor", this);
        CommandDispatcher.register("SCHEMA_LOCALIZER", this);
    }

    public static boolean askUserForInfo(String viewSetName, String dlgTitle, SpQuery query) {
        ViewBasedDisplayDialog editorDlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "Global", viewSetName, null, dlgTitle, UIRegistry.getResourceString("OK"), null, null, true, 8);
        editorDlg.preCreateUI();
        editorDlg.setData(query);
        editorDlg.getMultiView().preValidate();
        editorDlg.setModal(true);
        editorDlg.setVisible(true);
        if (!editorDlg.isCancelled()) {
            editorDlg.getMultiView().getDataFromUI();
        }
        editorDlg.dispose();
        return !editorDlg.isCancelled();
    }

    protected SpQuery createNewQueryDataObj(DBTableInfo tableInfo) {
        SpQuery query = new SpQuery();
        query.initialize();
        query.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
        query.setName(String.format(UIRegistry.getResourceString("QB_NEW_QUERY_NAME"), tableInfo.getTitle()));
        query.setNamed(false);
        query.setContextTableId((short)tableInfo.getTableId());
        query.setContextName(tableInfo.getShortClassName());
        return query;
    }

    public void createAndExecute(String sqlStr) {
        UsageTracker.incrUsageCount("QB.EXE");
        SQLQueryPane sqlPane = new SQLQueryPane(this.name, this, false, false);
        this.addSubPaneToMgr(sqlPane);
        sqlPane.setSQLStr(sqlStr);
        sqlPane.doQuery();
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = StartUpTask.createFullImageSplashPanel(this.title, this);
        return this.starterPane;
    }

    @Override
    public void preInitialize() {
        this.actionNavBox = new NavBox(this.getActionNavBoxTitle());
        this.addNewQCreators();
    }

    protected String getActionNavBoxTitle() {
        return UIRegistry.getResourceString("QB_CREATE_QUERY");
    }

    protected void readOrgLists() {
        this.freqQueries = this.readResourceForList("QueryFreqList");
        this.extraQueries = this.readResourceForList("QueryExtraList");
        if (AppContextMgr.isSecurityOn()) {
            this.securityFilter(this.freqQueries);
            this.securityFilter(this.extraQueries);
        }
    }

    protected void securityFilter(Vector<String> list) {
        int t = list.size() - 1;
        while (t >= 0) {
            String tblName = list.get(t);
            if (!DBTableIdMgr.getInstance().getByShortClassName(tblName).getPermissions().canView()) {
                list.remove(t);
            }
            --t;
        }
    }

    protected Vector<String> readResourceForList(String resourceName) {
        Vector list = null;
        String xmlStr = null;
        AppResourceIFace appRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
        if (appRes != null) {
            xmlStr = appRes.getDataAsString();
        } else {
            AppResourceIFace newAppRes = AppContextMgr.getInstance().copyToDirAppRes("Personal", resourceName);
            if (newAppRes != null) {
                AppContextMgr.getInstance().saveResource(newAppRes);
                xmlStr = newAppRes.getDataAsString();
            } else if (resourceName.equals("QueryFreqList") || resourceName.equals("QueryExtraList")) {
                ((SpecifyAppContextMgr)AppContextMgr.getInstance()).addDiskResourceToAppDir("Discipline", resourceName);
                newAppRes = AppContextMgr.getInstance().copyToDirAppRes("Personal", resourceName);
                if (newAppRes != null) {
                    AppContextMgr.getInstance().saveResource(newAppRes);
                    xmlStr = newAppRes.getDataAsString();
                } else {
                    xmlStr = "";
                }
            } else {
                xmlStr = "";
            }
        }
        if (StringUtils.isNotEmpty((String)xmlStr)) {
            XStream xstream = new XStream();
            list = (Vector)xstream.fromXML(xmlStr);
        }
        if (list == null) {
            list = new Vector();
        }
        return list;
    }

    protected void saveQueryList(String resourceName, Vector<String> list) {
        XStream xstream = new XStream();
        AppResourceIFace uaAppRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
        if (uaAppRes != null) {
            uaAppRes.setDataAsString(xstream.toXML(list));
            AppContextMgr.getInstance().saveResource(uaAppRes);
        } else {
            AppContextMgr.getInstance().putResourceAsXML(resourceName, xstream.toXML(list));
        }
    }

    protected void saveQueryListConfiguration() {
        this.saveQueryList("QueryFreqList", this.freqQueries);
        this.saveQueryList("QueryExtraList", this.extraQueries);
    }

    protected void configureCreatorQueries() {
        QueryCreatorsConfigureDlg dlg = new QueryCreatorsConfigureDlg(this, this.freqQueries, this.extraQueries, this.stdQueries);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            this.actionNavBox.clear();
            Vector<String> freqs = dlg.getFreqQueries();
            Vector<String> extras = dlg.getExtraQueries();
            this.buildNavBoxes(freqs, extras);
            this.actionNavBox.validate();
            this.actionNavBox.doLayout();
            NavBoxMgr.getInstance().validate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
            this.freqQueries = freqs;
            this.extraQueries = extras;
            this.saveQueryListConfiguration();
        }
    }

    protected void configureFavoriteQueries() {
        QueryConfigureDlg dlg = new QueryConfigureDlg(this);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            Vector<SpQuery> favs;
            block17: {
                RecordSetItemIFace rsi;
                int id;
                favs = dlg.getFavQueries();
                Vector<SpQuery> extras = dlg.getOtherQueries();
                Hashtable<Integer, Integer> hash = new Hashtable<Integer, Integer>();
                for (SpQuery q : favs) {
                    id = q.getId();
                    hash.put(id, id);
                }
                for (NavBoxItemIFace nbi : new Vector<NavBoxItemIFace>(this.navBox.getItems())) {
                    int id2;
                    Integer idInt;
                    RecordSetIFace rs = (RecordSetIFace)nbi.getData();
                    if (rs == null || (idInt = (rsi = rs.getOnlyItem()).getRecordId()) == null || hash.get(id2 = idInt.intValue()) != null) continue;
                    this.navBox.remove(nbi);
                }
                hash.clear();
                for (NavBoxItemIFace nbi : this.navBox.getItems()) {
                    RecordSetIFace rs = (RecordSetIFace)nbi.getData();
                    if (rs == null) continue;
                    rsi = rs.getOnlyItem();
                    int id3 = rsi.getRecordId();
                    hash.put(id3, id3);
                }
                for (SpQuery query : favs) {
                    id = query.getId();
                    if (hash.get(id) != null) continue;
                    RecordSet rs = new RecordSet();
                    rs.initialize();
                    rs.set(query.getName(), SpQuery.getClassTableId(), RecordSet.GLOBAL);
                    rs.addItem(query.getSpQueryId());
                    this.addToNavBox(rs);
                }
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.beginTransaction();
                        short order = 0;
                        for (SpQuery query : favs) {
                            query.setIsFavorite(true);
                            short s = order;
                            order = (short)(s + 1);
                            query.setOrdinal(s);
                            session.saveOrUpdate(query);
                        }
                        for (SpQuery query : extras) {
                            query.setIsFavorite(false);
                            query.setOrdinal(null);
                            session.saveOrUpdate(query);
                        }
                        session.commit();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(QueryTask.class, ex);
                        session.rollback();
                        if (session != null) {
                            session.close();
                        }
                        break block17;
                    }
                }
                catch (Throwable id3) {
                    if (session != null) {
                        session.close();
                    }
                    throw id3;
                }
                if (session != null) {
                    session.close();
                }
            }
            Hashtable<Integer, NavBoxItemIFace> nbiHash = new Hashtable<Integer, NavBoxItemIFace>();
            for (NavBoxItemIFace nbi : this.navBox.getItems()) {
                RecordSetIFace rs = (RecordSetIFace)nbi.getData();
                if (rs == null) continue;
                RecordSetItemIFace rsi = rs.getOnlyItem();
                int id = rsi.getRecordId();
                nbiHash.put(id, nbi);
            }
            this.navBox.clear();
            Collections.sort(favs, new Comparator<SpQuery>(){

                @Override
                public int compare(SpQuery q1, SpQuery q2) {
                    return q1.getOrdinal().compareTo(q2.getOrdinal());
                }
            });
            for (SpQuery query : favs) {
                int id = query.getId();
                this.navBox.add((NavBoxItemIFace)nbiHash.get(id));
            }
            this.checkForOtherNavBtn();
            this.navBox.validate();
            this.navBox.doLayout();
            NavBoxMgr.getInstance().validate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
        }
    }

    protected void checkForOtherNavBtn() {
        String sqlStr = "From SpQuery as sq Inner Join sq.specifyUser as user where sq.isFavorite = false AND user.specifyUserId = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId();
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<?> queries = session.getDataList(sqlStr);
            int count = 0;
            for (Object[] obj : queries) {
                SpQuery query = (SpQuery)obj[0];
                if (AppContextMgr.isSecurityOn() && !DBTableIdMgr.getInstance().getInfoById(query.getContextTableId().shortValue()).getPermissions().canView()) continue;
                count = 1;
                break;
            }
            if (count > 0) {
                NavBoxItemIFace nbi = NavBox.createBtnWithTT(UIRegistry.getResourceString("QY_OTHER_QUERIES"), this.name, UIRegistry.getResourceString("QY_OTHER_QUERIES_TT"), IconManager.STD_ICON_SIZE, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        QueryTask.this.showOtherViewsDlg();
                    }
                });
                this.navBox.add(nbi);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void doConfigure() {
        UsageTracker.incrUsageCount("QB.CONFIG");
        String configCreators = UIRegistry.getResourceString("QY_CONFIGURE_CREATORS");
        String configQueries = UIRegistry.getResourceString("QY_CONFIGURE_QUERIES");
        Vector configNames = new Vector();
        Collections.addAll(configNames, configCreators, configQueries);
        ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg((Frame)UIRegistry.getTopWindow(), "QY_CHOOSE_CONFIG", configNames, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            if (((String)dlg.getSelectedObject()).equals(configCreators)) {
                this.configureCreatorQueries();
            } else {
                this.configureFavoriteQueries();
            }
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = new JMenuItem(UIRegistry.getResourceString("QY_CONFIGURE_CREATORS"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryTask.this.configureCreatorQueries();
            }
        });
        mi = new JMenuItem(UIRegistry.getResourceString("QY_CONFIGURE_QUERIES"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryTask.this.configureFavoriteQueries();
            }
        });
        mi = new JMenuItem(UIRegistry.getResourceString("QY_IMPORT_QUERIES"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryTask.this.importQueries();
            }
        });
        mi = new JMenuItem(UIRegistry.getResourceString("QY_EXPORT_QUERIES"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryTask.this.exportQueries();
            }
        });
        return popupMenu;
    }

    protected void buildNavBoxes(Vector<String> freqList, Vector<String> extraList) {
        this.createCreateQueryNavBtns(freqList);
        if (extraList != null && !extraList.isEmpty()) {
            NavBoxItemIFace nbi = NavBox.createBtnWithTT(UIRegistry.getResourceString("QY_EXTRA_TABLES"), "MoreTables", UIRegistry.getResourceString("QY_EXTRA_TABLES_TT"), IconManager.STD_ICON_SIZE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryTask.this.showMiscViewsDlg();
                }
            });
            this.actionNavBox.add(nbi);
        }
    }

    protected void showMiscViewsDlg() {
        String shortClassName = null;
        if (this.extraQueries.size() == 1) {
            shortClassName = this.extraQueries.get(0);
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(shortClassName);
            if (tableInfo != null) {
                this.createNewQuery(tableInfo);
            }
        } else {
            String sName;
            DBTableInfo tableInfo;
            Hashtable<String, DBTableInfo> tiHash = new Hashtable<String, DBTableInfo>();
            Vector<String> names = new Vector<String>();
            for (String sName2 : this.extraQueries) {
                tableInfo = DBTableIdMgr.getInstance().getByShortClassName(sName2);
                names.add(tableInfo.getTitle());
                tiHash.put(tableInfo.getTitle(), tableInfo);
            }
            ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg((Frame)UIRegistry.getTopWindow(), "QY_EXTRA_TABLES", names, ToggleButtonChooserPanel.Type.RadioButton);
            dlg.setUseScrollPane(true);
            dlg.setVisible(true);
            if (!dlg.isCancelled() && (tableInfo = (DBTableInfo)tiHash.get(sName = (String)dlg.getSelectedObject())) != null) {
                this.createNewQuery(tableInfo);
            }
        }
    }

    protected void showOtherViewsDlg() {
        Vector<SpQuery> queryList = new Vector<SpQuery>();
        List<?> rows = null;
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            rows = session.getDataList("FROM SpQuery as sq Inner Join sq.specifyUser as user where sq.isFavorite = false AND user.specifyUserId = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId() + " ORDER BY sq.name");
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        if (rows.size() == 1) {
            Object[] row = (Object[])rows.iterator().next();
            new EditOtherQueryWorker(((SpQuery)row[0]).getId()).start();
        } else {
            for (Object obj : rows) {
                Object[] row = (Object[])obj;
                queryList.add((SpQuery)row[0]);
            }
            ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg((Frame)UIRegistry.getTopWindow(), "QY_OTHER_QUERIES", queryList, ToggleButtonChooserPanel.Type.RadioButton);
            dlg.setUseScrollPane(true);
            dlg.setVisible(true);
            if (!dlg.isCancelled()) {
                new EditOtherQueryWorker(((SpQuery)dlg.getSelectedObject()).getId()).start();
            }
        }
    }

    protected void createCreateQueryNavBtns(Vector<String> list) {
        for (String shortClassName : list) {
            this.createQueryCreateNB(shortClassName);
        }
    }

    protected void createQueryCreateNB(String shortClassName) {
        final DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(shortClassName);
        this.actionNavBox.add(NavBox.createBtnWithTT(String.format(UIRegistry.getResourceString("QB_CREATE_NEWQUERY"), tableInfo.getTitle()), tableInfo.getName(), UIRegistry.getResourceString("QB_CREATE_NEWQUERY_TT"), IconManager.STD_ICON_SIZE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new NewQueryWorker(tableInfo).start();
            }
        }));
    }

    protected boolean showQueryCreator(String tblName) {
        DBTableInfo tbl = DBTableIdMgr.getInstance().getByShortClassName(tblName);
        return !tbl.isHidden() && (!AppContextMgr.isSecurityOn() || tbl.getPermissions().canView());
    }

    protected void addNewQCreators() {
        this.readOrgLists();
        this.buildNavBoxes(this.freqQueries, this.extraQueries);
        try {
            Element root = XMLHelper.readDOMFromConfigDir("querybuilder.xml");
            List tableNodes = root.selectNodes("/database/table");
            for (Object obj : tableNodes) {
                String sName = XMLHelper.getAttr((Element)obj, "name", null);
                if (!this.showQueryCreator(sName)) continue;
                this.stdQueries.add(sName);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryTask.class, ex);
            ex.printStackTrace();
        }
    }

    protected String getQueryType() {
        return QUERY;
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            this.navBox = new DroppableNavBox(this.getQueryNavBoxTitle(), QUERY_FLAVOR, this.getQueryType(), SAVE_QUERY);
            this.loadQueries();
            this.navBoxes.add(this.actionNavBox);
            this.navBoxes.add(this.navBox);
            this.registerServices();
        }
        this.isShowDefault = true;
    }

    protected void registerServices() {
        ContextMgr.registerService(new ReportServiceInfo());
    }

    protected String getQueryNavBoxTitle() {
        return UIRegistry.getResourceString("QUERIES");
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        String label = UIRegistry.getResourceString(this.name);
        String localIconName = this.name;
        String hint = UIRegistry.getResourceString("search_hint");
        ToolBarDropDownBtn btn = this.createToolbarButton(label, localIconName, hint, this.menus);
        if (this.tbList.size() == 0) {
            this.tbList.add(btn);
        }
        this.toolbarItems.add(new ToolBarItemDesc(btn));
        return this.toolbarItems;
    }

    protected NavBoxItemIFace addToNavBox(final RecordSet recordSet) {
        ImageIcon rsIcon;
        boolean canDelete = ((QueryTask)ContextMgr.getTaskByClass(QueryTask.class)).isPermitted();
        RolloverCommand roc = (RolloverCommand)((Object)QueryTask.makeDnDNavBtn(this.navBox, recordSet.getName(), QUERY, null, canDelete ? new CommandAction(this.getQueryType(), "Delete", recordSet) : null, true, true));
        roc.setToolTip(UIRegistry.getResourceString("QY_CLICK2EDIT"));
        roc.setData(recordSet);
        roc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new EditQueryWorker(recordSet.getOnlyItem().getRecordId(), (RolloverCommand)e.getSource()).start();
            }
        });
        NavBoxItemIFace nbi = (NavBoxItemIFace)((Object)roc);
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(recordSet.getTableId());
        if (tblInfo != null && (rsIcon = tblInfo.getIcon(IconManager.STD_ICON_SIZE)) != null) {
            nbi.setIcon(rsIcon);
        }
        roc.addDragDataFlavor(new DataFlavorTableExt(this.getClass(), this.getQueryType(), recordSet.getTableId()));
        if (canDelete) {
            roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        }
        return nbi;
    }

    public static boolean isSchemaExportQuery(SpQuery query) {
        return BasicSQLUtils.getCount("select count(*) from spexportschemaitemmapping mapping inner join spqueryfield qf  on qf.spqueryfieldid = mapping.spqueryfieldid where qf.spqueryid = " + query.getId()) > 0;
    }

    protected boolean isLoadableQuery(SpQuery query) {
        return !QueryTask.isSchemaExportQuery(query);
    }

    protected String getQueryLoaderHQL() {
        return "From SpQuery as sq Inner Join sq.specifyUser as user where sq.isFavorite = true AND user.specifyUserId = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId() + " ORDER BY ordinal";
    }

    protected List<?> getQueriesForLoading(DataProviderSessionIFace session) {
        return session.getDataList(this.getQueryLoaderHQL());
    }

    protected void loadQueries() {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<?> queries = this.getQueriesForLoading(session);
            for (Object obj : queries) {
                SpQuery query = (SpQuery)(obj instanceof Object[] ? ((Object[])obj)[0] : obj);
                if (AppContextMgr.isSecurityOn() && !DBTableIdMgr.getInstance().getInfoById(query.getContextTableId().shortValue()).getPermissions().canView() || !this.isLoadableQuery(query)) continue;
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.set(query.getName(), SpQuery.getClassTableId(), RecordSet.GLOBAL);
                rs.addItem(query.getSpQueryId());
                this.addToNavBox(rs);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        this.checkForOtherNavBtn();
    }

    protected void createNewQuery(DBTableInfo tableInfo) {
        SpQuery query;
        if ((this.queryBldrPane == null || this.queryBldrPane.aboutToShutdown()) && (query = this.createNewQueryDataObj(tableInfo)) != null) {
            this.editQuery(query);
        }
    }

    protected boolean editQuery(Integer queryId) {
        UsageTracker.incrUsageCount("QB.EDT");
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            SpQuery dataObj = session.getData(SpQuery.class, "spQueryId", queryId, DataProviderSessionIFace.CompareType.Equals);
            if (dataObj != null) {
                dataObj.forceLoad(true);
                boolean bl = this.editQuery(dataObj);
                return bl;
            }
            return false;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryTask.class, ex);
            ex.printStackTrace();
            return false;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public void requestContext() {
        boolean goodQueryPane;
        boolean goodStarterPane = this.starterPane != null && SubPaneMgr.getInstance().indexOfComponent(this.starterPane.getUIComponent()) > -1;
        boolean bl = goodQueryPane = this.queryBldrPane != null && SubPaneMgr.getInstance().indexOfComponent(this.queryBldrPane.getUIComponent()) > -1;
        if (goodStarterPane || goodQueryPane) {
            ContextMgr.requestContext(this);
        }
        if (!goodStarterPane) {
            if (!goodQueryPane) {
                super.requestContext();
            } else {
                SubPaneMgr.getInstance().showPane(this.queryBldrPane);
            }
        } else {
            SubPaneMgr.getInstance().showPane(this.starterPane);
        }
    }

    protected QueryBldrPane getNewQbPane(SpQuery query) {
        return new QueryBldrPane(query.getName(), (Taskable)this, query);
    }

    protected boolean checkLock(SpQuery query) {
        return true;
    }

    protected boolean editQuery(SpQuery query) {
        if (this.checkLock(query)) {
            QueryBldrPane newPane = this.getNewQbPane(query);
            if (this.starterPane != null) {
                SubPaneMgr.getInstance().replacePane(this.starterPane, newPane);
                this.starterPane = null;
            } else if (this.queryBldrPane != null) {
                SubPaneMgr.getInstance().replacePane(this.queryBldrPane, newPane);
            }
            this.queryBldrPane = newPane;
            return true;
        }
        return false;
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        return this.extendedNavBoxes;
    }

    @Override
    public boolean isSingletonPane() {
        return true;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    protected void persistQuery(SpQuery query, SpExportSchemaMapping schemaMapping) {
        boolean saved;
        boolean bl = saved = schemaMapping == null ? DataModelObjBase.save(true, new Object[]{query}) : DataModelObjBase.save(true, new Object[]{query, schemaMapping});
        if (saved) {
            FormHelper.updateLastEdittedInfo(query);
        }
    }

    public RolloverCommand saveNewQuery(SpQuery query, SpExportSchemaMapping schemaMapping, boolean enabled) {
        query.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        query.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
        if (query.getIsFavorite() == null) {
            query.setIsFavorite(true);
        }
        this.persistQuery(query, schemaMapping);
        RecordSet rs = new RecordSet();
        rs.initialize();
        rs.set(query.getName(), SpQuery.getClassTableId(), RecordSet.GLOBAL);
        rs.addItem(query.getSpQueryId());
        RolloverCommand roc = (RolloverCommand)((Object)this.addToNavBox(rs));
        roc.setEnabled(enabled);
        NavBoxMgr.getInstance().addBox(this.navBox);
        this.navBox.invalidate();
        this.navBox.setSize(this.navBox.getPreferredSize());
        this.navBox.doLayout();
        this.navBox.repaint();
        NavBoxMgr.getInstance().invalidate();
        NavBoxMgr.getInstance().doLayout();
        NavBoxMgr.getInstance().repaint();
        UIRegistry.forceTopFrameRepaint();
        String msg = String.format(UIRegistry.getResourceString("WB_SAVED"), query.getName());
        UIRegistry.getStatusBar().setText(msg);
        return roc;
    }

    protected void deleteThisQuery(SpQuery query, DataProviderSessionIFace session) throws Exception {
        session.delete(query);
    }

    protected boolean deleteQuery(RecordSet rs) {
        UsageTracker.incrUsageCount("QB.DEL");
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        boolean transOpen = false;
        SpQuery query = session.get(SpQuery.class, rs.getOnlyItem().getRecordId());
        try {
            query.forceLoad(true);
            if (query.getReports().size() > 0) {
                CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_CONFIRM_DELETE_TITLE"), true, 5, (Component)new QBReportInfoPanel(query, UIRegistry.getResourceString("QB_UNDELETABLE_REPS")));
                cd.setHelpContext("QBUndeletableReps");
                UIHelper.centerAndShow(cd);
                cd.dispose();
                return false;
            }
            int option = JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("REP_CONFIRM_DELETE"), query.getName()), UIRegistry.getResourceString("REP_CONFIRM_DELETE_TITLE"), 0, 3, null, null, 1);
            if (option == 0) {
                session.beginTransaction();
                transOpen = true;
                this.deleteThisQuery(query, session);
                session.commit();
                transOpen = false;
                return true;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryTask.class, ex);
            if (transOpen) {
                session.rollback();
            }
            ex.printStackTrace();
            log.error((Object)ex);
        }
        finally {
            session.close();
        }
        return false;
    }

    protected void deleteQueryFromUI(NavBoxItemIFace boxItem, RecordSet rs) {
        this.deleteDnDBtn(this.navBox, boxItem != null ? boxItem : QueryTask.getBoxByTitle(this.navBox, rs.getName()));
    }

    protected void processQueryCommands(CommandAction cmdAction) {
        if (cmdAction.isAction("Delete") && cmdAction.getData() instanceof RecordSetIFace) {
            RecordSet recordSet = (RecordSet)cmdAction.getData();
            if (this.deleteQuery(recordSet)) {
                this.deleteQueryFromUI(null, recordSet);
            }
            return;
        }
        if (cmdAction.isAction(REFRESH_QUERIES)) {
            this.navBox.clear();
            this.loadQueries();
            this.navBox.invalidate();
            this.navBox.doLayout();
            this.navBox.repaint();
            NavBoxMgr.getInstance().invalidate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
            UIRegistry.forceTopFrameRepaint();
            return;
        }
        if (cmdAction.isAction(QUERY_RESULTS_REPORT)) {
            ResultSetTableModel rsm;
            SearchResultReportServiceInfo selectedRep = null;
            JTable dataTbl = (JTable)cmdAction.getProperties().get("jtable");
            if (dataTbl != null && (rsm = (ResultSetTableModel)dataTbl.getModel()) != null) {
                Object src;
                QueryForIdResultsIFace results = rsm.getResults();
                QueryBldrPane qb = results instanceof QBQueryForIdResultsHQL ? ((QBQueryForIdResultsHQL)results).getQueryBuilder() : null;
                int tableId = ((RecordSet)cmdAction.getData()).getDbTableId();
                Vector<SearchResultReportServiceInfo> reps = new Vector<SearchResultReportServiceInfo>(((ReportsBaseTask)ContextMgr.getTaskByClass(ReportsTask.class)).getReports(tableId, qb));
                if (reps.size() == 0) {
                    log.error((Object)"no reports for query. Should't have gotten here.");
                } else if (rsm.isLoadingCells()) {
                    UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString("QB_NO_REPORTS_WHILE_LOADING_RESULTS"), 5000, null, null, true);
                } else {
                    ChooseFromListDlg<SearchResultReportServiceInfo> dlg = new ChooseFromListDlg<SearchResultReportServiceInfo>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_CHOOSE_SP_REPORT"), reps);
                    dlg.setVisible(true);
                    if (dlg.isCancelled()) {
                        return;
                    }
                    selectedRep = dlg.getSelectedObject();
                    dlg.dispose();
                }
                if (selectedRep == null || selectedRep.getFileName() == null) {
                    return;
                }
                if (selectedRep.isLiveData()) {
                    List<ERTICaptionInfo> captions = rsm.getResults().getVisibleCaptionInfo();
                    src = new QBLiveDataSource(rsm, captions, selectedRep.getRepeats());
                } else {
                    int[] selectedRows = rsm.getParentERTP().getSelectedRows();
                    if (selectedRows != null && selectedRows.length == 0) {
                        selectedRows = null;
                    }
                    src = selectedRows == null ? (RecordSet)cmdAction.getData() : rsm.getRecordSet(selectedRows, false);
                }
                CommandAction cmd = new CommandAction("Reports", "RPT.PrintReport", src);
                cmd.setProperty("title", rsm.getResults().getTitle());
                cmd.setProperty("file", selectedRep.getFileName());
                if (selectedRep.isRequiresNewConnection()) {
                    RecordSet repRS = new RecordSet();
                    repRS.initialize();
                    repRS.set(selectedRep.getReportName(), SpReport.getClassTableId(), RecordSet.GLOBAL);
                    repRS.addItem(selectedRep.getSpReportId());
                    cmd.setProperty("spreport", repRS);
                }
                CommandDispatcher.dispatch(cmd);
            }
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart")) {
            this.configurationHasChanged.set(true);
            this.isInitialized = false;
            this.initialize();
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(this.getQueryType())) {
            this.processQueryCommands(cmdAction);
        } else if (cmdAction.isType("treedefeditor")) {
            this.configurationHasChanged.set(true);
        } else if (cmdAction.isType("SCHEMA_LOCALIZER")) {
            this.configurationHasChanged.set(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubPaneMgr.getInstance().getCurrentSubPane() == QueryTask.this.queryBldrPane && QueryTask.this.queryBldrPane != null) {
                        QueryTask.this.queryBldrPane.showingPane(true);
                    }
                }
            });
        }
    }

    protected void bldTableTrees() {
        if (this.tableTree == null || this.tableTree.get() == null || this.needToRebuildTableTree()) {
            this.tableTreeHash = null;
            this.tableTree = new SoftReference<TableTree>(this.readTables());
        }
        if (this.tableTreeHash == null || this.tableTreeHash.get() == null || this.needToRebuildTableTree()) {
            this.tableTreeHash = new SoftReference<Hashtable<String, TableTree>>(this.buildTableTreeHash(this.tableTree.get()));
        }
        this.configurationHasChanged.set(false);
    }

    protected void clearTableTree(TableTree tree) {
        if (tree.getTableQRI() != null) {
            tree.getTableQRI().setIsInUse(false);
            int f = 0;
            while (f < tree.getTableQRI().getFields()) {
                tree.getTableQRI().getField(f).setIsInUse(false);
                ++f;
            }
        }
        int k = 0;
        while (k < tree.getKids()) {
            this.clearTableTree(tree.getKid(k));
            ++k;
        }
    }

    public synchronized Pair<TableTree, Hashtable<String, TableTree>> getTableTrees() {
        if (this.needToRebuildTableTree()) {
            this.bldTableTrees();
        } else {
            this.clearTableTree(this.tableTree.get());
        }
        return new Pair<TableTree, Hashtable<String, TableTree>>(this.tableTree.get(), this.tableTreeHash.get());
    }

    public synchronized boolean needToRebuildTableTree() {
        return this.tableTree == null || this.tableTree.get() == null || this.tableTreeHash == null || this.tableTreeHash.get() == null || this.configurationHasChanged.get();
    }

    protected TableTree readTables() {
        TableTree treeRoot = new TableTree("root", "root", "root", null);
        try {
            Element root = XMLHelper.readDOMFromConfigDir("querybuilder.xml");
            List tableNodes = root.selectNodes("/database/table");
            for (Object obj : tableNodes) {
                Element tableElement = (Element)obj;
                this.processForTables(tableElement, treeRoot);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryTask.class, ex);
            ex.printStackTrace();
        }
        return treeRoot;
    }

    protected void processForTables(Element parent, TableTree parentTT) {
        String tableName = XMLHelper.getAttr(parent, "name", null);
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(tableName);
        if (!(tableInfo.isHidden() || AppContextMgr.isSecurityOn() && !tableInfo.getPermissions().canView())) {
            Element kidElement;
            String fieldName = XMLHelper.getAttr(parent, "field", null);
            if (StringUtils.isEmpty((String)fieldName)) {
                fieldName = String.valueOf(tableName.substring(0, 1).toLowerCase()) + tableName.substring(1);
            }
            String abbrev = XMLHelper.getAttr(parent, "abbrev", null);
            TableTree newTreeNode = parentTT.addKid(new TableTree(tableName, fieldName, abbrev, tableInfo));
            if (Treeable.class.isAssignableFrom(tableInfo.getClassObj())) {
                try {
                    SpecifyAppContextMgr mgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
                    TreeDefIface<?, ?, ?> treeDef = mgr.getTreeDefForClass(tableInfo.getClassObj());
                    TreeSet defItems = new TreeSet(new Comparator<TreeDefItemIface<?, ?, ?>>(){

                        @Override
                        public int compare(TreeDefItemIface<?, ?, ?> o1, TreeDefItemIface<?, ?, ?> o2) {
                            Integer r1 = o1.getRankId();
                            Integer r2 = o2.getRankId();
                            return r1.compareTo(r2);
                        }
                    });
                    defItems.addAll(treeDef.getTreeDefItems());
                    for (TreeDefItemIface defItem : defItems) {
                        if (defItem.getRankId() <= 0) continue;
                        try {
                            newTreeNode.getTableQRI().addField(new TreeLevelQRI(newTreeNode.getTableQRI(), null, defItem.getRankId(), "name", treeDef));
                            if (!(defItem instanceof TaxonTreeDefItem)) continue;
                            newTreeNode.getTableQRI().addField(new TreeLevelQRI(newTreeNode.getTableQRI(), null, defItem.getRankId(), "author", treeDef));
                        }
                        catch (Exception ex) {
                            if (ex instanceof TreeLevelQRI.NoTreeDefItemException) {
                                log.error((Object)ex);
                                continue;
                            }
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(QueryTask.class, ex);
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryTask.class, ex);
                    ex.printStackTrace();
                }
            }
            for (Object kidObj : parent.selectNodes("table")) {
                kidElement = (Element)kidObj;
                this.processForTables(kidElement, newTreeNode);
            }
            for (Object obj : parent.selectNodes("alias")) {
                kidElement = (Element)obj;
                String kidClassName = XMLHelper.getAttr(kidElement, "name", null);
                tableInfo = DBTableIdMgr.getInstance().getByShortClassName(kidClassName);
                if (tableInfo.isHidden() || AppContextMgr.isSecurityOn() && !tableInfo.getPermissions().canView()) continue;
                tableName = XMLHelper.getAttr(kidElement, "name", null);
                fieldName = XMLHelper.getAttr(kidElement, "field", null);
                if (StringUtils.isEmpty((String)fieldName)) {
                    fieldName = String.valueOf(tableName.substring(0, 1).toLowerCase()) + tableName.substring(1);
                }
                newTreeNode.addKid(new TableTree(kidClassName, fieldName, true));
            }
        }
    }

    protected String getTopLevelNodeSelector() {
        return "/queries/query";
    }

    protected static Vector<SpQuery> getQueriesFromFile(String filePath, String topNode) {
        Vector<SpQuery> queries = new Vector<SpQuery>();
        try {
            Element root = XMLHelper.readFileToDOM4J(new File(filePath));
            for (Object obj : root.selectNodes(topNode)) {
                Element el = (Element)obj;
                SpQuery query = new SpQuery();
                query.initialize();
                query.fromXML(el);
                query.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
                queries.add(query);
            }
            return queries;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryTask.class, ex);
            ex.printStackTrace();
            return null;
        }
    }

    protected static void adjustImportedQueryNames(List<SpQuery> importedQueries, List<String> existingQueries) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(existingQueries);
        for (SpQuery query : importedQueries) {
            String origName = query.getName();
            int cnt = 0;
            String qName = origName;
            while (names.contains(qName)) {
                qName = String.valueOf(origName) + ++cnt;
            }
            query.setName(qName);
            names.add(qName);
        }
    }

    protected static boolean importQueries(String filePath) {
        Vector<SpQuery> queries = QueryTask.getQueriesFromFile(filePath, "/queries/query");
        Vector<String> names = new Vector<String>();
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<SpQuery> qs = session.getDataList(SpQuery.class);
            for (SpQuery q : qs) {
                names.add(q.getName());
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        QueryTask.adjustImportedQueryNames(queries, names);
        return DataModelObjBase.save(true, new Object[]{queries});
    }

    protected void importQueries() {
        UsageTracker.incrUsageCount("QB.IMPORT");
        String path = AppPreferences.getLocalPrefs().get(XML_PATH_PREF, null);
        FileDialog fDlg = new FileDialog((Frame)UIRegistry.getTopWindow(), "Open", 0);
        if (path != null) {
            fDlg.setDirectory(path);
        }
        fDlg.setVisible(true);
        String dirStr = fDlg.getDirectory();
        String fileName = fDlg.getFile();
        if (StringUtils.isEmpty((String)dirStr) || StringUtils.isEmpty((String)fileName)) {
            return;
        }
        path = String.valueOf(dirStr) + fileName;
        AppPreferences.getLocalPrefs().put(XML_PATH_PREF, path);
        Vector<SpQuery> queries = QueryTask.getQueriesFromFile(path, this.getTopLevelNodeSelector());
        ToggleButtonChooserDlg<SpQuery> dlg = new ToggleButtonChooserDlg<SpQuery>((Frame)UIRegistry.getMostRecentWindow(), "QY_IMPORT_QUERIES", "QY_SEL_QUERIES_IMP", queries, 7, ToggleButtonChooserPanel.Type.Checkbox);
        dlg.setAddSelectAll(true);
        dlg.setUseScrollPane(true);
        dlg.setHelpContext("QBImport");
        UIHelper.centerAndShow(dlg);
        List<SpQuery> queriesList = dlg.getSelectedObjects();
        if (queriesList == null || queriesList.size() == 0) {
            return;
        }
        Vector<String> names = new Vector<String>();
        for (NavBoxItemIFace nbi : this.navBox.getItems()) {
            names.add(nbi.getTitle());
        }
        QueryTask.adjustImportedQueryNames(queries, names);
        if (this.saveImportedQueries(queriesList)) {
            for (SpQuery query : queriesList) {
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.set(query.getName(), SpQuery.getClassTableId(), RecordSet.GLOBAL);
                rs.addItem(query.getSpQueryId());
                this.addToNavBox(rs);
            }
            this.navBox.validate();
            this.navBox.repaint();
        }
    }

    protected boolean saveImportedQueries(List<SpQuery> queriesList) {
        return DataModelObjBase.save(true, new Object[]{queriesList});
    }

    protected String getExportUsageKey() {
        return "QB.EXPORT";
    }

    protected String getNothingToExporti18nKey() {
        return "QY_NO_QUERIES_TO_EXPORT";
    }

    protected String getExportDlgTitlei18nKey() {
        return "QY_EXPORT_QUERIES";
    }

    protected String getExportDlgMsgi18nKey() {
        return "QY_SEL_QUERIES_EXP";
    }

    protected String getExportHelpContext() {
        return "QBExport";
    }

    protected String getXMLExportFirstLine() {
        return "<queries>\n";
    }

    protected String getXMLExportLastLine() {
        return "</queries>";
    }

    protected void toXML(SpQuery query, StringBuilder sb) {
        query.toXML(sb);
    }

    protected void exportQueries() {
        UsageTracker.incrUsageCount(this.getExportUsageKey());
        Vector<String> list = new Vector<String>();
        for (NavBoxItemIFace nbi : this.navBox.getItems()) {
            list.add(nbi.getTitle());
        }
        List selectedList = null;
        if (list.size() == 0) {
            UIRegistry.showLocalizedMsg(this.getNothingToExporti18nKey());
            return;
        }
        if (list.size() == 1) {
            selectedList = list;
        } else {
            ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg((Frame)UIRegistry.getMostRecentWindow(), this.getExportDlgTitlei18nKey(), this.getExportDlgMsgi18nKey(), list, 7, ToggleButtonChooserPanel.Type.Checkbox);
            dlg.setAddSelectAll(true);
            dlg.setUseScrollPane(true);
            dlg.setHelpContext(this.getExportHelpContext());
            UIHelper.centerAndShow(dlg);
            selectedList = dlg.getSelectedObjects();
            if (dlg.isCancelled() || selectedList.size() == 0) {
                return;
            }
        }
        String path = AppPreferences.getLocalPrefs().get(XML_PATH_PREF, null);
        FileDialog fDlg = new FileDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("SAVE"), 1);
        if (path != null) {
            fDlg.setDirectory(path);
        }
        fDlg.setVisible(true);
        String dirStr = fDlg.getDirectory();
        String fileName = fDlg.getFile();
        if (StringUtils.isEmpty((String)dirStr) || StringUtils.isEmpty((String)fileName)) {
            return;
        }
        if (StringUtils.isEmpty((String)FilenameUtils.getExtension((String)fileName))) {
            fileName = String.valueOf(fileName) + ".xml";
        }
        path = String.valueOf(dirStr) + fileName;
        AppPreferences.getLocalPrefs().put(XML_PATH_PREF, path);
        Hashtable<String, Boolean> hash = new Hashtable<String, Boolean>();
        for (String qTitle : selectedList) {
            hash.put(qTitle, true);
        }
        Vector<SpQuery> queries = new Vector<SpQuery>();
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                for (NavBoxItemIFace nbi : this.navBox.getItems()) {
                    RecordSetIFace rs;
                    if (hash.get(nbi.getTitle()) == null || (rs = (RecordSetIFace)nbi.getData()) == null) continue;
                    SpQuery query = session.get(SpQuery.class, rs.getOnlyItem().getRecordId());
                    queries.add(query);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.getXMLExportFirstLine());
                for (SpQuery q : queries) {
                    q.toXML(sb);
                }
                sb.append(this.getXMLExportLastLine());
                FileUtils.writeStringToFile((File)new File(path), (String)sb.toString());
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(QueryTask.class, ex);
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[2] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray[3] = blArray2;
        return blArrayArray;
    }

    protected Hashtable<String, TableTree> buildTableTreeHash(TableTree treeRoot) {
        Hashtable<String, TableTree> result = new Hashtable<String, TableTree>();
        try {
            int t = 0;
            while (t < treeRoot.getKids()) {
                TableTree tt = treeRoot.getKid(t);
                result.put(tt.getName(), tt);
                log.debug((Object)("Adding[" + tt.getName() + "] to hash"));
                ++t;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(QueryTask.class, ex);
            ex.printStackTrace();
        }
        return result;
    }

    public boolean isPermitted() {
        return this.getPermissions().canView();
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel("QueryTask.PermTitle", "QueryTask.PermEnable", null, null, null);
    }

    public void reloadQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new EditQueryWorker(QueryTask.this.queryBldrPane.getQuery().getId(), QueryTask.this.queryBldrPane.getQueryNavBtn()).start();
            }
        });
    }

    protected class EditOtherQueryWorker
    extends OpenQueryWorker {
        protected final Integer queryId;

        public EditOtherQueryWorker(Integer queryId) {
            this.queryId = queryId;
        }

        @Override
        public void finished() {
            super.finished();
            QueryTask.this.editQuery(this.queryId);
        }
    }

    protected class EditQueryWorker
    extends OpenQueryWorker {
        protected final Integer queryId;
        protected final RolloverCommand queryNavBtn;

        public EditQueryWorker(Integer queryId, RolloverCommand queryNavBtn) {
            this.queryId = queryId;
            this.queryNavBtn = queryNavBtn;
        }

        @Override
        public void finished() {
            super.finished();
            if ((QueryTask.this.queryBldrPane == null || QueryTask.this.queryBldrPane.aboutToShutdown()) && QueryTask.this.editQuery(this.queryId)) {
                this.queryNavBtn.setEnabled(false);
                QueryTask.this.queryBldrPane.setQueryNavBtn(this.queryNavBtn);
            }
        }
    }

    protected class NewQueryWorker
    extends OpenQueryWorker {
        protected final DBTableInfo tableInfo;

        public NewQueryWorker(DBTableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        @Override
        public void finished() {
            super.finished();
            QueryTask.this.createNewQuery(this.tableInfo);
        }
    }

    protected class OpenQueryWorker
    extends SwingWorker {
        protected OpenQueryWorker() {
        }

        @Override
        public Object construct() {
            UIRegistry.displayStatusBarText(UIRegistry.getResourceString("QB_LOADING"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.getStatusBar().setIndeterminate("QUERYTASK", true);
                }
            });
            QueryTask.this.getTableTrees();
            UIRegistry.displayStatusBarText("");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.getStatusBar().setProgressDone("QUERYTASK");
                }
            });
            return null;
        }
    }

    class QueryAction
    implements ActionListener {
        private String queryStr;
        private String viewSetName;
        private String viewName;

        public QueryAction(String queryStr, String viewSetName, String viewName) {
            this.queryStr = queryStr;
            this.viewSetName = viewSetName;
            this.viewName = viewName;
        }

        public QueryAction(String queryStr) {
            this(queryStr, null, null);
        }

        public QueryAction(String viewSetName, String viewName) {
            this(null, viewSetName, viewName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isNotEmpty((String)this.queryStr)) {
                QueryTask.this.createAndExecute(this.queryStr);
            } else if (StringUtils.isNotEmpty((String)this.viewSetName)) {
                StringUtils.isNotEmpty((String)this.viewName);
            }
        }
    }
}

