/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QueryCreatorsConfigureDlg
extends CustomDialog {
    protected QueryTask task;
    protected Vector<String> freqQueries = null;
    protected Vector<String> extraQueries = null;
    protected Vector<String> stdQueries = null;
    protected JButton mvToExtraBtn;
    protected JButton mvToFreqBtn;
    protected QueryOrderPanel freqPanel;
    protected QueryOrderPanel extraPanel;
    protected boolean hasChanged = false;
    protected Hashtable<String, String> reverseNameHash = new Hashtable();
    protected Hashtable<String, String> nameHash = new Hashtable();

    public QueryCreatorsConfigureDlg(QueryTask task, Vector<String> freqQueries, Vector<String> extraQueries, Vector<String> stdQueries) {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("QY_CONFIGURE_CREATORS"), true, 7, null);
        this.task = task;
        this.freqQueries = freqQueries;
        this.extraQueries = extraQueries;
        this.stdQueries = stdQueries;
        for (String sName : stdQueries) {
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(sName);
            this.nameHash.put(sName, tableInfo.getTitle());
            this.reverseNameHash.put(tableInfo.getTitle(), sName);
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, "QBNewQueryConfig");
        this.freqPanel = new QueryOrderPanel("QY_QUICK_LIST", this.freqQueries, true);
        this.extraPanel = new QueryOrderPanel("QY_EXTRA_LIST", this.extraQueries, false);
        this.mvToExtraBtn = UIHelper.createIconBtn("Map", "QY_MOVE_TO_EXTRA_TT", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryCreatorsConfigureDlg.this.moveToExtra();
            }
        });
        this.mvToFreqBtn = UIHelper.createIconBtn("Unmap", "QY_MOVE_TO_FREQ", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryCreatorsConfigureDlg.this.moveToFreq();
            }
        });
        CellConstraints cc = new CellConstraints();
        PanelBuilder middlePanel = new PanelBuilder(new FormLayout("c:p:g", "p, 2px, p"));
        middlePanel.add((Component)this.mvToExtraBtn, cc.xy(1, 1));
        middlePanel.add((Component)this.mvToFreqBtn, cc.xy(1, 3));
        PanelBuilder middlePanel2 = new PanelBuilder(new FormLayout("c:p:g", "f:p:g, p, f:p:g"));
        middlePanel2.add((Component)middlePanel.getPanel(), cc.xy(1, 2));
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("p:g,5px,p,10px,p:g", "f:p:g"));
        mainPB.add((Component)this.freqPanel, cc.xy(1, 1));
        mainPB.add((Component)middlePanel2.getPanel(), cc.xy(3, 1));
        mainPB.add((Component)this.extraPanel, cc.xy(5, 1));
        mainPB.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentPanel = mainPB.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width, 500);
        size.height = Math.max(size.height, 350);
        this.setSize(size);
    }

    protected void moveToExtra() {
        int inx = this.freqPanel.getOrderList().getSelectedIndex();
        if (inx > -1) {
            Object name = this.freqPanel.getOrderList().getSelectedValue();
            ((DefaultListModel)this.freqPanel.getOrderList().getModel()).removeElement(name);
            ((DefaultListModel)this.extraPanel.getOrderList().getModel()).addElement(name);
        }
    }

    protected void moveToFreq() {
        int inx = this.extraPanel.getOrderList().getSelectedIndex();
        if (inx > -1) {
            Object name = this.extraPanel.getOrderList().getSelectedValue();
            ((DefaultListModel)this.extraPanel.getOrderList().getModel()).removeElement(name);
            ((DefaultListModel)this.freqPanel.getOrderList().getModel()).addElement(name);
        }
    }

    protected void setHasChanged(boolean hasChangedArg) {
        this.hasChanged = hasChangedArg;
        this.getOkBtn().setEnabled(this.hasChanged);
    }

    protected void addItem(JList list) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (String sName : this.freqPanel.getNames()) {
            hash.put(sName, sName);
        }
        for (String sName : this.extraPanel.getNames()) {
            hash.put(sName, sName);
        }
        Vector<String> uniqueList = new Vector<String>();
        Hashtable<String, String> newAvailViews = new Hashtable<String, String>();
        for (String stdName : this.stdQueries) {
            if (hash.get(stdName) != null) continue;
            hash.put(stdName, stdName);
            uniqueList.add(this.nameHash.get(stdName));
            newAvailViews.put(stdName, stdName);
        }
        if (uniqueList.size() == 0) {
            JOptionPane.showMessageDialog(this, UIRegistry.getResourceString("QY_NONE_QUERIES_AVAIL"), UIRegistry.getResourceString("QY_NONE_QUERIES_AVAIL_TITLE"), 1);
            return;
        }
        ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg((Frame)UIRegistry.getTopWindow(), "QY_AVAIL_QUERIES_CONFIG", uniqueList);
        dlg.setUseScrollPane(true);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            ListModel model = list.getModel();
            for (String name : dlg.getSelectedObjects()) {
                ((DefaultListModel)model).addElement(name);
            }
        }
        this.setHasChanged(true);
    }

    public Vector<String> getFreqQueries() {
        return this.freqPanel.getNames();
    }

    public Vector<String> getExtraQueries() {
        return this.extraPanel.getNames();
    }

    protected void removeItem(JList list) {
        int index = list.getSelectedIndex();
        if (index > -1) {
            ((DefaultListModel)list.getModel()).remove(index);
            this.setHasChanged(true);
            list.repaint();
        }
    }

    protected void editItem(JList list) {
    }

    protected void itemSelected() {
        this.mvToExtraBtn.setEnabled(!this.freqPanel.getOrderList().isSelectionEmpty());
        this.mvToFreqBtn.setEnabled(!this.extraPanel.getOrderList().isSelectionEmpty());
    }

    public class QueryOrderPanel
    extends JPanel {
        protected JList orderList;
        protected DefaultListModel orderModel;
        protected JButton orderUpBtn;
        protected JButton orderDwnBtn;
        protected EditDeleteAddPanel edaPanel;

        public QueryOrderPanel(String titleKey, Vector<String> names, boolean orderOnLeft) {
            PanelBuilder outer = new PanelBuilder(new FormLayout(orderOnLeft ? "p,2px,f:p:g" : "f:p:g,2px,p", "p,2px,f:p:g,2px,p"), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            this.orderModel = new DefaultListModel();
            for (String shortClassName : names) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(shortClassName);
                if (tableInfo == null) {
                    throw new RuntimeException("The Query Named can't be found in table info[" + shortClassName + "]");
                }
                this.orderModel.addElement(tableInfo.getTitle());
            }
            this.orderList = new JList(this.orderModel);
            this.orderList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    QueryOrderPanel.this.updateEnabledState();
                    QueryCreatorsConfigureDlg.this.itemSelected();
                }
            });
            this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "QY_MOVE_UP", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int inx = QueryOrderPanel.this.orderList.getSelectedIndex();
                    String item = (String)QueryOrderPanel.this.orderModel.getElementAt(inx);
                    QueryOrderPanel.this.orderModel.remove(inx);
                    QueryOrderPanel.this.orderModel.insertElementAt(item, inx - 1);
                    QueryOrderPanel.this.orderList.setSelectedIndex(inx - 1);
                    QueryOrderPanel.this.updateEnabledState();
                }
            });
            this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "QY_MOVE_DOWN", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int inx = QueryOrderPanel.this.orderList.getSelectedIndex();
                    String item = (String)QueryOrderPanel.this.orderModel.getElementAt(inx);
                    QueryOrderPanel.this.orderModel.remove(inx);
                    QueryOrderPanel.this.orderModel.insertElementAt(item, inx + 1);
                    QueryOrderPanel.this.orderList.setSelectedIndex(inx + 1);
                    QueryOrderPanel.this.updateEnabledState();
                }
            });
            this.edaPanel = new EditDeleteAddPanel(null, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryCreatorsConfigureDlg.this.removeItem(QueryOrderPanel.this.orderList);
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryCreatorsConfigureDlg.this.addItem(QueryOrderPanel.this.orderList);
                }
            });
            PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
            upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
            upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
            int col = orderOnLeft ? 3 : 1;
            outer.add((Component)UIHelper.createLabel(UIRegistry.getResourceString(titleKey), 0), cc.xy(col, 1));
            JScrollPane sp = UIHelper.createScrollPane(this.orderList);
            outer.add((Component)sp, cc.xy(col, 3));
            outer.add((Component)this.edaPanel, cc.xy(col, 5));
            outer.add((Component)upDownPanel.getPanel(), cc.xy(orderOnLeft ? 1 : 3, 3));
            outer.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.edaPanel.getAddBtn().setEnabled(true);
        }

        protected void updateEnabledState() {
            int inx = this.orderList.getSelectedIndex();
            this.orderUpBtn.setEnabled(inx > 0);
            this.orderDwnBtn.setEnabled(inx > -1 && inx < this.orderModel.size() - 1);
            this.edaPanel.setEnabled(inx > -1);
            this.edaPanel.getAddBtn().setEnabled(true);
        }

        public JList getOrderList() {
            return this.orderList;
        }

        public Vector<String> getNames() {
            Vector<String> names = new Vector<String>();
            int i = 0;
            while (i < this.orderModel.size()) {
                names.add(QueryCreatorsConfigureDlg.this.reverseNameHash.get(this.orderModel.get(i)));
                ++i;
            }
            return names;
        }
    }
}

