/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QueryConfigureDlg
extends CustomDialog {
    protected QueryTask task;
    protected Vector<SpQuery> favQueries = new Vector();
    protected Vector<SpQuery> otherQueries = new Vector();
    protected JButton mvToOtherBtn;
    protected JButton mvToFreqBtn;
    protected QueryOrderPanel favPanel;
    protected QueryOrderPanel otherPanel;
    protected boolean hasChanged = false;

    public QueryConfigureDlg(QueryTask task) {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("QY_CONFIGURE_QUERIES"), true, 7, null);
        this.task = task;
    }

    @Override
    public void createUI() {
        super.createUI();
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, "QBSavedQueriesConfig");
        String sqlStr = "FROM SpQuery as sq Inner Join sq.specifyUser as user where user.specifyUserId = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId() + " ORDER BY ordinal";
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<?> rows = session.getDataList(sqlStr);
            for (Object row : rows) {
                Object[] objs = (Object[])row;
                SpQuery query = (SpQuery)objs[0];
                if (QueryTask.isSchemaExportQuery(query)) continue;
                if (query.getIsFavorite().booleanValue()) {
                    this.favQueries.add(query);
                    continue;
                }
                this.otherQueries.add(query);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        this.favPanel = new QueryOrderPanel("QY_FAV_LIST", this.favQueries, true, true);
        this.otherPanel = new QueryOrderPanel("QY_OTHER_LIST", this.otherQueries, false, false);
        this.mvToOtherBtn = UIHelper.createIconBtn("Map", "QY_MOVE_TO_OTHER_TT", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryConfigureDlg.this.moveToOther();
            }
        });
        this.mvToFreqBtn = UIHelper.createIconBtn("Unmap", "QY_MOVE_TO_FAV_TT", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryConfigureDlg.this.moveToFav();
            }
        });
        CellConstraints cc = new CellConstraints();
        PanelBuilder middlePanel = new PanelBuilder(new FormLayout("c:p:g", "p, 2px, p"));
        middlePanel.add((Component)this.mvToOtherBtn, cc.xy(1, 1));
        middlePanel.add((Component)this.mvToFreqBtn, cc.xy(1, 3));
        PanelBuilder middlePanel2 = new PanelBuilder(new FormLayout("c:p:g", "f:p:g, p, f:p:g"));
        middlePanel2.add((Component)middlePanel.getPanel(), cc.xy(1, 2));
        PanelBuilder mainPB = new PanelBuilder(new FormLayout("f:p:g,5px,p,10px,f:p:g", "f:p:g"));
        mainPB.add((Component)this.favPanel, cc.xy(1, 1));
        mainPB.add((Component)middlePanel2.getPanel(), cc.xy(3, 1));
        mainPB.add((Component)this.otherPanel, cc.xy(5, 1));
        mainPB.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentPanel = mainPB.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width, 500);
        size.height = Math.max(size.height, 350);
        this.setSize(size);
    }

    protected void moveToOther() {
        int inx = this.favPanel.getOrderList().getSelectedIndex();
        if (inx > -1) {
            Object name = this.favPanel.getOrderList().getSelectedValue();
            ((DefaultListModel)this.favPanel.getOrderList().getModel()).removeElement(name);
            ((DefaultListModel)this.otherPanel.getOrderList().getModel()).addElement(name);
        }
    }

    protected void moveToFav() {
        int inx = this.otherPanel.getOrderList().getSelectedIndex();
        if (inx > -1) {
            Object name = this.otherPanel.getOrderList().getSelectedValue();
            ((DefaultListModel)this.otherPanel.getOrderList().getModel()).removeElement(name);
            ((DefaultListModel)this.favPanel.getOrderList().getModel()).addElement(name);
        }
    }

    protected void setHasChanged(boolean hasChangedArg) {
        this.hasChanged = hasChangedArg;
        this.getOkBtn().setEnabled(this.hasChanged);
    }

    public Vector<SpQuery> getFavQueries() {
        return this.favPanel.getQueries();
    }

    public Vector<SpQuery> getOtherQueries() {
        return this.otherPanel.getQueries();
    }

    protected void removeItem(JList list) {
        int index = list.getSelectedIndex();
        if (index > -1) {
            ((DefaultListModel)list.getModel()).remove(index);
            this.setHasChanged(true);
            list.repaint();
        }
    }

    protected void editItem(JList list) {
    }

    protected void itemSelected() {
        this.mvToOtherBtn.setEnabled(!this.favPanel.getOrderList().isSelectionEmpty());
        this.mvToFreqBtn.setEnabled(!this.otherPanel.getOrderList().isSelectionEmpty());
    }

    public class QueryOrderPanel
    extends JPanel {
        protected JList orderList;
        protected DefaultListModel orderModel;
        protected JButton orderUpBtn;
        protected JButton orderDwnBtn;

        public QueryOrderPanel(String titleKey, Vector<SpQuery> queries, boolean orderOnLeft, boolean hideOrdering) {
            PanelBuilder outer = new PanelBuilder(new FormLayout(orderOnLeft ? "p,2px,f:p:g" : "f:p:g,2px,p", "p,2px,f:p:g"), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            this.orderModel = new DefaultListModel();
            for (SpQuery q : queries) {
                this.orderModel.addElement(q);
            }
            this.orderList = new JList(this.orderModel);
            this.orderList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    QueryOrderPanel.this.updateEnabledState();
                    QueryConfigureDlg.this.itemSelected();
                }
            });
            this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "QY_MOVE_UP", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int inx = QueryOrderPanel.this.orderList.getSelectedIndex();
                    SpQuery item = (SpQuery)QueryOrderPanel.this.orderModel.getElementAt(inx);
                    QueryOrderPanel.this.orderModel.remove(inx);
                    QueryOrderPanel.this.orderModel.insertElementAt(item, inx - 1);
                    QueryOrderPanel.this.orderList.setSelectedIndex(inx - 1);
                    QueryOrderPanel.this.updateEnabledState();
                }
            });
            this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "QY_MOVE_DOWN", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int inx = QueryOrderPanel.this.orderList.getSelectedIndex();
                    SpQuery item = (SpQuery)QueryOrderPanel.this.orderModel.getElementAt(inx);
                    QueryOrderPanel.this.orderModel.remove(inx);
                    QueryOrderPanel.this.orderModel.insertElementAt(item, inx + 1);
                    QueryOrderPanel.this.orderList.setSelectedIndex(inx + 1);
                    QueryOrderPanel.this.updateEnabledState();
                }
            });
            int col = orderOnLeft ? 3 : 1;
            outer.add((Component)UIHelper.createLabel(UIRegistry.getResourceString(titleKey), 0), cc.xy(col, 1));
            JScrollPane sp = UIHelper.createScrollPane(this.orderList);
            outer.add((Component)sp, cc.xy(col, 3));
            if (hideOrdering) {
                PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
                upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
                upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
                outer.add((Component)upDownPanel.getPanel(), cc.xy(orderOnLeft ? 1 : 3, 3));
            }
            outer.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }

        protected void updateEnabledState() {
            int inx = this.orderList.getSelectedIndex();
            this.orderUpBtn.setEnabled(inx > 0);
            this.orderDwnBtn.setEnabled(inx > -1 && inx < this.orderModel.size() - 1);
        }

        public JList getOrderList() {
            return this.orderList;
        }

        public Vector<SpQuery> getQueries() {
            Vector<SpQuery> queries = new Vector<SpQuery>();
            int i = 0;
            while (i < this.orderModel.size()) {
                queries.add((SpQuery)this.orderModel.get(i));
                ++i;
            }
            return queries;
        }
    }
}

