/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.HtmlDescPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.TableModel2Excel;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.rstools.RecordSetToolsIFace;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class PluginsTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(PluginsTask.class);
    public static final DataFlavor TOOLS_FLAVOR = new DataFlavor(PluginsTask.class, "Plugins");
    private static final String ON_TASKBAR = "Exporttask.OnTaskbar";
    public static final String GE_BALLOON_FG_COLOR = "google.earth.fgcolor";
    public static final String GE_BALLOON_FG_COLOR_STR = "255, 255, 255";
    public static final String GE_BALLOON_BG_COLOR = "google.earth.bgcolor";
    public static final String GE_BALLOON_BG_COLOR_STR = "0, 102, 179";
    public static final String GE_BALLOON_PRIMARY_URL = "google.earth.primaryurl";
    public static final String GE_BALLOON_PRIMARY_URL_TITLE = "google.earth.primaryurltitle";
    public static final String GE_BALLOON_SECONDARY_URL = "google.earth.secondaryurl";
    public static final String GE_BALLOON_SECONDARY_URL_TITLE = "google.earth.secondaryurltitle";
    public static String GE_BALLOON_PRIMARY_URL_STR = "";
    public static String GE_BALLOON_SECONDARY_URL_STR = "";
    public static String GE_BALLOON_PRIMARY_URL_TITLE_STR = "fb";
    public static String GE_BALLOON_SECONDARY_URL_TITLE_STR = "ad";
    public static final String PLUGINS = "Plugins";
    public static final String EXPORT_RS = "ExportRecordSet";
    public static final String EXPORT_LIST = "ExportList";
    public static final String EXPORT_JTABLE = "ExportJTable";
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected ToolBarDropDownBtn toolBarBtn = null;
    protected Vector<NavBoxItemIFace> toolsNavBoxList = new Vector();
    protected List<Class<? extends RecordSetToolsIFace>> toolsRegistryList = new Vector<Class<? extends RecordSetToolsIFace>>();
    protected List<RecordSetToolsIFace> loadedToolsList = new Vector<RecordSetToolsIFace>();

    public PluginsTask() {
        super(PLUGINS, UIRegistry.getResourceString(PLUGINS));
        CommandDispatcher.register(PLUGINS, this);
        CommandDispatcher.register("Preferences", this);
    }

    @Override
    public boolean isSingletonPane() {
        return true;
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            AppPreferences remotePrefs = AppPreferences.getRemote();
            remotePrefs.put(GE_BALLOON_FG_COLOR, GE_BALLOON_FG_COLOR_STR);
            remotePrefs.put(GE_BALLOON_BG_COLOR, GE_BALLOON_BG_COLOR_STR);
            String primaryURL = remotePrefs.get(GE_BALLOON_PRIMARY_URL, null);
            String primaryURLTitle = remotePrefs.get(GE_BALLOON_PRIMARY_URL_TITLE, null);
            if (StringUtils.isEmpty((String)primaryURL)) {
                remotePrefs.put(GE_BALLOON_PRIMARY_URL, GE_BALLOON_PRIMARY_URL_STR);
                if (StringUtils.isEmpty((String)primaryURLTitle)) {
                    remotePrefs.put(GE_BALLOON_PRIMARY_URL_TITLE, GE_BALLOON_PRIMARY_URL_TITLE_STR);
                }
            }
            String secondaryURL = remotePrefs.get(GE_BALLOON_SECONDARY_URL, null);
            String secondaryURLTitle = remotePrefs.get(GE_BALLOON_SECONDARY_URL_TITLE, null);
            if (StringUtils.isEmpty((String)secondaryURL)) {
                remotePrefs.put(GE_BALLOON_SECONDARY_URL, GE_BALLOON_SECONDARY_URL_STR);
                if (StringUtils.isEmpty((String)secondaryURLTitle)) {
                    remotePrefs.put(GE_BALLOON_SECONDARY_URL_TITLE, GE_BALLOON_SECONDARY_URL_TITLE_STR);
                }
            }
            CommandAction cmdAction = new CommandAction(PLUGINS, EXPORT_JTABLE);
            ContextMgr.registerService(30, EXPORT_JTABLE, -1, cmdAction, this, "ExportExcel16", UIRegistry.getResourceString("EXPORT_GRID_TT"));
            this.readToolRegistry();
            this.toolsNavBoxList.clear();
            for (Class<? extends RecordSetToolsIFace> exporterClass : this.toolsRegistryList) {
                try {
                    RecordSetToolsIFace exporter = exporterClass.newInstance();
                    this.loadedToolsList.add(exporter);
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PluginsTask.class, e);
                    log.warn((Object)"Failed to instantiate an exporter", (Throwable)e);
                }
            }
            if (this.isVisible) {
                this.extendedNavBoxes.clear();
                NavBox navBox = new NavBox(UIRegistry.getResourceString(PLUGINS));
                for (RecordSetToolsIFace tool : this.loadedToolsList) {
                    if (!tool.isVisible()) continue;
                    cmdAction = new CommandAction(PLUGINS, EXPORT_RS);
                    cmdAction.setProperty("tool", tool);
                    NavBoxItemIFace nbi = PluginsTask.makeDnDNavBtn(navBox, tool.getName(), tool.getIconName(), cmdAction, null, true, false);
                    RolloverCommand roc = (RolloverCommand)((Object)nbi);
                    int[] tableIds = tool.getTableIds();
                    if (tableIds != null && tableIds.length > 0) {
                        DataFlavorTableExt df = new DataFlavorTableExt(RecordSetTask.RECORDSET_FLAVOR.getDefaultRepresentationClass(), RecordSetTask.RECORDSET_FLAVOR.getHumanPresentableName(), tableIds);
                        roc.addDropDataFlavor(df);
                    }
                    this.toolsNavBoxList.add(nbi);
                }
                this.navBoxes.add(navBox);
            }
        }
    }

    protected void readToolRegistry() {
        this.toolsRegistryList.clear();
        String fileName = "rstools_registry.xml";
        HashMap<String, Pair<String, Boolean>> rsPlugins = new HashMap<String, Pair<String, Boolean>>();
        String path = XMLHelper.getConfigDirPath(fileName);
        this.readToolRegistry(path, rsPlugins);
        path = String.valueOf(AppPreferences.getLocalPrefs().getDirPath()) + File.separator + fileName;
        this.readToolRegistry(path, rsPlugins);
        for (String rspName : rsPlugins.keySet()) {
            Pair<String, Boolean> p = rsPlugins.get(rspName);
            if (p == null) continue;
            try {
                Class<RecordSetToolsIFace> cls = Class.forName((String)p.first).asSubclass(RecordSetToolsIFace.class);
                this.toolsRegistryList.add(cls);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PluginsTask.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
        }
    }

    protected void readToolRegistry(String path, HashMap<String, Pair<String, Boolean>> rsPlugins) {
        try {
            File file = new File(path);
            if (file.exists()) {
                Element root = XMLHelper.readFileToDOM4J(file);
                List boxes = root.selectNodes("/tools/tool");
                for (Element pluginElement : boxes) {
                    String rspName = pluginElement.attributeValue("name");
                    String clsName = pluginElement.attributeValue("class");
                    Boolean addToUI = XMLHelper.getAttr(pluginElement, "addui", false);
                    if (!StringUtils.isNotEmpty((String)rspName) || !StringUtils.isNotEmpty((String)clsName)) continue;
                    rsPlugins.put(rspName, new Pair<String, Boolean>(clsName, addToUI));
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PluginsTask.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
    }

    @Override
    public void requestContext() {
        ContextMgr.requestContext(this);
        if (this.starterPane == null) {
            super.requestContext();
        } else {
            SubPaneMgr.getInstance().showPane(this.starterPane);
        }
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        super.subPaneRemoved(subPane);
        if (subPane == this.starterPane) {
            this.starterPane = null;
        }
    }

    @Override
    public SubPaneIFace getStarterPane() {
        StringBuilder htmlDesc = new StringBuilder("<h3>Welcome to the Specify Plugins</h3>");
        htmlDesc.append("<p>Tools installed:<ul>");
        for (RecordSetToolsIFace tool : this.loadedToolsList) {
            if (!tool.isVisible()) continue;
            htmlDesc.append("<li><b>" + tool.getName() + "</b><p>" + tool.getDescription());
        }
        htmlDesc.append("<br></ul>");
        this.starterPane = new HtmlDescPane(this.name, (Taskable)this, htmlDesc.toString());
        return this.starterPane;
    }

    protected void processToolDataFromRecordSet(Object data, Properties requestParams, RecordSetToolsIFace exporter) {
        if (data instanceof RecordSetIFace) {
            this.processTool(exporter, (RecordSetIFace)data, requestParams);
        }
    }

    protected void processToolDataFromList(Object data, Properties requestParams, RecordSetToolsIFace exporter) {
        if (data instanceof List) {
            this.doProcessTool(exporter, (List)data, requestParams);
        }
    }

    protected void processTool(RecordSetToolsIFace tool, RecordSetIFace recordSet, Properties requestParams) {
        try {
            tool.processRecordSet(recordSet, requestParams);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PluginsTask.class, e);
            log.error((Object)"Exception while exporting a RecordSet", (Throwable)e);
            JStatusBar statusBar = UIRegistry.getStatusBar();
            statusBar.setErrorMessage(e.getMessage(), e);
        }
    }

    protected void doProcessTool(RecordSetToolsIFace tool, List<?> dataList, Properties requestParams) {
        try {
            tool.processDataList(dataList, requestParams);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PluginsTask.class, e);
            log.error((Object)"Exception while exporting a data list", (Throwable)e);
            JStatusBar statusBar = UIRegistry.getStatusBar();
            statusBar.setErrorMessage(e.getLocalizedMessage(), e);
        }
    }

    protected void exportTable(JTable table) {
        Hashtable values = new Hashtable();
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "SystemSetup", "ExcelExportInfo", null, UIRegistry.getResourceString("EXCEL_EXPORT_INFO_TITLE"), UIRegistry.getResourceString("Export"), null, null, true, 0);
        dlg.setData(values);
        dlg.setModal(true);
        dlg.setVisible(true);
        if (dlg.getBtnPressed() == 1) {
            dlg.getMultiView().getDataFromUI();
            File file = new File((String)values.get("FilePath"));
            TableModel2Excel.convertToExcel(file, (String)values.get("Title"), table.getModel());
        }
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        RecordSetTask rsTask = (RecordSetTask)ContextMgr.getTaskByClass(RecordSetTask.class);
        List<NavBoxIFace> nbs = rsTask.getNavBoxes();
        if (nbs != null) {
            this.extendedNavBoxes.addAll(nbs);
        }
        return this.extendedNavBoxes;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        String label = UIRegistry.getResourceString(PLUGINS);
        String hint = UIRegistry.getResourceString("export_hint");
        this.toolBarBtn = this.createToolbarButton(label, this.iconName, hint);
        this.toolbarItems = new Vector();
        if (AppPreferences.getRemote().getBoolean(ON_TASKBAR, false).booleanValue()) {
            this.toolbarItems.add(new ToolBarItemDesc(this.toolBarBtn));
        }
        return this.toolbarItems;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        String menuDesc = "Specify.SYSTEM_MENU";
        this.menuItems = new Vector();
        if (this.permissions == null || this.permissions.canModify()) {
            String menuTitle = "PluginsTask.PLUGIN_MENU";
            String mneu = "PluginsTask.PLUGIN_MNEU";
            String desc = "PluginsTask.PLUGIN_DESC";
            JMenuItem mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PluginsTask.this.requestContext();
                }
            });
            MenuItemDesc rsMI = new MenuItemDesc(mi, menuDesc);
            rsMI.setPosition(MenuItemDesc.Position.After);
            rsMI.setSepPosition(MenuItemDesc.Position.Before);
            this.menuItems.add(rsMI);
        }
        return this.menuItems;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    protected void processToolRecordSet(CommandAction cmdAction) {
        RecordSetToolsIFace tool = this.getTool(cmdAction);
        if (tool != null) {
            Object data = cmdAction.getData();
            if (data instanceof CommandAction && (CommandAction)data == cmdAction) {
                RecordSetTask rsTask = (RecordSetTask)TaskMgr.getTask("Record_Set");
                List<RecordSetIFace> colObjRSList = rsTask.getRecordSets(CollectionObject.getClassTableId());
                data = this.getRecordSetOfDataObjs(null, CollectionObject.class, "catalogNumber", colObjRSList.size());
            }
            this.processToolDataFromRecordSet(data, cmdAction.getProperties(), tool);
        }
    }

    protected void processToolList(CommandAction cmdAction) {
        RecordSetToolsIFace tool = this.getTool(cmdAction);
        if (tool != null) {
            this.processToolDataFromList(cmdAction.getData(), cmdAction.getProperties(), tool);
        }
    }

    protected void prefsChanged(CommandAction cmdAction) {
        Object value;
        AppPreferences appPrefs = (AppPreferences)cmdAction.getData();
        if (appPrefs == AppPreferences.getRemote() && (value = cmdAction.getProperties().get(ON_TASKBAR)) != null && value instanceof Boolean) {
            JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
            Boolean isChecked = (Boolean)value;
            if (isChecked.booleanValue()) {
                TaskMgr.addToolbarBtn(this.toolBarBtn, toolBar.getComponentCount() - 1);
            } else {
                TaskMgr.removeToolbarBtn(this.toolBarBtn);
            }
            toolBar.validate();
            toolBar.repaint();
        }
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel(PLUGINS, "ENABLE", null, null, null);
    }

    protected RecordSetToolsIFace getTool(CommandAction cmdAction) {
        Object propValue = cmdAction.getProperty("tool");
        if (propValue instanceof RecordSetToolsIFace) {
            return (RecordSetToolsIFace)propValue;
        }
        if (propValue instanceof Class) {
            for (RecordSetToolsIFace exp : this.loadedToolsList) {
                if (!exp.getClass().equals(propValue)) continue;
                return exp;
            }
        }
        if (propValue instanceof String) {
            for (RecordSetToolsIFace exp : this.loadedToolsList) {
                if (!exp.getClass().getName().equals(propValue)) continue;
                return exp;
            }
        }
        return null;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(PLUGINS)) {
            JTable table;
            if (cmdAction.isAction(EXPORT_RS)) {
                this.processToolRecordSet(cmdAction);
            } else if (cmdAction.isAction(EXPORT_LIST)) {
                this.processToolList(cmdAction);
            } else if (cmdAction.isAction(EXPORT_JTABLE) && (table = (JTable)cmdAction.getProperty("jtable")) != null) {
                this.exportTable(table);
            }
        } else if (cmdAction.isType("Preferences")) {
            this.prefsChanged(cmdAction);
        }
    }
}

