/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.subpane.LocalityMapperSubPane;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.sql.ResultSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LocalityMapperTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(LocalityMapperTask.class);
    public static final String LOCALITYMAPPER = "LocalityMapper";
    protected ResultSet resultSet;

    public LocalityMapperTask() {
        super(LOCALITYMAPPER, UIRegistry.getResourceString(LOCALITYMAPPER));
        CommandDispatcher.register(LOCALITYMAPPER, this);
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = new SimpleDescPane(this.name, (Taskable)this, "Map");
        return this.starterPane;
    }

    public void createMappingInfoFromRecordSet(RecordSetIFace recordSet) {
        String sqlStr = DBTableIdMgr.getInstance().getQueryForTable(recordSet);
        if (StringUtils.isNotEmpty((String)sqlStr)) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            List<CollectingEvent> list = session.getDataList(sqlStr);
            session.close();
            LocalityMapperSubPane panel = new LocalityMapperSubPane(this.name, (Taskable)this, list);
            this.addSubPaneToMgr(panel);
        } else {
            log.warn((Object)"Query String was empty.");
        }
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(LOCALITYMAPPER) && cmdAction.isAction("DoLocalityMap") && cmdAction.getData() instanceof RecordSetIFace) {
            RecordSetIFace recordSet = (RecordSetIFace)cmdAction.getData();
            this.createMappingInfoFromRecordSet(recordSet);
        }
    }
}

