/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.SecurityOption;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.subpane.LifeMapperPane;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class LifeMapperTask
extends BaseTask {
    private static final String LIFEMAPPER = "Lifemapper";
    private static final String LIFEMAP_TITLE = "LIFEMAP_TITLE";
    private static final String LIFEMAP_SECURITY = "LIFEMAPEDIT";
    protected LifeMapperPane lmPane = null;
    protected NavBox actionNavBox = null;
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected ToolBarDropDownBtn toolBarBtn = null;

    public LifeMapperTask() {
        super(LIFEMAPPER, UIRegistry.getResourceString(LIFEMAP_TITLE));
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            this.extendedNavBoxes.clear();
        }
        this.isShowDefault = true;
    }

    @Override
    public void preInitialize() {
        CommandDispatcher.register(LIFEMAPPER, this);
        this.actionNavBox = new NavBox(UIRegistry.getResourceString("Actions"));
    }

    @Override
    public SubPaneIFace getStarterPane() {
        UsageTracker.incrUsageCount("LM.OpenLifemapper");
        if (this.starterPane == null || this.lmPane.hasSizeChanged()) {
            if (this.lmPane != null) {
                this.lmPane.shutdown();
            }
            this.lmPane = new LifeMapperPane(this.name, this);
            this.starterPane = this.lmPane;
        }
        return this.starterPane;
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        super.subPaneRemoved(subPane);
        if (subPane == this.starterPane) {
            this.lmPane = null;
            this.starterPane = null;
        }
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        return this.extendedNavBoxes;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        String label = UIRegistry.getResourceString(LIFEMAPPER);
        String hint = UIRegistry.getResourceString(LIFEMAPPER);
        this.toolBarBtn = this.createToolbarButton(label, this.iconName, hint);
        this.toolbarItems = new Vector();
        this.toolbarItems.add(new ToolBarItemDesc(this.toolBarBtn));
        return this.toolbarItems;
    }

    @Override
    public List<SecurityOptionIFace> getAdditionalSecurityOptions() {
        ArrayList<SecurityOptionIFace> list = new ArrayList<SecurityOptionIFace>();
        SecurityOption secOpt = new SecurityOption(LIFEMAP_SECURITY, UIRegistry.getResourceString(LIFEMAP_TITLE), "Task", new BasicPermisionPanel(LIFEMAP_TITLE, "LIFEMAP_VIEW", "LIFEMAP_EDIT"));
        boolean[][] blArrayArray = new boolean[4][];
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArrayArray[0] = blArray;
        blArrayArray[1] = new boolean[4];
        blArrayArray[2] = new boolean[4];
        blArrayArray[3] = new boolean[4];
        this.addPerms(secOpt, blArrayArray);
        list.add(secOpt);
        return list;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        this.menuItems = new Vector();
        return this.menuItems;
    }

    protected void processRecordSetCommands(CommandAction cmdAction) {
        if (cmdAction.isAction("Display")) {
            if (cmdAction.getData() instanceof RecordSetIFace) {
                RecordSetIFace rs = (RecordSetIFace)cmdAction.getData();
                rs.getDbTableId().intValue();
                Taxon.getClassTableId();
            } else if (cmdAction.getData() instanceof Pair) {
                Pair p = (Pair)cmdAction.getData();
                this.getStarterPane();
                this.lmPane.resetWWPanel();
                this.lmPane.setDoResetWWPanel(false);
                this.lmPane.doSearchGenusSpecies(((Taxon)p.first).getFullName(), true);
                this.requestContext();
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(LIFEMAPPER)) {
            this.processRecordSetCommands(cmdAction);
        }
    }
}

