/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.RecordSetFactory;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.CommandActionForDB;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.dbsupport.TableModel2Excel;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.EMailHelper;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.ExchangeIn;
import edu.ku.brc.specify.datamodel.ExchangeOut;
import edu.ku.brc.specify.datamodel.Gift;
import edu.ku.brc.specify.datamodel.GiftPreparation;
import edu.ku.brc.specify.datamodel.InfoRequest;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.LoanReturnPreparation;
import edu.ku.brc.specify.datamodel.Permit;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.PreparationsProviderIFace;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import edu.ku.brc.specify.datamodel.Shipment;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.busrules.LoanBusRules;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.DataEntryTask;
import edu.ku.brc.specify.tasks.EntryFlavor;
import edu.ku.brc.specify.tasks.InfoForTaskReport;
import edu.ku.brc.specify.tasks.InteractionEntry;
import edu.ku.brc.specify.tasks.InteractionsProcessor;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tasks.TaskConfigItemIFace;
import edu.ku.brc.specify.tasks.TaskConfigureDlg;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.ui.LoanReturnDlg;
import edu.ku.brc.specify.ui.LoanReturnInfo;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InteractionsTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(InteractionsTask.class);
    protected static final String resourceName = "InteractionsTaskInit";
    public static final String INTERACTIONS = "Interactions";
    public static final DataFlavorTableExt INTERACTIONS_FLAVOR = new DataFlavorTableExt(DataEntryTask.class, "Interactions");
    public static final DataFlavorTableExt INFOREQUEST_FLAVOR = new DataFlavorTableExt(InfoRequest.class, "InfoRequest", new int[]{50});
    public static final DataFlavorTableExt LOAN_FLAVOR = new DataFlavorTableExt(Loan.class, "Loan", new int[]{52});
    public static final DataFlavorTableExt GIFT_FLAVOR = new DataFlavorTableExt(Loan.class, "Gift");
    public static final DataFlavorTableExt EXCHGIN_FLAVOR = new DataFlavorTableExt(ExchangeIn.class, "ExchangeIn");
    public static final DataFlavorTableExt EXCHGOUT_FLAVOR = new DataFlavorTableExt(ExchangeOut.class, "ExchangeOut");
    public static final String IS_USING_INTERACTIONS_PREFNAME = "Interactions.Using.Interactions.";
    protected static final String InfoRequestName = "InfoRequest";
    protected static final String NEW_LOAN = "NEW_LOAN";
    protected static final String NEW_ACCESSION = "NEW_ACCESSION";
    protected static final String NEW_PERMIT = "NEW_PERMIT";
    protected static final String NEW_GIFT = "NEW_GIFT";
    protected static final String NEW_EXCHANGE_OUT = "NEW_EXCHANGE_OUT";
    protected static final String PRINT_LOAN = "PRINT_LOAN";
    protected static final String PRINT_INVOICE = "PRINT_INVOICE";
    protected static final String INFO_REQ_MESSAGE = "Specify Info Request";
    protected static final String CREATE_MAILMSG = "CreateMailMsg";
    protected static final String ADD_TO_LOAN = "AddToLoan";
    protected static final String ADD_TO_GIFT = "AddToGift";
    protected static final String RET_LOAN = "RET_LOAN";
    protected static final String OPEN_NEW_VIEW = "OpenNewView";
    protected static final String LN_NO_PRP = "LN_NO_PRP";
    protected static final int loanTableId = DBTableIdMgr.getInstance().getIdByClassName(Loan.class.getName());
    protected static final int infoRequestTableId = DBTableIdMgr.getInstance().getIdByClassName(InfoRequest.class.getName());
    protected static final int colObjTableId = DBTableIdMgr.getInstance().getIdByClassName(CollectionObject.class.getName());
    protected NavBox infoRequestNavBox;
    protected Vector<NavBoxIFace> extendedNavBoxes = new Vector();
    protected Vector<NavBoxItemIFace> invoiceList = new Vector();
    protected NavBoxItemIFace exchgNavBtn = null;
    protected NavBoxItemIFace giftsNavBtn = null;
    protected NavBox actionsNavBox;
    protected boolean isUsingInteractions = true;
    protected ToolBarDropDownBtn toolBarBtn = null;
    protected int indexOfTBB = -1;
    protected Vector<InteractionEntry> entries = new Vector();
    protected Vector<Integer> printableInvoiceTblIds = new Vector();
    InteractionsProcessor<Gift> giftProcessor = new InteractionsProcessor(this, false, Gift.getClassTableId());
    InteractionsProcessor<Loan> loanProcessor = new InteractionsProcessor(this, true, Loan.getClassTableId());

    static {
        INFOREQUEST_FLAVOR.addTableId(50);
    }

    public InteractionsTask() {
        super(INTERACTIONS, UIRegistry.getResourceString(INTERACTIONS));
        CommandDispatcher.register(INTERACTIONS, this);
        CommandDispatcher.register("Record_Set", this);
        CommandDispatcher.register("Database", this);
        CommandDispatcher.register("Data_Entry", this);
        CommandDispatcher.register("Preferences", this);
        this.readEntries();
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            this.setUpCachedPrefs();
            this.extendedNavBoxes.clear();
            this.invoiceList.clear();
            this.actionsNavBox = new NavBox(UIRegistry.getResourceString("CreateAndUpdate"));
            SpecifyAppContextMgr acm = (SpecifyAppContextMgr)AppContextMgr.getInstance();
            boolean showIRBox = true;
            for (InteractionEntry entry : this.entries) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(entry.getTableName());
                if (!AppContextMgr.isSecurityOn() || tableInfo.getPermissions().canView()) {
                    String label = StringUtils.isNotEmpty((String)entry.getLabelKey()) ? UIRegistry.getResourceString(entry.getLabelKey()) : tableInfo.getTitle();
                    String tooltip = "";
                    if (StringUtils.isEmpty((String)entry.getTooltip()) && StringUtils.isNotEmpty((String)entry.getViewName())) {
                        ViewIFace view = acm.getView(entry.getViewName());
                        if (view != null) {
                            tooltip = UIRegistry.getLocalizedMessage("DET_OPEN_VIEW", view.getObjTitle());
                        }
                    } else if (StringUtils.isNotEmpty((String)entry.getTooltip())) {
                        tooltip = UIRegistry.getLocalizedMessage(entry.getTooltip(), new Object[0]);
                    }
                    entry.setTitle(label);
                    entry.setI18NTooltip(tooltip);
                    if (entry.isOnLeft()) {
                        NavBoxButton navBtn = this.addCommand(this.actionsNavBox, tableInfo, entry);
                        navBtn.setToolTip(entry.getI18NTooltip());
                    }
                    if (!StringUtils.isNotEmpty((String)entry.getViewName()) || !entry.isSearchService()) continue;
                    CommandAction cmdAction = this.createCmdActionFromEntry(entry, tableInfo);
                    ContextMgr.registerService(10, entry.getViewName(), tableInfo.getTableId(), cmdAction, this, "Data_Entry", tableInfo.getTitle(), true);
                    continue;
                }
                if (tableInfo.getTableId() != infoRequestTableId) continue;
                showIRBox = false;
            }
            this.navBoxes.add(this.actionsNavBox);
            this.infoRequestNavBox = new NavBox(UIRegistry.getResourceString(InfoRequestName));
            this.loadNavBox(this.infoRequestNavBox, InfoRequest.class, INFOREQUEST_FLAVOR, showIRBox);
        }
        this.isShowDefault = true;
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart") || cmdAction.isAction("StartUp")) {
            this.isInitialized = false;
            this.initialize();
        }
    }

    public static boolean isInteractionTable(int tableId) {
        return tableId == Loan.getClassTableId() || tableId == Gift.getClassTableId() || tableId == Accession.getClassTableId() || tableId == Permit.getClassTableId() || tableId == RepositoryAgreement.getClassTableId() || tableId == ExchangeIn.getClassTableId() || tableId == ExchangeOut.getClassTableId();
    }

    private void readEntries() {
        try {
            XStream xstream = new XStream();
            InteractionEntry.config(xstream);
            EntryFlavor.config(xstream);
            String xmlStr = null;
            AppResourceIFace appRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
            if (appRes != null) {
                xmlStr = appRes.getDataAsString();
            } else {
                AppResourceIFace newAppRes = AppContextMgr.getInstance().copyToDirAppRes("Personal", resourceName);
                if (newAppRes != null) {
                    xmlStr = newAppRes.getDataAsString();
                } else {
                    return;
                }
            }
            this.entries = (Vector)xstream.fromXML(xmlStr);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
        }
    }

    private void writeEntries() {
        XStream xstream = new XStream();
        InteractionEntry.config(xstream);
        EntryFlavor.config(xstream);
        AppResourceIFace appRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
        if (appRes != null) {
            appRes.setDataAsString(xstream.toXML(this.entries));
            AppContextMgr.getInstance().saveResource(appRes);
        } else {
            AppContextMgr.getInstance().putResourceAsXML(resourceName, xstream.toXML(this.entries));
        }
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void doConfigure() {
        boolean isEmpty = this.infoRequestNavBox.getItems().size() == 0;
        Vector<TaskConfigItemIFace> stdList = new Vector<TaskConfigItemIFace>();
        Vector<TaskConfigItemIFace> miscList = new Vector<TaskConfigItemIFace>();
        Vector<InteractionEntry> srvList = new Vector<InteractionEntry>();
        boolean showIRBox = true;
        for (InteractionEntry entry : this.entries) {
            DBTableInfo dBTableInfo = DBTableIdMgr.getInstance().getInfoByTableName(entry.getTableName());
            if (!AppContextMgr.isSecurityOn() || dBTableInfo.getPermissions().canView()) {
                entry.setEnabled(true);
                if (entry.isVisible()) {
                    Iterator<TaskConfigItemIFace> list = entry.isOnLeft() ? stdList : miscList;
                    try {
                        ((Vector)((Object)list)).add((TaskConfigItemIFace)entry.clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    continue;
                }
                srvList.add(entry);
                continue;
            }
            entry.setEnabled(false);
            if (dBTableInfo.getTableId() != infoRequestTableId) continue;
            showIRBox = false;
        }
        if (showIRBox) {
            this.navBoxes.add(this.infoRequestNavBox);
        } else {
            this.navBoxes.remove(this.infoRequestNavBox);
        }
        int origNumStd = stdList.size();
        TaskConfigureDlg dlg = new TaskConfigureDlg(stdList, miscList, false, "InteractionsConfig", "IAT_TITLE", "IAT_AVAIL_ITEMS", "IAT_HIDDEN_ITEMS", "IAT_MAKE_AVAIL", "IAT_MAKE_HIDDEN");
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            JToolBar toolBar;
            this.entries.clear();
            for (TaskConfigItemIFace taskConfigItemIFace : stdList) {
                ((InteractionEntry)taskConfigItemIFace).setOnLeft(true);
                this.entries.add((InteractionEntry)taskConfigItemIFace);
            }
            for (TaskConfigItemIFace taskConfigItemIFace : miscList) {
                ((InteractionEntry)taskConfigItemIFace).setOnLeft(false);
                this.entries.add((InteractionEntry)taskConfigItemIFace);
            }
            for (TaskConfigItemIFace taskConfigItemIFace : srvList) {
                this.entries.add((InteractionEntry)taskConfigItemIFace);
            }
            this.writeEntries();
            this.actionsNavBox.clear();
            Collections.sort(this.entries);
            for (InteractionEntry interactionEntry : this.entries) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(interactionEntry.getTableName());
                if (!interactionEntry.isEnabled()) continue;
                if (interactionEntry.isOnLeft()) {
                    NavBoxButton navBtn = this.addCommand(this.actionsNavBox, tableInfo, interactionEntry);
                    navBtn.setToolTip(interactionEntry.getI18NTooltip());
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)interactionEntry.getViewName()) || interactionEntry.isSearchService()) continue;
                CommandAction cmdAction = this.createCmdActionFromEntry(interactionEntry, tableInfo);
                ContextMgr.registerService(10, interactionEntry.getViewName(), tableInfo.getTableId(), cmdAction, this, "Data_Entry", tableInfo.getTitle(), true);
            }
            NavBoxMgr.getInstance().validate();
            NavBoxMgr.getInstance().invalidate();
            NavBoxMgr.getInstance().doLayout();
            if (stdList.size() == 0) {
                String string = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
                AppPreferences.getRemote().putBoolean(IS_USING_INTERACTIONS_PREFNAME + string, false);
                toolBar = (JToolBar)UIRegistry.get("toolbar");
                this.indexOfTBB = toolBar.getComponentIndex(this.toolBarBtn);
                if (this.indexOfTBB > -1) {
                    TaskMgr.removeToolbarBtn(this.toolBarBtn);
                    toolBar.validate();
                    toolBar.repaint();
                }
            } else if (isEmpty && stdList.size() > 0) {
                String string = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
                AppPreferences.getRemote().putBoolean(IS_USING_INTERACTIONS_PREFNAME + string, true);
                this.prefsChanged(new CommandAction(null, null, AppPreferences.getRemote()));
                if (origNumStd == 0) {
                    toolBar = (JToolBar)UIRegistry.get("toolbar");
                    int inx = this.indexOfTBB != -1 ? this.indexOfTBB : 4;
                    TaskMgr.addToolbarBtn(this.toolBarBtn, inx);
                    toolBar.validate();
                    toolBar.repaint();
                }
            }
        }
    }

    protected void setUpCachedPrefs() {
        AppPreferences remotePrefs = AppPreferences.getRemote();
        String ds = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
        this.isUsingInteractions = remotePrefs.getBoolean(IS_USING_INTERACTIONS_PREFNAME + ds, true);
    }

    protected List<AppResourceIFace> getInvoiceAppResources() {
        Vector<AppResourceIFace> ars = new Vector<AppResourceIFace>();
        for (AppResourceIFace ap : AppContextMgr.getInstance().getResourceByMimeType("jrxml/report")) {
            Properties params = ap.getMetaDataMap();
            if (!params.getProperty("reporttype", "").equals("Invoice")) continue;
            ars.add(ap);
        }
        return ars;
    }

    private CommandAction createCmdActionFromEntry(InteractionEntry entry, DBTableInfo tableInfo) {
        CommandAction cmdAction = new CommandAction(entry.getCmdType(), entry.getAction(), tableInfo.getTableId());
        if (StringUtils.isNotEmpty((String)entry.getViewName())) {
            cmdAction.setProperty("view", entry.getViewName());
            cmdAction.setProperty("OriginatingTask", this);
        }
        return cmdAction;
    }

    protected NavBoxButton addCommand(NavBox navBox, DBTableInfo tableInfo, InteractionEntry entry) {
        DataFlavorTableExt dfx;
        CommandAction cmdAction = this.createCmdActionFromEntry(entry, tableInfo);
        if (StringUtils.isNotEmpty((String)entry.getViewName()) && entry.isSearchService()) {
            ContextMgr.registerService(10, entry.getViewName(), tableInfo.getTableId(), cmdAction, this, "Data_Entry", tableInfo.getTitle(), true);
        }
        NavBoxButton roc = (NavBoxButton)InteractionsTask.makeDnDNavBtn(navBox, entry.getTitle(), entry.getIconName(), cmdAction, null, true, false);
        for (EntryFlavor ef : entry.getDraggableFlavors()) {
            if (cmdAction.getAction().equals(PRINT_INVOICE)) {
                System.out.println(ef);
            }
            dfx = new DataFlavorTableExt(ef.getDataFlavorClass(), ef.getHumanReadable(), ef.getTableIdsAsArray());
            roc.addDragDataFlavor(dfx);
        }
        for (EntryFlavor ef : entry.getDroppableFlavors()) {
            if (cmdAction.getAction().equals(PRINT_INVOICE) && ef.getClassName().equals(RecordSetTask.class.getName())) {
                this.printableInvoiceTblIds.addAll(ef.getTableIds());
            }
            dfx = new DataFlavorTableExt(ef.getDataFlavorClass(), ef.getHumanReadable(), ef.getTableIdsAsArray());
            roc.addDropDataFlavor(dfx);
        }
        return roc;
    }

    protected void loadNavBox(NavBox navBox, Class<?> dataClass, DataFlavor dragFlav, boolean addBox) {
        DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(dataClass.getSimpleName());
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                String sql = "FROM " + ti.getClassName() + " WHERE collectionMemberId = COLMEMID";
                List<?> list = session.getDataList(QueryAdjusterForDomain.getInstance().adjustSQL(sql));
                for (FormDataObjIFace dataObj : list) {
                    this.createNavBtn(navBox, dragFlav, dataObj, ti);
                }
                if (addBox) {
                    this.navBoxes.add(navBox);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected NavBoxItemIFace createNavBtn(NavBox navBox, DataFlavor dragFlav, FormDataObjIFace dataObj, DBTableInfo ti) {
        RecordSet rs = new RecordSet();
        rs.initialize();
        rs.set(dataObj.getIdentityTitle(), ti.getTableId(), RecordSet.HIDDEN);
        rs.addItem(dataObj.getId());
        CommandAction cmd = new CommandAction("Data_Entry", "Edit", rs);
        cmd.setProperty("OriginatingTask", this);
        CommandActionForDB delCmd = new CommandActionForDB(INTERACTIONS, "Delete", ti.getTableId(), dataObj.getId());
        NavBoxItemIFace nbi = InteractionsTask.makeDnDNavBtn(navBox, dataObj.getIdentityTitle(), ti.getShortClassName(), cmd, delCmd, true, true);
        NavBoxButton roc = (NavBoxButton)nbi;
        nbi.setData(rs);
        roc.addDragDataFlavor(dragFlav);
        roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        return nbi;
    }

    protected NavBoxItemIFace addToNavBoxAndRegisterAsDroppable(NavBox navBox, NavBoxItemIFace nbi, Properties params) {
        NavBoxButton roc = (NavBoxButton)nbi;
        roc.setData(params);
        roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        roc.addDragDataFlavor(INTERACTIONS_FLAVOR);
        roc.addDropDataFlavor(RecordSetTask.RECORDSET_FLAVOR);
        navBox.add(nbi);
        return nbi;
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        this.extendedNavBoxes.clear();
        this.extendedNavBoxes.addAll(this.navBoxes);
        RecordSetTask rsTask = (RecordSetTask)ContextMgr.getTaskByClass(RecordSetTask.class);
        List<NavBoxIFace> nbs = rsTask.getNavBoxes();
        if (nbs != null) {
            this.extendedNavBoxes.addAll(nbs);
        }
        return this.extendedNavBoxes;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        if (this.starterPane != null) {
            return this.starterPane;
        }
        this.starterPane = StartUpTask.createFullImageSplashPanel(this.title, this);
        return this.starterPane;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        String label = UIRegistry.getResourceString(this.name);
        String iconNameStr = this.name;
        String hint = UIRegistry.getResourceString("interactions_hint");
        this.toolBarBtn = this.createToolbarButton(label, iconNameStr, hint);
        AppPreferences remotePrefs = AppPreferences.getRemote();
        if (remotePrefs == AppPreferences.getRemote()) {
            String ds = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
            this.isUsingInteractions = remotePrefs.getBoolean(IS_USING_INTERACTIONS_PREFNAME + ds, true);
        }
        if (this.isUsingInteractions) {
            this.toolbarItems.add(new ToolBarItemDesc(this.toolBarBtn));
        }
        return this.toolbarItems;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    protected void printInvoice(String fileNameArg, Object data) {
        RecordSetIFace rs;
        InfoForTaskReport invoiceInfo;
        if (data instanceof RecordSetIFace && (invoiceInfo = this.getInvoiceInfo((rs = (RecordSetIFace)data).getDbTableId())) != null) {
            this.dispatchReport(invoiceInfo, rs, "LoanInvoice");
        }
    }

    protected void showMissingDetsDlg(List<CollectionObject> noCurrDetList) {
        StringBuilder sb = new StringBuilder();
        for (CollectionObject co : noCurrDetList) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(co.getIdentityTitle());
        }
        PanelBuilder pb = new PanelBuilder(new FormLayout("p:g", "p,2px,p"));
        CellConstraints cc = new CellConstraints();
        JTextArea ta = UIHelper.createTextArea(5, 40);
        JScrollPane scroll = UIHelper.createScrollPane(ta);
        JLabel lbl = UIHelper.createLabel(UIRegistry.getResourceString("InteractionsTask.MISSING_DET"));
        pb.add((Component)lbl, cc.xy(1, 1));
        pb.add((Component)scroll, cc.xy(1, 3));
        ta.setText(sb.toString());
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        pb.setDefaultDialogBorder();
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("InteractionsTask.MISSING_DET_TITLE"), true, 1, (Component)pb.getPanel());
        dlg.setVisible(true);
    }

    protected Vector<RecordSetIFace> getInfoReqRecordSetsFromSideBar() {
        Vector<RecordSetIFace> rsList = new Vector<RecordSetIFace>();
        for (NavBoxItemIFace nbi : this.infoRequestNavBox.getItems()) {
            rsList.add((RecordSet)nbi.getData());
        }
        return rsList;
    }

    protected Vector<RecordSetIFace> getLoanRecordSetsFromSideBar() {
        Vector<RecordSetIFace> rsList = new Vector<RecordSetIFace>();
        for (NavBoxItemIFace nbi : this.infoRequestNavBox.getItems()) {
            rsList.add((RecordSet)nbi.getData());
        }
        return rsList;
    }

    protected void addPrepsToLoan(PreparationsProviderIFace existingLoanArg, InfoRequest infoRequest, Hashtable<Integer, Integer> prepsHash, Viewable srcViewable) {
        Loan loan;
        Loan existingLoan;
        block20: {
            existingLoan = (Loan)existingLoanArg;
            if (existingLoan == null) {
                loan = new Loan();
                loan.initialize();
                Calendar dueDate = Calendar.getInstance();
                dueDate.add(2, 6);
                loan.setCurrentDueDate(dueDate);
                Shipment shipment = new Shipment();
                shipment.initialize();
                if (infoRequest != null && infoRequest.getAgent() != null) {
                    shipment.setShippedTo(infoRequest.getAgent());
                }
                loan.addReference(shipment, "shipments");
            } else {
                loan = existingLoan;
            }
            Hashtable<Integer, LoanPreparation> prepToLoanPrepHash = null;
            if (existingLoan != null) {
                prepToLoanPrepHash = new Hashtable<Integer, LoanPreparation>();
                for (LoanPreparation lp : existingLoan.getLoanPreparations()) {
                    prepToLoanPrepHash.put(lp.getPreparation().getId(), lp);
                }
            }
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    for (Integer prepId : prepsHash.keySet()) {
                        LoanPreparation lp;
                        Preparation prep = session.get(Preparation.class, prepId);
                        Integer count = prepsHash.get(prepId);
                        if (prepToLoanPrepHash != null && (lp = (LoanPreparation)prepToLoanPrepHash.get(prep.getId())) != null) {
                            int lpCnt = lp.getQuantity();
                            lp.setQuantity(lpCnt += count.intValue());
                            continue;
                        }
                        LoanPreparation lpo = new LoanPreparation();
                        lpo.initialize();
                        lpo.setPreparation(prep);
                        lpo.setQuantity(count);
                        lpo.setLoan(loan);
                        loan.getLoanPreparations().add(lpo);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                    if (session != null) {
                        session.close();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        if (existingLoan == null) {
            if (srcViewable != null) {
                srcViewable.setNewObject(loan);
            } else {
                DataEntryTask dataEntryTask = (DataEntryTask)TaskMgr.getTask("Data_Entry");
                if (dataEntryTask != null) {
                    DBTableInfo loanTableInfo = DBTableIdMgr.getInstance().getInfoById(loan.getTableId());
                    dataEntryTask.openView(this, null, loanTableInfo.getDefaultFormName(), "edit", loan, true);
                }
            }
        } else {
            CommandDispatcher.dispatch(new CommandAction(INTERACTIONS, "REFRESH_LOAN_PREPS", loan));
        }
    }

    protected void addPrepsToGift(PreparationsProviderIFace existingGiftArg, InfoRequest infoRequest, Hashtable<Integer, Integer> prepsHash, Viewable srcViewable) {
        Gift gift;
        Gift existingGift;
        block20: {
            existingGift = (Gift)existingGiftArg;
            if (existingGift == null) {
                gift = new Gift();
                gift.initialize();
                Calendar dueDate = Calendar.getInstance();
                dueDate.add(2, 6);
                Shipment shipment = new Shipment();
                shipment.initialize();
                if (infoRequest != null && infoRequest.getAgent() != null) {
                    shipment.setShippedTo(infoRequest.getAgent());
                }
                gift.addReference(shipment, "shipments");
            } else {
                gift = existingGift;
            }
            Hashtable<Integer, GiftPreparation> prepToGiftPrepHash = null;
            if (existingGift != null) {
                prepToGiftPrepHash = new Hashtable<Integer, GiftPreparation>();
                for (GiftPreparation lp : existingGift.getGiftPreparations()) {
                    prepToGiftPrepHash.put(lp.getPreparation().getId(), lp);
                }
            }
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    for (Integer prepId : prepsHash.keySet()) {
                        GiftPreparation gp;
                        Preparation prep = session.get(Preparation.class, prepId);
                        Integer count = prepsHash.get(prepId);
                        if (prepToGiftPrepHash != null && (gp = (GiftPreparation)prepToGiftPrepHash.get(prep.getId())) != null) {
                            int lpCnt = gp.getQuantity();
                            gp.setQuantity(lpCnt += count.intValue());
                            continue;
                        }
                        GiftPreparation gpo = new GiftPreparation();
                        gpo.initialize();
                        gpo.setPreparation(prep);
                        gpo.setQuantity(count);
                        gpo.setGift(gift);
                        gift.getGiftPreparations().add(gpo);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                    if (session != null) {
                        session.close();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        if (existingGift == null) {
            if (srcViewable != null) {
                srcViewable.setNewObject(gift);
            } else {
                DataEntryTask dataEntryTask = (DataEntryTask)TaskMgr.getTask("Data_Entry");
                if (dataEntryTask != null) {
                    DBTableInfo giftTableInfo = DBTableIdMgr.getInstance().getInfoById(gift.getTableId());
                    dataEntryTask.openView(this, null, giftTableInfo.getDefaultFormName(), "edit", gift, true);
                }
            }
        } else {
            CommandDispatcher.dispatch(new CommandAction(INTERACTIONS, "REFRESH_GIFT_PREPS", gift));
        }
    }

    protected String askForInvoiceName() {
        List<AppResourceIFace> invoiceReports = this.getInvoiceAppResources();
        if (invoiceReports.size() == 1) {
            return (String)invoiceReports.get(0).getMetaDataMap().get("file");
        }
        ChooseFromListDlg<AppResourceIFace> dlg = new ChooseFromListDlg<AppResourceIFace>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ChooseInvoice"), invoiceReports, IconManager.getIcon(this.name, IconManager.IconSize.Std24));
        dlg.setMultiSelect(false);
        dlg.setModal(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            return (String)dlg.getSelectedObject().getMetaDataMap().get("file");
        }
        return null;
    }

    protected void createInfoRequest(RecordSetIFace recordSetArg, CommandAction cmdAction) {
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(InfoRequest.getClassTableId());
        ViewIFace view = AppContextMgr.getInstance().getView(tableInfo.getDefaultFormName());
        InfoRequest infoRequest = new InfoRequest();
        infoRequest.initialize();
        RecordSetTask rsTask = (RecordSetTask)TaskMgr.getTask("Record_Set");
        List<RecordSetIFace> colObjRSList = rsTask.getRecordSets(CollectionObject.getClassTableId());
        RecordSetIFace recordSetFromDB = this.getRecordSetOfDataObjs(recordSetArg, CollectionObject.class, "catalogNumber", colObjRSList.size());
        if (recordSetFromDB != null) {
            RecordSet recordSet = RecordSetTask.copyRecordSet(recordSetFromDB);
            if (recordSet == null) {
                UIRegistry.showLocalizedError("ERROR_COPYING_RS");
                return;
            }
            recordSet.setName(String.valueOf(recordSet.getName()) + "_IT");
            infoRequest.addReference(recordSet, "recordSets");
            if (recordSet.getOrderedItems() != null && recordSet.getNumItems() > 0) {
                Taskable irTask = TaskMgr.getTask(InfoRequestName);
                if (cmdAction != null && cmdAction.getData() instanceof Viewable) {
                    ((Viewable)cmdAction.getData()).setNewObject(infoRequest);
                } else {
                    this.createFormPanel(irTask.getTitle(), view.getViewSetName(), view.getName(), "edit", infoRequest, 4, irTask.getIcon(16));
                }
            } else {
                UIRegistry.displayErrorDlgLocalized("ERROR_MISSING_RS_OR_NOITEMS", new Object[0]);
            }
        }
    }

    protected void checkToPrintLoan(CommandAction cmdAction) {
        boolean isGift = cmdAction.getData() instanceof Gift;
        if (cmdAction.getData() instanceof Loan || isGift) {
            Component comp;
            Loan loan = isGift ? null : (Loan)cmdAction.getData();
            Gift gift = isGift ? (Gift)cmdAction.getData() : null;
            Boolean doPrintInvoice = null;
            FormViewObj formViewObj = this.getCurrentFormViewObj();
            if (formViewObj != null && (comp = formViewObj.getControlByName("generateInvoice")) instanceof JCheckBox) {
                doPrintInvoice = ((JCheckBox)comp).isSelected();
            }
            if (doPrintInvoice == null) {
                String number = isGift ? gift.getGiftNumber() : loan.getLoanNumber();
                String btnLbl = UIRegistry.getResourceString(isGift ? "GIFT" : "LOAN");
                String msg = UIRegistry.getLocalizedMessage("CreateInvoiceForNum", UIRegistry.getResourceString(isGift ? "GIFT" : "LOAN"), number);
                Object[] options = new Object[]{btnLbl, UIRegistry.getResourceString("CANCEL")};
                int n = JOptionPane.showOptionDialog(UIRegistry.get("frame"), msg, btnLbl, 0, 3, null, options, options[0]);
                doPrintInvoice = n == 0;
            }
            if (doPrintInvoice.booleanValue()) {
                InfoForTaskReport invoice = this.getReport(isGift);
                if (invoice == null) {
                    return;
                }
                DataProviderSessionIFace session = null;
                try {
                    Set<Shipment> shipments;
                    session = DataProviderFactory.getInstance().createSession();
                    String hql = isGift ? "FROM Gift WHERE giftId = " + gift.getGiftId() : "FROM Loan WHERE loanId = " + loan.getLoanId();
                    loan = isGift ? null : (Loan)session.getData(hql);
                    gift = isGift ? (Gift)session.getData(hql) : null;
                    Set<Shipment> set = shipments = isGift ? gift.getShipments() : loan.getShipments();
                    if (shipments != null && shipments.size() == 0) {
                        UIRegistry.displayErrorDlg(UIRegistry.getResourceString("NO_SHIPMENTS_ERROR"));
                    } else if (shipments.size() > 1) {
                        UIRegistry.displayErrorDlg(UIRegistry.getResourceString("MULTI_SHIPMENTS_NOT_SUPPORTED"));
                    } else {
                        Shipment shipment;
                        Shipment shipment2 = shipment = isGift ? gift.getShipments().iterator().next() : loan.getShipments().iterator().next();
                        if (shipment.getShippedBy() == null) {
                            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("SHIPMENT_MISSING_SHIPPEDBY"));
                        } else if (shipment.getShippedBy().getAddresses().size() == 0) {
                            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("SHIPPEDBY_MISSING_ADDR"));
                        } else if (shipment.getShippedTo() == null) {
                            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("SHIPMENT_MISSING_SHIPPEDTO"));
                        } else if (shipment.getShippedTo().getAddresses().size() == 0) {
                            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("SHIPPEDTO_MISSING_ADDR"));
                        } else {
                            Integer id;
                            int tableId;
                            String identTitle;
                            if (isGift) {
                                identTitle = gift.getIdentityTitle();
                                tableId = gift.getTableId();
                                id = gift.getId();
                            } else {
                                identTitle = loan.getIdentityTitle();
                                tableId = loan.getTableId();
                                id = loan.getId();
                            }
                            RecordSet rs = new RecordSet();
                            rs.initialize();
                            rs.setName(identTitle);
                            rs.setDbTableId(tableId);
                            rs.addItem(id);
                            this.dispatchReport(invoice, rs, "LoanInvoice");
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
    }

    public InfoForTaskReport getReport(boolean isGift) {
        return this.getInvoiceInfo(DBTableIdMgr.getInstance().getIdByShortName(isGift ? "Gift" : "Loan"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InfoForTaskReport getInvoiceInfo(int invoiceTblId) {
        DataProviderSessionIFace session = null;
        ChooseFromListDlg dlg = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<AppResourceIFace> reps = AppContextMgr.getInstance().getResourceByMimeType("jrxml/label");
            reps.addAll(AppContextMgr.getInstance().getResourceByMimeType("jrxml/report"));
            Vector<InfoForTaskReport> repInfo = new Vector<InfoForTaskReport>();
            for (AppResourceIFace rep : reps) {
                boolean includeIt;
                SpReport spReport;
                block16: {
                    Properties params = rep.getMetaDataMap();
                    String tableid = params.getProperty("tableid");
                    spReport = null;
                    includeIt = false;
                    try {
                        DataProviderSessionIFace.QueryIFace q;
                        List<?> spReps;
                        Integer tblId = null;
                        try {
                            tblId = Integer.valueOf(tableid);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (tblId == null) continue;
                        if (tblId.equals(invoiceTblId)) {
                            includeIt = true;
                            break block16;
                        }
                        if (!tblId.equals(-1) || (spReps = (q = session.createQuery("from SpReport spr join spr.appResource apr  join spr.query spq where apr.id = " + ((SpAppResource)rep).getId() + " and spq.contextTableId = " + invoiceTblId, false)).list()).size() <= 0) break block16;
                        includeIt = true;
                        spReport = (SpReport)((Object[])spReps.get(0))[0];
                        spReport.forceLoad();
                        if (spReps.size() > 1) {
                            log.error((Object)("More than SpReport exists for " + rep.getName()));
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                    }
                }
                if (!includeIt) continue;
                repInfo.add(new InfoForTaskReport((SpAppResource)rep, spReport));
            }
            if (repInfo.size() == 0) {
                UIRegistry.displayInfoMsgDlgLocalized("InteractionsTask.NoInvoiceFound", DBTableIdMgr.getInstance().getTitleForId(invoiceTblId));
                return null;
            }
            if (repInfo.size() == 1) {
                InfoForTaskReport infoForTaskReport = (InfoForTaskReport)repInfo.get(0);
                return infoForTaskReport;
            }
            dlg = new ChooseFromListDlg((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_CHOOSE_INVOICE"), repInfo);
            dlg.setVisible(true);
            if (dlg.isCancelled()) {
                return null;
            }
            InfoForTaskReport infoForTaskReport = (InfoForTaskReport)dlg.getSelectedObject();
            return infoForTaskReport;
        }
        finally {
            session.close();
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    public void createAndSendEMail() {
        FormViewObj formViewObj = this.getCurrentFormViewObj();
        if (formViewObj != null && formViewObj.getDataObj() instanceof InfoRequest) {
            Viewable viewable;
            MultiView mv;
            InfoRequest infoRequest = (InfoRequest)formViewObj.getDataObj();
            Agent toAgent = infoRequest.getAgent();
            boolean sendEMail = true;
            Component comp = formViewObj.getControlByName("sendEMail");
            if (comp instanceof JCheckBox) {
                sendEMail = ((JCheckBox)comp).isSelected();
            }
            if ((mv = formViewObj.getSubView("InfoRequestColObj")) != null && sendEMail && (viewable = mv.getCurrentView()) instanceof TableViewObj) {
                Hashtable<String, String> emailPrefs = new Hashtable<String, String>();
                if (!EMailHelper.isEMailPrefsOK(emailPrefs)) {
                    JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("NO_EMAIL_PREF_INFO"), UIRegistry.getResourceString("NO_EMAIL_PREF_INFO_TITLE"), 2);
                    return;
                }
                File tempExcelFileName = TableModel2Excel.getTempExcelName();
                emailPrefs.put("to", toAgent.getEmail() != null ? toAgent.getEmail() : "");
                emailPrefs.put("from", emailPrefs.get("email"));
                emailPrefs.put("subject", String.format(UIRegistry.getResourceString("INFO_REQUEST_SUBJECT"), infoRequest.getIdentityTitle()));
                emailPrefs.put("bodytext", "");
                emailPrefs.put("attachedFileName", tempExcelFileName.getName());
                Frame topFrame = (Frame)UIRegistry.getTopWindow();
                ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog(topFrame, "SystemSetup", "SendMail", null, UIRegistry.getResourceString("SEND_MAIL_TITLE"), UIRegistry.getResourceString("SEND_BTN"), null, null, true, 0);
                dlg.setData(emailPrefs);
                dlg.setModal(true);
                dlg.setVisible(true);
                if (dlg.getBtnPressed() == 1) {
                    EMailHelper.ErrorType status;
                    dlg.getMultiView().getDataFromUI();
                    TableViewObj tblViewObj = (TableViewObj)viewable;
                    File excelFile = TableModel2Excel.convertToExcel(tempExcelFileName, UIRegistry.getResourceString("CollectionObject"), tblViewObj.getTable().getModel());
                    StringBuilder sb = TableModel2Excel.convertToHTML(UIRegistry.getResourceString("CollectionObject"), tblViewObj.getTable().getModel());
                    String text = String.valueOf(emailPrefs.get("bodytext").replace("\n", "<br>")) + "<BR><BR>" + sb.toString();
                    UIRegistry.displayLocalizedStatusBarText("SENDING_EMAIL", new Object[0]);
                    String password = Encryption.decrypt(emailPrefs.get("password"));
                    if (StringUtils.isEmpty((String)password)) {
                        password = EMailHelper.askForPassword(topFrame);
                    }
                    if (StringUtils.isNotEmpty((String)password) && (status = EMailHelper.sendMsg(emailPrefs.get("smtp"), emailPrefs.get("username"), password, emailPrefs.get("email"), emailPrefs.get("to"), emailPrefs.get("subject"), text, "text/html", emailPrefs.get("port"), emailPrefs.get("security"), excelFile)) != EMailHelper.ErrorType.Cancel) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.displayLocalizedStatusBarText(status == EMailHelper.ErrorType.Error ? "EMAIL_SENT_ERROR" : "EMAIL_SENT_OK", new Object[0]);
                            }
                        });
                    }
                }
            }
        } else {
            log.error((Object)"Why doesn't the current SubPane have a main FormViewObj?");
        }
    }

    protected InfoRequest deleteInfoRequest(int infoReqId) {
        InfoRequest infoRequest = null;
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                infoRequest = session.get(InfoRequest.class, infoReqId);
                if (infoRequest != null) {
                    session.beginTransaction();
                    session.delete(infoRequest);
                    session.commit();
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                ex.printStackTrace();
                log.error((Object)ex);
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return infoRequest;
    }

    protected void deleteInfoRequestFromUI(NavBoxItemIFace boxItem, InfoRequest infoRequest) {
        this.deleteDnDBtn(this.infoRequestNavBox, boxItem != null ? boxItem : this.getBoxByTitle(infoRequest.getIdentityTitle()));
    }

    protected void doReturnLoans(final MultiView multiView, final Agent agent, final Calendar returnedDate, final List<LoanReturnInfo> returns, final boolean doingSingleItem) {
        final JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setIndeterminate(INTERACTIONS, true);
        String msg = UIRegistry.getResourceString("InteractionsTask.ReturningLoanItems");
        statusBar.setText(msg);
        UIRegistry.writeSimpleGlassPaneMsg(msg, 24);
        SwingWorker worker = new SwingWorker(){
            protected int numLPR = 0;
            protected HashMap<Integer, Loan> mergedLoans = new HashMap();

            @Override
            public Object construct() {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.beginTransaction();
                        for (LoanReturnInfo loanRetInfo : returns) {
                            LoanPreparation loanPrep = loanRetInfo.getLoanPreparation();
                            Loan loan = this.mergedLoans.get(loanPrep.getLoan().getId());
                            if (loan == null) {
                                loan = session.merge(loanPrep.getLoan());
                                this.mergedLoans.put(loan.getId(), loan);
                            }
                            for (LoanPreparation lp : loan.getLoanPreparations()) {
                                if (!loanPrep.getId().equals(lp.getId())) continue;
                                loanPrep = lp;
                            }
                            LoanReturnPreparation loanRetPrep = new LoanReturnPreparation();
                            loanRetPrep.initialize();
                            loanRetPrep.setReceivedBy(agent);
                            loanRetPrep.setModifiedByAgent(Agent.getUserAgent());
                            loanRetPrep.setReturnedDate(returnedDate);
                            loanRetPrep.setQuantityResolved(loanRetInfo.getResolvedQty());
                            loanRetPrep.setQuantityReturned(loanRetInfo.getReturnedQty());
                            loanPrep.setIsResolved(loanRetInfo.isResolved());
                            loanRetPrep.setRemarks(loanRetInfo.getRemarks());
                            loanPrep.setQuantityResolved(loanRetInfo.getResolvedQty());
                            loanPrep.setQuantityReturned(loanRetInfo.getReturnedQty());
                            loanPrep.addReference(loanRetPrep, "loanReturnPreparations");
                            if (doingSingleItem) {
                                boolean isClosed = true;
                                for (LoanPreparation lp : loan.getLoanPreparations()) {
                                    if (lp.getQuantityResolved().equals(lp.getQuantity())) {
                                        if (lp.getIsResolved().booleanValue()) continue;
                                        lp.setIsResolved(true);
                                        continue;
                                    }
                                    isClosed = false;
                                }
                                loan.setIsClosed(isClosed);
                            } else {
                                loan.setIsClosed(true);
                            }
                            session.save(loanRetPrep);
                            session.saveOrUpdate(loanPrep);
                            session.saveOrUpdate(loan);
                        }
                        session.commit();
                        this.numLPR += returns.size();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
                return null;
            }

            @Override
            public void finished() {
                statusBar.setProgressDone(InteractionsTask.INTERACTIONS);
                statusBar.setText("");
                if (multiView != null) {
                    multiView.setIsNewForm(false, true);
                    multiView.setData(null);
                    if (doingSingleItem && this.mergedLoans.size() == 1) {
                        multiView.setData(this.mergedLoans.values().iterator().next());
                    }
                }
                UIRegistry.clearSimpleGlassPaneMsg();
                UIRegistry.showLocalizedMsg(1, "InteractionsTask.LN_RET_TITLE", "InteractionsTask.RET_LN_SV", this.numLPR);
            }
        };
        worker.start();
    }

    protected void returnLoan() {
        LoanReturnDlg dlg;
        Loan loan = null;
        MultiView mv = null;
        SubPaneIFace subPane = SubPaneMgr.getInstance().getCurrentSubPane();
        if (subPane != null && (mv = subPane.getMultiView()) != null && mv.getData() instanceof Loan) {
            loan = (Loan)mv.getData();
        }
        if (mv != null && loan != null && (dlg = new LoanReturnDlg(loan)).createUI()) {
            dlg.setModal(true);
            UIHelper.centerAndShow(dlg);
            dlg.dispose();
            if (!dlg.isCancelled()) {
                FormViewObj fvp = mv.getCurrentViewAsFormViewObj();
                fvp.setHasNewData(true);
                List<LoanReturnInfo> returns = dlg.getLoanReturnInfo();
                if (returns.size() > 0) {
                    this.doReturnLoans(mv, dlg.getAgent(), dlg.getDate(), returns, true);
                }
            }
        }
    }

    protected void createLoanNoPreps(Viewable srcViewable) {
        Loan loan = new Loan();
        loan.initialize();
        Calendar dueDate = Calendar.getInstance();
        dueDate.add(2, 6);
        loan.setCurrentDueDate(dueDate);
        Shipment shipment = new Shipment();
        shipment.initialize();
        loan.addReference(shipment, "shipments");
        if (srcViewable != null) {
            srcViewable.setNewObject(loan);
        } else {
            FormViewObj fvo;
            MultiView mv;
            DBTableInfo loanTableInfo;
            FormPane formPane;
            DataEntryTask dataEntryTask = (DataEntryTask)TaskMgr.getTask("Data_Entry");
            if (dataEntryTask != null && (formPane = dataEntryTask.openView(this, null, (loanTableInfo = DBTableIdMgr.getInstance().getInfoById(loan.getTableId())).getDefaultFormName(), "edit", loan, true)) != null && (mv = formPane.getMultiView()) != null && (fvo = mv.getCurrentViewAsFormViewObj()) != null && fvo.getBusinessRules() != null && fvo.getBusinessRules() instanceof LoanBusRules) {
                ((LoanBusRules)fvo.getBusinessRules()).setDoCreateLoanNoPreps(true);
            }
        }
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        super.subPaneRemoved(subPane);
        if (subPane == this.starterPane) {
            this.starterPane = null;
        }
    }

    protected void prefsChanged(CommandAction cmdAction) {
        AppPreferences remotePrefs = (AppPreferences)cmdAction.getData();
        if (remotePrefs == AppPreferences.getRemote()) {
            String ds = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
            this.isUsingInteractions = remotePrefs.getBoolean(IS_USING_INTERACTIONS_PREFNAME + ds, true);
            JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
            if (!this.isUsingInteractions) {
                this.indexOfTBB = toolBar.getComponentIndex(this.toolBarBtn);
                TaskMgr.removeToolbarBtn(this.toolBarBtn);
                toolBar.validate();
                toolBar.repaint();
            } else {
                int curInx = toolBar.getComponentIndex(this.toolBarBtn);
                if (curInx == -1) {
                    int inx = this.indexOfTBB != -1 ? this.indexOfTBB : 4;
                    TaskMgr.addToolbarBtn(this.toolBarBtn, inx);
                    toolBar.validate();
                    toolBar.repaint();
                }
            }
        }
    }

    protected void processRecordSetCommands(CommandAction cmdAction) {
        Object data = cmdAction.getData();
        UsageTracker.incrUsageCount("IN." + cmdAction.getType() + (data != null ? "." + data.getClass().getSimpleName() : ""));
        if (cmdAction.isAction("Clicked")) {
            RecordSetIFace rs;
            Object srcObj = cmdAction.getSrcObj();
            Object dstObj = cmdAction.getDstObj();
            log.debug((Object)("********* In Labels doCommand src[" + srcObj + "] dst[" + dstObj + "] data[" + data + "] context[" + ContextMgr.getCurrentContext() + "]"));
            if (ContextMgr.getCurrentContext() == this && dstObj instanceof RecordSetIFace && (rs = (RecordSetIFace)dstObj).getDbTableId() == Loan.getClassTableId()) {
                DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(rs.getDbTableId());
                super.createFormPanel(ti.getTitle(), "view", rs, IconManager.getIcon(ti.getShortClassName(), IconManager.IconSize.Std16));
            }
        }
    }

    protected void processDatabaseCommands(CommandAction cmdAction) {
        if (cmdAction.getData() instanceof InfoRequest) {
            System.out.println(cmdAction);
            if (cmdAction.isAction("Update")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandDispatcher.dispatch(new CommandAction(InteractionsTask.INTERACTIONS, InteractionsTask.CREATE_MAILMSG, SubPaneMgr.getInstance().getCurrentSubPane()));
                    }
                });
            } else if (cmdAction.isAction("Insert")) {
                InfoRequest infoRequest = (InfoRequest)cmdAction.getData();
                this.createNavBtn(this.infoRequestNavBox, INFOREQUEST_FLAVOR, infoRequest, DBTableIdMgr.getInstance().getInfoById(InfoRequest.getClassTableId()));
            }
        }
    }

    private void showInfoReqForm(CommandActionForDB cmdAction, RecordSetIFace irRS) {
        DataEntryTask dataEntryTask = (DataEntryTask)TaskMgr.getTask("Data_Entry");
        if (dataEntryTask != null) {
            DBTableInfo tableInfo;
            InfoRequest infoReq;
            block7: {
                infoReq = null;
                tableInfo = DBTableIdMgr.getInstance().getInfoById(InfoRequest.getClassTableId());
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    try {
                        infoReq = session.get(InfoRequest.class, cmdAction != null ? cmdAction.getId() : irRS.getItems().iterator().next().getRecordId());
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                        ex.printStackTrace();
                        log.error((Object)ex);
                        session.close();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    throw throwable;
                }
                session.close();
            }
            if (infoReq != null) {
                dataEntryTask.openView(this, null, tableInfo.getDefaultFormName(), "edit", infoReq, true);
            }
        }
    }

    private void deleteInfoRequest(CommandActionForDB cmdActionDB) {
        NavBoxButton nb = (NavBoxButton)cmdActionDB.getSrcObj();
        int option = JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("InteractionsTask.CONFIRM_DELETE_IR"), nb.getName()), UIRegistry.getResourceString("InteractionsTask.CONFIRM_DELETE_TITLE_IR"), 0, 3, null, null, 1);
        if (option == 0) {
            InfoRequest infoRequest = this.deleteInfoRequest(cmdActionDB.getId());
            this.deleteInfoRequestFromUI(null, infoRequest);
        }
    }

    private void returnLoan(RecordSetIFace dataObj) {
        ArrayList<LoanReturnInfo> lriList;
        block16: {
            RecordSetIFace recordSet = null;
            if (dataObj instanceof RecordSetIFace) {
                recordSet = dataObj;
            } else if (dataObj == null) {
                RecordSetTask rsTask = (RecordSetTask)ContextMgr.getTaskByClass(RecordSetTask.class);
                Vector<RecordSetIFace> loanRSList = new Vector<RecordSetIFace>(rsTask.getRecordSets(Loan.getClassTableId()));
                recordSet = this.getRecordSetOfDataObjs(null, Loan.class, "loanNumber", loanRSList.size());
            }
            if (recordSet == null) {
                return;
            }
            lriList = new ArrayList<LoanReturnInfo>();
            if (recordSet.getDbTableId() == Loan.getClassTableId()) {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        HashSet<Integer> loanHashMap = new HashSet<Integer>();
                        session = DataProviderFactory.getInstance().createSession();
                        for (RecordSetItemIFace rsi : recordSet.getItems()) {
                            Loan loan;
                            if (loanHashMap.contains(rsi.getRecordId()) || (loan = session.get(Loan.class, rsi.getRecordId())) == null) continue;
                            loanHashMap.add(rsi.getRecordId());
                            if (loan.getIsClosed().booleanValue()) continue;
                            for (LoanPreparation lp : loan.getLoanPreparations()) {
                                if (lp.getIsResolved().booleanValue()) continue;
                                int qty = lp.getQuantity();
                                int qtyResolved = lp.getQuantityResolved();
                                int qtyReturned = lp.getQuantityReturned();
                                int qtyToBeReturned = qty - qtyResolved;
                                qtyReturned += qtyToBeReturned;
                                lriList.add(new LoanReturnInfo(lp, null, qtyToBeReturned, qtyResolved += qtyToBeReturned, true));
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(InteractionsTask.class, ex);
                        if (session != null) {
                            session.close();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
        }
        if (lriList.size() > 0) {
            Agent currAgent = AppContextMgr.getInstance().getClassObject(Agent.class);
            this.doReturnLoans(null, currAgent, Calendar.getInstance(), lriList, false);
        }
    }

    protected void processInteractionsCommands(final CommandAction cmdAction) {
        RecordSetIFace rs;
        boolean isOKToAdd;
        boolean isNewLoan = cmdAction.isAction(NEW_LOAN);
        boolean isNewLoanNoPreps = cmdAction.isAction(LN_NO_PRP);
        boolean isNewGift = cmdAction.isAction(NEW_GIFT);
        boolean isInfoReq = cmdAction.isAction(INFO_REQ_MESSAGE);
        if (AppContextMgr.isSecurityOn()) {
            PermissionSettings loanPerms = DBTableIdMgr.getInstance().getInfoById(Loan.getClassTableId()).getPermissions();
            PermissionSettings giftPerms = DBTableIdMgr.getInstance().getInfoById(Gift.getClassTableId()).getPermissions();
            PermissionSettings irPerms = DBTableIdMgr.getInstance().getInfoById(InfoRequest.getClassTableId()).getPermissions();
            isOKToAdd = (isNewLoan || isNewLoanNoPreps) && (loanPerms == null || loanPerms.canAdd()) || isNewGift && (giftPerms == null || giftPerms.canAdd()) || isInfoReq && (irPerms == null || irPerms.canAdd());
        } else {
            isOKToAdd = isNewLoan || isNewGift || isInfoReq || isNewLoanNoPreps;
        }
        UsageTracker.incrUsageCount("IN." + cmdAction.getType());
        if (cmdAction.isAction(CREATE_MAILMSG)) {
            this.createAndSendEMail();
        } else if (cmdAction.isAction(PRINT_INVOICE)) {
            RecordSetIFace recordSet;
            if (cmdAction.getData() instanceof RecordSetIFace) {
                this.printInvoice(null, cmdAction.getData());
            }
            if (cmdAction.getData() instanceof CommandAction && (recordSet = RecordSetTask.askForRecordSet(this.printableInvoiceTblIds, null, true)) != null) {
                this.printInvoice(cmdAction.getPropertyAsString("file"), recordSet);
            }
        } else if (isNewLoan || isNewGift || isNewLoanNoPreps) {
            if (cmdAction.getData() == cmdAction) {
                if (isOKToAdd) {
                    if (isNewLoan) {
                        this.loanProcessor.createOrAdd();
                    } else if (isNewLoanNoPreps) {
                        this.createLoanNoPreps(null);
                    } else {
                        this.giftProcessor.createOrAdd();
                    }
                }
            } else if (cmdAction.getData() instanceof RecordSetIFace) {
                RecordSetIFace rs2 = (RecordSetIFace)cmdAction.getData();
                if (rs2.getDbTableId() == colObjTableId || rs2.getDbTableId() == infoRequestTableId) {
                    if (isOKToAdd) {
                        if (isNewLoan) {
                            this.loanProcessor.createOrAdd(rs2);
                        } else {
                            this.giftProcessor.createOrAdd(rs2);
                        }
                    }
                } else {
                    log.error((Object)"Dropped wrong table type.");
                }
            } else if (cmdAction.getData() instanceof Viewable) {
                if (isNewLoan) {
                    this.loanProcessor.createOrAdd((Viewable)cmdAction.getData());
                } else if (isNewLoanNoPreps) {
                    this.createLoanNoPreps((Viewable)cmdAction.getData());
                } else {
                    this.giftProcessor.createOrAdd((Viewable)cmdAction.getData());
                }
            } else if (cmdAction.getData() instanceof InfoRequest) {
                if (isOKToAdd) {
                    if (isNewLoan) {
                        this.loanProcessor.createFromInfoRequest((InfoRequest)cmdAction.getData());
                    } else {
                        this.giftProcessor.createFromInfoRequest((InfoRequest)cmdAction.getData());
                    }
                }
            } else if (cmdAction.getData() instanceof CommandActionForDB && isOKToAdd) {
                CommandActionForDB cmdActionDB = (CommandActionForDB)cmdAction.getData();
                rs = RecordSetFactory.getInstance().createRecordSet("", cmdActionDB.getTableId(), RecordSet.GLOBAL);
                rs.addItem(cmdActionDB.getId());
                if (isNewLoan) {
                    this.loanProcessor.createOrAdd(rs);
                } else {
                    this.giftProcessor.createOrAdd(rs);
                }
            }
        } else if (cmdAction.isAction(ADD_TO_LOAN)) {
            this.loanProcessor.createOrAdd((Loan)cmdAction.getData());
        } else if (cmdAction.isAction(ADD_TO_GIFT)) {
            this.giftProcessor.createOrAdd((Gift)cmdAction.getData());
        } else if (cmdAction.isAction(INFO_REQ_MESSAGE)) {
            if (cmdAction.getData() == cmdAction || cmdAction.getData() instanceof Viewable) {
                this.createInfoRequest(null, cmdAction);
            } else if (cmdAction.getData() instanceof RecordSetIFace) {
                Object data = cmdAction.getData();
                if (data instanceof RecordSetIFace) {
                    rs = (RecordSetIFace)data;
                    if (rs.getDbTableId() == infoRequestTableId) {
                        this.showInfoReqForm(null, rs);
                    } else if (rs.getDbTableId() == CollectionObject.getClassTableId()) {
                        this.createInfoRequest((RecordSetIFace)data, cmdAction);
                    }
                }
            } else if (cmdAction.getData() instanceof CommandActionForDB) {
                this.showInfoReqForm((CommandActionForDB)cmdAction.getData(), null);
            }
        } else if (cmdAction.isAction("ReturnLoan")) {
            this.returnLoan();
        } else if (cmdAction.isAction(RET_LOAN)) {
            if (cmdAction.getData() instanceof RecordSetIFace) {
                this.returnLoan((RecordSetIFace)cmdAction.getData());
            } else if (cmdAction.getData() == cmdAction) {
                this.returnLoan(null);
            }
        } else if (cmdAction.isAction("Delete")) {
            if (cmdAction instanceof CommandActionForDB) {
                this.deleteInfoRequest((CommandActionForDB)cmdAction);
            }
        } else if (cmdAction.isAction(OPEN_NEW_VIEW) || cmdAction.isAction("Edit")) {
            try {
                final CommandAction cachedCmdAction = (CommandAction)cmdAction.clone();
                cmdAction.setType("Data_Entry");
                cmdAction.setProperty("OriginatingTask", this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandDispatcher.dispatch(cmdAction);
                        cmdAction.set(cachedCmdAction);
                    }
                });
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isConsumed()) {
            return;
        }
        if (cmdAction.isType("Database")) {
            this.processDatabaseCommands(cmdAction);
        } else if (cmdAction.isType("Data_Entry")) {
            if (cmdAction.isAction("SaveBeforeSetData")) {
                this.checkToPrintLoan(cmdAction);
            }
        } else if (cmdAction.isType(INTERACTIONS)) {
            this.processInteractionsCommands(cmdAction);
        } else if (cmdAction.isType("Preferences")) {
            this.prefsChanged(cmdAction);
        } else if (cmdAction.isType("Record_Set")) {
            this.processRecordSetCommands(cmdAction);
        }
    }

    public Vector<InteractionEntry> getEntries() {
        return this.entries;
    }

    @Override
    protected boolean canRequestContext() {
        return Uploader.checkUploadLock(this) == 0;
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        BasicPermisionPanel editor = new BasicPermisionPanel();
        editor.setAssociatedTableIds(new int[]{52});
        return editor;
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[2] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray[3] = blArray2;
        return blArrayArray;
    }
}

