/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.InfoRequest;
import edu.ku.brc.specify.datamodel.PreparationsProviderIFace;
import edu.ku.brc.specify.tasks.InteractionsTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.ui.ColObjInfo;
import edu.ku.brc.specify.ui.PrepInfo;
import edu.ku.brc.specify.ui.SelectPrepsDlg;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InteractionsProcessor<T extends PreparationsProviderIFace> {
    private static final Logger log = Logger.getLogger(InteractionsProcessor.class);
    private static final String LOAN_LOADR = "LoanLoader";
    protected InteractionsTask task;
    protected boolean isLoan;
    protected int tableId;
    protected Viewable viewable = null;

    public InteractionsProcessor(InteractionsTask task, boolean isLoan, int tableId) {
        this.task = task;
        this.isLoan = isLoan;
        this.tableId = tableId;
    }

    protected BaseTask.ASK_TYPE askSourceOfPreps(boolean hasInfoReqs, boolean hasColObjRS) {
        String label = hasInfoReqs && hasColObjRS ? UIRegistry.getResourceString("NEW_INTER_USE_RS_IR") : (hasInfoReqs ? UIRegistry.getResourceString("NEW_INTER_USE_IR") : UIRegistry.getResourceString("NEW_INTER_USE_RS"));
        Object[] options = new Object[]{label, UIRegistry.getResourceString("NEW_INTER_ENTER_CATNUM")};
        int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("NEW_INTER_CHOOSE_RSOPT"), UIRegistry.getResourceString("NEW_INTER_CHOOSE_RSOPT_TITLE"), 1, 3, null, options, options[0]);
        if (userChoice == 1) {
            return BaseTask.ASK_TYPE.EnterDataObjs;
        }
        if (userChoice == 0) {
            return BaseTask.ASK_TYPE.ChooseRS;
        }
        return BaseTask.ASK_TYPE.Cancel;
    }

    public void createOrAdd() {
        this.viewable = null;
        this.createOrAdd(null, null, null);
    }

    public void createOrAdd(Viewable viewableArg) {
        this.viewable = viewableArg;
        this.createOrAdd(null, null, null);
    }

    public void createOrAdd(RecordSetIFace recordSetArg) {
        this.viewable = null;
        this.createOrAdd(null, null, recordSetArg);
    }

    public void createOrAdd(T currPrepProvider) {
        this.viewable = null;
        this.createOrAdd(currPrepProvider, null, null);
    }

    public void createOrAdd(T currPrepProvider, InfoRequest infoRequest, RecordSetIFace recordSetArg) {
        RecordSetIFace recordSet = recordSetArg;
        if (infoRequest == null && recordSet == null) {
            String catNumField = "catalogNumber";
            Vector<RecordSetIFace> rsList = this.task.getInfoReqRecordSetsFromSideBar();
            RecordSetTask rsTask = (RecordSetTask)TaskMgr.getTask("Record_Set");
            List<RecordSetIFace> colObjRSList = rsTask.getRecordSets(CollectionObject.getClassTableId());
            if (rsList.size() == 0 && colObjRSList.size() == 0) {
                recordSet = this.task.askForDataObjRecordSet(CollectionObject.class, catNumField);
            } else {
                BaseTask.ASK_TYPE rv = this.askSourceOfPreps(rsList.size() > 0, colObjRSList.size() > 0);
                if (rv == BaseTask.ASK_TYPE.ChooseRS) {
                    recordSet = RecordSetTask.askForRecordSet(CollectionObject.getClassTableId(), rsList);
                } else if (rv == BaseTask.ASK_TYPE.EnterDataObjs) {
                    recordSet = this.task.askForDataObjRecordSet(CollectionObject.class, catNumField);
                } else if (rv == BaseTask.ASK_TYPE.Cancel) {
                    if (this.viewable != null) {
                        this.viewable.setNewObject(null);
                    }
                    return;
                }
            }
        }
        if (recordSet == null) {
            return;
        }
        DBTableIdMgr.getInstance().getInClause(recordSet);
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(recordSet.getDbTableId());
        DataProviderFactory.getInstance().evict(tableInfo.getClassObj());
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            if (infoRequest == null && recordSet.getDbTableId() == InfoRequest.getClassTableId()) {
                InfoRequest infoReq;
                RecordSetItemIFace item;
                if (recordSet.getNumItems() == 1 && (item = recordSet.getOnlyItem()) != null && (infoReq = session.get(InfoRequest.class, (int)item.getRecordId())) != null) {
                    this.createOrAdd(null, infoReq, infoReq.getRecordSets().iterator().next());
                }
                return;
            }
            String sqlStr = DBTableIdMgr.getInstance().getQueryForTable(recordSet);
            if (StringUtils.isNotBlank((String)sqlStr)) {
                final JStatusBar statusBar = UIRegistry.getStatusBar();
                statusBar.setIndeterminate(LOAN_LOADR, true);
                if (recordSet.getNumItems() > 2) {
                    UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getResourceString("NEW_INTER_LOADING_PREP"), 24);
                }
                PrepLoaderSQL prepLoaderSQL = new PrepLoaderSQL(this, currPrepProvider, recordSet, infoRequest, this.isLoan);
                prepLoaderSQL.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        log.debug(evt.getNewValue());
                        if ("progress".equals(evt.getPropertyName())) {
                            statusBar.setValue(InteractionsProcessor.LOAN_LOADR, (Integer)evt.getNewValue());
                        }
                    }
                });
                prepLoaderSQL.execute();
            } else {
                log.error((Object)("Query String empty for RecordSet tableId[" + recordSet.getDbTableId() + "]"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(InteractionsProcessor.class, ex);
        }
    }

    protected void prepsLoaded(Hashtable<Integer, ColObjInfo> coToPrepHash, Hashtable<Integer, String> prepTypeHash, T prepProvider, InfoRequest infoRequest) {
        if (coToPrepHash.size() == 0 || prepTypeHash.size() == 0) {
            UIRegistry.showLocalizedMsg("NEW_INTER_NO_PREPS_TITLE", "NEW_INTER_NO_PREPS", new Object[0]);
            return;
        }
        final DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(this.tableId);
        SelectPrepsDlg loanSelectPrepsDlg = new SelectPrepsDlg(coToPrepHash, prepTypeHash, ti.getTitle());
        loanSelectPrepsDlg.createUI();
        loanSelectPrepsDlg.setModal(true);
        UIHelper.centerAndShow(loanSelectPrepsDlg);
        if (loanSelectPrepsDlg.isCancelled()) {
            if (this.viewable != null) {
                this.viewable.setNewObject(null);
            }
            return;
        }
        Hashtable<Integer, Integer> prepsHash = loanSelectPrepsDlg.getPreparationCounts();
        if (prepsHash.size() > 0) {
            SwingWorker worker = new SwingWorker((PreparationsProviderIFace)prepProvider, infoRequest, prepsHash){
                private final /* synthetic */ PreparationsProviderIFace val$prepProvider;
                private final /* synthetic */ InfoRequest val$infoRequest;
                private final /* synthetic */ Hashtable val$prepsHash;
                {
                    this.val$prepProvider = preparationsProviderIFace;
                    this.val$infoRequest = infoRequest;
                    this.val$prepsHash = hashtable;
                }

                @Override
                public Object construct() {
                    JStatusBar statusBar = UIRegistry.getStatusBar();
                    statusBar.setIndeterminate("INTERACTIONS", true);
                    statusBar.setText(UIRegistry.getLocalizedMessage("CREATING_INTERACTION", ti.getTitle()));
                    if (InteractionsProcessor.this.isLoan) {
                        InteractionsProcessor.this.task.addPrepsToLoan(this.val$prepProvider, this.val$infoRequest, this.val$prepsHash, InteractionsProcessor.this.viewable);
                    } else {
                        InteractionsProcessor.this.task.addPrepsToGift(this.val$prepProvider, this.val$infoRequest, this.val$prepsHash, InteractionsProcessor.this.viewable);
                    }
                    return null;
                }

                @Override
                public void finished() {
                    JStatusBar statusBar = UIRegistry.getStatusBar();
                    statusBar.setProgressDone("INTERACTIONS");
                    statusBar.setText("");
                }
            };
            worker.start();
        }
    }

    public void createFromInfoRequest(InfoRequest infoRequest) {
        RecordSetIFace rs;
        block9: {
            rs = null;
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    session.attach(infoRequest);
                    rs = infoRequest.getRecordSets().iterator().next();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(InteractionsProcessor.class, ex);
                    if (session != null) {
                        session.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        if (rs != null) {
            this.createOrAdd(null, infoRequest, rs);
        }
    }

    class PrepLoaderSQL
    extends javax.swing.SwingWorker<Integer, Integer> {
        private final String PROGRESS = "progress";
        private RecordSetIFace recordSet;
        private T prepsProvider;
        private InfoRequest infoRequest;
        private boolean isForLoan;
        private Hashtable<Integer, String> prepTypeHash = new Hashtable();
        private Hashtable<Integer, ColObjInfo> coToPrepHash = new Hashtable();
        final /* synthetic */ InteractionsProcessor this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public PrepLoaderSQL(T prepsProvider, RecordSetIFace recordSet, InfoRequest infoRequest, boolean isForLoan) {
            this.this$0 = (InteractionsProcessor)n;
            this.recordSet = recordSet;
            this.prepsProvider = prepsProvider;
            this.infoRequest = infoRequest;
            this.isForLoan = isForLoan;
        }

        private Integer getInt(Object val) {
            return val == null ? 0 : (Integer)val;
        }

        protected Vector<Object[]> getColObjsFromRecordSet() {
            String sql = "SELECT co.CollectionObjectID, co.CatalogNumber, tx.FullName FROM determination as dt INNER JOIN collectionobject as co ON dt.CollectionObjectID = co.CollectionObjectID INNER JOIN taxon as tx ON dt.TaxonID = tx.TaxonID WHERE isCurrent <> 0 AND dt.CollectionMemberID = COLMEMID AND co.CollectionObjectID " + DBTableIdMgr.getInstance().getInClause(this.recordSet);
            sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
            log.debug((Object)sql);
            Vector<Object[]> fullItems = BasicSQLUtils.query(sql);
            if (fullItems.size() != this.recordSet.getNumItems()) {
                sql = "SELECT CollectionObjectID, CatalogNumber FROM collectionobject WHERE CollectionMemberID = COLMEMID AND CollectionObjectID " + DBTableIdMgr.getInstance().getInClause(this.recordSet);
                Vector<Object[]> partialItems = BasicSQLUtils.query(QueryAdjusterForDomain.getInstance().adjustSQL(sql));
                partialItems.addAll(fullItems);
                return partialItems;
            }
            return fullItems;
        }

        protected int collectForLoan() {
            int total = 0;
            int count = 0;
            try {
                Vector<Object[]> coIdRows = this.getColObjsFromRecordSet();
                total = coIdRows.size() * 2;
                if (coIdRows.size() != 0) {
                    UIRegistry.getStatusBar().setProgressRange(InteractionsProcessor.LOAN_LOADR, 0, Math.min(count, total));
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT co.CollectionObjectID, p.PreparationID, gp.Quantity FROM preparation AS p INNER JOIN collectionobject AS co ON p.CollectionObjectID = co.CollectionObjectID INNER JOIN giftpreparation AS gp ON p.PreparationID = gp.PreparationID WHERE co.CollectionMemberID = COLMEMID AND co.CollectionObjectID in (");
                    for (Object[] row : coIdRows) {
                        if (++count % 10 == 0) {
                            this.firePropertyChange("progress", 0, count);
                        }
                        Integer coId = (Integer)row[0];
                        sb.append(coId);
                        sb.append(',');
                        if (row[1] == null) continue;
                        this.coToPrepHash.put(coId, new ColObjInfo(coId, row[1].toString(), row.length == 3 ? row[2].toString() : null));
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(')');
                    Hashtable<Integer, Integer> prepIdToGiftQnt = new Hashtable<Integer, Integer>();
                    String sql = QueryAdjusterForDomain.getInstance().adjustSQL(sb.toString());
                    log.debug((Object)sql);
                    Vector<Object[]> rows = BasicSQLUtils.query(sql);
                    if (rows.size() > 0) {
                        for (Object[] row : rows) {
                            prepIdToGiftQnt.put((Integer)row[1], (Integer)row[2]);
                        }
                    }
                    sb = new StringBuilder();
                    sb.append("SELECT p.PreparationID, p.CountAmt, lp.Quantity, lp.QuantityResolved, co.CollectionObjectID, pt.PrepTypeID, pt.Name FROM preparation AS p INNER JOIN collectionobject AS co ON p.CollectionObjectID = co.CollectionObjectID INNER JOIN preptype AS pt ON p.PrepTypeID = pt.PrepTypeID LEFT OUTER JOIN loanpreparation AS lp ON p.PreparationID = lp.PreparationID WHERE pt.IsLoanable <> 0 AND co.CollectionObjectID in (");
                    for (Object[] row : coIdRows) {
                        sb.append(row[0]);
                        sb.append(',');
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(") ORDER BY co.CatalogNumber ASC");
                    sql = QueryAdjusterForDomain.getInstance().adjustSQL(sb.toString());
                    log.debug((Object)sql);
                    rows = BasicSQLUtils.query(sql);
                    if (rows.size() > 0) {
                        for (Object[] row : rows) {
                            if (++count % 10 == 0) {
                                this.firePropertyChange("progress", 0, Math.min(count, total));
                            }
                            int prepId = this.getInt(row[0]);
                            int pQty = this.getInt(row[1]);
                            int qty = this.getInt(row[2]);
                            int qtyRes = this.getInt(row[3]);
                            int coId = this.getInt(row[4]);
                            this.prepTypeHash.put((Integer)row[5], row[6].toString());
                            pQty -= this.getInt(prepIdToGiftQnt.get(prepId)).intValue();
                            ColObjInfo colObjInfo = this.coToPrepHash.get(coId);
                            if (colObjInfo == null) continue;
                            PrepInfo prepInfo = colObjInfo.get(prepId);
                            if (prepInfo != null) {
                                prepInfo.add(qty, qtyRes);
                                continue;
                            }
                            colObjInfo.add(new PrepInfo(prepId, (Integer)row[5], pQty, qty, qtyRes));
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(InteractionsProcessor.class, ex);
            }
            this.firePropertyChange("progress", 0, total);
            UIRegistry.getStatusBar().setIndeterminate(InteractionsProcessor.LOAN_LOADR, true);
            return 0;
        }

        protected int collectForGift() {
            int total = 0;
            int count = 0;
            try {
                Vector<Object[]> coIdRows = this.getColObjsFromRecordSet();
                if (coIdRows.size() != 0) {
                    UIRegistry.getStatusBar().setProgressRange(InteractionsProcessor.LOAN_LOADR, 0, total);
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT p.PreparationID, lp.Quantity, lp.QuantityResolved FROM preparation AS p INNER JOIN collectionobject AS co ON p.CollectionObjectID = co.CollectionObjectID INNER JOIN loanpreparation AS lp ON p.PreparationID = lp.PreparationID WHERE co.CollectionMemberID = COLMEMID AND co.CollectionObjectID in (");
                    for (Object[] row : coIdRows) {
                        if (++count % 10 == 0) {
                            this.firePropertyChange("progress", 0, Math.min(count, total));
                        }
                        Integer coId = (Integer)row[0];
                        sb.append(coId);
                        sb.append(',');
                        if (row[1] == null) continue;
                        this.coToPrepHash.put(coId, new ColObjInfo(coId, row[1].toString(), row.length == 3 ? row[2].toString() : null));
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(')');
                    Hashtable<Integer, Integer> prepIdToLoanQnt = new Hashtable<Integer, Integer>();
                    String sql = QueryAdjusterForDomain.getInstance().adjustSQL(sb.toString());
                    log.debug((Object)sql);
                    Vector<Object[]> rows = BasicSQLUtils.query(sql);
                    if (rows.size() > 0) {
                        for (Object[] row : rows) {
                            int qty = this.getInt(row[1]);
                            int qtyRes = this.getInt(row[2]);
                            prepIdToLoanQnt.put((Integer)row[0], qty - qtyRes);
                        }
                    }
                    sb = new StringBuilder();
                    sb.append("SELECT p.PreparationID, p.CountAmt, gp.Quantity, co.CollectionObjectID, pt.PrepTypeID, pt.Name FROM preparation AS p INNER JOIN collectionobject AS co ON p.CollectionObjectID = co.CollectionObjectID INNER JOIN preptype AS pt ON p.PrepTypeID = pt.PrepTypeID LEFT OUTER JOIN giftpreparation AS gp ON p.PreparationID = gp.PreparationID WHERE pt.IsLoanable <> 0 AND co.CollectionObjectID in (");
                    for (Object[] row : coIdRows) {
                        sb.append(row[0]);
                        sb.append(',');
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(") ORDER BY co.CatalogNumber ASC");
                    sql = QueryAdjusterForDomain.getInstance().adjustSQL(sb.toString());
                    log.debug((Object)sql);
                    rows = BasicSQLUtils.query(sql);
                    if (rows.size() > 0) {
                        for (Object[] row : rows) {
                            int prepId = this.getInt(row[0]);
                            if (++count % 10 == 0) {
                                this.firePropertyChange("progress", 0, Math.min(count, total));
                            }
                            int pQty = this.getInt(row[1]);
                            int qty = this.getInt(row[2]);
                            int coId = this.getInt(row[3]);
                            this.prepTypeHash.put((Integer)row[4], row[5].toString());
                            pQty -= this.getInt(prepIdToLoanQnt.get(prepId)).intValue();
                            ColObjInfo colObjInfo = this.coToPrepHash.get(coId);
                            if (colObjInfo == null) continue;
                            PrepInfo prepInfo = colObjInfo.get(prepId);
                            if (prepInfo != null) {
                                prepInfo.add(qty, qty);
                                continue;
                            }
                            colObjInfo.add(new PrepInfo(prepId, (Integer)row[4], pQty, qty, 0));
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(InteractionsProcessor.class, ex);
            }
            this.firePropertyChange("progress", 0, total);
            UIRegistry.getStatusBar().setIndeterminate(InteractionsProcessor.LOAN_LOADR, true);
            return 0;
        }

        @Override
        protected Integer doInBackground() throws Exception {
            this.coToPrepHash = new Hashtable();
            return this.isForLoan ? this.collectForLoan() : this.collectForGift();
        }

        @Override
        protected void done() {
            super.done();
            UIRegistry.getStatusBar().setProgressDone(InteractionsProcessor.LOAN_LOADR);
            if (this.recordSet != null && this.recordSet.getNumItems() > 2) {
                UIRegistry.clearSimpleGlassPaneMsg();
            }
            this.this$0.prepsLoaded(this.coToPrepHash, this.prepTypeHash, this.prepsProvider, this.infoRequest);
        }
    }
}

