/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxAction;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.tasks.subpane.DroppableTaskPane;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.CommandActionForDB;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.TableModel2Excel;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.EMailHelper;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.InfoRequest;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.InteractionsTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InfoRequestTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(InfoRequestTask.class);
    public static final String INFOREQUEST = "InfoRequest";
    public static final DataFlavor INFOREQUEST_FLAVOR = new DataFlavor(RecordSetTask.class, "InfoRequest");
    public static final String INFO_REQ_MESSAGE = "Specify Info Request";
    public static final String CREATE_MAILMSG = "CreateMailMsg";
    protected static final String infoReqIconName = "inforequest";
    protected static DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    protected NavBox navBox = null;

    public InfoRequestTask() {
        super(INFOREQUEST, UIRegistry.getResourceString(INFOREQUEST));
        CommandDispatcher.register(INFOREQUEST, this);
        CommandDispatcher.register("Database", this);
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    this.navBox = new NavBox(this.title);
                    List<InfoRequest> infoRequests = session.getDataList(InfoRequest.class);
                    Iterator<InfoRequest> iter = infoRequests.iterator();
                    while (iter.hasNext()) {
                        this.addInfoRequest(iter.next());
                    }
                    this.navBoxes.add(this.navBox);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(InfoRequestTask.class, ex);
                    log.error((Object)ex);
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    protected void addInfoRequest(InfoRequest infoRequest) {
        UsageTracker.incrUsageCount("IA.IR.ADD");
        NavBoxItemIFace nbi = InfoRequestTask.makeDnDNavBtn(this.navBox, infoRequest.getIdentityTitle(), infoReqIconName, null, (CommandAction)new CommandActionForDB("Data_Entry", "Edit", InfoRequest.getClassTableId(), infoRequest.getId()), new CommandAction(INFOREQUEST, "Delete", infoRequest), true, true);
        this.setUpDraggable(nbi, new DataFlavor[]{Trash.TRASH_FLAVOR, InteractionsTask.LOAN_FLAVOR}, new NavBoxAction("Data_Entry", "Edit"));
        this.navBox.validate();
        this.navBox.repaint();
        NavBox.refresh(this.navBox);
    }

    protected void addDraggableDataFlavors(NavBoxButton roc) {
        roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        roc.addDragDataFlavor(DroppableTaskPane.DROPPABLE_PANE_FLAVOR);
    }

    public void saveInfoRequest(InfoRequest infoRequest) {
        this.addInfoRequest(infoRequest);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        infoRequest.setTimestampCreated(now);
        if (DataModelObjBase.save(true, new Object[]{infoRequest})) {
            NavBoxMgr.getInstance().addBox(this.navBox);
            this.navBox.invalidate();
            this.navBox.doLayout();
            this.navBox.repaint();
        }
    }

    protected NavBoxItemIFace getBoxByName(String boxName) {
        for (NavBoxItemIFace nbi : this.navBox.getItems()) {
            if (!((NavBoxButton)nbi).getLabelText().equals(boxName)) continue;
            return nbi;
        }
        return null;
    }

    public static void createInfoRequest(RecordSetIFace recordSet) {
    }

    protected void deleteInfoRequestFromUI(NavBoxItemIFace boxItem, InfoRequest infoRequest) {
        JComponent comp;
        JComponent jComponent = comp = boxItem != null ? boxItem.getUIComponent() : this.getBoxByName(infoRequest.getIdentityTitle()).getUIComponent();
        if (comp != null) {
            this.navBox.remove(comp);
            this.navBox.invalidate();
            this.navBox.setSize(this.navBox.getPreferredSize());
            this.navBox.doLayout();
            this.navBox.repaint();
            NavBoxMgr.getInstance().invalidate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
            UIRegistry.forceTopFrameRepaint();
        }
    }

    public static String getCommentValueAsStr(String commentId, String content) {
        int inx = content.indexOf(commentId);
        if (inx > -1) {
            int eInx = content.substring(inx += commentId.length() + 1).indexOf(" -->") + inx;
            return content.substring(inx, eInx);
        }
        return null;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.recentFormPane = new FormPane(this.name, (Taskable)this, "");
        this.starterPane = this.recentFormPane;
        return this.recentFormPane;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    public boolean isEMailPrefsOK(Hashtable<String, String> emailPrefs) {
        String[] emailPrefNames;
        AppPreferences appPrefs = AppPreferences.getRemote();
        boolean allOK = true;
        String[] stringArray = emailPrefNames = new String[]{"smtp", "username", "password", "email", "port", "security"};
        int n = emailPrefNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pName = stringArray[n2];
            String value = appPrefs.get("settings.email." + pName, null);
            if (!StringUtils.isNotEmpty((String)value)) {
                allOK = false;
                break;
            }
            emailPrefs.put(pName, value);
            ++n2;
        }
        return allOK;
    }

    public void createAndSendEMail() {
        FormViewObj formViewObj = this.getCurrentFormViewObj();
        if (formViewObj != null) {
            Viewable viewable;
            InfoRequest infoRequest = (InfoRequest)formViewObj.getDataObj();
            Agent toAgent = infoRequest.getAgent();
            boolean sendEMailTmp = true;
            Component comp = formViewObj.getControlByName("sendEMail");
            if (comp instanceof JCheckBox) {
                sendEMailTmp = ((JCheckBox)comp).isSelected();
            }
            boolean sendEMail = sendEMailTmp;
            MultiView mv = formViewObj.getSubView("InfoRequestColObj");
            if (mv != null && sendEMail && (viewable = mv.getCurrentView()) instanceof TableViewObj) {
                Hashtable<String, String> emailPrefs = new Hashtable<String, String>();
                if (!this.isEMailPrefsOK(emailPrefs)) {
                    JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("NO_EMAIL_PREF_INFO"), UIRegistry.getResourceString("NO_EMAIL_PREF_INFO_TITLE"), 2);
                    return;
                }
                File tempExcelFileName = TableModel2Excel.getTempExcelName();
                AppPreferences appPrefs = AppPreferences.getLocalPrefs();
                Hashtable<String, String> values = new Hashtable<String, String>();
                values.put("to", toAgent.getEmail() != null ? toAgent.getEmail() : "");
                values.put("from", appPrefs.get("settings.email.email", ""));
                values.put("subject", String.format(UIRegistry.getResourceString("INFO_REQUEST_SUBJECT"), infoRequest.getIdentityTitle()));
                values.put("bodytext", "");
                values.put("attachedFileName", tempExcelFileName.getName());
                ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "SystemSetup", "SendMail", null, UIRegistry.getResourceString("SEND_MAIL_TITLE"), UIRegistry.getResourceString("SEND_BTN"), null, null, true, 0);
                dlg.setData(values);
                dlg.setModal(true);
                dlg.setVisible(true);
                if (dlg.getBtnPressed() == 1) {
                    EMailHelper.ErrorType status;
                    dlg.getMultiView().getDataFromUI();
                    TableViewObj tblViewObj = (TableViewObj)viewable;
                    File excelFile = TableModel2Excel.convertToExcel(tempExcelFileName, UIRegistry.getResourceString("CollectionObject"), tblViewObj.getTable().getModel());
                    StringBuilder sb = TableModel2Excel.convertToHTML(UIRegistry.getResourceString("CollectionObject"), tblViewObj.getTable().getModel());
                    String text = String.valueOf(((String)values.get("bodytext")).replace("\n", "<br>")) + "<BR><BR>" + sb.toString();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.displayLocalizedStatusBarText("SENDING_EMAIL", new Object[0]);
                        }
                    });
                    if (sendEMail && (status = EMailHelper.sendMsg(emailPrefs.get("servername"), emailPrefs.get("username"), Encryption.decrypt(emailPrefs.get("password")), emailPrefs.get("email"), (String)values.get("to"), (String)values.get("subject"), text, "text/html", emailPrefs.get("port"), emailPrefs.get("security"), excelFile)) != EMailHelper.ErrorType.Cancel) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.displayLocalizedStatusBarText(status == EMailHelper.ErrorType.Error ? "EMAIL_SENT_ERROR" : "EMAIL_SENT_OK", new Object[0]);
                            }
                        });
                    }
                }
            }
        } else {
            log.error((Object)"Why doesn't the current SubPane have a main FormViewObj?");
        }
    }

    protected void processInfoRequestCommands(CommandAction cmdAction) {
        Object data;
        UsageTracker.incrUsageCount("IR." + cmdAction.getType());
        if (cmdAction.isAction(CREATE_MAILMSG)) {
            this.createAndSendEMail();
        } else if (cmdAction.isAction("Save")) {
            Object data2 = cmdAction.getData();
            if (data2 instanceof RecordSetIFace) {
                InfoRequest infoRequest = new InfoRequest();
                this.saveInfoRequest(infoRequest);
            }
        } else if (cmdAction.isAction("Delete") && cmdAction.getData() instanceof RecordSetIFace) {
            InfoRequest inforRequest = (InfoRequest)cmdAction.getData();
            if (DataModelObjBase.delete(true, new Object[]{inforRequest})) {
                this.deleteInfoRequestFromUI(null, inforRequest);
            }
        } else if (cmdAction.isAction("Create") && cmdAction.getData() instanceof RecordSetIFace && (data = cmdAction.getData()) instanceof RecordSetIFace) {
            InfoRequestTask.createInfoRequest((RecordSetIFace)data);
        }
    }

    protected void processDatabaseCommands(CommandAction cmdAction) {
        if (cmdAction.getData() instanceof InfoRequest && cmdAction.isAction("Insert")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType("Database")) {
            this.processDatabaseCommands(cmdAction);
        } else if (cmdAction.isType(INFOREQUEST)) {
            this.processInfoRequestCommands(cmdAction);
        }
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArrayArray[2] = blArray;
        blArrayArray[3] = new boolean[4];
        return blArrayArray;
    }

    @Override
    public boolean isPermissionsSettable() {
        return false;
    }
}

