/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.busrules.GeographyBusRules;
import edu.ku.brc.specify.tasks.BaseTreeTask;
import edu.ku.brc.specify.ui.treetables.TreeNodePopupMenu;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import javax.persistence.Transient;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class GeographyTreeTask
extends BaseTreeTask<Geography, GeographyTreeDef, GeographyTreeDefItem>
implements SQLExecutionListener {
    public static final String GEOGRAPHY = "GeographyTree";

    public GeographyTreeTask() {
        super(GEOGRAPHY, UIRegistry.getResourceString(GEOGRAPHY));
        this.treeClass = Geography.class;
        this.treeDefClass = GeographyTreeDef.class;
        this.commandTypeString = GEOGRAPHY;
        this.businessRules = new GeographyBusRules();
        this.initialize();
    }

    @Override
    @Transient
    protected GeographyTreeDef getCurrentTreeDef() {
        return (GeographyTreeDef)((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(Geography.class);
    }

    protected void showCollectionObjects(TreeTableViewer<Geography, GeographyTreeDef, GeographyTreeDefItem> ttv, JList list) {
        Geography geography = ttv.getSelectedNode(list);
        ttv.initializeNodeAssociations(geography);
        String sql = "SELECT collectionobject.CollectionObjectID FROM geography INNER JOIN locality ON geography.GeographyID = locality.GeographyID INNER JOIN collectingevent ON locality.LocalityID = collectingevent.LocalityID INNER JOIN collectionobject ON collectingevent.CollectingEventID = collectionobject.CollectingEventID WHERE CollectionMemberID = COLMEMID AND geography.GeographyID = " + geography.getId();
        sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
        SQLExecutionProcessor sqlProc = new SQLExecutionProcessor(this, sql);
        sqlProc.start();
    }

    @Override
    protected TreeTableViewer<Geography, GeographyTreeDef, GeographyTreeDefItem> createTreeViewer(String titleArg, boolean isEditMode) {
        final TreeTableViewer<Geography, GeographyTreeDef, GeographyTreeDefItem> ttv = super.createTreeViewer(titleArg, isEditMode);
        if (ttv != null) {
            final TreeNodePopupMenu popup = ttv.getPopupMenu();
            JMenuItem coMenuItem = new JMenuItem(UIRegistry.getResourceString("TTV_ASSOC_COS"));
            coMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeographyTreeTask.this.showCollectionObjects(ttv, popup.getList());
                }
            });
            popup.add(coMenuItem, true);
        }
        return ttv;
    }

    @Override
    public void exectionDone(SQLExecutionProcessor process, ResultSet resultSet) {
        RecordSet recordSet = new RecordSet();
        recordSet.initialize();
        recordSet.set("TTV", CollectionObject.getClassTableId(), RecordSet.GLOBAL);
        try {
            while (resultSet.next()) {
                recordSet.addItem(resultSet.getInt(1));
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(GeographyTreeTask.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
        final RecordSet rs = recordSet;
        if (rs.getRecordSetItems().size() > 0) {
            UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("TTV_OPENING_CO_FORM"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommandDispatcher.dispatch(new CommandAction("Data_Entry", "Edit", rs));
                }
            });
        } else {
            UIRegistry.displayInfoMsgDlgLocalized("TTV_GEO_NO_COS_FOR_NODE", new Object[0]);
            UIRegistry.getStatusBar().setLocalizedText("TTV_GEO_NO_COS_FOR_NODE", new Object[0]);
        }
    }

    @Override
    public void executionError(SQLExecutionProcessor process, Exception ex) {
    }
}

