/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.specify.permission.BasicSpPermission;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.ViewLoader;
import edu.ku.brc.specify.extras.ViewToSchemaReview;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.PermissionOptionPersist;
import edu.ku.brc.specify.tasks.StartUpTask;
import edu.ku.brc.specify.tools.FormDisplayer;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class FormEditTask
extends BaseTask {
    public static final String FORMS = "FORMS";

    public FormEditTask() {
        super(FORMS, "Forms");
        this.iconName = "Form";
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
        }
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        JMenu formMenu;
        super.doProcessAppCommands(cmdAction);
        if ((cmdAction.isAction("AppRestart") || cmdAction.isAction("StartUp")) && (formMenu = (JMenu)UIRegistry.get("Specify.FORM_MENU")) != null) {
            boolean isOKToEdit = SecurityMgr.getInstance().checkPermission("Task.FORMS", BasicSpPermission.view);
            formMenu.setEnabled(isOKToEdit);
        }
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        String FORM_SECURITY = "Task.FORMS";
        String FORM_MENU = "Specify.FORMS_MENU";
        String SYSTEM_MENU = "Specify.SYSTEM_MENU";
        String FULL_SYSTEM_MENU = "Specify.SYSTEM_MENU/Specify.FORMS_MENU";
        SecurityMgr secMgr = SecurityMgr.getInstance();
        this.menuItems = new Vector();
        String securityName = this.buildTaskPermissionName("Task.FORMS");
        if (!AppContextMgr.isSecurityOn() || secMgr.getPermission(securityName) != null && !secMgr.getPermission(securityName).hasNoPerm()) {
            String reloadViews = "reload_views";
            JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem(UIRegistry.getResourceString("Specify.RELOAD_VIEWS"));
            cbMenuItem.setSelected(AppPreferences.getLocalPrefs().getBoolean("reload_views", false));
            cbMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean isReload = AppPreferences.getLocalPrefs().getBoolean("reload_views", false) == false;
                    AppPreferences.getLocalPrefs().putBoolean("reload_views", isReload);
                    ((JMenuItem)ae.getSource()).setSelected(isReload);
                    ((JMenuItem)ae.getSource()).setSelected(isReload);
                }
            });
            MenuItemDesc mid = new MenuItemDesc(cbMenuItem, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            this.menuItems.add(mid);
            String verifyFields = "verify_field_names";
            cbMenuItem = new JCheckBoxMenuItem(UIRegistry.getResourceString("Specify.VERIFY_FIELDS"));
            cbMenuItem.setSelected(AppPreferences.getLocalPrefs().getBoolean("verify_field_names", false));
            cbMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean isVerify = AppPreferences.getLocalPrefs().getBoolean("verify_field_names", false) == false;
                    AppPreferences.getLocalPrefs().putBoolean("verify_field_names", isVerify);
                    ((JMenuItem)ae.getSource()).setSelected(isVerify);
                    ViewLoader.setDoFieldVerification(isVerify);
                }
            });
            mid = new MenuItemDesc(cbMenuItem, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            this.menuItems.add(mid);
            cbMenuItem = new JCheckBoxMenuItem(UIRegistry.getResourceString("Specify.SHOW_FORM_DEBUG"));
            cbMenuItem.setSelected(FormViewObj.isUseDebugForm());
            cbMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean useDebugForm = !FormViewObj.isUseDebugForm();
                    FormViewObj.setUseDebugForm(useDebugForm);
                    ((JMenuItem)ae.getSource()).setSelected(useDebugForm);
                }
            });
            mid = new MenuItemDesc(cbMenuItem, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            mid.setSepPosition(MenuItemDesc.Position.After);
            this.menuItems.add(mid);
            String ttle = "Specify.CREATE_FORM_IMAGES";
            String mneu = "Specify.CREATE_FORM_IMAGES_MNEU";
            String desc = "Specify.CREATE_FORM_IMAGES";
            JMenuItem mi = UIHelper.createLocalizedMenuItem(ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    FormDisplayer fd = new FormDisplayer();
                    fd.generateFormImages();
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            this.menuItems.add(mid);
            ttle = "Specify.CREATE_FORM_LIST";
            mneu = "Specify.CREATE_FORM_LIST_MNEU";
            desc = "Specify.CREATE_FORM_LIST";
            mi = UIHelper.createLocalizedMenuItem(ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    FormDisplayer fd = new FormDisplayer();
                    fd.createViewListing(UIRegistry.getUserHomeDir(), true);
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            this.menuItems.add(mid);
            ttle = "Specify.FORM_FIELD_LIST";
            mneu = "Specify.FORM_FIELD_LIST_MNEU";
            desc = "Specify.FORM_FIELD_LIST";
            mi = UIHelper.createLocalizedMenuItem(ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ViewToSchemaReview.dumpFormFieldList(true);
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            this.menuItems.add(mid);
            ttle = "Specify.VIEW_REVIEW_LIST";
            mneu = "Specify.VIEW_REVIEW_LIST_MNEU";
            desc = "Specify.VIEW_REVIEW_LIST";
            mi = UIHelper.createLocalizedMenuItem(ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    new ViewToSchemaReview().checkSchemaAndViews();
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            this.menuItems.add(mid);
            ttle = "Specify.FORM_DEV";
            mneu = "Specify.FORM_DEV_MNEU";
            desc = "Specify.FORM_DEV_DESC";
            final JCheckBoxMenuItem miCbx = UIHelper.createLocalizedCheckBoxMenuItem(ttle, mneu, desc, true, null);
            miCbx.setSelected(FormDevHelper.isFormDevMode());
            miCbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    FormDevHelper.setIsFormDevMode(miCbx.isSelected());
                }
            });
            mid = new MenuItemDesc(miCbx, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            mid.setSepPosition(MenuItemDesc.Position.Before);
            this.menuItems.add(mid);
            ttle = "Specify.SHOW_DEV_WIN";
            mneu = "Specify.SHOW_DEV_WIN_MNEU";
            desc = "Specify.SHOW_DEV_WIN";
            mi = UIHelper.createLocalizedMenuItem(ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    FormDevHelper.getLogFrame().setVisible(true);
                }
            });
            mid = new MenuItemDesc(mi, "Specify.SYSTEM_MENU/Specify.FORMS_MENU");
            this.menuItems.add(mid);
        }
        return this.menuItems;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = StartUpTask.createFullImageSplashPanel(this.title, this);
        return this.starterPane;
    }

    @Override
    protected Hashtable<String, PermissionOptionPersist> getAndSetDefPerms() {
        return super.getAndSetDefPerms();
    }

    @Override
    public PermissionIFace getDefaultPermissions(String userType) {
        return super.getDefaultPermissions(userType);
    }

    @Override
    protected boolean[][] getPermsArray() {
        return new boolean[][]{{true, true, true, true}, new boolean[4], new boolean[4], new boolean[4]};
    }
}

