/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.ERTIJoinColInfo;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigDlg;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.core.expresssearch.QueryForIdResultsHQL;
import edu.ku.brc.af.core.expresssearch.QueryForIdResultsSQL;
import edu.ku.brc.af.core.expresssearch.SearchConfig;
import edu.ku.brc.af.core.expresssearch.SearchConfigService;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.SearchBox;
import edu.ku.brc.af.ui.SearchTermField;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.JPAQuery;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.subpane.ESResultsSubPane;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressTableResultsFromQuery;
import edu.ku.brc.specify.tasks.subpane.SIQueryForIdResults;
import edu.ku.brc.specify.tasks.subpane.qb.QBQueryForIdResultsHQL;
import edu.ku.brc.specify.tasks.subpane.qb.QBResultsSubPane;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconEntry;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExpressSearchTask
extends BaseTask
implements CommandListener,
SQLExecutionListener,
CustomQueryListener {
    private static final Logger log = Logger.getLogger(ExpressSearchTask.class);
    public static final String GLOBAL_SEARCH_AVAIL = "GLOBAL_SEARCH_AVAIL";
    public static final String GLOBAL_SEARCH = "GLOBAL_SEARCH";
    public static final int RESULTS_THRESHOLD = 20000;
    public static final String EXPRESSSEARCH = "Express_Search";
    public static final String CHECK_INDEXER_PATH = "CheckIndexerPath";
    protected Color selectionFG = UIManager.getColor("TextField.selectionForeground");
    protected Color selectionBG = UIManager.getColor("TextField.selectionBackground");
    protected static ExpressSearchTask instance = null;
    protected static final String LAST_SEARCH = "lastsearch";
    protected SearchBox searchBox;
    protected JAutoCompTextField searchText;
    protected JButton searchBtn;
    protected JCheckBoxMenuItem globalSearchCheckBoxMI;
    protected Color textBGColor = null;
    protected Color badSearchColor = new Color(255, 235, 235);
    protected Vector<ESResultsSubPane> paneCache = new Vector();
    protected Vector<SQLExecutionProcessor> sqlProcessorList = new Vector();
    protected boolean sqlHasResults = false;
    protected Vector<CustomQueryIFace> queryList = new Vector();
    protected int queryCount = 0;
    protected int queryCountDone = 0;
    protected ESResultsSubPane queryResultsPane = null;
    protected SIQueryForIdResults searchWarningsResults = null;
    protected JStatusBar statusBar = null;
    protected boolean doingDebug = false;

    public ExpressSearchTask() {
        super(EXPRESSSEARCH, UIRegistry.getResourceString(EXPRESSSEARCH));
        this.iconName = "Search";
        this.closeOnLastPane = true;
        CommandDispatcher.register(EXPRESSSEARCH, this);
        instance = this;
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            this.statusBar = UIRegistry.getStatusBar();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.searchBox != null) {
            this.searchBox.setEnabled(enabled);
        }
    }

    public static boolean isStarted() {
        return instance != null;
    }

    public void appContextHasChanged() {
        if (this.searchText != null) {
            this.searchText.setPickListAdapter(PickListDBAdapterFactory.getInstance().create("ExpressSearch", true));
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            this.searchText.setText(localPrefs.get(this.getLastSearchKey(), ""));
        }
        if (this.searchBtn != null) {
            this.searchBtn.setEnabled(true);
            this.searchText.setEnabled(true);
        }
        if (this.textBGColor != null) {
            this.searchText.setBackground(this.textBGColor);
            this.searchText.setForeground(UIManager.getColor("TextField.foreground"));
        }
        SearchConfigService.getInstance().reset();
        if (this.searchBox != null && this.searchBox.getMenuCreator() != null) {
            this.searchBox.getMenuCreator().reset();
        }
    }

    protected String getLastSearchKey() {
        Discipline discp = AppContextMgr.getInstance().getClassObject(Discipline.class);
        String disciplineName = discp != null ? "_" + discp.getType() : "";
        return LAST_SEARCH + disciplineName;
    }

    protected void doQuery() {
        this.sqlHasResults = false;
        this.searchText.setBackground(this.textBGColor);
        this.searchText.setForeground(UIManager.getColor("TextField.foreground"));
        String searchTerm = this.searchText.getText();
        if (StringUtils.isNotEmpty((String)searchTerm)) {
            if (searchTerm.length() == 2 && (searchTerm.endsWith("*") || searchTerm.startsWith("*"))) {
                UIRegistry.showLocalizedError("ExpressSearchTask.NO_SINGLE_CHAR");
            } else if (QueryAdjusterForDomain.getInstance().isUserInputNotInjectable(searchTerm.toLowerCase())) {
                boolean isOK = true;
                if (searchTerm.startsWith("*") && searchTerm.endsWith("*") && searchTerm.length() > 3) {
                    int inx = searchTerm.length() - 2;
                    if (searchTerm.indexOf(32, 2) > 1 && searchTerm.lastIndexOf(32) < searchTerm.length() - 2 && searchTerm.charAt(1) != '\"' && searchTerm.charAt(1) != '\'' && searchTerm.charAt(1) != '`' && searchTerm.charAt(inx) != '\"' && searchTerm.charAt(inx) != '\'' && searchTerm.charAt(inx) != '`') {
                        JLabel label = UIHelper.createI18NLabel("ExpressSearchTask.MISSING_QUOTES");
                        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
                        pb.add((Component)label, new CellConstraints().xy(1, 1));
                        pb.setDefaultDialogBorder();
                        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("HINT"), true, pb.getPanel());
                        dlg.setOkLabel(UIRegistry.getResourceString("ExpressSearchTask.SRCH_ANYWAY"));
                        dlg.setCancelLabel(UIRegistry.getResourceString("ExpressSearchTask.DNT_SRCH"));
                        dlg.setVisible(true);
                        boolean bl = isOK = !dlg.isCancelled();
                    }
                }
                if (isOK) {
                    ESResultsSubPane expressSearchPane = new ESResultsSubPane(searchTerm, this, true);
                    if (!this.doQuery(this.searchText, null, expressSearchPane)) {
                        this.setUserInputToNotFound("BAD_SEARCH_TERMS", true);
                    } else {
                        AppPreferences.getLocalPrefs().put(this.getLastSearchKey(), searchTerm);
                    }
                }
            } else {
                this.setUserInputToNotFound("ES_SUSPICIOUS_SQL", true);
            }
        }
    }

    public boolean doQuery(String searchTerm, ExpressSearchResultsPaneIFace esrp) {
        if (StringUtils.isNotEmpty((String)searchTerm) && QueryAdjusterForDomain.getInstance().isUserInputNotInjectable(searchTerm.toLowerCase())) {
            return this.doQuery(null, searchTerm, esrp);
        }
        return false;
    }

    protected synchronized JPAQuery startSearchJPA(ExpressSearchResultsPaneIFace esrPane, SearchTableConfig searchTableConfig, String searchTerm, List<SearchTermField> terms) {
        JPAQuery jpaQuery = null;
        String sqlStr = searchTableConfig.getSQL(terms, true, true);
        if (sqlStr != null) {
            jpaQuery = new JPAQuery(sqlStr, (CustomQueryListener)this);
            jpaQuery.setData(new Object[]{searchTableConfig, esrPane, searchTerm});
            this.queryList.add(jpaQuery);
            ++this.queryCount;
            if (this.statusBar != null) {
                this.statusBar.setProgressRange(EXPRESSSEARCH, 0, this.queryCount, this.queryCountDone);
            }
            if (esrPane.doQueriesSynchronously()) {
                jpaQuery.execute();
            } else {
                jpaQuery.start();
            }
        }
        return jpaQuery;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean doQuery(JTextField searchTextArg, String searchTextStr, ExpressSearchResultsPaneIFace esrPane) {
        block12: {
            block10: {
                block11: {
                    this.doingDebug = AppPreferences.getLocalPrefs().getBoolean("esdebug", false);
                    this.searchWarningsResults = null;
                    searchTerm = (searchTextArg != null ? (searchTerm = searchTextArg.getText()) : searchTextStr).toLowerCase();
                    if (!ESTermParser.getInstance().parse(searchTerm, false)) {
                        this.setUserInputToNotFound("BAD_SEARCH_TERMS", false);
                        return false;
                    }
                    if (!StringUtils.isNotEmpty((String)searchTerm)) break block10;
                    context = SearchConfigService.getInstance().getSearchContext();
                    if (context != null) break block11;
                    config = SearchConfigService.getInstance().getSearchConfig();
                    if (config.getTables().size() <= 0) ** GOTO lbl42
                    this.sqlHasResults = false;
                    if (searchTextArg != null) {
                        searchTextArg.setEnabled(false);
                    }
                    if (this.searchBtn != null) {
                        this.searchBtn.setEnabled(false);
                    }
                    this.queryList.clear();
                    this.queryCount = 0;
                    this.queryCountDone = 0;
                    cnt = 0;
                    for (SearchTableConfig table : config.getTables()) {
                        if (table.getTableInfo().isHidden()) continue;
                        if (AppContextMgr.isSecurityOn()) {
                            if (table.getTableInfo().getPermissions().canView()) {
                                if (this.startSearchJPA(esrPane, table, searchTerm, ESTermParser.getInstance().getFields()) == null) continue;
                                ++cnt;
                                continue;
                            }
                            ExpressSearchTask.log.debug((Object)("Skipping [" + table.getTableInfo().getTitle() + "]"));
                            continue;
                        }
                        if (this.startSearchJPA(esrPane, table, searchTerm, ESTermParser.getInstance().getFields()) == null) continue;
                        ++cnt;
                    }
                    if (cnt == 0) {
                        this.setUserInputToNotFound("NO_FIELDS_TO_SEARCH", true);
                        this.searchText.setEnabled(true);
                        this.searchBtn.setEnabled(true);
                        return false;
                    }
                    if (this.queryList.size() == 0) {
                        this.completionUIHelper(null);
                    } else {
                        return true;
lbl42:
                        // 1 sources

                        searchTextArg.getToolkit().beep();
                    }
                    break block12;
                }
                if (this.startSearchJPA(esrPane, context, searchTerm, ESTermParser.getInstance().getFields()) != null) {
                    return true;
                }
                this.setUserInputToNotFound("NO_FIELDS_TO_SEARCH", true);
                return true;
            }
            ExpressSearchTask.log.error((Object)"SearchTableConfig service has been loaded or is empty.");
        }
        return false;
    }

    protected void collectResults(SearchConfig config, String tableId, String searchTerm, ResultSet resultSet, Integer id, Hashtable<String, List<ExpressResultsTableInfo>> joinIdToTableInfoHash, Hashtable<String, QueryForIdResultsSQL> resultsForJoinsHash) {
        try {
            Integer recId = resultSet != null ? Integer.valueOf(resultSet.getInt(1)) : id;
            List<ExpressResultsTableInfo> list = joinIdToTableInfoHash.get(tableId);
            if (list != null) {
                for (ExpressResultsTableInfo erti : list) {
                    QueryForIdResultsSQL results;
                    if (!config.isActiveForRelatedQueryId(erti.getId()).booleanValue()) continue;
                    if (AppContextMgr.isSecurityOn()) {
                        if (!erti.getTableInfo().getPermissions().canView()) continue;
                        boolean hasUnviewableCol = false;
                        for (ERTICaptionInfo capInfo : erti.getCaptionInfo()) {
                            DBFieldInfo fldInfo = capInfo.getFieldInfo();
                            if (fldInfo != null) {
                                if (fldInfo.getTableInfo().getPermissions().canView()) continue;
                                hasUnviewableCol = true;
                                break;
                            }
                            if (capInfo.getAggClass() != null) {
                                DBTableInfo aggTblInfo = DBTableIdMgr.getInstance().getByShortClassName(capInfo.getAggClass().getSimpleName());
                                if (aggTblInfo == null || aggTblInfo.getPermissions().canAdd()) continue;
                                hasUnviewableCol = true;
                                break;
                            }
                            log.error((Object)("*********** NO FIELD: " + capInfo.getColName()));
                        }
                        if (hasUnviewableCol) continue;
                    }
                    if ((results = resultsForJoinsHash.get(erti.getId())) == null) {
                        Integer joinColTableId = null;
                        ERTIJoinColInfo[] joinCols = erti.getJoins();
                        if (joinCols != null) {
                            ERTIJoinColInfo[] eRTIJoinColInfoArray = joinCols;
                            int n = joinCols.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ERTIJoinColInfo jci = eRTIJoinColInfoArray[n2];
                                if (tableId.equals(jci.getJoinTableId())) {
                                    joinColTableId = jci.getJoinTableIdAsInt();
                                    if (!AppContextMgr.isSecurityOn() || jci.getTableInfo().getPermissions().canView()) break;
                                }
                                ++n2;
                            }
                        }
                        if (joinColTableId == null) {
                            throw new RuntimeException("Shouldn't have got here!");
                        }
                        Integer displayOrder = SearchConfigService.getInstance().getSearchConfig().getOrderForRelatedQueryId(erti.getId());
                        results = new QueryForIdResultsSQL(erti.getId(), joinColTableId, erti, displayOrder, searchTerm);
                        resultsForJoinsHash.put(erti.getId(), results);
                    }
                    if (this.doingDebug) {
                        log.debug((Object)("*** Adding recId[" + recId + "] to erti[" + erti.getId() + "] "));
                    }
                    results.add(recId);
                }
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(ExpressSearchTask.class, ex);
            ex.printStackTrace();
        }
    }

    protected void displayResults(ExpressSearchResultsPaneIFace esrPane, QueryForIdResultsIFace queryResults, Hashtable<String, QueryForIdResultsSQL> resultsForJoinsMap) {
        if (queryResults.size() > 0) {
            esrPane.addSearchResults(queryResults);
        }
        if (resultsForJoinsMap != null) {
            for (QueryForIdResultsSQL rs : resultsForJoinsMap.values()) {
                if (rs.getRecIds().size() <= 0) continue;
                esrPane.addSearchResults(rs);
            }
            resultsForJoinsMap.clear();
        }
    }

    public void displayRecordSet(RecordSetIFace recordSet, boolean isEditable) {
        if (recordSet.getNumItems() > 0) {
            SearchConfig config = SearchConfigService.getInstance().getSearchConfig();
            SearchTableConfig searchTableConfig = config.getSearchTableConfigById(recordSet.getDbTableId());
            if (searchTableConfig != null) {
                String rsName = UIRegistry.getLocalizedMessage("ES_RS_TAB_NM", recordSet.getName());
                SubPaneIFace sp = SubPaneMgr.getInstance().getSubPaneByName(rsName);
                if (sp != null) {
                    SubPaneMgr.getInstance().showPane(sp);
                } else {
                    ESResultsSubPane esrPane = new ESResultsSubPane(rsName, this, true);
                    esrPane.setIcon(IconManager.getIcon("Record_Set", IconManager.IconSize.Std16));
                    Hashtable<String, QueryForIdResultsSQL> resultsForJoinsHash = new Hashtable<String, QueryForIdResultsSQL>();
                    QueryForIdResultsHQL results = new QueryForIdResultsHQL(searchTableConfig, new Color(255, 158, 6), recordSet);
                    results.setEditable(isEditable);
                    results.setExpanded(true);
                    this.displayResults(esrPane, results, resultsForJoinsHash);
                    this.addSubPaneToMgr(esrPane);
                }
            } else {
                String tblTitle = DBTableIdMgr.getInstance().getTitleForId(recordSet.getDbTableId());
                UIRegistry.showLocalizedError("RS_CONFIG_SEARCH", tblTitle);
            }
        } else {
            UIRegistry.showLocalizedError("RS_HAS_NO_ITEMS", recordSet.getName());
        }
    }

    public void doBasicSearch(String searchName) {
        Hashtable<String, ExpressResultsTableInfo> idToTableInfoMap = ExpressSearchConfigCache.getSearchIdToTableInfoHash();
        for (ExpressResultsTableInfo erti : idToTableInfoMap.values()) {
            if (!erti.getName().equals(searchName)) continue;
            ESResultsSubPane expressSearchPane = new ESResultsSubPane(erti.getTitle(), this, true);
            QueryForIdResultsSQL esr = new QueryForIdResultsSQL(erti.getTitle(), null, erti, 0, "");
            ExpressTableResultsFromQuery esrfq = new ExpressTableResultsFromQuery(expressSearchPane, esr, true);
            this.addSubPaneToMgr(expressSearchPane);
            return;
        }
        log.error((Object)("Can't find a search definition for name [" + searchName + "]"));
    }

    protected void doHQLQuery(QueryForIdResultsIFace results, Boolean reusePanel) {
        if (reusePanel == null || !reusePanel.booleanValue()) {
            ESResultsSubPane expressSearchPane = new ESResultsSubPane(UIRegistry.getResourceString("ES_QUERY_RESULTS"), this, true);
            this.addSubPaneToMgr(expressSearchPane);
            expressSearchPane.addSearchResults(results);
        } else {
            if (this.queryResultsPane == null) {
                this.queryResultsPane = new QBResultsSubPane(UIRegistry.getResourceString("ES_QUERY_RESULTS"), this, true);
                this.queryResultsPane.setIcon(IconManager.getIcon("Query", IconManager.IconSize.Std16));
            } else {
                this.queryResultsPane.reset();
            }
            this.queryResultsPane.addSearchResults(results);
        }
    }

    @Override
    public SubPaneIFace getStarterPane() {
        this.starterPane = new SimpleDescPane(this.name, (Taskable)this, "This is the Express Search Pane");
        return this.starterPane;
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        Vector<NavBoxIFace> extendedNavBoxes = new Vector<NavBoxIFace>();
        extendedNavBoxes.clear();
        extendedNavBoxes.addAll(this.navBoxes);
        RecordSetTask rsTask = (RecordSetTask)ContextMgr.getTaskByClass(RecordSetTask.class);
        List<NavBoxIFace> nbs = rsTask.getNavBoxes();
        if (nbs != null) {
            extendedNavBoxes.addAll(nbs);
        }
        return extendedNavBoxes;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel searchPanel = new JPanel(gridbag);
        JLabel spacer = UIHelper.createLabel("  ");
        this.searchBtn = UIHelper.createButton(UIRegistry.getResourceString("SEARCH"));
        this.searchBtn.setToolTipText(UIRegistry.getResourceString("ExpressSearchTT"));
        HelpMgr.setHelpID(this.searchBtn, EXPRESSSEARCH);
        this.searchText = new JAutoCompTextField(15, PickListDBAdapterFactory.getInstance().create("ExpressSearch", true));
        this.searchText.setAskBeforeSave(false);
        HelpMgr.registerComponent(this.searchText, EXPRESSSEARCH);
        this.searchBox = new SearchBox(this.searchText, new SearchBoxMenuCreator());
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        this.searchText.setText(localPrefs.get(this.getLastSearchKey(), ""));
        this.textBGColor = this.searchText.getBackground();
        ActionListener doQuery = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressSearchTask.this.doQuery();
            }
        };
        this.searchBtn.addActionListener(doQuery);
        this.searchText.addActionListener(doQuery);
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ExpressSearchTask.this.searchText.getBackground() != ExpressSearchTask.this.textBGColor) {
                    ExpressSearchTask.this.searchText.setBackground(ExpressSearchTask.this.textBGColor);
                    ExpressSearchTask.this.searchText.setForeground(UIManager.getColor("TextField.foreground"));
                }
            }
        });
        this.searchText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ExpressSearchTask.this.showContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ExpressSearchTask.this.showContextMenu(e);
            }
        });
        c.weightx = 1.0;
        gridbag.setConstraints(spacer, c);
        searchPanel.add(spacer);
        c.weightx = 0.0;
        gridbag.setConstraints(this.searchBox, c);
        searchPanel.add(this.searchBox);
        searchPanel.add(spacer);
        searchPanel.setOpaque(false);
        if (!UIHelper.isMacOS()) {
            gridbag.setConstraints(this.searchBtn, c);
            searchPanel.add(this.searchBtn);
        }
        this.toolbarItems.add(new ToolBarItemDesc(searchPanel, ToolBarItemDesc.Position.AdjustRightLastComp));
        return this.toolbarItems;
    }

    protected void showContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(UIRegistry.getResourceString("ES_TEXT_RESET"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ExpressSearchTask.this.searchText.setEnabled(true);
                    ExpressSearchTask.this.searchText.setBackground(ExpressSearchTask.this.textBGColor);
                    ExpressSearchTask.this.searchText.setText("");
                    if (ExpressSearchTask.this.statusBar != null) {
                        ExpressSearchTask.this.statusBar.setProgressDone(ExpressSearchTask.EXPRESSSEARCH);
                    }
                }
            });
            popup.add(menuItem);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        return new Vector<MenuItemDesc>();
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart")) {
            this.appContextHasChanged();
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        super.doCommand(cmdAction);
        if (cmdAction.isType(EXPRESSSEARCH)) {
            UsageTracker.incrUsageCount("ES." + cmdAction.getType());
            if (cmdAction.isAction("HQL")) {
                this.doHQLQuery((QueryForIdResultsIFace)cmdAction.getData(), (Boolean)cmdAction.getProperty("reuse_panel"));
            } else if (cmdAction.isAction("ExpressSearch")) {
                String searchTerm = cmdAction.getData().toString();
                ESResultsSubPane expressSearchPane = new ESResultsSubPane(searchTerm, this, true);
                this.doQuery(null, searchTerm, expressSearchPane);
            } else if (cmdAction.isAction("Search")) {
                this.doBasicSearch(cmdAction.getData().toString());
            } else if (cmdAction.isAction("SearchComplete")) {
                this.doSearchComplete(cmdAction);
            } else if (cmdAction.isAction("ViewRecordSet")) {
                RolloverCommand roc;
                RecordSetIFace recordSet = null;
                if (cmdAction.getData() instanceof RecordSetIFace) {
                    recordSet = (RecordSetIFace)cmdAction.getData();
                } else if (cmdAction.getData() instanceof RolloverCommand && (roc = (RolloverCommand)cmdAction.getData()).getData() instanceof RecordSetIFace) {
                    recordSet = (RecordSetIFace)roc.getData();
                }
                if (recordSet != null) {
                    this.displayRecordSet(recordSet, (Boolean)cmdAction.getProperty("canModify"));
                }
            }
        }
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        if (subPane == this.queryResultsPane) {
            this.queryResultsPane = null;
        }
        super.subPaneRemoved(subPane);
    }

    @Override
    public synchronized void exectionDone(SQLExecutionProcessor process, ResultSet resultSet) {
        if (!this.sqlHasResults) {
            try {
                this.sqlHasResults = resultSet.first();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(ExpressSearchTask.class, ex);
            }
        }
        this.sqlProcessorList.remove(process);
        Object[] data = (Object[])process.getData();
        if (data != null && data.length == 3) {
            SearchTableConfig searchTableConfig = (SearchTableConfig)data[0];
            ExpressSearchResultsPaneIFace esrPane = (ExpressSearchResultsPaneIFace)data[1];
            String searchTerm = (String)data[2];
            Hashtable<String, ExpressResultsTableInfo> idToTableInfoHash = ExpressSearchConfigCache.getSearchIdToTableInfoHash();
            Hashtable<String, List<ExpressResultsTableInfo>> joinIdToTableInfohash = ExpressSearchConfigCache.getJoinIdToTableInfoHash();
            Hashtable<String, QueryForIdResultsSQL> resultsForJoinsHash = new Hashtable<String, QueryForIdResultsSQL>();
            try {
                if (resultSet.next()) {
                    String searchIdStr = Integer.toString(searchTableConfig.getTableInfo().getTableId());
                    ExpressResultsTableInfo tblInfo = idToTableInfoHash.get(searchIdStr);
                    if (tblInfo == null) {
                        throw new RuntimeException("Bad id from search[" + searchIdStr + "]");
                    }
                    SearchConfig config = SearchConfigService.getInstance().getSearchConfig();
                    int cnt = 0;
                    do {
                        if (cnt < 20000) {
                            this.collectResults(config, tblInfo.getTableId(), searchTerm, resultSet, null, joinIdToTableInfohash, resultsForJoinsHash);
                        }
                        ++cnt;
                    } while (resultSet.next());
                    if (cnt >= 20000) {
                        String reason = String.format(UIRegistry.getResourceString("ExpressSearchTask.MAX_SEARCH_RESULTS_EXCEEDED"), 20000, cnt);
                        if (this.searchWarningsResults == null) {
                            this.searchWarningsResults = new SIQueryForIdResults();
                            this.searchWarningsResults.addReason(searchTableConfig, reason);
                            this.displayResults(esrPane, this.searchWarningsResults, resultsForJoinsHash);
                        } else {
                            this.searchWarningsResults.addReason(searchTableConfig, reason);
                        }
                    }
                    if (resultsForJoinsHash.size() > 0) {
                        QueryForIdResultsSQL queryResults = new QueryForIdResultsSQL(searchIdStr, null, tblInfo, searchTableConfig.getDisplayOrder(), searchTerm);
                        this.displayResults(esrPane, queryResults, resultsForJoinsHash);
                    }
                }
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(ExpressSearchTask.class, ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void executionError(SQLExecutionProcessor process, Exception ex) {
        this.sqlProcessorList.remove(process);
    }

    protected void setUserInputToNotFound(String msgKey, boolean isInError) {
        if (isInError) {
            if (this.badSearchColor != null) {
                this.searchText.setBackground(this.badSearchColor);
            }
            this.searchText.setSelectionStart(0);
            this.searchText.setSelectionEnd(this.searchText.getText().length());
        }
        this.searchText.getToolkit().beep();
        this.searchText.repaint();
        this.searchText.requestFocus();
        if (isInError) {
            if (this.statusBar != null) {
                this.statusBar.setLocalizedErrorMessage(msgKey, new Object[0]);
            }
            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(msgKey), Color.RED);
        } else {
            this.displayNoResults(msgKey);
        }
    }

    protected void displayNoResults(String msgKey) {
        String fullMsg = UIRegistry.getLocalizedMessage(StringUtils.isNotEmpty((String)msgKey) ? msgKey : "NoExpressSearchResults", this.searchText.getText());
        UIRegistry.writeTimedSimpleGlassPaneMsg(fullMsg, null, null, 24, true);
    }

    protected synchronized void completionUIHelper(CustomQueryIFace customQuery) {
        if (customQuery != null) {
            this.queryList.remove(customQuery);
            ++this.queryCountDone;
        }
        if (this.statusBar != null) {
            this.statusBar.setValue(EXPRESSSEARCH, this.queryCountDone);
        }
        if (this.queryList.size() == 0) {
            if (this.searchText != null) {
                this.searchText.setEnabled(true);
                this.searchBtn.setEnabled(true);
                if (!this.sqlHasResults) {
                    this.setUserInputToNotFound("NoExpressSearchResults", false);
                } else {
                    this.searchText.setSelectionStart(this.searchText.getText().length());
                    this.searchText.setSelectionEnd(this.searchText.getText().length());
                    this.searchText.repaint();
                    if (this.statusBar != null) {
                        this.statusBar.setText("");
                    }
                }
            }
            CommandDispatcher.dispatch(new CommandAction(EXPRESSSEARCH, "SearchComplete"));
        }
    }

    @Override
    public synchronized void exectionDone(CustomQueryIFace customQuery) {
        boolean addPane = false;
        JPAQuery jpaQuery = (JPAQuery)customQuery;
        List<?> list = jpaQuery.getDataObjects();
        if (!this.sqlHasResults) {
            addPane = this.sqlHasResults = !jpaQuery.isInError() && list != null && list.size() > 0;
        }
        if (list != null) {
            if (list.size() > 0) {
                Object[] data = (Object[])jpaQuery.getData();
                SearchTableConfig searchTableConfig = (SearchTableConfig)data[0];
                final ExpressSearchResultsPaneIFace esrPane = (ExpressSearchResultsPaneIFace)data[1];
                String searchTerm = (String)data[2];
                if (addPane && esrPane instanceof SubPaneIFace) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExpressSearchTask.this.addSubPaneToMgr((SubPaneIFace)((Object)esrPane));
                        }
                    });
                }
                Hashtable<String, List<ExpressResultsTableInfo>> joinIdToTableInfoHash = ExpressSearchConfigCache.getJoinIdToTableInfoHash();
                Hashtable<String, QueryForIdResultsSQL> resultsForJoinsHash = new Hashtable<String, QueryForIdResultsSQL>();
                SearchConfig config = SearchConfigService.getInstance().getSearchConfig();
                String tableIdStr = Integer.toString(searchTableConfig.getTableInfo().getTableId());
                int cnt = 0;
                for (Object idObj : list) {
                    if (cnt < 20000) {
                        this.collectResults(config, tableIdStr, searchTerm, null, (Integer)idObj, joinIdToTableInfoHash, resultsForJoinsHash);
                    }
                    ++cnt;
                }
                if (cnt >= 20000) {
                    String reason = String.format("%d hits returned of %d maximum allowed. ", 20000, cnt);
                    if (this.searchWarningsResults == null) {
                        this.searchWarningsResults = new SIQueryForIdResults();
                        this.searchWarningsResults.addReason(searchTableConfig, reason);
                        this.displayResults(esrPane, this.searchWarningsResults, resultsForJoinsHash);
                    } else {
                        this.searchWarningsResults.addReason(searchTableConfig, reason);
                    }
                }
                QueryForIdResultsHQL results = new QueryForIdResultsHQL(searchTableConfig, new Color(30, 144, 255), searchTerm, list);
                results.setMultipleSelection(true);
                this.displayResults(esrPane, results, resultsForJoinsHash);
            }
        } else {
            log.error((Object)"List was null and cant't be");
        }
        this.completionUIHelper(customQuery);
    }

    @Override
    public synchronized void executionError(CustomQueryIFace customQuery) {
        log.error((Object)"Error running query!");
        this.completionUIHelper(customQuery);
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[2] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray[3] = blArray2;
        return blArrayArray;
    }

    private void doGlobalSearchSetup() {
        if (this.globalSearchCheckBoxMI.isSelected()) {
            AppPreferences.getLocalPrefs().putBoolean(GLOBAL_SEARCH, true);
        } else {
            AppPreferences.getLocalPrefs().remove(GLOBAL_SEARCH);
            this.searchBox.resetSearchIcon();
        }
    }

    protected boolean isQueryBuilderResults(QueryForIdResultsIFace results) {
        return this.queryResultsPane != null && results instanceof QBQueryForIdResultsHQL;
    }

    protected void doSearchComplete(CommandAction cmdAction) {
        if (this.statusBar != null) {
            this.statusBar.setProgressDone(EXPRESSSEARCH);
            if (cmdAction.getData() instanceof JPAQuery) {
                QueryForIdResultsIFace results = (QueryForIdResultsIFace)cmdAction.getProperty("QueryForIdResultsIFace");
                ESResultsTablePanelIFace esrto = (ESResultsTablePanelIFace)cmdAction.getProperty("ESResultsTablePanelIFace");
                if (!this.isQueryBuilderResults(results) && esrto != null && !esrto.hasResults()) {
                    results.complete();
                    UIRegistry.showLocalizedError("QB_NO_RESULTS_UNK");
                    return;
                }
                if (this.isQueryBuilderResults(results)) {
                    int rowCount = ((JPAQuery)cmdAction.getData()).getDataObjects().size();
                    boolean isError = ((JPAQuery)cmdAction.getData()).isInError();
                    boolean isCancelled = ((JPAQuery)cmdAction.getData()).isCancelled();
                    boolean showPane = !isError && !isCancelled && rowCount > 0;
                    int index = SubPaneMgr.getInstance().indexOfComponent(this.queryResultsPane.getUIComponent());
                    if (index == -1) {
                        if (showPane) {
                            this.addSubPaneToMgr(this.queryResultsPane);
                        }
                    } else if (showPane) {
                        SubPaneMgr.getInstance().showPane(this.queryResultsPane);
                    } else {
                        SubPaneMgr.getInstance().removePane(this.queryResultsPane, false);
                    }
                    results.complete();
                    if (isError) {
                        this.statusBar.setErrorMessage(UIRegistry.getResourceString("QB_RUN_ERROR"));
                    } else if (rowCount == 0) {
                        this.displayNoResults("QB_NO_RESULTS");
                    } else {
                        this.statusBar.setText(null);
                    }
                }
            }
        }
    }

    public class SearchBoxMenuCreator
    implements SearchBox.MenuCreator {
        protected List<JComponent> menus = null;
        protected SearchConfigService scService = SearchConfigService.getInstance();
        protected JMenuItem allMenuItem = null;
        protected JMenuItem configMenuItem = null;
        protected ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == SearchBoxMenuCreator.this.allMenuItem) {
                    SearchBoxMenuCreator.this.scService.setSearchContext(null);
                } else if (e.getSource() == SearchBoxMenuCreator.this.configMenuItem) {
                    ExpressSearchConfigDlg dlg = new ExpressSearchConfigDlg();
                    dlg.createUI();
                    UIHelper.centerAndShow(dlg);
                    dlg.cleanUp();
                } else {
                    String miTitle = ((JMenuItem)e.getSource()).getText();
                    for (SearchTableConfig stc : SearchBoxMenuCreator.this.scService.getSearchConfig().getTables()) {
                        if (!stc.getTitle().equals(miTitle)) continue;
                        SearchBoxMenuCreator.this.scService.setSearchContext(stc);
                    }
                }
            }
        };

        @Override
        public List<JComponent> createPopupMenus() {
            if (this.menus == null) {
                this.menus = new Vector<JComponent>();
                this.allMenuItem = new JMenuItem(UIRegistry.getResourceString("ALL"), SearchBox.getSearchIcon());
                this.allMenuItem.addActionListener(this.action);
                this.menus.add(this.allMenuItem);
                for (SearchTableConfig stc : this.scService.getSearchConfig().getTables()) {
                    PermissionSettings perm;
                    if (AppContextMgr.isSecurityOn() && !(perm = stc.getTableInfo().getPermissions()).canView()) continue;
                    JMenuItem menuItem = new JMenuItem(stc.getTitle(), IconManager.getIcon(stc.getIconName(), IconManager.IconSize.Std16));
                    menuItem.addActionListener(this.action);
                    this.menus.add(menuItem);
                    if (stc.getTableInfo().getTableId() != CollectingEvent.getClassTableId()) continue;
                    boolean isEmbedded = AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent();
                    IconEntry ciEntry = IconManager.getIconEntryByName(isEmbedded ? "collectinginformation" : "ce_restore");
                    menuItem.setIcon(ciEntry.getIcon(IconManager.IconSize.Std16));
                }
                if (!AppContextMgr.isSecurityOn() || SpecifyUser.isCurrentUserType(SpecifyUserTypes.UserType.Manager)) {
                    boolean isGlobalSearchAvail;
                    boolean permsOKForGlobalSearch = ((SpecifyQueryAdjusterForDomain)QueryAdjusterForDomain.getInstance()).isPermsOKForGlobalSearch();
                    boolean bl = isGlobalSearchAvail = permsOKForGlobalSearch && AppPreferences.getLocalPrefs().getBoolean(ExpressSearchTask.GLOBAL_SEARCH_AVAIL, false) != false;
                    if (isGlobalSearchAvail) {
                        boolean isGSOn = AppPreferences.getLocalPrefs().getBoolean(ExpressSearchTask.GLOBAL_SEARCH, false);
                        ActionListener globalSearchAL = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ExpressSearchTask.this.doGlobalSearchSetup();
                            }
                        };
                        ExpressSearchTask.this.globalSearchCheckBoxMI = new JCheckBoxMenuItem(UIRegistry.getResourceString(ExpressSearchTask.GLOBAL_SEARCH), IconManager.getIcon("GlobalSearch", IconManager.IconSize.Std16), isGSOn);
                        ExpressSearchTask.this.globalSearchCheckBoxMI.addActionListener(globalSearchAL);
                        this.menus.add(new JSeparator());
                        this.menus.add(ExpressSearchTask.this.globalSearchCheckBoxMI);
                    }
                } else {
                    AppPreferences.getLocalPrefs().remove(ExpressSearchTask.GLOBAL_SEARCH);
                }
                if (ExpressSearchTask.this.globalSearchCheckBoxMI == null) {
                    this.menus.add(new JSeparator());
                }
                this.configMenuItem = new JMenuItem(UIRegistry.getResourceString("ESConfig"), IconManager.getIcon("SystemSetup", IconManager.IconSize.Std16));
                this.configMenuItem.addActionListener(this.action);
                this.menus.add(this.configMenuItem);
            }
            return this.menus;
        }

        @Override
        public void reset() {
            this.menus = null;
        }
    }
}

