/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.UIFileFilter;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpExportSchema;
import edu.ku.brc.specify.datamodel.SpExportSchemaItem;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgrCallerIFace;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.XPathException;

public class ExportMappingTask
extends QueryTask {
    private static final Logger log = Logger.getLogger(ExportMappingTask.class);
    protected SpExportSchema exportSchema = null;
    protected SpExportSchemaMapping schemaMapping = null;
    protected final AtomicBoolean addingMapping = new AtomicBoolean(false);
    protected static final String DEF_IMP_PREF = "ExportSchemaMapping.SchemaImportDir";

    public ExportMappingTask() {
        super("ExportMappingTask", ExportMappingTask.getResStr("TaskTitle"));
    }

    private static String getI18N(String key) {
        return "ExportMappingTask." + key;
    }

    private static String getResStr(String key) {
        return UIRegistry.getResourceString(ExportMappingTask.getI18N(key));
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        return null;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        String menuDesc = "Specify.SYSTEM_MENU";
        this.menuItems = new Vector();
        if (this.permissions == null || this.permissions.canView()) {
            String menuTitle = ExportMappingTask.getI18N("ExMapMenu");
            String mneu = ExportMappingTask.getI18N("ExMapMneu");
            String desc = ExportMappingTask.getI18N("ExMapDesc");
            JMenuItem mi = UIHelper.createLocalizedMenuItem(menuTitle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ExportMappingTask.this.requestContext();
                }
            });
            MenuItemDesc rsMI = new MenuItemDesc(mi, menuDesc);
            rsMI.setPosition(MenuItemDesc.Position.Bottom);
            this.menuItems.add(rsMI);
        }
        return this.menuItems;
    }

    public static boolean checkMappingLock(final SpExportSchemaMapping map) {
        if (map == null) {
            return true;
        }
        TaskSemaphoreMgrCallerIFace callface = new TaskSemaphoreMgrCallerIFace(){

            @Override
            public TaskSemaphoreMgr.USER_ACTION resolveConflict(SpTaskSemaphore semaphore, boolean previouslyLocked, String prevLockBy) {
                if (previouslyLocked) {
                    int options = 0;
                    Object[] optionLabels = new String[]{UIRegistry.getResourceString("CANCEL"), UIRegistry.getResourceString("SpecifyAppContextMgr.OVERRIDE")};
                    int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("ExportMappingTask.LockedMsg", map.getMappingName(), prevLockBy), ExportMappingTask.getResStr("LockedDlgTitle"), options, 3, null, optionLabels, 0);
                    if (userChoice == 0) {
                        return TaskSemaphoreMgr.USER_ACTION.Cancel;
                    }
                    if (userChoice == 1 && ExportMappingTask.unlockMapping(map)) {
                        return TaskSemaphoreMgr.lock(ExportMappingTask.getLockTitle(map), ExportMappingTask.getLockName(map), null, TaskSemaphoreMgr.SCOPE.Global, false, this, false);
                    }
                    return TaskSemaphoreMgr.USER_ACTION.Cancel;
                }
                return TaskSemaphoreMgr.USER_ACTION.OK;
            }
        };
        return TaskSemaphoreMgr.lock(ExportMappingTask.getLockTitle(map), ExportMappingTask.getLockName(map), null, TaskSemaphoreMgr.SCOPE.Global, false, callface, false) == TaskSemaphoreMgr.USER_ACTION.OK;
    }

    protected static String getLockName(SpExportSchemaMapping map) {
        return "ExportMapping" + (map == null ? "" : map.getId());
    }

    protected static String getLockTitle(SpExportSchemaMapping map) {
        return map.getMappingName();
    }

    public static boolean unlockMapping(SpExportSchemaMapping map) {
        if (map != null && map.getId() != null) {
            return TaskSemaphoreMgr.unlock(ExportMappingTask.getLockTitle(map), "ExportMapping" + map.getId().toString(), TaskSemaphoreMgr.SCOPE.Global);
        }
        return true;
    }

    @Override
    protected boolean checkLock(SpQuery query) {
        boolean result = ExportMappingTask.checkMappingLock(query.getMapping());
        return result;
    }

    @Override
    public ImageIcon getIcon(int size) {
        IconManager.IconSize iSize = IconManager.IconSize.Std16;
        if (size != 16) {
            IconManager.IconSize[] iconSizeArray = IconManager.IconSize.values();
            int n = iconSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconManager.IconSize ic = iconSizeArray[n2];
                if (ic.size() == size) {
                    iSize = ic;
                    break;
                }
                ++n2;
            }
        }
        return IconManager.getIcon("Export16", iSize);
    }

    @Override
    protected void addNewQCreators() {
        this.actionNavBox.add(NavBox.createBtnWithTT(ExportMappingTask.getResStr("NewMapping"), "Query", ExportMappingTask.getResStr("NewMappigTT"), IconManager.STD_ICON_SIZE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportMappingTask.this.addMapping();
            }
        }));
        this.actionNavBox.add(NavBox.createBtnWithTT(ExportMappingTask.getResStr("ImportSchema"), "Query", ExportMappingTask.getResStr("ImportSchemaTT"), IconManager.STD_ICON_SIZE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportMappingTask.this.importSchema();
            }
        }));
    }

    protected Vector<SpExportSchemaMapping> getMappings() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            Vector<SpExportSchemaMapping> result = new Vector<SpExportSchemaMapping>();
            Integer disciplineId = AppContextMgr.getInstance().getClassObject(Discipline.class).getId();
            List<SpExportSchemaMapping> mappings = session.getDataList(SpExportSchemaMapping.class);
            for (SpExportSchemaMapping mapping : mappings) {
                if (!mapping.getSpExportSchema().getDiscipline().getId().equals(disciplineId)) continue;
                mapping.forceLoad();
                result.add(mapping);
            }
            Vector<SpExportSchemaMapping> vector = result;
            return vector;
        }
        finally {
            session.close();
        }
    }

    protected SpExportSchema chooseExportSchema() {
        ChooseFromListDlg<SpExportSchema> dlg = new ChooseFromListDlg<SpExportSchema>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ExportSchemaMapEditor.ChooseSchemaTitle"), this.getExportSchemas());
        UIHelper.centerAndShow(dlg);
        if (dlg.isCancelled()) {
            return null;
        }
        return dlg.getSelectedObject();
    }

    protected List<SpExportSchema> getExportSchemas() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            List<SpExportSchema> result = session.getDataList(SpExportSchema.class, "discipline", AppContextMgr.getInstance().getClassObject(Discipline.class));
            for (SpExportSchema schema : result) {
                schema.forceLoad();
            }
            List<SpExportSchema> list = result;
            return list;
        }
        finally {
            session.close();
        }
    }

    protected SpQuery createNewQueryDataObj() {
        DBTableInfo tableInfo = this.getTableInfo();
        SpQuery query = new SpQuery();
        query.initialize();
        query.setName(String.valueOf(this.exportSchema.getSchemaName()) + this.exportSchema.getVersion());
        query.setNamed(false);
        query.setContextTableId((short)tableInfo.getTableId());
        query.setContextName(tableInfo.getShortClassName());
        return query;
    }

    protected QueryBldrPane buildQb(SpQuery query) {
        if (!this.addingMapping.get()) {
            this.schemaMapping = query.getMapping();
            if (this.schemaMapping != null) {
                this.exportSchema = this.schemaMapping.getSpExportSchema();
            }
        }
        return new QueryBldrPane(query.getName(), this, query, false, this.exportSchema, this.schemaMapping);
    }

    @Override
    protected String getActionNavBoxTitle() {
        return ExportMappingTask.getResStr("ActionNavBoxTitle");
    }

    @Override
    protected String getQueryNavBoxTitle() {
        return ExportMappingTask.getResStr("MappingNavBoxTitle");
    }

    @Override
    protected QueryBldrPane getNewQbPane(SpQuery query) {
        return this.buildQb(query);
    }

    @Override
    public String getHelpTarget() {
        return "export_data";
    }

    protected DBTableInfo getTableInfo() {
        return DBTableIdMgr.getInstance().getInfoById(1);
    }

    protected void addMapping() {
        SpExportSchema selectedSchema;
        if ((this.queryBldrPane == null || this.queryBldrPane.aboutToShutdown()) && (selectedSchema = this.chooseExportSchema()) != null) {
            this.exportSchema = selectedSchema;
            this.schemaMapping = new SpExportSchemaMapping();
            this.schemaMapping.initialize();
            this.schemaMapping.setSpExportSchema(this.exportSchema);
            SpQuery query = this.createNewQueryDataObj();
            if (query != null) {
                this.addingMapping.set(true);
                try {
                    this.editQuery(query);
                }
                finally {
                    this.addingMapping.set(false);
                }
            }
        }
    }

    public static String getDefaultSchemaImportDir() {
        File pathDir;
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        String path = localPrefs.get(DEF_IMP_PREF, null);
        if (path != null && (pathDir = new File(path)).exists() && pathDir.isDirectory()) {
            return path;
        }
        return String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "config";
    }

    protected void importSchema() {
        JFileChooser chooser = new JFileChooser(ExportMappingTask.getDefaultSchemaImportDir());
        chooser.setDialogTitle(ExportMappingTask.getResStr("IMPORT_SCHEMADEF_TITLE"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new UIFileFilter("xsd", ExportMappingTask.getResStr("SCHEMA_DEFS")));
        if (chooser.showOpenDialog(UIRegistry.get("frame")) != 0) {
            UIRegistry.getStatusBar().setText("");
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            UIRegistry.getStatusBar().setText(ExportMappingTask.getResStr("NO_FILE"));
            return;
        }
        String path = chooser.getCurrentDirectory().getPath();
        if (StringUtils.isNotEmpty((String)path)) {
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            localPrefs.put(DEF_IMP_PREF, path);
        }
        if (ExportMappingTask.importSchemaDefinition(file, null, null)) {
            UIRegistry.displayInfoMsgDlgLocalized(ExportMappingTask.getI18N("SchemaImportSuccess"), new Object[0]);
        } else {
            UIRegistry.displayInfoMsgDlgLocalized(ExportMappingTask.getI18N("SchemaImportFailure"), new Object[0]);
        }
    }

    @Override
    protected void registerServices() {
    }

    @Override
    protected List<?> getQueriesForLoading(DataProviderSessionIFace session) {
        Vector<SpQuery> result = new Vector<SpQuery>();
        AppContextMgr appConMgr = AppContextMgr.getInstance();
        if (appConMgr != null) {
            Collection currentCollection = appConMgr.getClassObject(Collection.class);
            if (currentCollection != null) {
                Integer collId = currentCollection.getId();
                if (collId != null) {
                    List<SpExportSchema> exportSchemas = this.getExportSchemas(session);
                    if (exportSchemas != null) {
                        for (SpExportSchema spExportSchema : exportSchemas) {
                            for (SpExportSchemaMapping mapping : spExportSchema.getSpExportSchemaMappings()) {
                                if (!mapping.getCollectionMemberId().equals(collId)) continue;
                                result.add(mapping.getMappings().iterator().next().getQueryField().getQuery());
                            }
                        }
                    } else {
                        log.error((Object)"exportSchemas list is null");
                    }
                } else {
                    log.error((Object)"Collection Id is null");
                }
            } else {
                log.error((Object)"Collection is null");
            }
        } else {
            log.error((Object)"AppContextMgr is null");
        }
        return result;
    }

    protected List<SpExportSchema> getExportSchemas(DataProviderSessionIFace session) {
        List<SpExportSchema> result = session.getDataList(SpExportSchema.class, "discipline", AppContextMgr.getInstance().getClassObject(Discipline.class));
        for (SpExportSchema schema : result) {
            schema.forceLoad();
        }
        return result;
    }

    @Override
    protected boolean isLoadableQuery(SpQuery query) {
        return true;
    }

    @Override
    protected void deleteThisQuery(SpQuery query, DataProviderSessionIFace session) throws Exception {
        session.delete(ExportMappingTask.getMappingForQuery(query, session));
        super.deleteThisQuery(query, session);
    }

    @Override
    protected String getQueryType() {
        return "ExportMappingTask";
    }

    public static SpExportSchemaMapping getMappingForQuery(SpQuery query, DataProviderSessionIFace session) throws Exception {
        DataProviderSessionIFace theSession = session;
        boolean createSession = theSession == null;
        try {
            if (createSession) {
                theSession = DataProviderFactory.getInstance().createSession();
            }
            if (theSession != null) {
                String hql = "from SpExportSchemaMapping sesm inner join sesm.mappings maps inner join maps.queryField qf inner join qf.query q where q.id = " + query.getId() + " and sesm.collectionMemberId = " + AppContextMgr.getInstance().getClassObject(Collection.class).getId();
                DataProviderSessionIFace.QueryIFace q = theSession.createQuery(hql, false);
                if (q.list().size() == 0) {
                    return null;
                }
                Object x = q.list().get(0);
                SpExportSchemaMapping spExportSchemaMapping = (SpExportSchemaMapping)((Object[])x)[0];
                return spExportSchemaMapping;
            }
            return null;
        }
        finally {
            if (createSession && theSession != null) {
                theSession.close();
            }
        }
    }

    public static boolean importSchemaDefinition(File xsdFile, String titleText, String versionText) {
        Element xsd = null;
        try {
            xsd = XMLHelper.readFileToDOM4J(xsdFile);
        }
        catch (Exception ex) {
            UIRegistry.displayErrorDlg(ex.getLocalizedMessage());
            return false;
        }
        String theTitle = titleText;
        String theVersion = versionText;
        if (xsd != null) {
            if (titleText == null && versionText == null) {
                ColorWrapper requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
                PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, p, 2dlu, f:p:g", "p, 2dlu, p, 2dlu, p"));
                CellConstraints cc = new CellConstraints();
                pb.add((Component)UIHelper.createI18NFormLabel(ExportMappingTask.getI18N("SchemaDescTitle")), cc.xy(2, 1));
                pb.add((Component)UIHelper.createI18NFormLabel(ExportMappingTask.getI18N("SchemaTitleTitle")), cc.xy(2, 3));
                pb.add((Component)UIHelper.createI18NFormLabel(ExportMappingTask.getI18N("SchemaVersionTitle")), cc.xy(2, 5));
                JTextField namespace = UIHelper.createTextField(xsd.attributeValue("targetNamespace"));
                namespace.setEditable(false);
                pb.add((Component)namespace, cc.xy(4, 1));
                final JTextField title = UIHelper.createTextField(40);
                title.setBackground(requiredFieldColor.getColor());
                pb.add((Component)title, cc.xy(4, 3));
                final JTextField version = UIHelper.createTextField();
                version.setBackground(requiredFieldColor.getColor());
                pb.add((Component)version, cc.xy(4, 5));
                pb.setDefaultDialogBorder();
                final CustomDialog dlg = new CustomDialog((Frame)UIRegistry.get("frame"), ExportMappingTask.getResStr("SchemaInfoTitle"), true, 3, (Component)pb.getPanel());
                DocumentAdaptor dl = new DocumentAdaptor(){

                    @Override
                    protected void changed(DocumentEvent e) {
                        dlg.getOkBtn().setEnabled(!title.getText().isEmpty() || !version.getText().isEmpty());
                    }
                };
                title.getDocument().addDocumentListener(dl);
                version.getDocument().addDocumentListener(dl);
                UIHelper.centerAndShow(dlg);
                if (dlg.isCancelled()) {
                    return false;
                }
                theTitle = title.getText();
                theVersion = version.getText();
            }
            boolean doRollback = false;
            DataProviderSessionIFace session = null;
            try {
                SpExportSchema schema = new SpExportSchema();
                schema.initialize();
                schema.setSchemaName(theTitle);
                schema.setSchemaVersion(theVersion);
                String desc = xsd.attributeValue("targetNamespace");
                schema.setDescription(desc.substring(0, Math.min(255, desc.length())));
                schema.setDiscipline(AppContextMgr.getInstance().getClassObject(Discipline.class));
                for (Object itemObj : ExportMappingTask.getNodesForDef(xsd)) {
                    SpExportSchemaItem item = ExportMappingTask.createSchemaItem((Element)itemObj);
                    item.setSpExportSchema(schema);
                    schema.getSpExportSchemaItems().add(item);
                }
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                doRollback = true;
                session.save(schema);
                session.commit();
                doRollback = false;
                return true;
            }
            catch (Exception ex) {
                if (doRollback && session != null) {
                    session.rollback();
                }
                UIRegistry.displayErrorDlg(ex.getLocalizedMessage());
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        UIRegistry.displayErrorDlgLocalized(ExportMappingTask.getI18N("MAPPING_ERR"), new Object[0]);
        return false;
    }

    protected boolean includeGroup(String substitutionGroupName) {
        return true;
    }

    protected boolean includeTerm(Element term) {
        return term.attributeValue("type", null) != null && this.includeGroup(term.attributeValue("substitutionGroup", null));
    }

    protected static List<Object> getNodesForDef(Element xsd) {
        LinkedList<Object> result = null;
        try {
            result = xsd.selectNodes("xsd:element");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = new LinkedList<Object>();
            for (Object e : xsd.selectNodes("xs:element")) {
                if (((Element)e).attributeValue("type", null) == null) continue;
                result.add(e);
            }
        }
        for (Object e : result) {
            System.out.println(((Element)e).attributeValue("name"));
        }
        return result;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = new JMenuItem(ExportMappingTask.getResStr("XML_IMPORT_MAPPINGS"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportMappingTask.this.importQueries();
            }
        });
        mi = new JMenuItem(ExportMappingTask.getResStr("XML_EXPORT_MAPPINGS"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportMappingTask.this.exportQueries();
            }
        });
        mi = new JMenuItem(ExportMappingTask.getResStr("DELETE_SCHEMATA"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportMappingTask.this.deleteSchemata();
            }
        });
        return popupMenu;
    }

    protected void deleteSchemata() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        if (session != null) {
            try {
                List<SpExportSchema> schemas = session.getDataList(SpExportSchema.class, "discipline", AppContextMgr.getInstance().getClassObject(Discipline.class), DataProviderSessionIFace.CompareType.Equals);
                ChooseFromListDlg<SpExportSchema> dlg = new ChooseFromListDlg<SpExportSchema>((Frame)UIRegistry.getTopWindow(), ExportMappingTask.getResStr("DELETE_DLG_TITLE"), ExportMappingTask.getResStr("DELETE_DLG_MSG"), -1, schemas);
                UIHelper.centerAndShow(dlg);
                if (!dlg.isCancelled() && dlg.getSelectedObject() != null) {
                    SpExportSchema selected = dlg.getSelectedObject();
                    if (selected.getSpExportSchemaMappings().size() > 0) {
                        this.displayMappings(dlg.getSelectedObject(), selected.getSpExportSchemaMappings().size() > 1 ? ExportMappingTask.getResStr("MAPPINGS_PREVENT_DELETE") : ExportMappingTask.getResStr("MAPPING_PREVENTS_DELETE"));
                    } else {
                        boolean rollback = false;
                        try {
                            session.beginTransaction();
                            session.delete(selected);
                            session.commit();
                            UIRegistry.displayLocalizedStatusBarText(ExportMappingTask.getI18N("SchemaDeleted"), new Object[0]);
                        }
                        catch (Exception ex) {
                            if (rollback) {
                                session.rollback();
                            }
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(ExportMappingTask.class, ex);
                            UIRegistry.displayStatusBarErrMsg(ExportMappingTask.getResStr("SchemaDeleteError"));
                        }
                    }
                }
            }
            finally {
                session.close();
            }
        }
    }

    protected void displayMappings(SpExportSchema schema, String msg) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        int i = 0;
        for (SpExportSchemaMapping mapping : schema.getSpExportSchemaMappings()) {
            model.add(i++, mapping.getMappingName());
        }
        JList list = new JList(model);
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, p:g, 5dlu", "5dlu, p, 3dlu"));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)UIHelper.createLabel(msg), cc.xy(2, 2));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)pb.getPanel(), "North");
        pane.add(list, "Center");
        CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), ExportMappingTask.getResStr("MAPPINGS_TITLE"), true, 1, (Component)pane);
        UIHelper.centerAndShow(cd);
    }

    @Override
    protected String getTopLevelNodeSelector() {
        return "/spexportschemamappings/query";
    }

    protected JPanel bldSchemaImportPane(String schemaNamespace) {
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, p, 2dlu, p, 5dlu", "p, 2dlu, p, 2dlu, p"));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)UIHelper.createLabel("Schema:", 4), cc.xy(2, 1));
        pb.add((Component)UIHelper.createLabel("Schema Title:", 4), cc.xy(2, 3));
        pb.add((Component)UIHelper.createLabel("Schema Version:", 4), cc.xy(2, 5));
        JTextField namespace = UIHelper.createTextField(schemaNamespace);
        ViewFactory.changeTextFieldUIForDisplay(namespace, false);
        pb.add((Component)namespace, cc.xy(4, 1));
        pb.add((Component)UIHelper.createTextField(), cc.xy(4, 3));
        pb.add((Component)UIHelper.createTextField(), cc.xy(4, 5));
        return pb.getPanel();
    }

    protected static SpExportSchemaItem createSchemaItem(Element itemElement) throws Exception {
        SpExportSchemaItem result = new SpExportSchemaItem();
        result.initialize();
        result.setFieldName(itemElement.attributeValue("name"));
        result.setDataType(itemElement.attributeValue("type"));
        try {
            for (Object docObj : itemElement.selectNodes("xsd:annotation/xsd:documentation")) {
                Element docElem = (Element)docObj;
                String desc = docElem.getText();
                result.setDescription(desc.substring(0, Math.min(255, desc.length())));
            }
        }
        catch (XPathException ex) {
            result.setDescription(null);
        }
        return result;
    }

    @Override
    protected String getExportDlgMsgi18nKey() {
        return ExportMappingTask.getI18N("ChooseMappings");
    }

    @Override
    protected String getExportDlgTitlei18nKey() {
        return ExportMappingTask.getI18N("EXPORT_QUERIES");
    }

    @Override
    protected String getExportHelpContext() {
        return super.getExportHelpContext();
    }

    @Override
    protected String getExportUsageKey() {
        return "ExportMapper.Export";
    }

    @Override
    protected String getXMLExportFirstLine() {
        return "<spexportschemamappings>\n";
    }

    @Override
    protected String getXMLExportLastLine() {
        return "</spexportschemamappings>";
    }

    @Override
    protected void toXML(SpQuery query, StringBuilder sb) {
        super.toXML(query, sb);
    }

    protected String uniqueName(String currentName, String sql) {
        Vector<Object[]> names = BasicSQLUtils.query(sql);
        HashSet<String> nameSet = new HashSet<String>();
        for (Object[] nm : names) {
            nameSet.add((String)nm[0]);
        }
        int cnt = 0;
        String objName = currentName;
        while (nameSet.contains(objName)) {
            objName = String.valueOf(currentName) + ++cnt;
        }
        return objName;
    }

    @Override
    protected boolean saveImportedQueries(List<SpQuery> queriesList) {
        for (SpQuery q : queriesList) {
            SpExportSchemaMapping m = q.getMapping();
            for (SpExportSchema e : m.getSpExportSchemas()) {
                e.setSchemaName(this.uniqueName(e.getSchemaName(), "select SchemaName from spexportschema where DisciplineID = " + AppContextMgr.getInstance().getClassObject(Discipline.class).getId()));
                e.setDiscipline(AppContextMgr.getInstance().getClassObject(Discipline.class));
                e.getSpExportSchemaMappings().clear();
                if (DataModelObjBase.save(true, new Object[]{e})) continue;
                return false;
            }
            m.setMappingName(q.getName());
            if (DataModelObjBase.save(true, new Object[]{q, m})) continue;
            return false;
        }
        return true;
    }
}

